(defproject lsenta/budb "0.0.1"
  :description "A CRDT Database for Clojure(script)"
  :url "https://github.com/lsenta/budb"

  :dependencies
  [[org.clojure/clojure "1.9.0-alpha16" :scope "provided"]
   [org.clojure/clojurescript "1.9.521" :scope "provided"]

   [com.taoensso/timbre "4.8.0"]

   [io.replikativ/superv.async "0.2.6"]
   [io.replikativ/konserve "0.4.9"]
   [lsenta/konserve-firebase "0.0.1"]

   [devcards "0.2.2" :scope "test"]
   [lsenta/figwheel-testbook "0.0.1" :scope "test"]
   [lein-doo "0.1.7" :scope "test"]
   [binaryage/devtools "0.9.2" :scope "test"]
   [binaryage/dirac "1.2.2" :scope "test"]
   [ring "1.5.1" :scope "test"]]

  :source-paths
  ["src/cljc" "src/clj" "src/cljs"]
  :test-paths
  ["test/cljc" "test/clj" "test/cljs"]
  :resource-paths
  ["resources"]

  ;; Don't package your firebase configuration
  :jar-exclusions
  [#"env/"]

  ;; Clean everything, especially the resources/target folder
  ;; that contains all the generated javascript.
  :clean-targets
  ^{:protect false} [:target-path :compile-path "resources/target"]

  :plugins [[lein-cljsbuild "1.1.6"]
            [lein-doo "0.1.7"]]
  :hooks [leiningen.cljsbuild]
  :doo {:build "test"}

  ;; -- Resources Management --
  :resource
  {:resource-paths ["resources/dev"]
   :includes       [#".*"]
   :excludes       [#".*~"]
   :skip-stencil   [#"^.*~$" #"^.*\.(otf|eot|svg|ttf|woff|woff2)$"]
   :verbose        true
   :target-path    "resources/target/test/"}


  ;; -- Ring Server --
  ;; Relies on the path hardcoded in test/clj/budb.test_server/handler
  :ring {:handler budb.test_server/handler
         :port    8100}

  ;; -- Figwheel Server --
  ;; Custom port because multi-projects.
  :figwheel
  {:server-port 8149}


  :profiles
  {:dev
   {:dependencies [[pjstadig/humane-test-output "0.8.1"]]
    :plugins      [[lein-doo "0.1.7"]
                   [lein-resource "16.9.1"]
                   [lein-figwheel "0.5.10"]
                   [lein-ring "0.11.0"]
                   [com.jakemccrary/lein-test-refresh "0.20.0"]]
    :injections   [(require 'pjstadig.humane-test-output)
                   (pjstadig.humane-test-output/activate!)]}}

  :cljsbuild
  {:builds
   [
    ;; -- CLJS: Test --
    ;; Build in a debuggable mode with the doo-runner available
    ;; generate to testable.js
    {:id           "test"
     :source-paths ["env"
                    "src/cljc" "src/cljs"
                    "test/cljc" "test/cljs"]
     :compiler     {:output-to     "target/test/testable.js"
                    :main          running.doo-runner
                    :optimizations :none
                    :pretty-print  true
                    :source-map    true}}
    ;; -- CLJS: Testbook --
    ;; The small test runner on top of figwheel
    ;; generates to testbook.js
    {:id           "testbook"
     :source-paths ["env"
                    "src/cljc" "src/cljs"
                    "test/cljc" "test/cljs"]
     :figwheel     {:on-jsload running.testbook/reload-hook}
     :compiler     {:main          running.testbook
                    :asset-path    "/js/testbook"
                    :output-to     "resources/target/test/js/testbook.js"
                    :output-dir    "resources/target/test/js/testbook"
                    :optimizations :none
                    :pretty-print  true
                    :source-map    true}}
    ;; -- CLJS: Devbook --
    ;; The devcard build
    ;; generates to devbook.js
    {:id           "devbook"
     :source-paths ["env"
                    "src/cljc" "src/cljs"
                    "test/cljc" "test/cljs"]
     :figwheel     {:devcards true}
     :compiler     {:main          devbook.core
                    :asset-path    "/js/devbook"
                    :output-to     "resources/target/test/js/devbook.js"
                    :output-dir    "resources/target/test/js/devbook"
                    :optimizations :none
                    :pretty-print  true
                    :source-map    true}}]})
