;; Monoidal Example

;; Monoid Abstract layer
(defprotocol Foo
  (get-bar [thing] "Get the essential bar.")
  (set-bar [thing value] "Set the the essential bar.")
  (do-foo [thing foo-arg] "Do some foo with arg on topic")
  )

(defn abstract
  [thing]
  "Do some high level thing using the monoidal value passed in."
  (-> thing
    (do-foo "like a boss")
    (->/as (-> get-bar bar)
      (set-bar (+ bar 42))
      )))

(require '[abstract :as a])
(defrecord FooRec [foo bar baz]
  Foo
  )

;; Monadic Example

;; Monad Abstract layer
(defprotocol Foo
  (make-thing [thing] "Oops, I don't have a thing yet")
  (get-bar [thing] "Get the essential bar.")
  (set-bar [thing] "Set the the essential bar.")
  (do-foo [thing foo-arg] "Do some foo with arg on topic"))

(defn abstract
  [bar]
  "Do some high level thing returning a monadic value."
  (-> (make-thing ??? bar) ;; XXX Unable to provide argument to make-thing!!
    (do-foo "like a boss")
    (->/as (-> get-bar bar)
      (set-bar (+ bar 42)))))

;; Monad Integration layer

(require '[abstract :as a])

(defrecord FooRec [foo bar baz]
  Foo
  (make-thing [_] (->FooRec 0 0 0) )
  (do-foo [_ arg] )
  (get-bar [_])
  (set-bar [_]))

(defn integration-monadic
  []
  (->))

