(ns lonocloud.data.ordered.set
  (:require                                                       
                   [cljs.reader])
        
  (:require-macros [lonocloud.data.ordered.common :refer [change!]])
       
                                                                         
                                                                           
                                                           
                                                                     
                                      )

(declare transient-ordered-set)

      
(deftype OrderedSet [^PersistentHashMap k->i
                     ^PersistentVector i->k]
  Object
  (toString [this]
    (pr-str* this))

  IPrintWithWriter
  (-pr-writer [this writer opts]
    (-write writer (str "#ordered/set " (pr-str (seq this)))))

  IWithMeta
  (-with-meta [this m]
    (OrderedSet. (-with-meta k->i m) i->k))

  IMeta
  (-meta [this]
    (-meta k->i))

  ICollection
  (-conj [this k]
    (if-let [i (-lookup k->i k)]
      this
      (OrderedSet. (-assoc k->i k (-count i->k))
                   (-conj i->k k))))

  IEmptyableCollection
  (-empty [this]
    (OrderedSet. (-> {} (with-meta (meta k->i))) []))

  IEquiv
  (-equiv [this other]
    (or (identical? this other)
        (and (set? other)
             (== (count this) (count other))
             (every? #(contains? this %) other))))

  IHash
  (-hash [this]
    (-hash k->i))

  ISeqable
  (-seq [this]
    (seq (remove #(= ::empty %) i->k)))

  ICounted
  (-count [this]
    (-count k->i))

  ISet
  (-disjoin [this k]
    (if-let [i (-lookup k->i k)]
      (OrderedSet. (dissoc k->i k)
                   (assoc i->k i ::empty))
      this))

  IReversible
  (-rseq [this]
    (seq (remove #(= ::empty %) (rseq i->k))))

  ILookup
  (-lookup [this k]
    (-lookup this k nil))
  (-lookup [coll k not-found]
    (if (-contains-key? k->i k)
      k
      not-found))

  IFn
  (-invoke [this k]
    (-lookup this k))
  (-invoke [this k not-found]
    (-lookup this k not-found))

  IEditableCollection
  (-as-transient [this]
    (transient-ordered-set this)))

      
(deftype TransientOrderedSet [^:mutable k->i
                              ^:mutable i->k]
  ITransientCollection
  (-conj! [this k]
    (let [i (-lookup k->i k)]
      (when-not i
        (change! k->i -assoc! k (-count i->k))
        (change! i->k -conj! k)))
    this)
  (-persistent! [this]
    (OrderedSet. (-persistent! k->i) (-persistent! i->k)))

  ITransientSet
  (-disjoin! [this k]
    (when-let [i (-lookup k->i k)]
      (change! k->i -dissoc! k)
      (change! i->k -assoc-n! i ::empty))
    this)

  ICounted
  (-count [this]
    (-count k->i))

  ILookup
  (-lookup [this k]
    (-lookup this k nil))
  (-lookup [this k not-found]
    (if (-lookup k->i k)
      k
      not-found))

  IFn
  (-invoke [this k]
    (-lookup this k))
  (-invoke [this k not-found]
    (-lookup this k not-found)))

     
                                         
                                             
                
                   
                               
                                  
                                          
            
                
                               
          
                                                             
                                    
             
                                                
               
                                                
                     
                     
                         
               
                             
               
                  

      
              
                       
                    
                                         
                       

        
                  
                  
                  
                                      
                      
                               
                                  
                                
                                              
                                                              

     
                  
                               
                    
                          
                        
                                    
              
                  
                 
                          
                      
                          
                                  
                        
                           
         
                 
                                                 

            
              
                                                       

                     
                     
                                 
     
                                                

     
                                                            
                                                         
                                                            
                                                            
               
               
                  
               
                             
                   
                            
             
                                 
                                          
         
                
                            
                 
                                                                    
                                
         
                    
                              
                    
                                   
                                      

(defn transient-ordered-set [^OrderedSet os]
  (TransientOrderedSet. (transient (.-k->i os))
                        (transient (.-i->k os))))

(def ^:private ^OrderedSet
  empty-ordered-set (empty (OrderedSet. nil nil)))

(defn ordered-set
  ([] empty-ordered-set)
  ([& xs] (into empty-ordered-set xs)))

(defn into-ordered-set
  [items]
  (into empty-ordered-set items))

      
(cljs.reader/register-tag-parser! 'ordered/set into-ordered-set)

     
                                                        
                            
                           

;;;;;;;;;;;; This file autogenerated from src/cljx/lonocloud/data/ordered/set.cljx
