(ns lonocloud.data.ordered.map
  (:require                                                       
                                                                   
                   [cljs.reader])
        
  (:require-macros [lonocloud.data.ordered.common :refer [change!]])
       
                                       
                                              
                                          
                                            
                                      
                                         
                             
                            
                                       
                                   
                                 
                                                     
                                                                
                          
                                     )

(defrecord NotFound [])
(def ^:private not-found (NotFound.))

(defn entry [k v i]
                                     
         [k [i v]])

(declare transient-ordered-map)

      
(deftype OrderedMap [^PersistentHashMap backing-map
                     ^PersistentVector order]
  Object
  (toString [this]
    (pr-str* this))

  IPrintWithWriter
  (-pr-writer [this writer opts]
    (-write writer (str "#ordered/map " (pr-str (seq this)))))

  IWithMeta
  (-with-meta [this m]
    (OrderedMap. (-with-meta backing-map m) order))

  IMeta
  (-meta [this]
    (-meta backing-map))

  ICollection
  (-conj [this entry]
    (cond
     (vector? entry) (-assoc this (-nth entry 0) (-nth entry 1))
     (satisfies? IMapEntry entry) (-assoc this (key entry) (val entry))
     :else (reduce -conj this entry)
     #_(persistent! (reduce -conj! (transient this) entry))))

  IEmptyableCollection
  (-empty [this]
    (OrderedMap. (-> {} (with-meta (meta backing-map))) []))

  IEquiv
  (-equiv [this other]
    (and (map? other)
         (== (count this) (count other))
         (every? (fn [[k v]]
                   (= v (-lookup other k not-found)))
                 (-seq this))))

  IHash
  (-hash [this]
    (-hash backing-map))

  ISeqable
  (-seq [this]
    (seq (keep identity order)))

  IReversible
  (-rseq [this]
    (seq (keep identity (rseq order))))

  ICounted
  (-count [this]
    (-count backing-map))

  IAssociative
  (-assoc [this k v]
    (if-let [[i old-v] (-lookup backing-map k)]
      (if (= v old-v)
        this
        (OrderedMap. (-conj backing-map (entry k v i))
                     (-assoc order i [k v])))
      (OrderedMap. (-conj backing-map (entry k v (-count order)))
                   (-conj order [k v]))))
  (-contains-key? [this k]
    (-contains-key? backing-map k))

  IMap
  (-dissoc [this k]
    (if-let [[i v] (-lookup backing-map k)]
      (OrderedMap. (-dissoc backing-map k)
                   (-assoc order i nil))
      this))

  IKVReduce
  (-kv-reduce [this f init]
    (reduce (fn [acc [k v]]
              (f acc k v)) init (seq this)))

  ILookup
  (-lookup [this k]
    (-lookup this k nil))
  (-lookup [this k not-found]
    (if-let [[_ v] (-lookup backing-map k)]
      v
      not-found))

  IFn
  (-invoke [this k]
    (-lookup this k))
  (-invoke [this k not-found]
    (-lookup this k not-found))

  IEditableCollection
  (-as-transient [this]
    (transient-ordered-map this)))

      
(deftype TransientOrderedMap [^:mutable backing-map
                              ^:mutable order]
  ICounted
  (-count [this]
    (-count backing-map))

  ILookup
  (-lookup [this k]
    (-lookup this k nil))
  (-lookup [this k not-found]
    (if-let [[i v] (-lookup backing-map k)]
      v
      not-found))

  ITransientCollection
  (-conj! [this entry]
    (cond
     (vector? entry) (-assoc! this (-nth entry 0) (-nth entry 1))
     (satisfies? IMapEntry entry) (-assoc! this (key entry) (val entry))
     :else (reduce -conj! this entry)))
  (-persistent! [this]
    (OrderedMap. (-persistent! backing-map)
                 (-persistent! order)))

  ITransientAssociative
  (-assoc! [this k v]
    (let [e (-lookup backing-map k not-found)
          i (if (identical? e not-found)
              (do (change! order -conj! [k v])
                  (dec (-count order)))
              (let [idx (first e)]
                (change! order -assoc! idx [k v])
                idx))]
      (change! backing-map -conj! (entry k v i))
      this))

  ITransientMap
  (-dissoc! [this k]
    (let [e (-lookup backing-map k not-found)]
      (when-not (identical? e not-found)
        (change! backing-map -dissoc! k)
        (change! order -assoc-n! (first e) nil)))
    this))

     
                                                
                                              

                       
                

     
                  
                    
                            
                              

     
           
                             
              
                                
               
                    
                    
                                 
                         
                                                     
                
                                     
             
                               

        
                  
                  
                      
                        
                  
                                 
                                           
                                                                                   
                           

                
            
                         
                     
                              
                                             
                                  
                                                           
                               
                   
                                   
                              
                          
                 
                        
                           
                                                   
              
                 

               
                                                            
                  
                        
                                       
                                                          
                                             
                                                               
                                                           
                                                                            
                                                              
                                                                  
                                           
                                  

                   
                                                   
                           
                       
              
                           
                                                          
                                                             
                                                                 
                                                   
                   
                                                   
                                           
                                               
            
             
                                
                  
                                            
                  
                                                                                                    
                                                         
                             

      
              
                              
                    
                                                        

                     
                     
                                 

            
              
                                        

     
                                                                                              
                                                                                           
               
            
                         
                 
                        
                           
                                                
              
                 
                   
                                                      
                                      
                                        
                                                    
                                       
                                 
                                                       
                      
                                               
            
                
                  
                         
                   
                                                  
                                   
                         
                                         
                                        
            
                    
                                          
                                       

(defn transient-ordered-map [^OrderedMap om]
  (TransientOrderedMap. (transient (.-backing-map om))
                        (transient (.-order om))))

(def ^:private ^OrderedMap
  empty-ordered-map (empty (OrderedMap. nil nil)))

(defn ordered-map
  ([] empty-ordered-map)
  ([coll]
     (into empty-ordered-map coll))
  ([k v & more]
     (apply assoc empty-ordered-map k v more)))

      
(cljs.reader/register-tag-parser! 'ordered/map ordered-map)

     
                                                        
                            
                           

;;;;;;;;;;;; This file autogenerated from src/cljx/lonocloud/data/ordered/map.cljx
