(ns lonocloud.data.ordered.map
  (:require       [lonocloud.data.ordered.common :refer [change!]]
                  [lonocloud.data.ordered.set :refer [ordered-set]]
                                )
        
                                                                    
       
  (:import (clojure.lang IPersistentMap
                         IPersistentCollection
                         IPersistentVector
                         IEditableCollection
                         ITransientMap
                         ITransientVector
                         IObj
                         IFn
                         MapEquivalence
                         Reversible
                         MapEntry
                         ;; Indexed, maybe add later?
                         ;; Sorted almost certainly not accurate
                         )
           (java.util Map Map$Entry)))

(defrecord NotFound [])
(def ^:private not-found (NotFound.))

(defn entry [k v i]
        (MapEntry. k (MapEntry. i v))
                  )

(declare transient-ordered-map)

      
                                                   
                                             
        
                  
                   

                  
                                
                                                              

           
                      
                                                   

       
               
                        

             
                     
         
                                                                
                                                                       
                                    
                                                             

                      
                
                                                            

        
                      
                     
                                        
                            
                                                     
                               

       
               
                        

          
              
                                

             
               
                                       

          
                
                         

              
                    
                                               
                     
            
                                                      
                                             
                                                                 
                                         
                          
                                   

      
                   
                                           
                                          
                                        
            

           
                           
                           
                                            

         
                   
                         
                             
                                           
       
                 

     
                   
                     
                             
                               

                     
                       
                                  

      
                                                   
                                              
          
                
                         

         
                   
                         
                             
                                           
       
                 

                      
                      
         
                                                                 
                                                                        
                                       
                      
                                           
                                       

                       
                     
                                             
                                        
                                              
                                       
                                  
                                                 
                      
                                                
            

               
                    
                                              
                                        
                                        
                                                 
          

     
(deftype OrderedMap [^IPersistentMap backing-map
                     ^IPersistentVector order]

  ;; tagging interfaces
  MapEquivalence

  IFn
  (invoke [this k]
    (.valAt this k))
  (invoke [this k not-found]
    (.valAt this k not-found))

  Map
  (size [_]
    (.size ^Map backing-map))
  (isEmpty [_]
    (.isEmpty ^Map backing-map))
  (get [this k]
    (.valAt this k))
  (containsKey [_ k]
    (.containsKey backing-map k))
  (containsValue [this v]
    (boolean (seq (filter #(= % v) (.values this)))))
  (values [this]
    (map (comp val val) (.seq this)))
  (keySet [_]
    (.keySet ^Map backing-map))

  Object
  (toString [this]
    (pr-str this))
  (equals [this other]
    (.equiv this other))
  (hashCode [this]
    (reduce (fn [acc ^MapEntry e]
              (let [k (.key e), v (.val e)]
                (unchecked-add ^Integer acc ^Integer (bit-xor (hash k) (hash v)))))
            0 (.seq this)))

  IPersistentMap
  (count [_]
    (.count backing-map))
  (equiv [this other]
    (and (instance? Map other)
         (= (.count this) (.size ^Map other))
         (every? (fn [^MapEntry e]
                   (= (.val e) (.get ^Map other (.key e))))
                 (.seq this))))
  (entryAt [this k]
    (let [v (get this k not-found)]
      (when (not= v not-found)
        (MapEntry. k v))))
  (valAt [this k]
    (.valAt this k nil))
  (valAt [this k not-found]
    (if-let [^MapEntry e (.get ^Map backing-map k)]
      (.val e)
      not-found))

  (empty [this]
    (OrderedMap. (-> {} (with-meta (meta backing-map))) []))
  (cons [this obj]
    (condp instance? obj
      Map$Entry (let [^Map$Entry e obj]
                  (.assoc this (.getKey e) (.getValue e)))
      IPersistentVector (if (= 2 (count obj))
                          (.assoc this (nth obj 0) (nth obj 1))
                          (throw (IllegalArgumentException.
                                  "Vector arg to map conj must be a pair")))
      (persistent! (reduce (fn [^ITransientMap m ^Map$Entry e]
                             (.assoc m (.getKey e) (.getValue e)))
                           (transient this)
                           obj))))

  (assoc [this k v]
    (if-let [^MapEntry e (.get ^Map backing-map k)]
      (let [old-v (.val e)]
        (if (= old-v v)
          this
          (let [i (.key e)]
            (OrderedMap. (.cons backing-map (entry k v i))
                         (.assoc order i (MapEntry. k v))))))
      (OrderedMap. (.cons backing-map (entry k v (.count order)))
                   (.cons order (MapEntry. k v)))))
  (without [this k]
    (if-let [^MapEntry e (.get ^Map backing-map k)]
      (OrderedMap. (.without backing-map k)
                   (.assoc order (.key e) nil))
      this))
  (seq [this]
    (seq (keep identity order)))
  (iterator [this]
    (clojure.lang.SeqIterator. (.seq this)))
  (entrySet [this]
    ;; not performant, but i'm not going to implement another whole java interface from scratch just
    ;; because rich won't let us inherit from AbstractSet
    (apply ordered-set this))

  IObj
  (meta [this]
    (.meta ^IObj backing-map))
  (withMeta [this m]
    (OrderedMap. (.withMeta ^IObj backing-map m) order))

  IEditableCollection
  (asTransient [this]
    (transient-ordered-map this))

  Reversible
  (rseq [this]
    (seq (keep identity (rseq order)))))

     
(deftype TransientOrderedMap [^{:unsynchronized-mutable true, :tag ITransientMap} backing-map,
                              ^{:unsynchronized-mutable true, :tag ITransientVector} order]
  ITransientMap
  (count [_]
    (.count backing-map))
  (valAt [this k]
    (.valAt this k nil))
  (valAt [this k not-found]
    (if-let [^MapEntry e (.valAt backing-map k)]
      (.val e)
      not-found))
  (assoc [this k v]
    (let [^MapEntry e (.valAt backing-map k not-found)
          vector-entry (MapEntry. k v)
          i (if (identical? e not-found)
              (do (change! order .conj vector-entry)
                  (dec (.count order)))
              (let [idx (.key e)]
                (change! order .assoc idx vector-entry)
                idx))]
      (change! backing-map .conj (entry k v i))
      this))
  (conj [this e]
    (let [[k v] e]
      (.assoc this k v)))
  (without [this k]
    (let [^MapEntry e (.valAt backing-map k this)]
      (when-not (identical? e this)
        (let [i (.key e)]
          (change! backing-map dissoc! k)
          (change! order assoc! i nil)))
      this))
  (persistent [this]
    (OrderedMap. (.persistent backing-map)
                 (.persistent order))))

(defn transient-ordered-map [^OrderedMap om]
  (TransientOrderedMap. (transient (.-backing-map om))
                        (transient (.-order om))))

(def ^:private ^OrderedMap
  empty-ordered-map (empty (OrderedMap. nil nil)))

(defn ordered-map
  ([] empty-ordered-map)
  ([coll]
     (into empty-ordered-map coll))
  ([k v & more]
     (apply assoc empty-ordered-map k v more)))

      
                                                           

     
(defmethod print-method OrderedMap [o ^java.io.Writer w]
  (.write w "#ordered/map ")
  (print-method (seq o) w))

;;;;;;;;;;;; This file autogenerated from src/cljx/lonocloud/data/ordered/map.cljx
