# ![graph-router](https://github.com/lockedon/graph-router/blob/master/graph-router-logo.png)

A Clojure library for composing and quering graphs!

## Installation

[![Clojars Project](http://clojars.org/lockedon/graph-router/latest-version.svg)](http://clojars.org/lockedon/graph-router)

Graph-router is available on clojars. Once you have added the latest version to your project.clj you are ready to go!

### Getting Started

Requiring graph-router.core provides you with two functions `dispatch` and `with`.

`dispatch` is used to process a query with a graph.

`with` is a utility funciton to help compose your graphs.

```clojure
(ns example.core
	(:require [graph-router.core :refer :all]))
```

## Composing Graphs

Graphs are descriptions of how to access data in Clojure hash maps. Graph-router leverages the fact that Clojure
keywords are also functions for accessing data in Clojure hash maps.

```clojure
(def data {:Hello "Hello" :World "World"})

(def data-keys [:Hello :World])
```

In the example above two bindings are defined:

`data` is a Clojure Hash map.

`data-keys` is a description of how to consume the values in `data`.

#### `with`

Graph-router requires at the top level a hash-map of data generators.

`with` is mainly used to define what function to use in place of a keyword in accessing data.

```clojure
(defn generate-graph 
	[_] 
	{:Hello "Hello" :World "World"})

(def graph {(with :Root generate-graph) [:Hello :World]})
```

In the above example the keyword `:Root` is declared as an alias for `generate-graph` that returns the data.

__NOTE:__
When using `with` to swap what function is used to access data, the function used must receive at least one argument. 
Just as a keyword receives one argument when being used as a function to access data in a hash map.

```clojure
(defn generate-graph 
	[_] 
	{:Hello "Hello" :World "World"})

(defn get-hello 
	[& args]
	(apply :Hello args))

;; This will produce an identical graph to the above example.
(def graph {(with :Root generate-graph) [(with :Hello get-hello) :World]})
```

## License

Copyright © 2015 LockedOn

Distributed under the Eclipse Public License either version 1.0 or (at
your option) any later version.
