(ns liu.mars.akka-cluster
  (:require [liu.mars.actor :refer [!]])
  (:import (akka.actor AbstractActor)
           (akka.cluster.pubsub DistributedPubSub DistributedPubSubMediator$Subscribe DistributedPubSubMediator$Publish DistributedPubSubMediator DistributedPubSubMediator$Put DistributedPubSubMediator$Send DistributedPubSubMediator$SendToAll)))

(defn mediator [^AbstractActor actor]
  (-> actor
      .getContext
      .system
      (DistributedPubSub/get)
      .mediator))

(defn subscribe
  ([m channel self]
   (! m (DistributedPubSubMediator$Subscribe. channel self) self))
  ([channel self]
   (subscribe (mediator self) channel self)))


(defn publish
  ([m channel message self]
   (! m (DistributedPubSubMediator$Publish. channel message) self))
  ([channel message self]
   (publish (mediator self) channel message self)))

(defn put
  ([m self]
   (! m (DistributedPubSubMediator$Put. self) self))
  ([self]
   (put (mediator self) self)))

(defn send
  ([m path message self local-affinity]
   (! m (DistributedPubSubMediator$Send. path message local-affinity) self))
  ([path message self local-affinity]
   (send (mediator self) path message self local-affinity)))

(defn send-all
  ([m path message self all-but-self]
   (! m (DistributedPubSubMediator$SendToAll. path message all-but-self) self))
  ([path message self all-but-self]
   (send (mediator self) path message self all-but-self)))