(ns tango.integration.autocomplete
  (:require [promesa.core :as p]
            [tango.integration.repl-helpers :as helpers]))

(defn- detect-namespace? [eql namespace]
  (p/let [result (eql {:repl/kind :clj
                       :text/contents (str "(require '" namespace ")")}
                      [:repl/result])]
    (-> result :repl/result (:result :not-found) nil?)))

;; Different evaluators have different autocomplete capabilities
(defn- detect-complete [_evaluator state]
  (p/let [eql (-> @state :editor/features :eql)
          compliment? (detect-namespace? eql "compliment.core")
          suitable? (detect-namespace? eql "suitable.js-completions")
          suitable? (and suitable? (detect-namespace? eql "suitable.compliment.sources.cljs"))]
    {:compliment? compliment?
     :suitable? (and compliment? suitable?)}))

(defn generate [state]
  (let [detection #_(memoize) detect-complete]
    (fn []
      (p/let [eql (helpers/prepare-new-eql state)
              evaluator (eql [:repl/evaluator])
              kind (p/then (eql [:repl/kind]) :repl/kind)
              completes (detection evaluator state)
              complete? (if (= kind :cljs)
                          (:suitable? completes)
                          (:compliment? completes))]
        (if complete?
          (p/then (eql [:completions/external]) :completions/external)
          (p/then (eql [:completions/var :completions/keyword])
                  (fn [{:completions/keys [var keyword]}]
                    (vec (concat var keyword)))))))))
