(ns orbit.meta-helper
  (:require [clojure.java.io :as io]
            [clojure.tools.reader :as r]
            [clojure.test :refer [testing]]
            [clojure.string :as str]))

(def wrap-js-patches
  `[(some-> object# .-then)
    (let [id# (str (gensym "promise-"))]
      (.then object# (fn [result#]
                       (tap> [{:orbit.patch/id id#}
                              (to-ebn {:orbit.patch/result result#})])))
      (.catch object# (fn [result#]
                        (tap> [{:orbit.patch/id id#}
                               (to-ebn {:orbit.patch/error result#})])))
      (to-meta# {:orbit.patch/id id#}
              (tagged-literal (-> object# type .-name (or "promise") symbol)
                              'pending)))

    (cljs.core/object? object#) (->> object#
                                     cljs.core/js-keys
                                     (map (fn [k#] [(keyword k#) (aget object# k#)]))
                                     (into {})
                                     to-ebn
                                     (str "#2ejs"))
    (cljs.core/array? object#) (->> object#
                                    (into [])
                                    to-ebn
                                    (str "#2ejs"))])

(defmacro contents-for-fn
  ([source-file] (slurp (io/resource source-file)))
  ([source-file fn-name]
   (let [re (re-pattern (str "(?s).*\\(defn\\s+(" fn-name "\\b)"))]
     (-> source-file
         io/resource
         slurp
         (str/replace re "(clojure.core/fn $1 ")
         (str/replace #"#\?@" "CONDITIONALSPLICE#")
         r/read-string
         pr-str
         (->> (str "`"))
         load-string
         pr-str
         (str/replace #"CONDITIONALSPLICE[^\s]* " "#?@")
         (str/replace-first #"cond meta.*?\b"
                            (str "cond "
                                 "#?@(:cljs " wrap-js-patches ")"
                                 " meta__"))))))
