(ns duck-repled.python.features
  (:require [duck-repled.tree-sitter :as ts]
            [com.wsscode.pathom3.connect.operation :as pco]
            [orbit.evaluation :as eval]
            [duck-repled.connect :as connect]
            [clojure.string :as str]
            [promesa.core :as p]
            [clojure.edn :as edn]))

(connect/defresolver complete-code [{:keys [python/captures text/range file/filename]}]
  {::pco/input [:python/captures :text/range (pco/? :file/filename)]
   ::pco/output [:completions/code]}

  (when-let [^js last-node (last captures)]
    (let [start (.. last-node -startPosition -column)
          parent (.-parent last-node)
          parent-type (some-> parent .-type)
          [_ [row col]] range
          node-row (.. last-node -startPosition -row)
          last-node-txt (cond-> (.-text last-node)
                          (< node-row row) (-> str/split-lines
                                               (nth (- row node-row))
                                               (str/triml)))
          txt (subs last-node-txt 0 (- col start))
          res {:prefix txt :line row}
          res (cond-> res filename (assoc :file filename))]

      (if (str/ends-with? txt ".")
        {:completions/code (assoc res
                                  :prefix ""
                                  :context (str/replace txt #"\.$" ""))}
        {:completions/code (cond-> res
                             (= "attribute" parent-type)
                             (assoc :context (-> parent .-children first .-text)))}))))

(connect/defresolver definition [{:keys [parsers]} {:keys [text/block file/filename]}]
  {::pco/input [:python/node :text/block (pco/? :file/filename)]
   ::pco/output [:definition/code]}
  (let [code (:text/contents block)
        row (ffirst (:text/range block))
        parsed (.parse ^js ts/py-parser code)
        _ (swap! parsers conj parsed)
        node (-> parsed .-rootNode .-children first)
        q ts/any-query
        captures (.captures ^js q node)
        attribute-node (->> captures
                            reverse
                            (filter #(-> % .-node .-type (= "attribute")))
                            first)
        code (cond-> {:symbol (.. attribute-node -node -text)
                      :line row}
               filename (assoc :file filename))]
    (when attribute-node
      {:definition/code code})))

(def resolvers [complete-code definition])
