(ns duck-repled.python.features
  (:require [duck-repled.tree-sitter :as ts]
            [com.wsscode.pathom3.connect.operation :as pco]
            [orbit.evaluation :as eval]
            [duck-repled.connect :as connect]
            [clojure.string :as str]
            [promesa.core :as p]
            [clojure.edn :as edn]))

(connect/defresolver complete-code [{:keys [python/captures text/range file/filename]}]
  {::pco/input [:python/captures :text/range (pco/? :file/filename)]
   ::pco/output [:completions/code]}

  (when-let [^js last-node (last captures)]
    (let [start (.. last-node -startPosition -column)
          last-node-txt (.-text last-node)
          parent (.-parent last-node)
          parent-type (.-type parent)
          txt (subs last-node-txt 0 (-> range last last (- start)))
          res {:prefix txt
               :line (-> range last first)}]

      {:completions/code (cond-> res
                           (= "attribute" parent-type)
                           (assoc :context (-> parent .-children first .-text))
                           filename (assoc :file filename))})))

(def resolvers [complete-code])
