/*
 * Decompiled with CFR 0.152.
 */
package lindenlab.llsd;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lindenlab.llsd.LLSDException;
import lindenlab.llsd.LLSDUndefined;

public class LLSD {
    private final Object content;
    private DecimalFormat decimalFormat = null;
    private DateFormat iso9601Format = null;

    public LLSD(Object setContent) {
        this.content = setContent;
    }

    public static String encodeXML(String text) {
        int i;
        if (text == null) {
            return "null";
        }
        int textLength = text.length();
        if (textLength == 0) {
            return text;
        }
        int encodeBufferSize = textLength;
        block12: for (i = 0; i < textLength; ++i) {
            switch (text.charAt(i)) {
                case '<': 
                case '>': {
                    encodeBufferSize += 3;
                    continue block12;
                }
                case '&': 
                case '-': {
                    encodeBufferSize += 4;
                    continue block12;
                }
                case '\"': {
                    encodeBufferSize += 5;
                    continue block12;
                }
            }
        }
        if (encodeBufferSize == textLength) {
            return text;
        }
        char[] encodeBuffer = new char[encodeBufferSize];
        i = 0;
        int j = 0;
        while (i < textLength) {
            char currentChar = text.charAt(i);
            switch (currentChar) {
                case '<': {
                    encodeBuffer[j] = 38;
                    encodeBuffer[++j] = 108;
                    encodeBuffer[++j] = 116;
                    encodeBuffer[++j] = 59;
                    break;
                }
                case '>': {
                    encodeBuffer[j] = 38;
                    encodeBuffer[++j] = 103;
                    encodeBuffer[++j] = 116;
                    encodeBuffer[++j] = 59;
                    break;
                }
                case '&': {
                    encodeBuffer[j] = 38;
                    encodeBuffer[++j] = 97;
                    encodeBuffer[++j] = 109;
                    encodeBuffer[++j] = 112;
                    encodeBuffer[++j] = 59;
                    break;
                }
                case '\"': {
                    encodeBuffer[j] = 38;
                    encodeBuffer[++j] = 113;
                    encodeBuffer[++j] = 117;
                    encodeBuffer[++j] = 111;
                    encodeBuffer[++j] = 116;
                    encodeBuffer[++j] = 59;
                    break;
                }
                case '-': {
                    encodeBuffer[j] = 38;
                    encodeBuffer[++j] = 35;
                    encodeBuffer[++j] = 52;
                    encodeBuffer[++j] = 53;
                    encodeBuffer[++j] = 59;
                    break;
                }
                default: {
                    encodeBuffer[j] = currentChar;
                }
            }
            ++i;
            ++j;
        }
        String output = new String(encodeBuffer);
        return output;
    }

    public Object getContent() {
        return this.content;
    }

    public void serialise(Writer writer, String charset) throws IOException, LLSDException {
        writer.write("<?xml version=\"1.0\" encoding=\"" + charset + "\"?>\n");
        writer.write("<llsd>\n");
        if (null != this.content) {
            this.serialiseElement(writer, this.content);
        }
        writer.write("</llsd>\n");
    }

    private void serialiseElement(Writer writer, Object toSerialise) throws IOException, LLSDException {
        if (null == this.iso9601Format) {
            this.iso9601Format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            this.decimalFormat = new DecimalFormat("#0.0#");
        }
        assert (null != toSerialise);
        if (toSerialise instanceof Map) {
            Map serialiseMap = (Map)toSerialise;
            writer.write("<map>\n");
            for (String key : serialiseMap.keySet()) {
                Object value = serialiseMap.get(key);
                writer.write("\t<key>" + LLSD.encodeXML(key) + "</key>\n\t");
                this.serialiseElement(writer, value);
            }
            writer.write("</map>\n");
        } else if (toSerialise instanceof List) {
            writer.write("<array>\n");
            for (Object current : (List)toSerialise) {
                writer.write("\t");
                this.serialiseElement(writer, current);
            }
            writer.write("</array>\n");
        } else if (toSerialise instanceof Boolean) {
            writer.write("<boolean>" + toSerialise.toString() + "</boolean>\n");
        } else if (toSerialise instanceof Integer) {
            writer.write("<integer>" + toSerialise.toString() + "</integer>\n");
        } else if (toSerialise instanceof Double) {
            if (toSerialise.equals(Double.NaN)) {
                writer.write("<real>nan</real>\n");
            } else {
                writer.write("<real>" + this.decimalFormat.format(toSerialise) + "</real>\n");
            }
        } else if (toSerialise instanceof Float) {
            if (toSerialise.equals(Float.valueOf(Float.NaN))) {
                writer.write("<real>nan</real>\n");
            } else {
                writer.write("<real>" + this.decimalFormat.format(toSerialise) + "</real>\n");
            }
        } else if (toSerialise instanceof UUID) {
            writer.write("<uuid>" + toSerialise.toString() + "</uuid>\n");
        } else if (toSerialise instanceof String) {
            writer.write("<string>" + LLSD.encodeXML((String)toSerialise) + "</string>\n");
        } else if (toSerialise instanceof Date) {
            writer.write("<date>" + this.iso9601Format.format((Date)toSerialise) + "</date>");
        } else if (toSerialise instanceof URI) {
            writer.write("<uri>" + LLSD.encodeXML(toSerialise.toString()) + "</uri>");
        } else if (toSerialise instanceof LLSDUndefined) {
            switch ((LLSDUndefined)((Object)toSerialise)) {
                case BINARY: {
                    writer.write("<binary><undefined /></binary>\n");
                    break;
                }
                case BOOLEAN: {
                    writer.write("<boolean><undefined /></boolean>\n");
                    break;
                }
                case DATE: {
                    writer.write("<date><undefined /></date>\n");
                    break;
                }
                case INTEGER: {
                    writer.write("<integer><undefined /></integer>\n");
                    break;
                }
                case REAL: {
                    writer.write("<real><undefined /></real>\n");
                    break;
                }
                case STRING: {
                    writer.write("<string><undefined /></string>\n");
                    break;
                }
                case URI: {
                    writer.write("<uri><undefined /></uri>\n");
                    break;
                }
                case UUID: {
                    writer.write("<uuid><undefined /></uuid>\n");
                }
            }
        } else {
            throw new LLSDException("Unable to serialise type \"" + toSerialise.getClass().getName() + "\".");
        }
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        try {
            this.serialise(writer, "UTF-8");
        }
        catch (IOException e) {
            return "Unable to serialise LLSD for display: " + e.getMessage();
        }
        catch (LLSDException e) {
            return "Unable to serialise LLSD for display: " + e.getMessage();
        }
        return writer.toString();
    }
}

