(ns helix.server.manifold
  (:require
   [manifold.deferred :as d]))


;; copied from manifold.deferred
(defn- random-array [n]
  (let [a (int-array n)]
    (clojure.core/loop [i 1]
      (if (= i n)
        a
        (let [j (rand-int (inc i))]
          (aset a i (aget a j))
          (aset a j i)
          (recur (inc i)))))))


(defn race-kv
  [m]
  (let [d (d/deferred)
        ks (keys m)
        cnt (count ks)
        ^ints idxs (random-array cnt)]
    (clojure.core/loop [i 0]
      (when (< i cnt)
        (let [i' (aget idxs i)
              k (nth ks i')
              x (get m k)]
          (if (d/deferred? x)
            (d/success-error-unrealized
             x
             val (d/success! d [k val (dissoc m k)])
             err (d/error! d [k err (dissoc m k)])
             (do (d/on-realized (d/chain' x)
                                #(d/success! d [k % (dissoc m k)])
                                #(d/error! d [k % (dissoc m k)]))
                 (recur (inc i))))
            (d/success! d [k x (dissoc m k)])))))
    d))


(comment
  (d/chain
   (race-kv {:a (d/future (Thread/sleep 100) 1)
             :b (d/future (Thread/sleep 200) 2)
             :c (d/future (Thread/sleep 150) 3)})
   (fn [[k x m]]
     (prn k x m)
     (race-kv m))
   (fn [[k x m]]
     (prn k x m)
     (race-kv m))
   (fn [[k x m]]
     (prn k x m))))
