goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('goog.string');
goog.require('sablono.normalize');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('goog.dom');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__45053__delegate = function (args){
if(cljs.core.map_QMARK_(cljs.core.first(args))){
var vec__44708 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(func,cljs.core.rest(args));
var seq__44709 = cljs.core.seq(vec__44708);
var first__44710 = cljs.core.first(seq__44709);
var seq__44709__$1 = cljs.core.next(seq__44709);
var tag = first__44710;
var body = seq__44709__$1;
if(cljs.core.map_QMARK_(cljs.core.first(body))){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tag,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.first(body),cljs.core.first(args)], 0))], null),cljs.core.rest(body));
} else {
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tag,cljs.core.first(args)], null),body);
}
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(func,args);
}
};
var G__45053 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__45054__i = 0, G__45054__a = new Array(arguments.length -  0);
while (G__45054__i < G__45054__a.length) {G__45054__a[G__45054__i] = arguments[G__45054__i + 0]; ++G__45054__i;}
  args = new cljs.core.IndexedSeq(G__45054__a,0,null);
} 
return G__45053__delegate.call(this,args);};
G__45053.cljs$lang$maxFixedArity = 0;
G__45053.cljs$lang$applyTo = (function (arglist__45055){
var args = cljs.core.seq(arglist__45055);
return G__45053__delegate(args);
});
G__45053.cljs$core$IFn$_invoke$arity$variadic = G__45053__delegate;
return G__45053;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__4582__auto__ = (function sablono$core$update_arglists_$_iter__44721(s__44722){
return (new cljs.core.LazySeq(null,(function (){
var s__44722__$1 = s__44722;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__44722__$1);
if(temp__5735__auto__){
var s__44722__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(s__44722__$2)){
var c__4580__auto__ = cljs.core.chunk_first(s__44722__$2);
var size__4581__auto__ = cljs.core.count(c__4580__auto__);
var b__44724 = cljs.core.chunk_buffer(size__4581__auto__);
if((function (){var i__44723 = (0);
while(true){
if((i__44723 < size__4581__auto__)){
var args = cljs.core._nth(c__4580__auto__,i__44723);
cljs.core.chunk_append(b__44724,cljs.core.vec(cljs.core.cons(new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)));

var G__45065 = (i__44723 + (1));
i__44723 = G__45065;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__44724),sablono$core$update_arglists_$_iter__44721(cljs.core.chunk_rest(s__44722__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__44724),null);
}
} else {
var args = cljs.core.first(s__44722__$2);
return cljs.core.cons(cljs.core.vec(cljs.core.cons(new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)),sablono$core$update_arglists_$_iter__44721(cljs.core.rest(s__44722__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4582__auto__(arglists);
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__4795__auto__ = [];
var len__4789__auto___45075 = arguments.length;
var i__4790__auto___45076 = (0);
while(true){
if((i__4790__auto___45076 < len__4789__auto___45075)){
args__4795__auto__.push((arguments[i__4790__auto___45076]));

var G__45077 = (i__4790__auto___45076 + (1));
i__4790__auto___45076 = G__45077;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((0) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((0)),(0),null)):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__4796__auto__);
});

(sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__4582__auto__ = (function sablono$core$iter__44763(s__44764){
return (new cljs.core.LazySeq(null,(function (){
var s__44764__$1 = s__44764;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__44764__$1);
if(temp__5735__auto__){
var s__44764__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(s__44764__$2)){
var c__4580__auto__ = cljs.core.chunk_first(s__44764__$2);
var size__4581__auto__ = cljs.core.count(c__4580__auto__);
var b__44766 = cljs.core.chunk_buffer(size__4581__auto__);
if((function (){var i__44765 = (0);
while(true){
if((i__44765 < size__4581__auto__)){
var style = cljs.core._nth(c__4580__auto__,i__44765);
cljs.core.chunk_append(b__44766,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([style], 0)),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null));

var G__45079 = (i__44765 + (1));
i__44765 = G__45079;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__44766),sablono$core$iter__44763(cljs.core.chunk_rest(s__44764__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__44766),null);
}
} else {
var style = cljs.core.first(s__44764__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([style], 0)),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null),sablono$core$iter__44763(cljs.core.rest(s__44764__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4582__auto__(styles);
}));

(sablono.core.include_css.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(sablono.core.include_css.cljs$lang$applyTo = (function (seq44758){
var self__4777__auto__ = this;
return self__4777__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44758));
}));

/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
return goog.dom.appendChild(goog.dom.getDocument().body,goog.dom.createDom("script",({"src": src})));
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js("http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to44794 = (function sablono$core$link_to44794(var_args){
var args__4795__auto__ = [];
var len__4789__auto___45081 = arguments.length;
var i__4790__auto___45082 = (0);
while(true){
if((i__4790__auto___45082 < len__4789__auto___45081)){
args__4795__auto__.push((arguments[i__4790__auto___45082]));

var G__45083 = (i__4790__auto___45082 + (1));
i__4790__auto___45082 = G__45083;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((1) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((1)),(0),null)):null);
return sablono.core.link_to44794.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4796__auto__);
});

(sablono.core.link_to44794.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([url], 0))], null),content], null);
}));

(sablono.core.link_to44794.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(sablono.core.link_to44794.cljs$lang$applyTo = (function (seq44796){
var G__44797 = cljs.core.first(seq44796);
var seq44796__$1 = cljs.core.next(seq44796);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__44797,seq44796__$1);
}));


sablono.core.link_to = sablono.core.wrap_attrs(sablono.core.link_to44794);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to44806 = (function sablono$core$mail_to44806(var_args){
var args__4795__auto__ = [];
var len__4789__auto___45085 = arguments.length;
var i__4790__auto___45086 = (0);
while(true){
if((i__4790__auto___45086 < len__4789__auto___45085)){
args__4795__auto__.push((arguments[i__4790__auto___45086]));

var G__45087 = (i__4790__auto___45086 + (1));
i__4790__auto___45086 = G__45087;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((1) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((1)),(0),null)):null);
return sablono.core.mail_to44806.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4796__auto__);
});

(sablono.core.mail_to44806.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__44811){
var vec__44812 = p__44811;
var content = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44812,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),["mailto:",cljs.core.str.cljs$core$IFn$_invoke$arity$1(e_mail)].join('')], null),(function (){var or__4185__auto__ = content;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return e_mail;
}
})()], null);
}));

(sablono.core.mail_to44806.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(sablono.core.mail_to44806.cljs$lang$applyTo = (function (seq44808){
var G__44809 = cljs.core.first(seq44808);
var seq44808__$1 = cljs.core.next(seq44808);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__44809,seq44808__$1);
}));


sablono.core.mail_to = sablono.core.wrap_attrs(sablono.core.mail_to44806);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list44815 = (function sablono$core$unordered_list44815(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),(function (){var iter__4582__auto__ = (function sablono$core$unordered_list44815_$_iter__44816(s__44817){
return (new cljs.core.LazySeq(null,(function (){
var s__44817__$1 = s__44817;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__44817__$1);
if(temp__5735__auto__){
var s__44817__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(s__44817__$2)){
var c__4580__auto__ = cljs.core.chunk_first(s__44817__$2);
var size__4581__auto__ = cljs.core.count(c__4580__auto__);
var b__44819 = cljs.core.chunk_buffer(size__4581__auto__);
if((function (){var i__44818 = (0);
while(true){
if((i__44818 < size__4581__auto__)){
var x = cljs.core._nth(c__4580__auto__,i__44818);
cljs.core.chunk_append(b__44819,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__45097 = (i__44818 + (1));
i__44818 = G__45097;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__44819),sablono$core$unordered_list44815_$_iter__44816(cljs.core.chunk_rest(s__44817__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__44819),null);
}
} else {
var x = cljs.core.first(s__44817__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$unordered_list44815_$_iter__44816(cljs.core.rest(s__44817__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4582__auto__(coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs(sablono.core.unordered_list44815);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list44820 = (function sablono$core$ordered_list44820(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ol","ol",932524051),(function (){var iter__4582__auto__ = (function sablono$core$ordered_list44820_$_iter__44833(s__44834){
return (new cljs.core.LazySeq(null,(function (){
var s__44834__$1 = s__44834;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__44834__$1);
if(temp__5735__auto__){
var s__44834__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(s__44834__$2)){
var c__4580__auto__ = cljs.core.chunk_first(s__44834__$2);
var size__4581__auto__ = cljs.core.count(c__4580__auto__);
var b__44836 = cljs.core.chunk_buffer(size__4581__auto__);
if((function (){var i__44835 = (0);
while(true){
if((i__44835 < size__4581__auto__)){
var x = cljs.core._nth(c__4580__auto__,i__44835);
cljs.core.chunk_append(b__44836,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__45100 = (i__44835 + (1));
i__44835 = G__45100;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__44836),sablono$core$ordered_list44820_$_iter__44833(cljs.core.chunk_rest(s__44834__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__44836),null);
}
} else {
var x = cljs.core.first(s__44834__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$ordered_list44820_$_iter__44833(cljs.core.rest(s__44834__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4582__auto__(coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs(sablono.core.ordered_list44820);
/**
 * Create an image element.
 */
sablono.core.image44841 = (function sablono$core$image44841(var_args){
var G__44844 = arguments.length;
switch (G__44844) {
case 1:
return sablono.core.image44841.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image44841.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.image44841.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([src], 0))], null)], null);
}));

(sablono.core.image44841.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([src], 0)),new cljs.core.Keyword(null,"alt","alt",-3214426),alt], null)], null);
}));

(sablono.core.image44841.cljs$lang$maxFixedArity = 2);


sablono.core.image = sablono.core.wrap_attrs(sablono.core.image44841);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (p1__44848_SHARP_,p2__44849_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__44848_SHARP_),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p2__44849_SHARP_),"]"].join('');
}),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(sablono.core._STAR_group_STAR_,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([name], 0))));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (p1__44850_SHARP_,p2__44851_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__44850_SHARP_),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p2__44851_SHARP_)].join('');
}),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(sablono.core._STAR_group_STAR_,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([name], 0))));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(var_args){
var G__44857 = arguments.length;
switch (G__44857) {
case 2:
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (type,name){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id(name)], null)], null);
}));

(sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3 = (function (type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id(name),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__4185__auto__ = value;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return undefined;
}
})()], null)], null);
}));

(sablono.core.input_field_STAR_.cljs$lang$maxFixedArity = 3);

/**
 * Creates a color input field.
 */
sablono.core.color_field44864 = (function sablono$core$color_field44864(var_args){
var G__44866 = arguments.length;
switch (G__44866) {
case 1:
return sablono.core.color_field44864.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field44864.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.color_field44864.cljs$core$IFn$_invoke$arity$1 = (function (name__44700__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"color","color",-1642760596,null)),name__44700__auto__);
}));

(sablono.core.color_field44864.cljs$core$IFn$_invoke$arity$2 = (function (name__44700__auto__,value__44701__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"color","color",-1642760596,null)),name__44700__auto__,value__44701__auto__);
}));

(sablono.core.color_field44864.cljs$lang$maxFixedArity = 2);


sablono.core.color_field = sablono.core.wrap_attrs(sablono.core.color_field44864);

/**
 * Creates a date input field.
 */
sablono.core.date_field44869 = (function sablono$core$date_field44869(var_args){
var G__44871 = arguments.length;
switch (G__44871) {
case 1:
return sablono.core.date_field44869.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field44869.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.date_field44869.cljs$core$IFn$_invoke$arity$1 = (function (name__44700__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"date","date",177097065,null)),name__44700__auto__);
}));

(sablono.core.date_field44869.cljs$core$IFn$_invoke$arity$2 = (function (name__44700__auto__,value__44701__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"date","date",177097065,null)),name__44700__auto__,value__44701__auto__);
}));

(sablono.core.date_field44869.cljs$lang$maxFixedArity = 2);


sablono.core.date_field = sablono.core.wrap_attrs(sablono.core.date_field44869);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field44875 = (function sablono$core$datetime_field44875(var_args){
var G__44877 = arguments.length;
switch (G__44877) {
case 1:
return sablono.core.datetime_field44875.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field44875.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.datetime_field44875.cljs$core$IFn$_invoke$arity$1 = (function (name__44700__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null)),name__44700__auto__);
}));

(sablono.core.datetime_field44875.cljs$core$IFn$_invoke$arity$2 = (function (name__44700__auto__,value__44701__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null)),name__44700__auto__,value__44701__auto__);
}));

(sablono.core.datetime_field44875.cljs$lang$maxFixedArity = 2);


sablono.core.datetime_field = sablono.core.wrap_attrs(sablono.core.datetime_field44875);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field44881 = (function sablono$core$datetime_local_field44881(var_args){
var G__44883 = arguments.length;
switch (G__44883) {
case 1:
return sablono.core.datetime_local_field44881.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field44881.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.datetime_local_field44881.cljs$core$IFn$_invoke$arity$1 = (function (name__44700__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null)),name__44700__auto__);
}));

(sablono.core.datetime_local_field44881.cljs$core$IFn$_invoke$arity$2 = (function (name__44700__auto__,value__44701__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null)),name__44700__auto__,value__44701__auto__);
}));

(sablono.core.datetime_local_field44881.cljs$lang$maxFixedArity = 2);


sablono.core.datetime_local_field = sablono.core.wrap_attrs(sablono.core.datetime_local_field44881);

/**
 * Creates a email input field.
 */
sablono.core.email_field44886 = (function sablono$core$email_field44886(var_args){
var G__44888 = arguments.length;
switch (G__44888) {
case 1:
return sablono.core.email_field44886.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field44886.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.email_field44886.cljs$core$IFn$_invoke$arity$1 = (function (name__44700__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"email","email",-1238619063,null)),name__44700__auto__);
}));

(sablono.core.email_field44886.cljs$core$IFn$_invoke$arity$2 = (function (name__44700__auto__,value__44701__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"email","email",-1238619063,null)),name__44700__auto__,value__44701__auto__);
}));

(sablono.core.email_field44886.cljs$lang$maxFixedArity = 2);


sablono.core.email_field = sablono.core.wrap_attrs(sablono.core.email_field44886);

/**
 * Creates a file input field.
 */
sablono.core.file_field44893 = (function sablono$core$file_field44893(var_args){
var G__44896 = arguments.length;
switch (G__44896) {
case 1:
return sablono.core.file_field44893.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field44893.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.file_field44893.cljs$core$IFn$_invoke$arity$1 = (function (name__44700__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"file","file",370885649,null)),name__44700__auto__);
}));

(sablono.core.file_field44893.cljs$core$IFn$_invoke$arity$2 = (function (name__44700__auto__,value__44701__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"file","file",370885649,null)),name__44700__auto__,value__44701__auto__);
}));

(sablono.core.file_field44893.cljs$lang$maxFixedArity = 2);


sablono.core.file_field = sablono.core.wrap_attrs(sablono.core.file_field44893);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field44898 = (function sablono$core$hidden_field44898(var_args){
var G__44906 = arguments.length;
switch (G__44906) {
case 1:
return sablono.core.hidden_field44898.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field44898.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.hidden_field44898.cljs$core$IFn$_invoke$arity$1 = (function (name__44700__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null)),name__44700__auto__);
}));

(sablono.core.hidden_field44898.cljs$core$IFn$_invoke$arity$2 = (function (name__44700__auto__,value__44701__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null)),name__44700__auto__,value__44701__auto__);
}));

(sablono.core.hidden_field44898.cljs$lang$maxFixedArity = 2);


sablono.core.hidden_field = sablono.core.wrap_attrs(sablono.core.hidden_field44898);

/**
 * Creates a month input field.
 */
sablono.core.month_field44909 = (function sablono$core$month_field44909(var_args){
var G__44911 = arguments.length;
switch (G__44911) {
case 1:
return sablono.core.month_field44909.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field44909.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.month_field44909.cljs$core$IFn$_invoke$arity$1 = (function (name__44700__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"month","month",-319717006,null)),name__44700__auto__);
}));

(sablono.core.month_field44909.cljs$core$IFn$_invoke$arity$2 = (function (name__44700__auto__,value__44701__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"month","month",-319717006,null)),name__44700__auto__,value__44701__auto__);
}));

(sablono.core.month_field44909.cljs$lang$maxFixedArity = 2);


sablono.core.month_field = sablono.core.wrap_attrs(sablono.core.month_field44909);

/**
 * Creates a number input field.
 */
sablono.core.number_field44912 = (function sablono$core$number_field44912(var_args){
var G__44917 = arguments.length;
switch (G__44917) {
case 1:
return sablono.core.number_field44912.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field44912.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.number_field44912.cljs$core$IFn$_invoke$arity$1 = (function (name__44700__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"number","number",-1084057331,null)),name__44700__auto__);
}));

(sablono.core.number_field44912.cljs$core$IFn$_invoke$arity$2 = (function (name__44700__auto__,value__44701__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"number","number",-1084057331,null)),name__44700__auto__,value__44701__auto__);
}));

(sablono.core.number_field44912.cljs$lang$maxFixedArity = 2);


sablono.core.number_field = sablono.core.wrap_attrs(sablono.core.number_field44912);

/**
 * Creates a password input field.
 */
sablono.core.password_field44918 = (function sablono$core$password_field44918(var_args){
var G__44920 = arguments.length;
switch (G__44920) {
case 1:
return sablono.core.password_field44918.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field44918.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.password_field44918.cljs$core$IFn$_invoke$arity$1 = (function (name__44700__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"password","password",2057553998,null)),name__44700__auto__);
}));

(sablono.core.password_field44918.cljs$core$IFn$_invoke$arity$2 = (function (name__44700__auto__,value__44701__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"password","password",2057553998,null)),name__44700__auto__,value__44701__auto__);
}));

(sablono.core.password_field44918.cljs$lang$maxFixedArity = 2);


sablono.core.password_field = sablono.core.wrap_attrs(sablono.core.password_field44918);

/**
 * Creates a range input field.
 */
sablono.core.range_field44921 = (function sablono$core$range_field44921(var_args){
var G__44923 = arguments.length;
switch (G__44923) {
case 1:
return sablono.core.range_field44921.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field44921.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.range_field44921.cljs$core$IFn$_invoke$arity$1 = (function (name__44700__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"range","range",-1014743483,null)),name__44700__auto__);
}));

(sablono.core.range_field44921.cljs$core$IFn$_invoke$arity$2 = (function (name__44700__auto__,value__44701__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"range","range",-1014743483,null)),name__44700__auto__,value__44701__auto__);
}));

(sablono.core.range_field44921.cljs$lang$maxFixedArity = 2);


sablono.core.range_field = sablono.core.wrap_attrs(sablono.core.range_field44921);

/**
 * Creates a search input field.
 */
sablono.core.search_field44924 = (function sablono$core$search_field44924(var_args){
var G__44927 = arguments.length;
switch (G__44927) {
case 1:
return sablono.core.search_field44924.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field44924.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.search_field44924.cljs$core$IFn$_invoke$arity$1 = (function (name__44700__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"search","search",-1089495947,null)),name__44700__auto__);
}));

(sablono.core.search_field44924.cljs$core$IFn$_invoke$arity$2 = (function (name__44700__auto__,value__44701__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"search","search",-1089495947,null)),name__44700__auto__,value__44701__auto__);
}));

(sablono.core.search_field44924.cljs$lang$maxFixedArity = 2);


sablono.core.search_field = sablono.core.wrap_attrs(sablono.core.search_field44924);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field44932 = (function sablono$core$tel_field44932(var_args){
var G__44936 = arguments.length;
switch (G__44936) {
case 1:
return sablono.core.tel_field44932.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field44932.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.tel_field44932.cljs$core$IFn$_invoke$arity$1 = (function (name__44700__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"tel","tel",1864669686,null)),name__44700__auto__);
}));

(sablono.core.tel_field44932.cljs$core$IFn$_invoke$arity$2 = (function (name__44700__auto__,value__44701__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"tel","tel",1864669686,null)),name__44700__auto__,value__44701__auto__);
}));

(sablono.core.tel_field44932.cljs$lang$maxFixedArity = 2);


sablono.core.tel_field = sablono.core.wrap_attrs(sablono.core.tel_field44932);

/**
 * Creates a text input field.
 */
sablono.core.text_field44943 = (function sablono$core$text_field44943(var_args){
var G__44947 = arguments.length;
switch (G__44947) {
case 1:
return sablono.core.text_field44943.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field44943.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.text_field44943.cljs$core$IFn$_invoke$arity$1 = (function (name__44700__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"text","text",-150030170,null)),name__44700__auto__);
}));

(sablono.core.text_field44943.cljs$core$IFn$_invoke$arity$2 = (function (name__44700__auto__,value__44701__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"text","text",-150030170,null)),name__44700__auto__,value__44701__auto__);
}));

(sablono.core.text_field44943.cljs$lang$maxFixedArity = 2);


sablono.core.text_field = sablono.core.wrap_attrs(sablono.core.text_field44943);

/**
 * Creates a time input field.
 */
sablono.core.time_field44952 = (function sablono$core$time_field44952(var_args){
var G__44956 = arguments.length;
switch (G__44956) {
case 1:
return sablono.core.time_field44952.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field44952.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.time_field44952.cljs$core$IFn$_invoke$arity$1 = (function (name__44700__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"time","time",-1268547887,null)),name__44700__auto__);
}));

(sablono.core.time_field44952.cljs$core$IFn$_invoke$arity$2 = (function (name__44700__auto__,value__44701__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"time","time",-1268547887,null)),name__44700__auto__,value__44701__auto__);
}));

(sablono.core.time_field44952.cljs$lang$maxFixedArity = 2);


sablono.core.time_field = sablono.core.wrap_attrs(sablono.core.time_field44952);

/**
 * Creates a url input field.
 */
sablono.core.url_field44963 = (function sablono$core$url_field44963(var_args){
var G__44968 = arguments.length;
switch (G__44968) {
case 1:
return sablono.core.url_field44963.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field44963.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.url_field44963.cljs$core$IFn$_invoke$arity$1 = (function (name__44700__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"url","url",1916828573,null)),name__44700__auto__);
}));

(sablono.core.url_field44963.cljs$core$IFn$_invoke$arity$2 = (function (name__44700__auto__,value__44701__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"url","url",1916828573,null)),name__44700__auto__,value__44701__auto__);
}));

(sablono.core.url_field44963.cljs$lang$maxFixedArity = 2);


sablono.core.url_field = sablono.core.wrap_attrs(sablono.core.url_field44963);

/**
 * Creates a week input field.
 */
sablono.core.week_field44973 = (function sablono$core$week_field44973(var_args){
var G__44977 = arguments.length;
switch (G__44977) {
case 1:
return sablono.core.week_field44973.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field44973.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.week_field44973.cljs$core$IFn$_invoke$arity$1 = (function (name__44700__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"week","week",314058249,null)),name__44700__auto__);
}));

(sablono.core.week_field44973.cljs$core$IFn$_invoke$arity$2 = (function (name__44700__auto__,value__44701__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"week","week",314058249,null)),name__44700__auto__,value__44701__auto__);
}));

(sablono.core.week_field44973.cljs$lang$maxFixedArity = 2);


sablono.core.week_field = sablono.core.wrap_attrs(sablono.core.week_field44973);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box44981 = (function sablono$core$check_box44981(var_args){
var G__44984 = arguments.length;
switch (G__44984) {
case 1:
return sablono.core.check_box44981.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box44981.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box44981.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.check_box44981.cljs$core$IFn$_invoke$arity$1 = (function (name){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id(name)], null)], null);
}));

(sablono.core.check_box44981.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id(name),new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
}));

(sablono.core.check_box44981.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id(name),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
}));

(sablono.core.check_box44981.cljs$lang$maxFixedArity = 3);


sablono.core.check_box = sablono.core.wrap_attrs(sablono.core.check_box44981);
/**
 * Creates a radio button.
 */
sablono.core.radio_button44988 = (function sablono$core$radio_button44988(var_args){
var G__44990 = arguments.length;
switch (G__44990) {
case 1:
return sablono.core.radio_button44988.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button44988.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button44988.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.radio_button44988.cljs$core$IFn$_invoke$arity$1 = (function (group){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id(sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([group], 0)))], null)], null);
}));

(sablono.core.radio_button44988.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id(sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([group], 0))),new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
}));

(sablono.core.radio_button44988.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id([sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([group], 0)),"-",sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([value], 0))].join('')),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
}));

(sablono.core.radio_button44988.cljs$lang$maxFixedArity = 3);


sablono.core.radio_button = sablono.core.wrap_attrs(sablono.core.radio_button44988);
sablono.core.hash_key = (function sablono$core$hash_key(x){
return goog.string.hashCode(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([x], 0)));
});
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options44997 = (function sablono$core$select_options44997(coll){
var iter__4582__auto__ = (function sablono$core$select_options44997_$_iter__44998(s__44999){
return (new cljs.core.LazySeq(null,(function (){
var s__44999__$1 = s__44999;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__44999__$1);
if(temp__5735__auto__){
var s__44999__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(s__44999__$2)){
var c__4580__auto__ = cljs.core.chunk_first(s__44999__$2);
var size__4581__auto__ = cljs.core.count(c__4580__auto__);
var b__45001 = cljs.core.chunk_buffer(size__4581__auto__);
if((function (){var i__45000 = (0);
while(true){
if((i__45000 < size__4581__auto__)){
var x = cljs.core._nth(c__4580__auto__,i__45000);
cljs.core.chunk_append(b__45001,((cljs.core.sequential_QMARK_(x))?(function (){var vec__45004 = x;
var text = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45004,(0),null);
var val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45004,(1),null);
var disabled_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45004,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$(disabled_QMARK_);
if(cljs.core.sequential_QMARK_(val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key(text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),(sablono.core.select_options44997.cljs$core$IFn$_invoke$arity$1 ? sablono.core.select_options44997.cljs$core$IFn$_invoke$arity$1(val) : sablono.core.select_options44997.call(null,val))], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key(val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key(x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)));

var G__45190 = (i__45000 + (1));
i__45000 = G__45190;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__45001),sablono$core$select_options44997_$_iter__44998(cljs.core.chunk_rest(s__44999__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__45001),null);
}
} else {
var x = cljs.core.first(s__44999__$2);
return cljs.core.cons(((cljs.core.sequential_QMARK_(x))?(function (){var vec__45008 = x;
var text = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45008,(0),null);
var val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45008,(1),null);
var disabled_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45008,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$(disabled_QMARK_);
if(cljs.core.sequential_QMARK_(val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key(text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),(sablono.core.select_options44997.cljs$core$IFn$_invoke$arity$1 ? sablono.core.select_options44997.cljs$core$IFn$_invoke$arity$1(val) : sablono.core.select_options44997.call(null,val))], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key(val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key(x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)),sablono$core$select_options44997_$_iter__44998(cljs.core.rest(s__44999__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4582__auto__(coll);
});

sablono.core.select_options = sablono.core.wrap_attrs(sablono.core.select_options44997);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down45015 = (function sablono$core$drop_down45015(var_args){
var G__45023 = arguments.length;
switch (G__45023) {
case 2:
return sablono.core.drop_down45015.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down45015.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.drop_down45015.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down45015.cljs$core$IFn$_invoke$arity$3(name,options,null);
}));

(sablono.core.drop_down45015.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id(name)], null),sablono.core.select_options(options,selected)], null);
}));

(sablono.core.drop_down45015.cljs$lang$maxFixedArity = 3);


sablono.core.drop_down = sablono.core.wrap_attrs(sablono.core.drop_down45015);
/**
 * Creates a text area element.
 */
sablono.core.text_area45026 = (function sablono$core$text_area45026(var_args){
var G__45028 = arguments.length;
switch (G__45028) {
case 1:
return sablono.core.text_area45026.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area45026.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.text_area45026.cljs$core$IFn$_invoke$arity$1 = (function (name){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id(name)], null)], null);
}));

(sablono.core.text_area45026.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id(name),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__4185__auto__ = value;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return undefined;
}
})()], null)], null);
}));

(sablono.core.text_area45026.cljs$lang$maxFixedArity = 2);


sablono.core.text_area = sablono.core.wrap_attrs(sablono.core.text_area45026);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label45035 = (function sablono$core$label45035(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"htmlFor","htmlFor",-1050291720),sablono.core.make_id(name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs(sablono.core.label45035);
/**
 * Creates a submit button.
 */
sablono.core.submit_button45036 = (function sablono$core$submit_button45036(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"submit",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs(sablono.core.submit_button45036);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button45039 = (function sablono$core$reset_button45039(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"reset",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs(sablono.core.reset_button45039);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to45041 = (function sablono$core$form_to45041(var_args){
var args__4795__auto__ = [];
var len__4789__auto___45212 = arguments.length;
var i__4790__auto___45213 = (0);
while(true){
if((i__4790__auto___45213 < len__4789__auto___45212)){
args__4795__auto__.push((arguments[i__4790__auto___45213]));

var G__45214 = (i__4790__auto___45213 + (1));
i__4790__auto___45213 = G__45214;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((1) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((1)),(0),null)):null);
return sablono.core.form_to45041.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4796__auto__);
});

(sablono.core.form_to45041.cljs$core$IFn$_invoke$arity$variadic = (function (p__45048,body){
var vec__45049 = p__45048;
var method = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45049,(0),null);
var action = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45049,(1),null);
var method_str = clojure.string.upper_case(cljs.core.name(method));
var action_uri = sablono.util.to_uri(action);
return cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(((cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"get","get",1683182755),null,new cljs.core.Keyword(null,"post","post",269697687),null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),method_str,new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),"POST",new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null),sablono.core.hidden_field(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),(3735928559)], null),"_method",method_str)], null)),body));
}));

(sablono.core.form_to45041.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(sablono.core.form_to45041.cljs$lang$applyTo = (function (seq45043){
var G__45044 = cljs.core.first(seq45043);
var seq45043__$1 = cljs.core.next(seq45043);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__45044,seq45043__$1);
}));


sablono.core.form_to = sablono.core.wrap_attrs(sablono.core.form_to45041);

//# sourceMappingURL=sablono.core.js.map
