goog.provide('shadow.dom');
goog.require('cljs.core');
goog.require('goog.dom');
goog.require('goog.dom.forms');
goog.require('goog.dom.classlist');
goog.require('goog.style');
goog.require('goog.style.transition');
goog.require('goog.string');
goog.require('clojure.string');
goog.require('cljs.core.async');
shadow.dom.transition_supported_QMARK_ = (((typeof window !== 'undefined'))?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
var x__4487__auto__ = (((this$ == null))?null:this$);
var m__4488__auto__ = (shadow.dom._to_dom[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return (m__4488__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4488__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4488__auto__.call(null,this$));
} else {
var m__4485__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__4485__auto__ == null)))){
return (m__4485__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4485__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4485__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
var x__4487__auto__ = (((this$ == null))?null:this$);
var m__4488__auto__ = (shadow.dom._to_svg[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return (m__4488__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4488__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4488__auto__.call(null,this$));
} else {
var m__4485__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__4485__auto__ == null)))){
return (m__4485__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4485__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4485__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__39499 = coll;
var G__39500 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__39499,G__39500) : shadow.dom.lazy_native_coll_seq.call(null,G__39499,G__39500));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__4185__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write(writer__4429__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__39545 = arguments.length;
switch (G__39545) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__39550 = arguments.length;
switch (G__39550) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__39556 = arguments.length;
switch (G__39556) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__39561 = arguments.length;
switch (G__39561) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__39581 = arguments.length;
switch (G__39581) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node(parent),shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node(el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node(el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__39597 = arguments.length;
switch (G__39597) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node(el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__4185__auto__ = (!((typeof document !== 'undefined')));
if(or__4185__auto__){
return or__4185__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e39602){if((e39602 instanceof Object)){
var e = e39602;
return console.log("didnt support attachEvent",el,e);
} else {
throw e39602;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__4185__auto__ = (!((typeof document !== 'undefined')));
if(or__4185__auto__){
return or__4185__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__39621 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__39622 = null;
var count__39623 = (0);
var i__39624 = (0);
while(true){
if((i__39624 < count__39623)){
var el = chunk__39622.cljs$core$IIndexed$_nth$arity$2(null,i__39624);
var handler_40681__$1 = ((function (seq__39621,chunk__39622,count__39623,i__39624,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__39621,chunk__39622,count__39623,i__39624,el))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_40681__$1);


var G__40688 = seq__39621;
var G__40689 = chunk__39622;
var G__40690 = count__39623;
var G__40691 = (i__39624 + (1));
seq__39621 = G__40688;
chunk__39622 = G__40689;
count__39623 = G__40690;
i__39624 = G__40691;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__39621);
if(temp__5735__auto__){
var seq__39621__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__39621__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__39621__$1);
var G__40693 = cljs.core.chunk_rest(seq__39621__$1);
var G__40694 = c__4609__auto__;
var G__40695 = cljs.core.count(c__4609__auto__);
var G__40696 = (0);
seq__39621 = G__40693;
chunk__39622 = G__40694;
count__39623 = G__40695;
i__39624 = G__40696;
continue;
} else {
var el = cljs.core.first(seq__39621__$1);
var handler_40701__$1 = ((function (seq__39621,chunk__39622,count__39623,i__39624,el,seq__39621__$1,temp__5735__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__39621,chunk__39622,count__39623,i__39624,el,seq__39621__$1,temp__5735__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_40701__$1);


var G__40703 = cljs.core.next(seq__39621__$1);
var G__40704 = null;
var G__40705 = (0);
var G__40706 = (0);
seq__39621 = G__40703;
chunk__39622 = G__40704;
count__39623 = G__40705;
i__39624 = G__40706;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__39652 = arguments.length;
switch (G__39652) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
return shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node(el),cljs.core.name(ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__39664 = cljs.core.seq(events);
var chunk__39665 = null;
var count__39666 = (0);
var i__39667 = (0);
while(true){
if((i__39667 < count__39666)){
var vec__39686 = chunk__39665.cljs$core$IIndexed$_nth$arity$2(null,i__39667);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39686,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39686,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__40713 = seq__39664;
var G__40714 = chunk__39665;
var G__40715 = count__39666;
var G__40716 = (i__39667 + (1));
seq__39664 = G__40713;
chunk__39665 = G__40714;
count__39666 = G__40715;
i__39667 = G__40716;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__39664);
if(temp__5735__auto__){
var seq__39664__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__39664__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__39664__$1);
var G__40718 = cljs.core.chunk_rest(seq__39664__$1);
var G__40719 = c__4609__auto__;
var G__40720 = cljs.core.count(c__4609__auto__);
var G__40721 = (0);
seq__39664 = G__40718;
chunk__39665 = G__40719;
count__39666 = G__40720;
i__39667 = G__40721;
continue;
} else {
var vec__39690 = cljs.core.first(seq__39664__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39690,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39690,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__40724 = cljs.core.next(seq__39664__$1);
var G__40725 = null;
var G__40726 = (0);
var G__40727 = (0);
seq__39664 = G__40724;
chunk__39665 = G__40725;
count__39666 = G__40726;
i__39667 = G__40727;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__39697 = cljs.core.seq(styles);
var chunk__39698 = null;
var count__39699 = (0);
var i__39700 = (0);
while(true){
if((i__39700 < count__39699)){
var vec__39721 = chunk__39698.cljs$core$IIndexed$_nth$arity$2(null,i__39700);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39721,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39721,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__40731 = seq__39697;
var G__40732 = chunk__39698;
var G__40733 = count__39699;
var G__40734 = (i__39700 + (1));
seq__39697 = G__40731;
chunk__39698 = G__40732;
count__39699 = G__40733;
i__39700 = G__40734;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__39697);
if(temp__5735__auto__){
var seq__39697__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__39697__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__39697__$1);
var G__40736 = cljs.core.chunk_rest(seq__39697__$1);
var G__40737 = c__4609__auto__;
var G__40738 = cljs.core.count(c__4609__auto__);
var G__40739 = (0);
seq__39697 = G__40736;
chunk__39698 = G__40737;
count__39699 = G__40738;
i__39700 = G__40739;
continue;
} else {
var vec__39726 = cljs.core.first(seq__39697__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39726,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39726,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__40744 = cljs.core.next(seq__39697__$1);
var G__40745 = null;
var G__40746 = (0);
var G__40747 = (0);
seq__39697 = G__40744;
chunk__39698 = G__40745;
count__39699 = G__40746;
i__39700 = G__40747;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__39734_40748 = key;
var G__39734_40749__$1 = (((G__39734_40748 instanceof cljs.core.Keyword))?G__39734_40748.fqn:null);
switch (G__39734_40749__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_40754 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__4185__auto__ = goog.string.startsWith(ks_40754,"data-");
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return goog.string.startsWith(ks_40754,"aria-");
}
})())){
el.setAttribute(ks_40754,value);
} else {
(el[ks_40754] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node(el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__39761){
var map__39763 = p__39761;
var map__39763__$1 = (((((!((map__39763 == null))))?(((((map__39763.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39763.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39763):map__39763);
var props = map__39763__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39763__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__39767 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39767,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39767,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39767,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__39778 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__39778,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__39778;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__39787 = arguments.length;
switch (G__39787) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5735__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5735__auto__)){
var n = temp__5735__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5735__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5735__auto__)){
var n = temp__5735__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__39803){
var vec__39804 = p__39803;
var seq__39805 = cljs.core.seq(vec__39804);
var first__39806 = cljs.core.first(seq__39805);
var seq__39805__$1 = cljs.core.next(seq__39805);
var nn = first__39806;
var first__39806__$1 = cljs.core.first(seq__39805__$1);
var seq__39805__$2 = cljs.core.next(seq__39805__$1);
var np = first__39806__$1;
var nc = seq__39805__$2;
var node = vec__39804;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__39816 = nn;
var G__39817 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__39816,G__39817) : create_fn.call(null,G__39816,G__39817));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__39819 = nn;
var G__39820 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__39819,G__39820) : create_fn.call(null,G__39819,G__39820));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__39821 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39821,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39821,(1),null);
var seq__39830_40790 = cljs.core.seq(node_children);
var chunk__39831_40791 = null;
var count__39832_40792 = (0);
var i__39833_40793 = (0);
while(true){
if((i__39833_40793 < count__39832_40792)){
var child_struct_40794 = chunk__39831_40791.cljs$core$IIndexed$_nth$arity$2(null,i__39833_40793);
var children_40795 = shadow.dom.dom_node(child_struct_40794);
if(cljs.core.seq_QMARK_(children_40795)){
var seq__39864_40796 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_40795));
var chunk__39866_40797 = null;
var count__39867_40798 = (0);
var i__39868_40799 = (0);
while(true){
if((i__39868_40799 < count__39867_40798)){
var child_40801 = chunk__39866_40797.cljs$core$IIndexed$_nth$arity$2(null,i__39868_40799);
if(cljs.core.truth_(child_40801)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_40801);


var G__40802 = seq__39864_40796;
var G__40803 = chunk__39866_40797;
var G__40804 = count__39867_40798;
var G__40805 = (i__39868_40799 + (1));
seq__39864_40796 = G__40802;
chunk__39866_40797 = G__40803;
count__39867_40798 = G__40804;
i__39868_40799 = G__40805;
continue;
} else {
var G__40806 = seq__39864_40796;
var G__40807 = chunk__39866_40797;
var G__40808 = count__39867_40798;
var G__40809 = (i__39868_40799 + (1));
seq__39864_40796 = G__40806;
chunk__39866_40797 = G__40807;
count__39867_40798 = G__40808;
i__39868_40799 = G__40809;
continue;
}
} else {
var temp__5735__auto___40810 = cljs.core.seq(seq__39864_40796);
if(temp__5735__auto___40810){
var seq__39864_40811__$1 = temp__5735__auto___40810;
if(cljs.core.chunked_seq_QMARK_(seq__39864_40811__$1)){
var c__4609__auto___40814 = cljs.core.chunk_first(seq__39864_40811__$1);
var G__40815 = cljs.core.chunk_rest(seq__39864_40811__$1);
var G__40816 = c__4609__auto___40814;
var G__40817 = cljs.core.count(c__4609__auto___40814);
var G__40818 = (0);
seq__39864_40796 = G__40815;
chunk__39866_40797 = G__40816;
count__39867_40798 = G__40817;
i__39868_40799 = G__40818;
continue;
} else {
var child_40819 = cljs.core.first(seq__39864_40811__$1);
if(cljs.core.truth_(child_40819)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_40819);


var G__40820 = cljs.core.next(seq__39864_40811__$1);
var G__40821 = null;
var G__40822 = (0);
var G__40823 = (0);
seq__39864_40796 = G__40820;
chunk__39866_40797 = G__40821;
count__39867_40798 = G__40822;
i__39868_40799 = G__40823;
continue;
} else {
var G__40824 = cljs.core.next(seq__39864_40811__$1);
var G__40825 = null;
var G__40826 = (0);
var G__40827 = (0);
seq__39864_40796 = G__40824;
chunk__39866_40797 = G__40825;
count__39867_40798 = G__40826;
i__39868_40799 = G__40827;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_40795);
}


var G__40830 = seq__39830_40790;
var G__40831 = chunk__39831_40791;
var G__40832 = count__39832_40792;
var G__40833 = (i__39833_40793 + (1));
seq__39830_40790 = G__40830;
chunk__39831_40791 = G__40831;
count__39832_40792 = G__40832;
i__39833_40793 = G__40833;
continue;
} else {
var temp__5735__auto___40834 = cljs.core.seq(seq__39830_40790);
if(temp__5735__auto___40834){
var seq__39830_40837__$1 = temp__5735__auto___40834;
if(cljs.core.chunked_seq_QMARK_(seq__39830_40837__$1)){
var c__4609__auto___40838 = cljs.core.chunk_first(seq__39830_40837__$1);
var G__40839 = cljs.core.chunk_rest(seq__39830_40837__$1);
var G__40840 = c__4609__auto___40838;
var G__40841 = cljs.core.count(c__4609__auto___40838);
var G__40842 = (0);
seq__39830_40790 = G__40839;
chunk__39831_40791 = G__40840;
count__39832_40792 = G__40841;
i__39833_40793 = G__40842;
continue;
} else {
var child_struct_40844 = cljs.core.first(seq__39830_40837__$1);
var children_40845 = shadow.dom.dom_node(child_struct_40844);
if(cljs.core.seq_QMARK_(children_40845)){
var seq__39893_40846 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_40845));
var chunk__39895_40847 = null;
var count__39896_40848 = (0);
var i__39897_40849 = (0);
while(true){
if((i__39897_40849 < count__39896_40848)){
var child_40854 = chunk__39895_40847.cljs$core$IIndexed$_nth$arity$2(null,i__39897_40849);
if(cljs.core.truth_(child_40854)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_40854);


var G__40855 = seq__39893_40846;
var G__40856 = chunk__39895_40847;
var G__40857 = count__39896_40848;
var G__40858 = (i__39897_40849 + (1));
seq__39893_40846 = G__40855;
chunk__39895_40847 = G__40856;
count__39896_40848 = G__40857;
i__39897_40849 = G__40858;
continue;
} else {
var G__40859 = seq__39893_40846;
var G__40860 = chunk__39895_40847;
var G__40861 = count__39896_40848;
var G__40862 = (i__39897_40849 + (1));
seq__39893_40846 = G__40859;
chunk__39895_40847 = G__40860;
count__39896_40848 = G__40861;
i__39897_40849 = G__40862;
continue;
}
} else {
var temp__5735__auto___40864__$1 = cljs.core.seq(seq__39893_40846);
if(temp__5735__auto___40864__$1){
var seq__39893_40865__$1 = temp__5735__auto___40864__$1;
if(cljs.core.chunked_seq_QMARK_(seq__39893_40865__$1)){
var c__4609__auto___40866 = cljs.core.chunk_first(seq__39893_40865__$1);
var G__40867 = cljs.core.chunk_rest(seq__39893_40865__$1);
var G__40868 = c__4609__auto___40866;
var G__40869 = cljs.core.count(c__4609__auto___40866);
var G__40870 = (0);
seq__39893_40846 = G__40867;
chunk__39895_40847 = G__40868;
count__39896_40848 = G__40869;
i__39897_40849 = G__40870;
continue;
} else {
var child_40871 = cljs.core.first(seq__39893_40865__$1);
if(cljs.core.truth_(child_40871)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_40871);


var G__40872 = cljs.core.next(seq__39893_40865__$1);
var G__40873 = null;
var G__40874 = (0);
var G__40875 = (0);
seq__39893_40846 = G__40872;
chunk__39895_40847 = G__40873;
count__39896_40848 = G__40874;
i__39897_40849 = G__40875;
continue;
} else {
var G__40876 = cljs.core.next(seq__39893_40865__$1);
var G__40877 = null;
var G__40878 = (0);
var G__40879 = (0);
seq__39893_40846 = G__40876;
chunk__39895_40847 = G__40877;
count__39896_40848 = G__40878;
i__39897_40849 = G__40879;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_40845);
}


var G__40885 = cljs.core.next(seq__39830_40837__$1);
var G__40886 = null;
var G__40887 = (0);
var G__40888 = (0);
seq__39830_40790 = G__40885;
chunk__39831_40791 = G__40886;
count__39832_40792 = G__40887;
i__39833_40793 = G__40888;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node(node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__39943 = cljs.core.seq(node);
var chunk__39944 = null;
var count__39945 = (0);
var i__39946 = (0);
while(true){
if((i__39946 < count__39945)){
var n = chunk__39944.cljs$core$IIndexed$_nth$arity$2(null,i__39946);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__40900 = seq__39943;
var G__40901 = chunk__39944;
var G__40902 = count__39945;
var G__40903 = (i__39946 + (1));
seq__39943 = G__40900;
chunk__39944 = G__40901;
count__39945 = G__40902;
i__39946 = G__40903;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__39943);
if(temp__5735__auto__){
var seq__39943__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__39943__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__39943__$1);
var G__40913 = cljs.core.chunk_rest(seq__39943__$1);
var G__40914 = c__4609__auto__;
var G__40915 = cljs.core.count(c__4609__auto__);
var G__40916 = (0);
seq__39943 = G__40913;
chunk__39944 = G__40914;
count__39945 = G__40915;
i__39946 = G__40916;
continue;
} else {
var n = cljs.core.first(seq__39943__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__40921 = cljs.core.next(seq__39943__$1);
var G__40922 = null;
var G__40923 = (0);
var G__40924 = (0);
seq__39943 = G__40921;
chunk__39944 = G__40922;
count__39945 = G__40923;
i__39946 = G__40924;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node(new$),shadow.dom.dom_node(old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__39954 = arguments.length;
switch (G__39954) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node(el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__39961 = arguments.length;
switch (G__39961) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node(el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__39971 = arguments.length;
switch (G__39971) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__4185__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.name(key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.name(key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node(node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__4795__auto__ = [];
var len__4789__auto___40951 = arguments.length;
var i__4790__auto___40952 = (0);
while(true){
if((i__4790__auto___40952 < len__4789__auto___40951)){
args__4795__auto__.push((arguments[i__4790__auto___40952]));

var G__40955 = (i__4790__auto___40952 + (1));
i__4790__auto___40952 = G__40955;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((0) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__4796__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__39993_40956 = cljs.core.seq(nodes);
var chunk__39994_40957 = null;
var count__39995_40958 = (0);
var i__39996_40959 = (0);
while(true){
if((i__39996_40959 < count__39995_40958)){
var node_40962 = chunk__39994_40957.cljs$core$IIndexed$_nth$arity$2(null,i__39996_40959);
fragment.appendChild(shadow.dom._to_dom(node_40962));


var G__40965 = seq__39993_40956;
var G__40966 = chunk__39994_40957;
var G__40967 = count__39995_40958;
var G__40968 = (i__39996_40959 + (1));
seq__39993_40956 = G__40965;
chunk__39994_40957 = G__40966;
count__39995_40958 = G__40967;
i__39996_40959 = G__40968;
continue;
} else {
var temp__5735__auto___40970 = cljs.core.seq(seq__39993_40956);
if(temp__5735__auto___40970){
var seq__39993_40971__$1 = temp__5735__auto___40970;
if(cljs.core.chunked_seq_QMARK_(seq__39993_40971__$1)){
var c__4609__auto___40973 = cljs.core.chunk_first(seq__39993_40971__$1);
var G__40974 = cljs.core.chunk_rest(seq__39993_40971__$1);
var G__40975 = c__4609__auto___40973;
var G__40976 = cljs.core.count(c__4609__auto___40973);
var G__40977 = (0);
seq__39993_40956 = G__40974;
chunk__39994_40957 = G__40975;
count__39995_40958 = G__40976;
i__39996_40959 = G__40977;
continue;
} else {
var node_40978 = cljs.core.first(seq__39993_40971__$1);
fragment.appendChild(shadow.dom._to_dom(node_40978));


var G__40979 = cljs.core.next(seq__39993_40971__$1);
var G__40980 = null;
var G__40981 = (0);
var G__40982 = (0);
seq__39993_40956 = G__40979;
chunk__39994_40957 = G__40980;
count__39995_40958 = G__40981;
i__39996_40959 = G__40982;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq39991){
var self__4777__auto__ = this;
return self__4777__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq39991));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__40000_40985 = cljs.core.seq(scripts);
var chunk__40001_40986 = null;
var count__40002_40987 = (0);
var i__40003_40988 = (0);
while(true){
if((i__40003_40988 < count__40002_40987)){
var vec__40018_40991 = chunk__40001_40986.cljs$core$IIndexed$_nth$arity$2(null,i__40003_40988);
var script_tag_40992 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40018_40991,(0),null);
var script_body_40993 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40018_40991,(1),null);
eval(script_body_40993);


var G__40995 = seq__40000_40985;
var G__40996 = chunk__40001_40986;
var G__40997 = count__40002_40987;
var G__40998 = (i__40003_40988 + (1));
seq__40000_40985 = G__40995;
chunk__40001_40986 = G__40996;
count__40002_40987 = G__40997;
i__40003_40988 = G__40998;
continue;
} else {
var temp__5735__auto___40999 = cljs.core.seq(seq__40000_40985);
if(temp__5735__auto___40999){
var seq__40000_41000__$1 = temp__5735__auto___40999;
if(cljs.core.chunked_seq_QMARK_(seq__40000_41000__$1)){
var c__4609__auto___41001 = cljs.core.chunk_first(seq__40000_41000__$1);
var G__41002 = cljs.core.chunk_rest(seq__40000_41000__$1);
var G__41003 = c__4609__auto___41001;
var G__41004 = cljs.core.count(c__4609__auto___41001);
var G__41005 = (0);
seq__40000_40985 = G__41002;
chunk__40001_40986 = G__41003;
count__40002_40987 = G__41004;
i__40003_40988 = G__41005;
continue;
} else {
var vec__40021_41006 = cljs.core.first(seq__40000_41000__$1);
var script_tag_41007 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40021_41006,(0),null);
var script_body_41008 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40021_41006,(1),null);
eval(script_body_41008);


var G__41013 = cljs.core.next(seq__40000_41000__$1);
var G__41014 = null;
var G__41015 = (0);
var G__41016 = (0);
seq__40000_40985 = G__41013;
chunk__40001_40986 = G__41014;
count__40002_40987 = G__41015;
i__40003_40988 = G__41016;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s__$1,p__40026){
var vec__40027 = p__40026;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40027,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40027,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node(el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__40037 = arguments.length;
switch (G__40037) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag),cljs.core.name(cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node(dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node(dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__40040 = cljs.core.seq(style_keys);
var chunk__40041 = null;
var count__40042 = (0);
var i__40043 = (0);
while(true){
if((i__40043 < count__40042)){
var it = chunk__40041.cljs$core$IIndexed$_nth$arity$2(null,i__40043);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__41036 = seq__40040;
var G__41037 = chunk__40041;
var G__41038 = count__40042;
var G__41039 = (i__40043 + (1));
seq__40040 = G__41036;
chunk__40041 = G__41037;
count__40042 = G__41038;
i__40043 = G__41039;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__40040);
if(temp__5735__auto__){
var seq__40040__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__40040__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__40040__$1);
var G__41040 = cljs.core.chunk_rest(seq__40040__$1);
var G__41041 = c__4609__auto__;
var G__41042 = cljs.core.count(c__4609__auto__);
var G__41043 = (0);
seq__40040 = G__41040;
chunk__40041 = G__41041;
count__40042 = G__41042;
i__40043 = G__41043;
continue;
} else {
var it = cljs.core.first(seq__40040__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__41046 = cljs.core.next(seq__40040__$1);
var G__41047 = null;
var G__41048 = (0);
var G__41049 = (0);
seq__40040 = G__41046;
chunk__40041 = G__41047;
count__40042 = G__41048;
i__40043 = G__41049;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4439__auto__,k__4440__auto__){
var self__ = this;
var this__4439__auto____$1 = this;
return this__4439__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4440__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4441__auto__,k40053,else__4442__auto__){
var self__ = this;
var this__4441__auto____$1 = this;
var G__40068 = k40053;
var G__40068__$1 = (((G__40068 instanceof cljs.core.Keyword))?G__40068.fqn:null);
switch (G__40068__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k40053,else__4442__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4458__auto__,f__4459__auto__,init__4460__auto__){
var self__ = this;
var this__4458__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4461__auto__,p__40071){
var vec__40073 = p__40071;
var k__4462__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40073,(0),null);
var v__4463__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40073,(1),null);
return (f__4459__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4459__auto__.cljs$core$IFn$_invoke$arity$3(ret__4461__auto__,k__4462__auto__,v__4463__auto__) : f__4459__auto__.call(null,ret__4461__auto__,k__4462__auto__,v__4463__auto__));
}),init__4460__auto__,this__4458__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4453__auto__,writer__4454__auto__,opts__4455__auto__){
var self__ = this;
var this__4453__auto____$1 = this;
var pr_pair__4456__auto__ = (function (keyval__4457__auto__){
return cljs.core.pr_sequential_writer(writer__4454__auto__,cljs.core.pr_writer,""," ","",opts__4455__auto__,keyval__4457__auto__);
});
return cljs.core.pr_sequential_writer(writer__4454__auto__,pr_pair__4456__auto__,"#shadow.dom.Coordinate{",", ","}",opts__4455__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__40052){
var self__ = this;
var G__40052__$1 = this;
return (new cljs.core.RecordIter((0),G__40052__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4437__auto__){
var self__ = this;
var this__4437__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4434__auto__){
var self__ = this;
var this__4434__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4443__auto__){
var self__ = this;
var this__4443__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4435__auto__){
var self__ = this;
var this__4435__auto____$1 = this;
var h__4297__auto__ = self__.__hash;
if((!((h__4297__auto__ == null)))){
return h__4297__auto__;
} else {
var h__4297__auto____$1 = (function (coll__4436__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__4436__auto__));
})(this__4435__auto____$1);
(self__.__hash = h__4297__auto____$1);

return h__4297__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this40054,other40055){
var self__ = this;
var this40054__$1 = this;
return (((!((other40055 == null)))) && ((this40054__$1.constructor === other40055.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this40054__$1.x,other40055.x)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this40054__$1.y,other40055.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this40054__$1.__extmap,other40055.__extmap)));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4448__auto__,k__4449__auto__){
var self__ = this;
var this__4448__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__4449__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4448__auto____$1),self__.__meta),k__4449__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4449__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4446__auto__,k__4447__auto__,G__40052){
var self__ = this;
var this__4446__auto____$1 = this;
var pred__40093 = cljs.core.keyword_identical_QMARK_;
var expr__40094 = k__4447__auto__;
if(cljs.core.truth_((pred__40093.cljs$core$IFn$_invoke$arity$2 ? pred__40093.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__40094) : pred__40093.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__40094)))){
return (new shadow.dom.Coordinate(G__40052,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__40093.cljs$core$IFn$_invoke$arity$2 ? pred__40093.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__40094) : pred__40093.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__40094)))){
return (new shadow.dom.Coordinate(self__.x,G__40052,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4447__auto__,G__40052),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4451__auto__){
var self__ = this;
var this__4451__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4438__auto__,G__40052){
var self__ = this;
var this__4438__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__40052,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4444__auto__,entry__4445__auto__){
var self__ = this;
var this__4444__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4445__auto__)){
return this__4444__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4445__auto__,(0)),cljs.core._nth(entry__4445__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4444__auto____$1,entry__4445__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__4482__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__4482__auto__,writer__4483__auto__){
return cljs.core._write(writer__4483__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__40058){
var extmap__4478__auto__ = (function (){var G__40114 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__40058,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__40058)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__40114);
} else {
return G__40114;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__40058),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__40058),null,cljs.core.not_empty(extmap__4478__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4439__auto__,k__4440__auto__){
var self__ = this;
var this__4439__auto____$1 = this;
return this__4439__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4440__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4441__auto__,k40122,else__4442__auto__){
var self__ = this;
var this__4441__auto____$1 = this;
var G__40130 = k40122;
var G__40130__$1 = (((G__40130 instanceof cljs.core.Keyword))?G__40130.fqn:null);
switch (G__40130__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k40122,else__4442__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4458__auto__,f__4459__auto__,init__4460__auto__){
var self__ = this;
var this__4458__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4461__auto__,p__40134){
var vec__40135 = p__40134;
var k__4462__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40135,(0),null);
var v__4463__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40135,(1),null);
return (f__4459__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4459__auto__.cljs$core$IFn$_invoke$arity$3(ret__4461__auto__,k__4462__auto__,v__4463__auto__) : f__4459__auto__.call(null,ret__4461__auto__,k__4462__auto__,v__4463__auto__));
}),init__4460__auto__,this__4458__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4453__auto__,writer__4454__auto__,opts__4455__auto__){
var self__ = this;
var this__4453__auto____$1 = this;
var pr_pair__4456__auto__ = (function (keyval__4457__auto__){
return cljs.core.pr_sequential_writer(writer__4454__auto__,cljs.core.pr_writer,""," ","",opts__4455__auto__,keyval__4457__auto__);
});
return cljs.core.pr_sequential_writer(writer__4454__auto__,pr_pair__4456__auto__,"#shadow.dom.Size{",", ","}",opts__4455__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__40121){
var self__ = this;
var G__40121__$1 = this;
return (new cljs.core.RecordIter((0),G__40121__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4437__auto__){
var self__ = this;
var this__4437__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4434__auto__){
var self__ = this;
var this__4434__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4443__auto__){
var self__ = this;
var this__4443__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4435__auto__){
var self__ = this;
var this__4435__auto____$1 = this;
var h__4297__auto__ = self__.__hash;
if((!((h__4297__auto__ == null)))){
return h__4297__auto__;
} else {
var h__4297__auto____$1 = (function (coll__4436__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__4436__auto__));
})(this__4435__auto____$1);
(self__.__hash = h__4297__auto____$1);

return h__4297__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this40123,other40124){
var self__ = this;
var this40123__$1 = this;
return (((!((other40124 == null)))) && ((this40123__$1.constructor === other40124.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this40123__$1.w,other40124.w)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this40123__$1.h,other40124.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this40123__$1.__extmap,other40124.__extmap)));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4448__auto__,k__4449__auto__){
var self__ = this;
var this__4448__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__4449__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4448__auto____$1),self__.__meta),k__4449__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4449__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4446__auto__,k__4447__auto__,G__40121){
var self__ = this;
var this__4446__auto____$1 = this;
var pred__40140 = cljs.core.keyword_identical_QMARK_;
var expr__40141 = k__4447__auto__;
if(cljs.core.truth_((pred__40140.cljs$core$IFn$_invoke$arity$2 ? pred__40140.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"w","w",354169001),expr__40141) : pred__40140.call(null,new cljs.core.Keyword(null,"w","w",354169001),expr__40141)))){
return (new shadow.dom.Size(G__40121,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__40140.cljs$core$IFn$_invoke$arity$2 ? pred__40140.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"h","h",1109658740),expr__40141) : pred__40140.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__40141)))){
return (new shadow.dom.Size(self__.w,G__40121,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4447__auto__,G__40121),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4451__auto__){
var self__ = this;
var this__4451__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4438__auto__,G__40121){
var self__ = this;
var this__4438__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__40121,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4444__auto__,entry__4445__auto__){
var self__ = this;
var this__4444__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4445__auto__)){
return this__4444__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4445__auto__,(0)),cljs.core._nth(entry__4445__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4444__auto____$1,entry__4445__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__4482__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__4482__auto__,writer__4483__auto__){
return cljs.core._write(writer__4483__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__40126){
var extmap__4478__auto__ = (function (){var G__40156 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__40126,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__40126)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__40156);
} else {
return G__40156;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__40126),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__40126),null,cljs.core.not_empty(extmap__4478__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj(goog.style.getSize(shadow.dom.dom_node(el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size(el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__4663__auto__ = opts;
var l__4664__auto__ = a__4663__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__4664__auto__)){
var G__41108 = (i + (1));
var G__41109 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__41108;
ret = G__41109;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__40184){
var vec__40185 = p__40184;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40185,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40185,(1),null);
return [cljs.core.name(k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__40199 = arguments.length;
switch (G__40199) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5733__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5733__auto__)){
var child = temp__5733__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__41124 = ps;
var G__41125 = (i + (1));
el__$1 = G__41124;
i = G__41125;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node(el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,(function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__40258 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40258,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40258,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40258,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__40261_41132 = cljs.core.seq(props);
var chunk__40262_41133 = null;
var count__40263_41134 = (0);
var i__40264_41135 = (0);
while(true){
if((i__40264_41135 < count__40263_41134)){
var vec__40283_41138 = chunk__40262_41133.cljs$core$IIndexed$_nth$arity$2(null,i__40264_41135);
var k_41139 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40283_41138,(0),null);
var v_41140 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40283_41138,(1),null);
el.setAttributeNS((function (){var temp__5735__auto__ = cljs.core.namespace(k_41139);
if(cljs.core.truth_(temp__5735__auto__)){
var ns = temp__5735__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_41139),v_41140);


var G__41146 = seq__40261_41132;
var G__41147 = chunk__40262_41133;
var G__41148 = count__40263_41134;
var G__41149 = (i__40264_41135 + (1));
seq__40261_41132 = G__41146;
chunk__40262_41133 = G__41147;
count__40263_41134 = G__41148;
i__40264_41135 = G__41149;
continue;
} else {
var temp__5735__auto___41150 = cljs.core.seq(seq__40261_41132);
if(temp__5735__auto___41150){
var seq__40261_41151__$1 = temp__5735__auto___41150;
if(cljs.core.chunked_seq_QMARK_(seq__40261_41151__$1)){
var c__4609__auto___41152 = cljs.core.chunk_first(seq__40261_41151__$1);
var G__41154 = cljs.core.chunk_rest(seq__40261_41151__$1);
var G__41155 = c__4609__auto___41152;
var G__41156 = cljs.core.count(c__4609__auto___41152);
var G__41157 = (0);
seq__40261_41132 = G__41154;
chunk__40262_41133 = G__41155;
count__40263_41134 = G__41156;
i__40264_41135 = G__41157;
continue;
} else {
var vec__40292_41159 = cljs.core.first(seq__40261_41151__$1);
var k_41160 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40292_41159,(0),null);
var v_41161 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40292_41159,(1),null);
el.setAttributeNS((function (){var temp__5735__auto____$1 = cljs.core.namespace(k_41160);
if(cljs.core.truth_(temp__5735__auto____$1)){
var ns = temp__5735__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_41160),v_41161);


var G__41163 = cljs.core.next(seq__40261_41151__$1);
var G__41164 = null;
var G__41165 = (0);
var G__41166 = (0);
seq__40261_41132 = G__41163;
chunk__40262_41133 = G__41164;
count__40263_41134 = G__41165;
i__40264_41135 = G__41166;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__40307 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40307,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40307,(1),null);
var seq__40311_41169 = cljs.core.seq(node_children);
var chunk__40313_41170 = null;
var count__40314_41171 = (0);
var i__40315_41172 = (0);
while(true){
if((i__40315_41172 < count__40314_41171)){
var child_struct_41176 = chunk__40313_41170.cljs$core$IIndexed$_nth$arity$2(null,i__40315_41172);
if((!((child_struct_41176 == null)))){
if(typeof child_struct_41176 === 'string'){
var text_41177 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_41177),child_struct_41176].join(''));
} else {
var children_41178 = shadow.dom.svg_node(child_struct_41176);
if(cljs.core.seq_QMARK_(children_41178)){
var seq__40429_41179 = cljs.core.seq(children_41178);
var chunk__40435_41180 = null;
var count__40436_41181 = (0);
var i__40437_41182 = (0);
while(true){
if((i__40437_41182 < count__40436_41181)){
var child_41187 = chunk__40435_41180.cljs$core$IIndexed$_nth$arity$2(null,i__40437_41182);
if(cljs.core.truth_(child_41187)){
node.appendChild(child_41187);


var G__41188 = seq__40429_41179;
var G__41189 = chunk__40435_41180;
var G__41190 = count__40436_41181;
var G__41191 = (i__40437_41182 + (1));
seq__40429_41179 = G__41188;
chunk__40435_41180 = G__41189;
count__40436_41181 = G__41190;
i__40437_41182 = G__41191;
continue;
} else {
var G__41193 = seq__40429_41179;
var G__41194 = chunk__40435_41180;
var G__41195 = count__40436_41181;
var G__41196 = (i__40437_41182 + (1));
seq__40429_41179 = G__41193;
chunk__40435_41180 = G__41194;
count__40436_41181 = G__41195;
i__40437_41182 = G__41196;
continue;
}
} else {
var temp__5735__auto___41197 = cljs.core.seq(seq__40429_41179);
if(temp__5735__auto___41197){
var seq__40429_41198__$1 = temp__5735__auto___41197;
if(cljs.core.chunked_seq_QMARK_(seq__40429_41198__$1)){
var c__4609__auto___41199 = cljs.core.chunk_first(seq__40429_41198__$1);
var G__41200 = cljs.core.chunk_rest(seq__40429_41198__$1);
var G__41201 = c__4609__auto___41199;
var G__41202 = cljs.core.count(c__4609__auto___41199);
var G__41203 = (0);
seq__40429_41179 = G__41200;
chunk__40435_41180 = G__41201;
count__40436_41181 = G__41202;
i__40437_41182 = G__41203;
continue;
} else {
var child_41204 = cljs.core.first(seq__40429_41198__$1);
if(cljs.core.truth_(child_41204)){
node.appendChild(child_41204);


var G__41205 = cljs.core.next(seq__40429_41198__$1);
var G__41206 = null;
var G__41207 = (0);
var G__41208 = (0);
seq__40429_41179 = G__41205;
chunk__40435_41180 = G__41206;
count__40436_41181 = G__41207;
i__40437_41182 = G__41208;
continue;
} else {
var G__41209 = cljs.core.next(seq__40429_41198__$1);
var G__41210 = null;
var G__41211 = (0);
var G__41212 = (0);
seq__40429_41179 = G__41209;
chunk__40435_41180 = G__41210;
count__40436_41181 = G__41211;
i__40437_41182 = G__41212;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_41178);
}
}


var G__41214 = seq__40311_41169;
var G__41215 = chunk__40313_41170;
var G__41216 = count__40314_41171;
var G__41217 = (i__40315_41172 + (1));
seq__40311_41169 = G__41214;
chunk__40313_41170 = G__41215;
count__40314_41171 = G__41216;
i__40315_41172 = G__41217;
continue;
} else {
var G__41218 = seq__40311_41169;
var G__41219 = chunk__40313_41170;
var G__41220 = count__40314_41171;
var G__41221 = (i__40315_41172 + (1));
seq__40311_41169 = G__41218;
chunk__40313_41170 = G__41219;
count__40314_41171 = G__41220;
i__40315_41172 = G__41221;
continue;
}
} else {
var temp__5735__auto___41222 = cljs.core.seq(seq__40311_41169);
if(temp__5735__auto___41222){
var seq__40311_41223__$1 = temp__5735__auto___41222;
if(cljs.core.chunked_seq_QMARK_(seq__40311_41223__$1)){
var c__4609__auto___41224 = cljs.core.chunk_first(seq__40311_41223__$1);
var G__41225 = cljs.core.chunk_rest(seq__40311_41223__$1);
var G__41226 = c__4609__auto___41224;
var G__41227 = cljs.core.count(c__4609__auto___41224);
var G__41228 = (0);
seq__40311_41169 = G__41225;
chunk__40313_41170 = G__41226;
count__40314_41171 = G__41227;
i__40315_41172 = G__41228;
continue;
} else {
var child_struct_41229 = cljs.core.first(seq__40311_41223__$1);
if((!((child_struct_41229 == null)))){
if(typeof child_struct_41229 === 'string'){
var text_41230 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_41230),child_struct_41229].join(''));
} else {
var children_41232 = shadow.dom.svg_node(child_struct_41229);
if(cljs.core.seq_QMARK_(children_41232)){
var seq__40481_41236 = cljs.core.seq(children_41232);
var chunk__40483_41237 = null;
var count__40484_41238 = (0);
var i__40485_41239 = (0);
while(true){
if((i__40485_41239 < count__40484_41238)){
var child_41240 = chunk__40483_41237.cljs$core$IIndexed$_nth$arity$2(null,i__40485_41239);
if(cljs.core.truth_(child_41240)){
node.appendChild(child_41240);


var G__41241 = seq__40481_41236;
var G__41242 = chunk__40483_41237;
var G__41243 = count__40484_41238;
var G__41244 = (i__40485_41239 + (1));
seq__40481_41236 = G__41241;
chunk__40483_41237 = G__41242;
count__40484_41238 = G__41243;
i__40485_41239 = G__41244;
continue;
} else {
var G__41245 = seq__40481_41236;
var G__41246 = chunk__40483_41237;
var G__41247 = count__40484_41238;
var G__41248 = (i__40485_41239 + (1));
seq__40481_41236 = G__41245;
chunk__40483_41237 = G__41246;
count__40484_41238 = G__41247;
i__40485_41239 = G__41248;
continue;
}
} else {
var temp__5735__auto___41249__$1 = cljs.core.seq(seq__40481_41236);
if(temp__5735__auto___41249__$1){
var seq__40481_41250__$1 = temp__5735__auto___41249__$1;
if(cljs.core.chunked_seq_QMARK_(seq__40481_41250__$1)){
var c__4609__auto___41251 = cljs.core.chunk_first(seq__40481_41250__$1);
var G__41252 = cljs.core.chunk_rest(seq__40481_41250__$1);
var G__41253 = c__4609__auto___41251;
var G__41254 = cljs.core.count(c__4609__auto___41251);
var G__41255 = (0);
seq__40481_41236 = G__41252;
chunk__40483_41237 = G__41253;
count__40484_41238 = G__41254;
i__40485_41239 = G__41255;
continue;
} else {
var child_41256 = cljs.core.first(seq__40481_41250__$1);
if(cljs.core.truth_(child_41256)){
node.appendChild(child_41256);


var G__41257 = cljs.core.next(seq__40481_41250__$1);
var G__41258 = null;
var G__41259 = (0);
var G__41260 = (0);
seq__40481_41236 = G__41257;
chunk__40483_41237 = G__41258;
count__40484_41238 = G__41259;
i__40485_41239 = G__41260;
continue;
} else {
var G__41262 = cljs.core.next(seq__40481_41250__$1);
var G__41263 = null;
var G__41264 = (0);
var G__41265 = (0);
seq__40481_41236 = G__41262;
chunk__40483_41237 = G__41263;
count__40484_41238 = G__41264;
i__40485_41239 = G__41265;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_41232);
}
}


var G__41266 = cljs.core.next(seq__40311_41223__$1);
var G__41267 = null;
var G__41268 = (0);
var G__41269 = (0);
seq__40311_41169 = G__41266;
chunk__40313_41170 = G__41267;
count__40314_41171 = G__41268;
i__40315_41172 = G__41269;
continue;
} else {
var G__41270 = cljs.core.next(seq__40311_41223__$1);
var G__41271 = null;
var G__41272 = (0);
var G__41273 = (0);
seq__40311_41169 = G__41270;
chunk__40313_41170 = G__41271;
count__40314_41171 = G__41272;
i__40315_41172 = G__41273;
continue;
}
}
} else {
}
}
break;
}

return node;
});
goog.object.set(shadow.dom.SVGElement,"string",true);

goog.object.set(shadow.dom._to_svg,"string",(function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
}));

goog.object.set(shadow.dom.SVGElement,"null",true);

goog.object.set(shadow.dom._to_svg,"null",(function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__4795__auto__ = [];
var len__4789__auto___41275 = arguments.length;
var i__4790__auto___41276 = (0);
while(true){
if((i__4790__auto___41276 < len__4789__auto___41275)){
args__4795__auto__.push((arguments[i__4790__auto___41276]));

var G__41277 = (i__4790__auto___41276 + (1));
i__4790__auto___41276 = G__41277;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((1) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4796__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq40535){
var G__40536 = cljs.core.first(seq40535);
var seq40535__$1 = cljs.core.next(seq40535);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__40536,seq40535__$1);
}));

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__40562 = arguments.length;
switch (G__40562) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,null,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,xf,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer((1));
var chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(buf,xf);
var event_fn = (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler(el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_(chan);
} else {
return null;
}
});
shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(event),event_fn);

if(cljs.core.truth_((function (){var and__4174__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__4174__auto__)){
return (!(once_or_cleanup === true));
} else {
return and__4174__auto__;
}
})())){
var c__37098__auto___41286 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__37099__auto__ = (function (){var switch__36879__auto__ = (function (state_40595){
var state_val_40596 = (state_40595[(1)]);
if((state_val_40596 === (1))){
var state_40595__$1 = state_40595;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40595__$1,(2),once_or_cleanup);
} else {
if((state_val_40596 === (2))){
var inst_40592 = (state_40595[(2)]);
var inst_40593 = shadow.dom.remove_event_handler(el,event,event_fn);
var state_40595__$1 = (function (){var statearr_40602 = state_40595;
(statearr_40602[(7)] = inst_40592);

return statearr_40602;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_40595__$1,inst_40593);
} else {
return null;
}
}
});
return (function() {
var shadow$dom$state_machine__36880__auto__ = null;
var shadow$dom$state_machine__36880__auto____0 = (function (){
var statearr_40603 = [null,null,null,null,null,null,null,null];
(statearr_40603[(0)] = shadow$dom$state_machine__36880__auto__);

(statearr_40603[(1)] = (1));

return statearr_40603;
});
var shadow$dom$state_machine__36880__auto____1 = (function (state_40595){
while(true){
var ret_value__36881__auto__ = (function (){try{while(true){
var result__36882__auto__ = switch__36879__auto__(state_40595);
if(cljs.core.keyword_identical_QMARK_(result__36882__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36882__auto__;
}
break;
}
}catch (e40605){if((e40605 instanceof Object)){
var ex__36883__auto__ = e40605;
var statearr_40607_41287 = state_40595;
(statearr_40607_41287[(5)] = ex__36883__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_40595);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e40605;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__36881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__41290 = state_40595;
state_40595 = G__41290;
continue;
} else {
return ret_value__36881__auto__;
}
break;
}
});
shadow$dom$state_machine__36880__auto__ = function(state_40595){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__36880__auto____0.call(this);
case 1:
return shadow$dom$state_machine__36880__auto____1.call(this,state_40595);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$dom$state_machine__36880__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__36880__auto____0;
shadow$dom$state_machine__36880__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__36880__auto____1;
return shadow$dom$state_machine__36880__auto__;
})()
})();
var state__37100__auto__ = (function (){var statearr_40618 = f__37099__auto__();
(statearr_40618[(6)] = c__37098__auto___41286);

return statearr_40618;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37100__auto__);
}));

} else {
}

return chan;
}));

(shadow.dom.event_chan.cljs$lang$maxFixedArity = 4);


//# sourceMappingURL=shadow.dom.js.map
