(ns helix.dom
  (:refer-clojure :exclude [map meta time])
  (:require
   [helix.core :as hx]
   [helix.impl.props :as impl.props])
  #?(:cljs (:require-macros [helix.dom])))

;; (declare
;;  input textarea option select a abbr address area article aside audio b base bdi
;;  bdo big blockquote body br button canvas caption cite code col colgroup data datalist
;;  dd del details dfn dialog div dl dt em embed fieldset figcaption figure footer form
;;  h1 h2 h3 h4 h5 h6 head header hgroup hr html i iframe img ins kbd keygen label legend
;;  li link main map mark menu menuitem meta meter nav noscript object ol optgroup output
;;  p param picture pre progress q rp rt ruby s samp script section small source span
;;  strong style sub summary sup table tbody td tfoot th thead time title tr track u ul var
;;  video wbr circle clipPath ellipse g line mask path pattern polyline rect svg text defs
;;  linearGradient polygon radialGradient stop tspan)

#_(def tags
  '[input textarea option select

    a
    abbr
    address
    area
    article
    aside
    audio
    b
    base
    bdi
    bdo
    big
    blockquote
    body
    br
    button
    canvas
    caption
    cite
    code
    col
    colgroup
    data
    datalist
    dd
    del
    details
    dfn
    dialog
    div
    dl
    dt
    em
    embed
    fieldset
    figcaption
    figure
    footer
    form
    h1
    h2
    h3
    h4
    h5
    h6
    head
    header
    hgroup
    hr
    html
    i
    iframe
    img
    ins
    kbd
    keygen
    label
    legend
    li
    link
    main
    map
    mark
    menu
    menuitem
    meta
    meter
    nav
    noscript
    object
    ol
    optgroup
    output
    p
    param
    picture
    pre
    progress
    q
    rp
    rt
    ruby
    s
    samp
    script
    section
    small
    source
    span
    strong
    style
    sub
    summary
    sup
    table
    tbody
    td
    tfoot
    th
    thead
    time
    title
    tr
    track
    u
    ul
    var
    video
    wbr

    ;; svg
    circle
    clipPath
    ellipse
    g
    line
    marker
    mask
    path
    pattern
    polyline
    rect
    svg
    text
    defs
    linearGradient
    polygon
    radialGradient
    stop
    tspan])


(defmacro $d
  "Creates a new React DOM element. \"type\" ought to be a string like \"span\",
  \"div\",etc.

  When a map of props are passed as the second argument, will statically convert
  to a JS object, specially handling things like converting kebab-case props to
  camelCase and other transformations.

  Use the special & or :& prop to merge dynamic props in."
  [type & args]
  (if (map? (first args))
    `^js/React.Element (.createElement
                        (hx/get-react)
                        ~type
                        (impl.props/dom-props ~(first args))
                        ~@(rest args))
    `^js/React.Element (.createElement
                        (hx/get-react)
                        ~type
                        nil
                        ~@args)))


#?(:clj (defn gen-tag
          [tag]
          `(defmacro ~tag
             {:style/indent :defn}
             [& args#]
             `($d ~(str '~tag) ~@args#))))

;; #?(:clj (defmacro gen-tags
;;           []
;;           `(do
;;              ~@(for [tag tags]
;;                  (gen-tag tag)))))

;; #?(:clj (gen-tags))


;;
;; Autogenerated code below
;;

(defmacro input
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'input)) args)))
(defmacro textarea
  #:style{:indent :defn}
  [& args]
  (seq
   (concat (list `$d) (list (str 'textarea)) args)))
(defmacro option
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'option)) args)))
(defmacro select
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'select)) args)))
(defmacro a
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'a)) args)))
(defmacro abbr
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'abbr)) args)))
(defmacro address
  #:style{:indent :defn}
  [& args]
  (seq
   (concat (list `$d) (list (str 'address)) args)))
(defmacro area
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'area)) args)))
(defmacro article
  #:style{:indent :defn}
  [& args]
  (seq
   (concat (list `$d) (list (str 'article)) args)))
(defmacro aside
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'aside)) args)))
(defmacro audio
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'audio)) args)))
(defmacro b
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'b)) args)))
(defmacro base
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'base)) args)))
(defmacro bdi
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'bdi)) args)))
(defmacro bdo
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'bdo)) args)))
(defmacro big
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'big)) args)))
(defmacro blockquote
  #:style{:indent :defn}
  [& args]
  (seq
   (concat
    (list `$d)
    (list (str 'blockquote))
    args)))
(defmacro body
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'body)) args)))
(defmacro br
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'br)) args)))
(defmacro button
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'button)) args)))
(defmacro canvas
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'canvas)) args)))
(defmacro caption
  #:style{:indent :defn}
  [& args]
  (seq
   (concat (list `$d) (list (str 'caption)) args)))
(defmacro cite
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'cite)) args)))
(defmacro code
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'code)) args)))
(defmacro col
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'col)) args)))
(defmacro colgroup
  #:style{:indent :defn}
  [& args]
  (seq
   (concat (list `$d) (list (str 'colgroup)) args)))
(defmacro data
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'data)) args)))
(defmacro datalist
  #:style{:indent :defn}
  [& args]
  (seq
   (concat (list `$d) (list (str 'datalist)) args)))
(defmacro dd
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'dd)) args)))
(defmacro del
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'del)) args)))
(defmacro details
  #:style{:indent :defn}
  [& args]
  (seq
   (concat (list `$d) (list (str 'details)) args)))
(defmacro dfn
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'dfn)) args)))
(defmacro dialog
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'dialog)) args)))
(defmacro div
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'div)) args)))
(defmacro dl
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'dl)) args)))
(defmacro dt
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'dt)) args)))
(defmacro em
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'em)) args)))
(defmacro embed
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'embed)) args)))
(defmacro fieldset
  #:style{:indent :defn}
  [& args]
  (seq
   (concat (list `$d) (list (str 'fieldset)) args)))
(defmacro figcaption
  #:style{:indent :defn}
  [& args]
  (seq
   (concat
    (list `$d)
    (list (str 'figcaption))
    args)))
(defmacro figure
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'figure)) args)))
(defmacro footer
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'footer)) args)))
(defmacro form
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'form)) args)))
(defmacro h1
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'h1)) args)))
(defmacro h2
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'h2)) args)))
(defmacro h3
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'h3)) args)))
(defmacro h4
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'h4)) args)))
(defmacro h5
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'h5)) args)))
(defmacro h6
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'h6)) args)))
(defmacro head
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'head)) args)))
(defmacro header
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'header)) args)))
(defmacro hgroup
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'hgroup)) args)))
(defmacro hr
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'hr)) args)))
(defmacro html
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'html)) args)))
(defmacro i
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'i)) args)))
(defmacro iframe
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'iframe)) args)))
(defmacro img
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'img)) args)))
(defmacro ins
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'ins)) args)))
(defmacro kbd
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'kbd)) args)))
(defmacro keygen
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'keygen)) args)))
(defmacro label
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'label)) args)))
(defmacro legend
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'legend)) args)))
(defmacro li
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'li)) args)))
(defmacro link
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'link)) args)))
(defmacro main
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'main)) args)))
(defmacro map
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'map)) args)))
(defmacro mark
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'mark)) args)))
(defmacro menu
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'menu)) args)))
(defmacro menuitem
  #:style{:indent :defn}
  [& args]
  (seq
   (concat (list `$d) (list (str 'menuitem)) args)))
(defmacro meta
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'meta)) args)))
(defmacro meter
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'meter)) args)))
(defmacro nav
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'nav)) args)))
(defmacro noscript
  #:style{:indent :defn}
  [& args]
  (seq
   (concat (list `$d) (list (str 'noscript)) args)))
(defmacro object
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'object)) args)))
(defmacro ol
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'ol)) args)))
(defmacro optgroup
  #:style{:indent :defn}
  [& args]
  (seq
   (concat (list `$d) (list (str 'optgroup)) args)))
(defmacro output
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'output)) args)))
(defmacro p
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'p)) args)))
(defmacro param
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'param)) args)))
(defmacro picture
  #:style{:indent :defn}
  [& args]
  (seq
   (concat (list `$d) (list (str 'picture)) args)))
(defmacro pre
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'pre)) args)))
(defmacro progress
  #:style{:indent :defn}
  [& args]
  (seq
   (concat (list `$d) (list (str 'progress)) args)))
(defmacro q
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'q)) args)))
(defmacro rp
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'rp)) args)))
(defmacro rt
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'rt)) args)))
(defmacro ruby
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'ruby)) args)))
(defmacro s
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 's)) args)))
(defmacro samp
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'samp)) args)))
(defmacro script
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'script)) args)))
(defmacro section
  #:style{:indent :defn}
  [& args]
  (seq
   (concat (list `$d) (list (str 'section)) args)))
(defmacro small
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'small)) args)))
(defmacro source
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'source)) args)))
(defmacro span
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'span)) args)))
(defmacro strong
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'strong)) args)))
(defmacro style
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'style)) args)))
(defmacro sub
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'sub)) args)))
(defmacro summary
  #:style{:indent :defn}
  [& args]
  (seq
   (concat (list `$d) (list (str 'summary)) args)))
(defmacro sup
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'sup)) args)))
(defmacro table
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'table)) args)))
(defmacro tbody
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'tbody)) args)))
(defmacro td
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'td)) args)))
(defmacro tfoot
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'tfoot)) args)))
(defmacro th
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'th)) args)))
(defmacro thead
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'thead)) args)))
(defmacro time
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'time)) args)))
(defmacro title
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'title)) args)))
(defmacro tr
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'tr)) args)))
(defmacro track
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'track)) args)))
(defmacro u
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'u)) args)))
(defmacro ul
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'ul)) args)))
(defmacro var
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'var)) args)))
(defmacro video
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'video)) args)))
(defmacro wbr
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'wbr)) args)))
(defmacro circle
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'circle)) args)))
(defmacro clipPath
  #:style{:indent :defn}
  [& args]
  (seq
   (concat (list `$d) (list (str 'clipPath)) args)))
(defmacro ellipse
  #:style{:indent :defn}
  [& args]
  (seq
   (concat (list `$d) (list (str 'ellipse)) args)))
(defmacro g
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'g)) args)))
(defmacro line
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'line)) args)))
(defmacro marker
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'marker)) args)))
(defmacro mask
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'mask)) args)))
(defmacro path
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'path)) args)))
(defmacro pattern
  #:style{:indent :defn}
  [& args]
  (seq
   (concat (list `$d) (list (str 'pattern)) args)))
(defmacro polyline
  #:style{:indent :defn}
  [& args]
  (seq
   (concat (list `$d) (list (str 'polyline)) args)))
(defmacro rect
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'rect)) args)))
(defmacro svg
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'svg)) args)))
(defmacro text
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'text)) args)))
(defmacro defs
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'defs)) args)))
(defmacro linearGradient
  #:style{:indent :defn}
  [& args]
  (seq
   (concat
    (list `$d)
    (list (str 'linearGradient))
    args)))
(defmacro polygon
  #:style{:indent :defn}
  [& args]
  (seq
   (concat (list `$d) (list (str 'polygon)) args)))
(defmacro radialGradient
  #:style{:indent :defn}
  [& args]
  (seq
   (concat
    (list `$d)
    (list (str 'radialGradient))
    args)))
(defmacro stop
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'stop)) args)))
(defmacro tspan
  #:style{:indent :defn}
  [& args]
  (seq (concat (list `$d) (list (str 'tspan)) args)))
