goog.provide('shadow.cljs.devtools.client.browser');
goog.require('cljs.core');
goog.require('cljs.reader');
goog.require('clojure.string');
goog.require('goog.dom');
goog.require('goog.userAgent.product');
goog.require('goog.Uri');
goog.require('goog.net.XhrIo');
goog.require('shadow.cljs.devtools.client.env');
goog.require('shadow.cljs.devtools.client.console');
goog.require('shadow.cljs.devtools.client.hud');
goog.require('clojure.set');
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.browser !== 'undefined') && (typeof shadow.cljs.devtools.client.browser.repl_ns_ref !== 'undefined')){
} else {
shadow.cljs.devtools.client.browser.repl_ns_ref = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
}
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.browser !== 'undefined') && (typeof shadow.cljs.devtools.client.browser.socket_ref !== 'undefined')){
} else {
shadow.cljs.devtools.client.browser.socket_ref = cljs.core.volatile_BANG_(null);
}
shadow.cljs.devtools.client.browser.devtools_msg = (function shadow$cljs$devtools$client$browser$devtools_msg(var_args){
var args__4795__auto__ = [];
var len__4789__auto___45237 = arguments.length;
var i__4790__auto___45238 = (0);
while(true){
if((i__4790__auto___45238 < len__4789__auto___45237)){
args__4795__auto__.push((arguments[i__4790__auto___45238]));

var G__45239 = (i__4790__auto___45238 + (1));
i__4790__auto___45238 = G__45239;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((1) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((1)),(0),null)):null);
return shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4796__auto__);
});

(shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic = (function (msg,args){
if(cljs.core.seq(shadow.cljs.devtools.client.env.log_style)){
return console.log.apply(console,cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [["%c\uD83E\uDC36 shadow-cljs: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg)].join(''),shadow.cljs.devtools.client.env.log_style], null),args)));
} else {
return console.log.apply(console,cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["shadow-cljs: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg)].join('')], null),args)));
}
}));

(shadow.cljs.devtools.client.browser.devtools_msg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.cljs.devtools.client.browser.devtools_msg.cljs$lang$applyTo = (function (seq44939){
var G__44940 = cljs.core.first(seq44939);
var seq44939__$1 = cljs.core.next(seq44939);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__44940,seq44939__$1);
}));

shadow.cljs.devtools.client.browser.ws_msg = (function shadow$cljs$devtools$client$browser$ws_msg(msg){
var temp__5733__auto__ = cljs.core.deref(shadow.cljs.devtools.client.browser.socket_ref);
if(cljs.core.truth_(temp__5733__auto__)){
var s = temp__5733__auto__;
return s.send(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([msg], 0)));
} else {
return console.warn("WEBSOCKET NOT CONNECTED",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([msg], 0)));
}
});
shadow.cljs.devtools.client.browser.script_eval = (function shadow$cljs$devtools$client$browser$script_eval(code){
return goog.globalEval(code);
});
shadow.cljs.devtools.client.browser.do_js_load = (function shadow$cljs$devtools$client$browser$do_js_load(sources){
var seq__44958 = cljs.core.seq(sources);
var chunk__44959 = null;
var count__44960 = (0);
var i__44961 = (0);
while(true){
if((i__44961 < count__44960)){
var map__44979 = chunk__44959.cljs$core$IIndexed$_nth$arity$2(null,i__44961);
var map__44979__$1 = (((((!((map__44979 == null))))?(((((map__44979.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44979.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44979):map__44979);
var src = map__44979__$1;
var resource_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44979__$1,new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582));
var output_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44979__$1,new cljs.core.Keyword(null,"output-name","output-name",-1769107767));
var resource_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44979__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
var js = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44979__$1,new cljs.core.Keyword(null,"js","js",1768080579));
$CLJS.SHADOW_ENV.setLoaded(output_name);

shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("load JS",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([resource_name], 0));

shadow.cljs.devtools.client.env.before_load_src(src);

try{shadow.cljs.devtools.client.browser.script_eval([cljs.core.str.cljs$core$IFn$_invoke$arity$1(js),"\n//# sourceURL=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name)].join(''));
}catch (e44982){var e_45240 = e44982;
console.error(["Failed to load ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name)].join(''),e_45240);

throw (new Error(["Failed to load ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(e_45240.message)].join('')));
}

var G__45241 = seq__44958;
var G__45242 = chunk__44959;
var G__45243 = count__44960;
var G__45244 = (i__44961 + (1));
seq__44958 = G__45241;
chunk__44959 = G__45242;
count__44960 = G__45243;
i__44961 = G__45244;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__44958);
if(temp__5735__auto__){
var seq__44958__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__44958__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__44958__$1);
var G__45245 = cljs.core.chunk_rest(seq__44958__$1);
var G__45246 = c__4609__auto__;
var G__45247 = cljs.core.count(c__4609__auto__);
var G__45248 = (0);
seq__44958 = G__45245;
chunk__44959 = G__45246;
count__44960 = G__45247;
i__44961 = G__45248;
continue;
} else {
var map__44985 = cljs.core.first(seq__44958__$1);
var map__44985__$1 = (((((!((map__44985 == null))))?(((((map__44985.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44985.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44985):map__44985);
var src = map__44985__$1;
var resource_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44985__$1,new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582));
var output_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44985__$1,new cljs.core.Keyword(null,"output-name","output-name",-1769107767));
var resource_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44985__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
var js = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44985__$1,new cljs.core.Keyword(null,"js","js",1768080579));
$CLJS.SHADOW_ENV.setLoaded(output_name);

shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("load JS",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([resource_name], 0));

shadow.cljs.devtools.client.env.before_load_src(src);

try{shadow.cljs.devtools.client.browser.script_eval([cljs.core.str.cljs$core$IFn$_invoke$arity$1(js),"\n//# sourceURL=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name)].join(''));
}catch (e44987){var e_45249 = e44987;
console.error(["Failed to load ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name)].join(''),e_45249);

throw (new Error(["Failed to load ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(e_45249.message)].join('')));
}

var G__45250 = cljs.core.next(seq__44958__$1);
var G__45251 = null;
var G__45252 = (0);
var G__45253 = (0);
seq__44958 = G__45250;
chunk__44959 = G__45251;
count__44960 = G__45252;
i__44961 = G__45253;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.cljs.devtools.client.browser.do_js_reload = (function shadow$cljs$devtools$client$browser$do_js_reload(msg,sources,complete_fn,failure_fn){
return shadow.cljs.devtools.client.env.do_js_reload.cljs$core$IFn$_invoke$arity$4(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(msg,new cljs.core.Keyword(null,"log-missing-fn","log-missing-fn",732676765),(function (fn_sym){
return shadow.cljs.devtools.client.browser.devtools_msg(["can't find fn ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_sym)].join(''));
}),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"log-call-async","log-call-async",183826192),(function (fn_sym){
return shadow.cljs.devtools.client.browser.devtools_msg(["call async ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_sym)].join(''));
}),new cljs.core.Keyword(null,"log-call","log-call",412404391),(function (fn_sym){
return shadow.cljs.devtools.client.browser.devtools_msg(["call ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_sym)].join(''));
})], 0)),(function (){
return shadow.cljs.devtools.client.browser.do_js_load(sources);
}),complete_fn,failure_fn);
});
/**
 * when (require '["some-str" :as x]) is done at the REPL we need to manually call the shadow.js.require for it
 * since the file only adds the shadow$provide. only need to do this for shadow-js.
 */
shadow.cljs.devtools.client.browser.do_js_requires = (function shadow$cljs$devtools$client$browser$do_js_requires(js_requires){
var seq__44993 = cljs.core.seq(js_requires);
var chunk__44994 = null;
var count__44995 = (0);
var i__44996 = (0);
while(true){
if((i__44996 < count__44995)){
var js_ns = chunk__44994.cljs$core$IIndexed$_nth$arity$2(null,i__44996);
var require_str_45254 = ["var ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_ns)," = shadow.js.require(\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_ns),"\");"].join('');
shadow.cljs.devtools.client.browser.script_eval(require_str_45254);


var G__45255 = seq__44993;
var G__45256 = chunk__44994;
var G__45257 = count__44995;
var G__45258 = (i__44996 + (1));
seq__44993 = G__45255;
chunk__44994 = G__45256;
count__44995 = G__45257;
i__44996 = G__45258;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__44993);
if(temp__5735__auto__){
var seq__44993__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__44993__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__44993__$1);
var G__45259 = cljs.core.chunk_rest(seq__44993__$1);
var G__45260 = c__4609__auto__;
var G__45261 = cljs.core.count(c__4609__auto__);
var G__45262 = (0);
seq__44993 = G__45259;
chunk__44994 = G__45260;
count__44995 = G__45261;
i__44996 = G__45262;
continue;
} else {
var js_ns = cljs.core.first(seq__44993__$1);
var require_str_45263 = ["var ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_ns)," = shadow.js.require(\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_ns),"\");"].join('');
shadow.cljs.devtools.client.browser.script_eval(require_str_45263);


var G__45264 = cljs.core.next(seq__44993__$1);
var G__45265 = null;
var G__45266 = (0);
var G__45267 = (0);
seq__44993 = G__45264;
chunk__44994 = G__45265;
count__44995 = G__45266;
i__44996 = G__45267;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.cljs.devtools.client.browser.load_sources = (function shadow$cljs$devtools$client$browser$load_sources(sources,callback){
if(cljs.core.empty_QMARK_(sources)){
var G__45007 = cljs.core.PersistentVector.EMPTY;
return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(G__45007) : callback.call(null,G__45007));
} else {
return goog.net.XhrIo.send(shadow.cljs.devtools.client.env.files_url(),(function (res){
var req = this;
var content = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(req.getResponseText());
return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(content) : callback.call(null,content));
}),"POST",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"client","client",-1323448117),new cljs.core.Keyword(null,"browser","browser",828191719),new cljs.core.Keyword(null,"sources","sources",-321166424),cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582)),sources)], null)], 0)),({"content-type": "application/edn; charset=utf-8"}));
}
});
shadow.cljs.devtools.client.browser.handle_build_complete = (function shadow$cljs$devtools$client$browser$handle_build_complete(p__45012){
var map__45013 = p__45012;
var map__45013__$1 = (((((!((map__45013 == null))))?(((((map__45013.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45013.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45013):map__45013);
var msg = map__45013__$1;
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45013__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var reload_info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45013__$1,new cljs.core.Keyword(null,"reload-info","reload-info",1648088086));
var warnings = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.distinct.cljs$core$IFn$_invoke$arity$1((function (){var iter__4582__auto__ = (function shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__45016(s__45017){
return (new cljs.core.LazySeq(null,(function (){
var s__45017__$1 = s__45017;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__45017__$1);
if(temp__5735__auto__){
var xs__6292__auto__ = temp__5735__auto__;
var map__45024 = cljs.core.first(xs__6292__auto__);
var map__45024__$1 = (((((!((map__45024 == null))))?(((((map__45024.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45024.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45024):map__45024);
var src = map__45024__$1;
var resource_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45024__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
var warnings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45024__$1,new cljs.core.Keyword(null,"warnings","warnings",-735437651));
if(cljs.core.not(new cljs.core.Keyword(null,"from-jar","from-jar",1050932827).cljs$core$IFn$_invoke$arity$1(src))){
var iterys__4578__auto__ = ((function (s__45017__$1,map__45024,map__45024__$1,src,resource_name,warnings,xs__6292__auto__,temp__5735__auto__,map__45013,map__45013__$1,msg,info,reload_info){
return (function shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__45016_$_iter__45018(s__45019){
return (new cljs.core.LazySeq(null,((function (s__45017__$1,map__45024,map__45024__$1,src,resource_name,warnings,xs__6292__auto__,temp__5735__auto__,map__45013,map__45013__$1,msg,info,reload_info){
return (function (){
var s__45019__$1 = s__45019;
while(true){
var temp__5735__auto____$1 = cljs.core.seq(s__45019__$1);
if(temp__5735__auto____$1){
var s__45019__$2 = temp__5735__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__45019__$2)){
var c__4580__auto__ = cljs.core.chunk_first(s__45019__$2);
var size__4581__auto__ = cljs.core.count(c__4580__auto__);
var b__45021 = cljs.core.chunk_buffer(size__4581__auto__);
if((function (){var i__45020 = (0);
while(true){
if((i__45020 < size__4581__auto__)){
var warning = cljs.core._nth(c__4580__auto__,i__45020);
cljs.core.chunk_append(b__45021,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(warning,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100),resource_name));

var G__45269 = (i__45020 + (1));
i__45020 = G__45269;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__45021),shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__45016_$_iter__45018(cljs.core.chunk_rest(s__45019__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__45021),null);
}
} else {
var warning = cljs.core.first(s__45019__$2);
return cljs.core.cons(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(warning,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100),resource_name),shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__45016_$_iter__45018(cljs.core.rest(s__45019__$2)));
}
} else {
return null;
}
break;
}
});})(s__45017__$1,map__45024,map__45024__$1,src,resource_name,warnings,xs__6292__auto__,temp__5735__auto__,map__45013,map__45013__$1,msg,info,reload_info))
,null,null));
});})(s__45017__$1,map__45024,map__45024__$1,src,resource_name,warnings,xs__6292__auto__,temp__5735__auto__,map__45013,map__45013__$1,msg,info,reload_info))
;
var fs__4579__auto__ = cljs.core.seq(iterys__4578__auto__(warnings));
if(fs__4579__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4579__auto__,shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__45016(cljs.core.rest(s__45017__$1)));
} else {
var G__45270 = cljs.core.rest(s__45017__$1);
s__45017__$1 = G__45270;
continue;
}
} else {
var G__45271 = cljs.core.rest(s__45017__$1);
s__45017__$1 = G__45271;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4582__auto__(new cljs.core.Keyword(null,"sources","sources",-321166424).cljs$core$IFn$_invoke$arity$1(info));
})()));
var seq__45029_45272 = cljs.core.seq(warnings);
var chunk__45030_45273 = null;
var count__45031_45274 = (0);
var i__45032_45275 = (0);
while(true){
if((i__45032_45275 < count__45031_45274)){
var map__45040_45276 = chunk__45030_45273.cljs$core$IIndexed$_nth$arity$2(null,i__45032_45275);
var map__45040_45277__$1 = (((((!((map__45040_45276 == null))))?(((((map__45040_45276.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45040_45276.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45040_45276):map__45040_45276);
var w_45278 = map__45040_45277__$1;
var msg_45279__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45040_45277__$1,new cljs.core.Keyword(null,"msg","msg",-1386103444));
var line_45280 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45040_45277__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_45281 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45040_45277__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var resource_name_45282 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45040_45277__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
console.warn(["BUILD-WARNING in ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name_45282)," at [",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line_45280),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column_45281),"]\n\t",cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg_45279__$1)].join(''));


var G__45283 = seq__45029_45272;
var G__45284 = chunk__45030_45273;
var G__45285 = count__45031_45274;
var G__45286 = (i__45032_45275 + (1));
seq__45029_45272 = G__45283;
chunk__45030_45273 = G__45284;
count__45031_45274 = G__45285;
i__45032_45275 = G__45286;
continue;
} else {
var temp__5735__auto___45287 = cljs.core.seq(seq__45029_45272);
if(temp__5735__auto___45287){
var seq__45029_45288__$1 = temp__5735__auto___45287;
if(cljs.core.chunked_seq_QMARK_(seq__45029_45288__$1)){
var c__4609__auto___45289 = cljs.core.chunk_first(seq__45029_45288__$1);
var G__45290 = cljs.core.chunk_rest(seq__45029_45288__$1);
var G__45291 = c__4609__auto___45289;
var G__45292 = cljs.core.count(c__4609__auto___45289);
var G__45293 = (0);
seq__45029_45272 = G__45290;
chunk__45030_45273 = G__45291;
count__45031_45274 = G__45292;
i__45032_45275 = G__45293;
continue;
} else {
var map__45046_45294 = cljs.core.first(seq__45029_45288__$1);
var map__45046_45295__$1 = (((((!((map__45046_45294 == null))))?(((((map__45046_45294.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45046_45294.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45046_45294):map__45046_45294);
var w_45296 = map__45046_45295__$1;
var msg_45297__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45046_45295__$1,new cljs.core.Keyword(null,"msg","msg",-1386103444));
var line_45298 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45046_45295__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_45299 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45046_45295__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var resource_name_45300 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45046_45295__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
console.warn(["BUILD-WARNING in ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name_45300)," at [",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line_45298),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column_45299),"]\n\t",cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg_45297__$1)].join(''));


var G__45301 = cljs.core.next(seq__45029_45288__$1);
var G__45302 = null;
var G__45303 = (0);
var G__45304 = (0);
seq__45029_45272 = G__45301;
chunk__45030_45273 = G__45302;
count__45031_45274 = G__45303;
i__45032_45275 = G__45304;
continue;
}
} else {
}
}
break;
}

if((!(shadow.cljs.devtools.client.env.autoload))){
return shadow.cljs.devtools.client.hud.load_end_success();
} else {
if(((cljs.core.empty_QMARK_(warnings)) || (shadow.cljs.devtools.client.env.ignore_warnings))){
var sources_to_get = shadow.cljs.devtools.client.env.filter_reload_sources(info,reload_info);
if(cljs.core.not(cljs.core.seq(sources_to_get))){
return shadow.cljs.devtools.client.hud.load_end_success();
} else {
if(cljs.core.seq(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(msg,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"reload-info","reload-info",1648088086),new cljs.core.Keyword(null,"after-load","after-load",-1278503285)], null)))){
} else {
shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("reloading code but no :after-load hooks are configured!",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["https://shadow-cljs.github.io/docs/UsersGuide.html#_lifecycle_hooks"], 0));
}

return shadow.cljs.devtools.client.browser.load_sources(sources_to_get,(function (p1__45011_SHARP_){
return shadow.cljs.devtools.client.browser.do_js_reload(msg,p1__45011_SHARP_,shadow.cljs.devtools.client.hud.load_end_success,shadow.cljs.devtools.client.hud.load_failure);
}));
}
} else {
return null;
}
}
});
shadow.cljs.devtools.client.browser.page_load_uri = (cljs.core.truth_(goog.global.document)?goog.Uri.parse(document.location.href):null);
shadow.cljs.devtools.client.browser.match_paths = (function shadow$cljs$devtools$client$browser$match_paths(old,new$){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("file",shadow.cljs.devtools.client.browser.page_load_uri.getScheme())){
var rel_new = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(new$,(1));
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(old,rel_new)) || (clojure.string.starts_with_QMARK_(old,[rel_new,"?"].join(''))))){
return rel_new;
} else {
return null;
}
} else {
var node_uri = goog.Uri.parse(old);
var node_uri_resolved = shadow.cljs.devtools.client.browser.page_load_uri.resolve(node_uri);
var node_abs = node_uri_resolved.getPath();
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1(shadow.cljs.devtools.client.browser.page_load_uri.hasSameDomainAs(node_uri))) || (cljs.core.not(node_uri.hasDomain())))){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(node_abs,new$)){
return new$;
} else {
return false;
}
} else {
return false;
}
}
});
shadow.cljs.devtools.client.browser.handle_asset_watch = (function shadow$cljs$devtools$client$browser$handle_asset_watch(p__45056){
var map__45057 = p__45056;
var map__45057__$1 = (((((!((map__45057 == null))))?(((((map__45057.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45057.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45057):map__45057);
var msg = map__45057__$1;
var updates = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45057__$1,new cljs.core.Keyword(null,"updates","updates",2013983452));
var seq__45059 = cljs.core.seq(updates);
var chunk__45061 = null;
var count__45062 = (0);
var i__45063 = (0);
while(true){
if((i__45063 < count__45062)){
var path = chunk__45061.cljs$core$IIndexed$_nth$arity$2(null,i__45063);
if(clojure.string.ends_with_QMARK_(path,"css")){
var seq__45103_45312 = cljs.core.seq(cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1(document.querySelectorAll("link[rel=\"stylesheet\"]")));
var chunk__45106_45313 = null;
var count__45107_45314 = (0);
var i__45108_45315 = (0);
while(true){
if((i__45108_45315 < count__45107_45314)){
var node_45316 = chunk__45106_45313.cljs$core$IIndexed$_nth$arity$2(null,i__45108_45315);
var path_match_45317 = shadow.cljs.devtools.client.browser.match_paths(node_45316.getAttribute("href"),path);
if(cljs.core.truth_(path_match_45317)){
var new_link_45318 = (function (){var G__45121 = node_45316.cloneNode(true);
G__45121.setAttribute("href",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(path_match_45317),"?r=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.rand.cljs$core$IFn$_invoke$arity$0())].join(''));

return G__45121;
})();
shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("load CSS",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([path_match_45317], 0));

goog.dom.insertSiblingAfter(new_link_45318,node_45316);

goog.dom.removeNode(node_45316);


var G__45319 = seq__45103_45312;
var G__45320 = chunk__45106_45313;
var G__45321 = count__45107_45314;
var G__45322 = (i__45108_45315 + (1));
seq__45103_45312 = G__45319;
chunk__45106_45313 = G__45320;
count__45107_45314 = G__45321;
i__45108_45315 = G__45322;
continue;
} else {
var G__45323 = seq__45103_45312;
var G__45324 = chunk__45106_45313;
var G__45325 = count__45107_45314;
var G__45326 = (i__45108_45315 + (1));
seq__45103_45312 = G__45323;
chunk__45106_45313 = G__45324;
count__45107_45314 = G__45325;
i__45108_45315 = G__45326;
continue;
}
} else {
var temp__5735__auto___45327 = cljs.core.seq(seq__45103_45312);
if(temp__5735__auto___45327){
var seq__45103_45328__$1 = temp__5735__auto___45327;
if(cljs.core.chunked_seq_QMARK_(seq__45103_45328__$1)){
var c__4609__auto___45329 = cljs.core.chunk_first(seq__45103_45328__$1);
var G__45330 = cljs.core.chunk_rest(seq__45103_45328__$1);
var G__45331 = c__4609__auto___45329;
var G__45332 = cljs.core.count(c__4609__auto___45329);
var G__45333 = (0);
seq__45103_45312 = G__45330;
chunk__45106_45313 = G__45331;
count__45107_45314 = G__45332;
i__45108_45315 = G__45333;
continue;
} else {
var node_45334 = cljs.core.first(seq__45103_45328__$1);
var path_match_45335 = shadow.cljs.devtools.client.browser.match_paths(node_45334.getAttribute("href"),path);
if(cljs.core.truth_(path_match_45335)){
var new_link_45336 = (function (){var G__45123 = node_45334.cloneNode(true);
G__45123.setAttribute("href",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(path_match_45335),"?r=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.rand.cljs$core$IFn$_invoke$arity$0())].join(''));

return G__45123;
})();
shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("load CSS",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([path_match_45335], 0));

goog.dom.insertSiblingAfter(new_link_45336,node_45334);

goog.dom.removeNode(node_45334);


var G__45337 = cljs.core.next(seq__45103_45328__$1);
var G__45338 = null;
var G__45339 = (0);
var G__45340 = (0);
seq__45103_45312 = G__45337;
chunk__45106_45313 = G__45338;
count__45107_45314 = G__45339;
i__45108_45315 = G__45340;
continue;
} else {
var G__45341 = cljs.core.next(seq__45103_45328__$1);
var G__45342 = null;
var G__45343 = (0);
var G__45344 = (0);
seq__45103_45312 = G__45341;
chunk__45106_45313 = G__45342;
count__45107_45314 = G__45343;
i__45108_45315 = G__45344;
continue;
}
}
} else {
}
}
break;
}


var G__45345 = seq__45059;
var G__45346 = chunk__45061;
var G__45347 = count__45062;
var G__45348 = (i__45063 + (1));
seq__45059 = G__45345;
chunk__45061 = G__45346;
count__45062 = G__45347;
i__45063 = G__45348;
continue;
} else {
var G__45349 = seq__45059;
var G__45350 = chunk__45061;
var G__45351 = count__45062;
var G__45352 = (i__45063 + (1));
seq__45059 = G__45349;
chunk__45061 = G__45350;
count__45062 = G__45351;
i__45063 = G__45352;
continue;
}
} else {
var temp__5735__auto__ = cljs.core.seq(seq__45059);
if(temp__5735__auto__){
var seq__45059__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__45059__$1)){
var c__4609__auto__ = cljs.core.chunk_first(seq__45059__$1);
var G__45353 = cljs.core.chunk_rest(seq__45059__$1);
var G__45354 = c__4609__auto__;
var G__45355 = cljs.core.count(c__4609__auto__);
var G__45356 = (0);
seq__45059 = G__45353;
chunk__45061 = G__45354;
count__45062 = G__45355;
i__45063 = G__45356;
continue;
} else {
var path = cljs.core.first(seq__45059__$1);
if(clojure.string.ends_with_QMARK_(path,"css")){
var seq__45127_45357 = cljs.core.seq(cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1(document.querySelectorAll("link[rel=\"stylesheet\"]")));
var chunk__45130_45358 = null;
var count__45131_45359 = (0);
var i__45132_45360 = (0);
while(true){
if((i__45132_45360 < count__45131_45359)){
var node_45362 = chunk__45130_45358.cljs$core$IIndexed$_nth$arity$2(null,i__45132_45360);
var path_match_45364 = shadow.cljs.devtools.client.browser.match_paths(node_45362.getAttribute("href"),path);
if(cljs.core.truth_(path_match_45364)){
var new_link_45366 = (function (){var G__45143 = node_45362.cloneNode(true);
G__45143.setAttribute("href",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(path_match_45364),"?r=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.rand.cljs$core$IFn$_invoke$arity$0())].join(''));

return G__45143;
})();
shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("load CSS",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([path_match_45364], 0));

goog.dom.insertSiblingAfter(new_link_45366,node_45362);

goog.dom.removeNode(node_45362);


var G__45367 = seq__45127_45357;
var G__45368 = chunk__45130_45358;
var G__45369 = count__45131_45359;
var G__45370 = (i__45132_45360 + (1));
seq__45127_45357 = G__45367;
chunk__45130_45358 = G__45368;
count__45131_45359 = G__45369;
i__45132_45360 = G__45370;
continue;
} else {
var G__45371 = seq__45127_45357;
var G__45372 = chunk__45130_45358;
var G__45373 = count__45131_45359;
var G__45374 = (i__45132_45360 + (1));
seq__45127_45357 = G__45371;
chunk__45130_45358 = G__45372;
count__45131_45359 = G__45373;
i__45132_45360 = G__45374;
continue;
}
} else {
var temp__5735__auto___45375__$1 = cljs.core.seq(seq__45127_45357);
if(temp__5735__auto___45375__$1){
var seq__45127_45376__$1 = temp__5735__auto___45375__$1;
if(cljs.core.chunked_seq_QMARK_(seq__45127_45376__$1)){
var c__4609__auto___45377 = cljs.core.chunk_first(seq__45127_45376__$1);
var G__45378 = cljs.core.chunk_rest(seq__45127_45376__$1);
var G__45379 = c__4609__auto___45377;
var G__45380 = cljs.core.count(c__4609__auto___45377);
var G__45381 = (0);
seq__45127_45357 = G__45378;
chunk__45130_45358 = G__45379;
count__45131_45359 = G__45380;
i__45132_45360 = G__45381;
continue;
} else {
var node_45382 = cljs.core.first(seq__45127_45376__$1);
var path_match_45384 = shadow.cljs.devtools.client.browser.match_paths(node_45382.getAttribute("href"),path);
if(cljs.core.truth_(path_match_45384)){
var new_link_45386 = (function (){var G__45146 = node_45382.cloneNode(true);
G__45146.setAttribute("href",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(path_match_45384),"?r=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.rand.cljs$core$IFn$_invoke$arity$0())].join(''));

return G__45146;
})();
shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("load CSS",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([path_match_45384], 0));

goog.dom.insertSiblingAfter(new_link_45386,node_45382);

goog.dom.removeNode(node_45382);


var G__45388 = cljs.core.next(seq__45127_45376__$1);
var G__45389 = null;
var G__45390 = (0);
var G__45391 = (0);
seq__45127_45357 = G__45388;
chunk__45130_45358 = G__45389;
count__45131_45359 = G__45390;
i__45132_45360 = G__45391;
continue;
} else {
var G__45392 = cljs.core.next(seq__45127_45376__$1);
var G__45393 = null;
var G__45394 = (0);
var G__45395 = (0);
seq__45127_45357 = G__45392;
chunk__45130_45358 = G__45393;
count__45131_45359 = G__45394;
i__45132_45360 = G__45395;
continue;
}
}
} else {
}
}
break;
}


var G__45396 = cljs.core.next(seq__45059__$1);
var G__45397 = null;
var G__45398 = (0);
var G__45399 = (0);
seq__45059 = G__45396;
chunk__45061 = G__45397;
count__45062 = G__45398;
i__45063 = G__45399;
continue;
} else {
var G__45400 = cljs.core.next(seq__45059__$1);
var G__45401 = null;
var G__45402 = (0);
var G__45403 = (0);
seq__45059 = G__45400;
chunk__45061 = G__45401;
count__45062 = G__45402;
i__45063 = G__45403;
continue;
}
}
} else {
return null;
}
}
break;
}
});
shadow.cljs.devtools.client.browser.get_ua_product = (function shadow$cljs$devtools$client$browser$get_ua_product(){
if(cljs.core.truth_(goog.userAgent.product.SAFARI)){
return new cljs.core.Keyword(null,"safari","safari",497115653);
} else {
if(cljs.core.truth_(goog.userAgent.product.CHROME)){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.FIREFOX)){
return new cljs.core.Keyword(null,"firefox","firefox",1283768880);
} else {
if(cljs.core.truth_(goog.userAgent.product.IE)){
return new cljs.core.Keyword(null,"ie","ie",2038473780);
} else {
return null;
}
}
}
}
});
shadow.cljs.devtools.client.browser.get_asset_root = (function shadow$cljs$devtools$client$browser$get_asset_root(){
var loc = (new goog.Uri(document.location.href));
var cbp = (new goog.Uri(CLOSURE_BASE_PATH));
var s = loc.resolve(cbp).toString();
return clojure.string.replace(s,/^file:\//,"file:///");
});
shadow.cljs.devtools.client.browser.repl_error = (function shadow$cljs$devtools$client$browser$repl_error(e){
console.error("repl/invoke error",e);

return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(shadow.cljs.devtools.client.env.repl_error(e),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),shadow.cljs.devtools.client.browser.get_ua_product(),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"asset-root","asset-root",1771735072),shadow.cljs.devtools.client.browser.get_asset_root()], 0));
});
shadow.cljs.devtools.client.browser.global_eval = (function shadow$cljs$devtools$client$browser$global_eval(js){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2("undefined",typeof(module))){
return eval(js);
} else {
return (0,eval)(js);;
}
});
shadow.cljs.devtools.client.browser.repl_invoke = (function shadow$cljs$devtools$client$browser$repl_invoke(p__45153){
var map__45154 = p__45153;
var map__45154__$1 = (((((!((map__45154 == null))))?(((((map__45154.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45154.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45154):map__45154);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45154__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var js = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45154__$1,new cljs.core.Keyword(null,"js","js",1768080579));
var result = shadow.cljs.devtools.client.env.repl_call((function (){
return shadow.cljs.devtools.client.browser.global_eval(js);
}),shadow.cljs.devtools.client.browser.repl_error);
return shadow.cljs.devtools.client.browser.ws_msg(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.Keyword(null,"id","id",-1388402092),id));
});
shadow.cljs.devtools.client.browser.repl_require = (function shadow$cljs$devtools$client$browser$repl_require(p__45157,done){
var map__45158 = p__45157;
var map__45158__$1 = (((((!((map__45158 == null))))?(((((map__45158.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45158.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45158):map__45158);
var msg = map__45158__$1;
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45158__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var sources = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45158__$1,new cljs.core.Keyword(null,"sources","sources",-321166424));
var reload_namespaces = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45158__$1,new cljs.core.Keyword(null,"reload-namespaces","reload-namespaces",250210134));
var js_requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45158__$1,new cljs.core.Keyword(null,"js-requires","js-requires",-1311472051));
var sources_to_load = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.remove.cljs$core$IFn$_invoke$arity$2((function (p__45166){
var map__45167 = p__45166;
var map__45167__$1 = (((((!((map__45167 == null))))?(((((map__45167.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45167.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45167):map__45167);
var src = map__45167__$1;
var provides = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45167__$1,new cljs.core.Keyword(null,"provides","provides",-1634397992));
var and__4174__auto__ = shadow.cljs.devtools.client.env.src_is_loaded_QMARK_(src);
if(cljs.core.truth_(and__4174__auto__)){
return cljs.core.not(cljs.core.some(reload_namespaces,provides));
} else {
return and__4174__auto__;
}
}),sources));
return shadow.cljs.devtools.client.browser.load_sources(sources_to_load,(function (sources__$1){
try{shadow.cljs.devtools.client.browser.do_js_load(sources__$1);

if(cljs.core.seq(js_requires)){
shadow.cljs.devtools.client.browser.do_js_requires(js_requires);
} else {
}

return shadow.cljs.devtools.client.browser.ws_msg(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","require-complete","repl/require-complete",-2140254719),new cljs.core.Keyword(null,"id","id",-1388402092),id], null));
}catch (e45170){var e = e45170;
return shadow.cljs.devtools.client.browser.ws_msg(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","require-error","repl/require-error",1689310021),new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"error","error",-978969032),e.message], null));
}finally {(done.cljs$core$IFn$_invoke$arity$0 ? done.cljs$core$IFn$_invoke$arity$0() : done.call(null));
}}));
});
shadow.cljs.devtools.client.browser.repl_init = (function shadow$cljs$devtools$client$browser$repl_init(p__45174,done){
var map__45175 = p__45174;
var map__45175__$1 = (((((!((map__45175 == null))))?(((((map__45175.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45175.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45175):map__45175);
var repl_state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45175__$1,new cljs.core.Keyword(null,"repl-state","repl-state",-1733780387));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45175__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
return shadow.cljs.devtools.client.browser.load_sources(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(shadow.cljs.devtools.client.env.src_is_loaded_QMARK_,new cljs.core.Keyword(null,"repl-sources","repl-sources",723867535).cljs$core$IFn$_invoke$arity$1(repl_state))),(function (sources){
shadow.cljs.devtools.client.browser.do_js_load(sources);

shadow.cljs.devtools.client.browser.ws_msg(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","init-complete","repl/init-complete",-162252879),new cljs.core.Keyword(null,"id","id",-1388402092),id], null));

shadow.cljs.devtools.client.browser.devtools_msg("REPL session start successful");

return (done.cljs$core$IFn$_invoke$arity$0 ? done.cljs$core$IFn$_invoke$arity$0() : done.call(null));
}));
});
shadow.cljs.devtools.client.browser.repl_set_ns = (function shadow$cljs$devtools$client$browser$repl_set_ns(p__45180){
var map__45188 = p__45180;
var map__45188__$1 = (((((!((map__45188 == null))))?(((((map__45188.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45188.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45188):map__45188);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45188__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45188__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
return shadow.cljs.devtools.client.browser.ws_msg(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","set-ns-complete","repl/set-ns-complete",680944662),new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"ns","ns",441598760),ns], null));
});
shadow.cljs.devtools.client.browser.close_reason_ref = cljs.core.volatile_BANG_(null);
shadow.cljs.devtools.client.browser.stale_client_detected = cljs.core.volatile_BANG_(false);
shadow.cljs.devtools.client.browser.handle_message = (function shadow$cljs$devtools$client$browser$handle_message(p__45197,done){
var map__45198 = p__45197;
var map__45198__$1 = (((((!((map__45198 == null))))?(((((map__45198.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45198.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45198):map__45198);
var msg = map__45198__$1;
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__45198__$1,new cljs.core.Keyword(null,"type","type",1174270348));
shadow.cljs.devtools.client.hud.connection_error_clear_BANG_();

var G__45200_45410 = type;
var G__45200_45411__$1 = (((G__45200_45410 instanceof cljs.core.Keyword))?G__45200_45410.fqn:null);
switch (G__45200_45411__$1) {
case "asset-watch":
shadow.cljs.devtools.client.browser.handle_asset_watch(msg);

break;
case "repl/invoke":
shadow.cljs.devtools.client.browser.repl_invoke(msg);

break;
case "repl/require":
shadow.cljs.devtools.client.browser.repl_require(msg,done);

break;
case "repl/set-ns":
shadow.cljs.devtools.client.browser.repl_set_ns(msg);

break;
case "repl/init":
shadow.cljs.devtools.client.browser.repl_init(msg,done);

break;
case "repl/session-start":
shadow.cljs.devtools.client.browser.repl_init(msg,done);

break;
case "repl/ping":
shadow.cljs.devtools.client.browser.ws_msg(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","pong","repl/pong",-166610159),new cljs.core.Keyword(null,"time-server","time-server",786726561),new cljs.core.Keyword(null,"time-server","time-server",786726561).cljs$core$IFn$_invoke$arity$1(msg),new cljs.core.Keyword(null,"time-runtime","time-runtime",-40294923),Date.now()], null));

break;
case "build-complete":
shadow.cljs.devtools.client.hud.hud_warnings(msg);

shadow.cljs.devtools.client.browser.handle_build_complete(msg);

break;
case "build-failure":
shadow.cljs.devtools.client.hud.load_end();

shadow.cljs.devtools.client.hud.hud_error(msg);

break;
case "build-init":
shadow.cljs.devtools.client.hud.hud_warnings(msg);

break;
case "build-start":
shadow.cljs.devtools.client.hud.hud_hide();

shadow.cljs.devtools.client.hud.load_start();

break;
case "pong":

break;
case "client/stale":
cljs.core.vreset_BANG_(shadow.cljs.devtools.client.browser.stale_client_detected,true);

cljs.core.vreset_BANG_(shadow.cljs.devtools.client.browser.close_reason_ref,"Stale Client! You are not using the latest compilation output!");

break;
case "client/no-worker":
cljs.core.vreset_BANG_(shadow.cljs.devtools.client.browser.stale_client_detected,true);

cljs.core.vreset_BANG_(shadow.cljs.devtools.client.browser.close_reason_ref,["watch for build \"",shadow.cljs.devtools.client.env.build_id,"\" not running"].join(''));

break;
case "custom-msg":
shadow.cljs.devtools.client.env.publish_BANG_(new cljs.core.Keyword(null,"payload","payload",-383036092).cljs$core$IFn$_invoke$arity$1(msg));

break;
default:

}

if(cljs.core.contains_QMARK_(shadow.cljs.devtools.client.env.async_ops,type)){
return null;
} else {
return (done.cljs$core$IFn$_invoke$arity$0 ? done.cljs$core$IFn$_invoke$arity$0() : done.call(null));
}
});
shadow.cljs.devtools.client.browser.compile = (function shadow$cljs$devtools$client$browser$compile(text,callback){
return goog.net.XhrIo.send(["http",((shadow.cljs.devtools.client.env.ssl)?"s":null),"://",shadow.cljs.devtools.client.env.server_host,":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.cljs.devtools.client.env.server_port),"/worker/compile/",shadow.cljs.devtools.client.env.build_id,"/",shadow.cljs.devtools.client.env.proc_id,"/browser"].join(''),(function (res){
var req = this;
var actions = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(req.getResponseText());
if(cljs.core.truth_(callback)){
return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(actions) : callback.call(null,actions));
} else {
return null;
}
}),"POST",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"input","input",556931961),text], null)], 0)),({"content-type": "application/edn; charset=utf-8"}));
});
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.browser !== 'undefined') && (typeof shadow.cljs.devtools.client.browser.ws_status !== 'undefined')){
} else {
shadow.cljs.devtools.client.browser.ws_status = cljs.core.volatile_BANG_(new cljs.core.Keyword(null,"init","init",-1875481434));
}
shadow.cljs.devtools.client.browser.ws_connect = (function shadow$cljs$devtools$client$browser$ws_connect(){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1((function (){var fexpr__45217 = cljs.core.deref(shadow.cljs.devtools.client.browser.ws_status);
return (fexpr__45217.cljs$core$IFn$_invoke$arity$1 ? fexpr__45217.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"init","init",-1875481434)) : fexpr__45217.call(null,new cljs.core.Keyword(null,"init","init",-1875481434)));
})())){
return (shadow.cljs.devtools.client.browser.ws_connect_impl.cljs$core$IFn$_invoke$arity$0 ? shadow.cljs.devtools.client.browser.ws_connect_impl.cljs$core$IFn$_invoke$arity$0() : shadow.cljs.devtools.client.browser.ws_connect_impl.call(null));
} else {
return null;
}
});
shadow.cljs.devtools.client.browser.maybe_reconnect = (function shadow$cljs$devtools$client$browser$maybe_reconnect(){
if(((cljs.core.not(cljs.core.deref(shadow.cljs.devtools.client.browser.stale_client_detected))) && (cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.cljs.devtools.client.browser.ws_status),new cljs.core.Keyword(null,"init","init",-1875481434))))){
cljs.core.vreset_BANG_(shadow.cljs.devtools.client.browser.ws_status,new cljs.core.Keyword(null,"init","init",-1875481434));

return setTimeout(shadow.cljs.devtools.client.browser.ws_connect,(3000));
} else {
return null;
}
});
shadow.cljs.devtools.client.browser.ws_connect_impl = (function shadow$cljs$devtools$client$browser$ws_connect_impl(){
cljs.core.vreset_BANG_(shadow.cljs.devtools.client.browser.ws_status,new cljs.core.Keyword(null,"connecting","connecting",-1347943866));

try{var print_fn = cljs.core._STAR_print_fn_STAR_;
var ws_url = shadow.cljs.devtools.client.env.ws_url(new cljs.core.Keyword(null,"browser","browser",828191719));
var socket = (new WebSocket(ws_url));
cljs.core.vreset_BANG_(shadow.cljs.devtools.client.browser.socket_ref,socket);

(socket.onmessage = (function (e){
return shadow.cljs.devtools.client.env.process_ws_msg(e.data,shadow.cljs.devtools.client.browser.handle_message);
}));

(socket.onopen = (function (e){
cljs.core.vreset_BANG_(shadow.cljs.devtools.client.browser.ws_status,new cljs.core.Keyword(null,"connected","connected",-169833045));

shadow.cljs.devtools.client.hud.connection_error_clear_BANG_();

cljs.core.vreset_BANG_(shadow.cljs.devtools.client.browser.close_reason_ref,null);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("goog",shadow.cljs.devtools.client.env.module_format)){
(goog.provide = goog.constructNamespace_);
} else {
}

shadow.cljs.devtools.client.env.set_print_fns_BANG_(shadow.cljs.devtools.client.browser.ws_msg);

return shadow.cljs.devtools.client.browser.devtools_msg("WebSocket connected!");
}));

(socket.onclose = (function (e){
shadow.cljs.devtools.client.browser.devtools_msg("WebSocket disconnected!");

shadow.cljs.devtools.client.hud.connection_error((function (){var or__4185__auto__ = cljs.core.deref(shadow.cljs.devtools.client.browser.close_reason_ref);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return "Connection closed!";
}
})());

cljs.core.vreset_BANG_(shadow.cljs.devtools.client.browser.socket_ref,null);

shadow.cljs.devtools.client.env.reset_print_fns_BANG_();

return shadow.cljs.devtools.client.browser.maybe_reconnect();
}));

return (socket.onerror = (function (e){
shadow.cljs.devtools.client.hud.connection_error("Connection failed!");

shadow.cljs.devtools.client.browser.maybe_reconnect();

return shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("websocket error",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e], 0));
}));
}catch (e45223){var e = e45223;
return shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("WebSocket setup failed",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e], 0));
}});
if(shadow.cljs.devtools.client.env.enabled){
var temp__5735__auto___45420 = cljs.core.deref(shadow.cljs.devtools.client.browser.socket_ref);
if(cljs.core.truth_(temp__5735__auto___45420)){
var s_45421 = temp__5735__auto___45420;
shadow.cljs.devtools.client.browser.devtools_msg("connection reset!");

(s_45421.onclose = (function (e){
return null;
}));

s_45421.close();

cljs.core.vreset_BANG_(shadow.cljs.devtools.client.browser.socket_ref,null);
} else {
}

window.addEventListener("beforeunload",(function (){
var temp__5735__auto__ = cljs.core.deref(shadow.cljs.devtools.client.browser.socket_ref);
if(cljs.core.truth_(temp__5735__auto__)){
var s = temp__5735__auto__;
return s.close();
} else {
return null;
}
}));

if(cljs.core.truth_((function (){var and__4174__auto__ = document;
if(cljs.core.truth_(and__4174__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("loading",document.readyState);
} else {
return and__4174__auto__;
}
})())){
window.addEventListener("DOMContentLoaded",shadow.cljs.devtools.client.browser.ws_connect);
} else {
setTimeout(shadow.cljs.devtools.client.browser.ws_connect,(10));
}
} else {
}

//# sourceMappingURL=shadow.cljs.devtools.client.browser.js.map
