goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('goog.array');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__37192 = arguments.length;
switch (G__37192) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async37193 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async37193 = (function (f,blockable,meta37194){
this.f = f;
this.blockable = blockable;
this.meta37194 = meta37194;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async37193.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_37195,meta37194__$1){
var self__ = this;
var _37195__$1 = this;
return (new cljs.core.async.t_cljs$core$async37193(self__.f,self__.blockable,meta37194__$1));
}));

(cljs.core.async.t_cljs$core$async37193.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_37195){
var self__ = this;
var _37195__$1 = this;
return self__.meta37194;
}));

(cljs.core.async.t_cljs$core$async37193.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async37193.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async37193.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async37193.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async37193.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta37194","meta37194",1661209050,null)], null);
}));

(cljs.core.async.t_cljs$core$async37193.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async37193.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async37193");

(cljs.core.async.t_cljs$core$async37193.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write(writer__4429__auto__,"cljs.core.async/t_cljs$core$async37193");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async37193.
 */
cljs.core.async.__GT_t_cljs$core$async37193 = (function cljs$core$async$__GT_t_cljs$core$async37193(f__$1,blockable__$1,meta37194){
return (new cljs.core.async.t_cljs$core$async37193(f__$1,blockable__$1,meta37194));
});

}

return (new cljs.core.async.t_cljs$core$async37193(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__37212 = arguments.length;
switch (G__37212) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__37226 = arguments.length;
switch (G__37226) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__37230 = arguments.length;
switch (G__37230) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_39353 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_39353) : fn1.call(null,val_39353));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_39353) : fn1.call(null,val_39353));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__37237 = arguments.length;
switch (G__37237) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5733__auto__)){
var ret = temp__5733__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5733__auto__)){
var retb = temp__5733__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4666__auto___39378 = n;
var x_39379 = (0);
while(true){
if((x_39379 < n__4666__auto___39378)){
(a[x_39379] = x_39379);

var G__39383 = (x_39379 + (1));
x_39379 = G__39383;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async37255 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async37255 = (function (flag,meta37256){
this.flag = flag;
this.meta37256 = meta37256;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async37255.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_37257,meta37256__$1){
var self__ = this;
var _37257__$1 = this;
return (new cljs.core.async.t_cljs$core$async37255(self__.flag,meta37256__$1));
}));

(cljs.core.async.t_cljs$core$async37255.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_37257){
var self__ = this;
var _37257__$1 = this;
return self__.meta37256;
}));

(cljs.core.async.t_cljs$core$async37255.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async37255.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async37255.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async37255.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async37255.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta37256","meta37256",-416941830,null)], null);
}));

(cljs.core.async.t_cljs$core$async37255.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async37255.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async37255");

(cljs.core.async.t_cljs$core$async37255.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write(writer__4429__auto__,"cljs.core.async/t_cljs$core$async37255");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async37255.
 */
cljs.core.async.__GT_t_cljs$core$async37255 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async37255(flag__$1,meta37256){
return (new cljs.core.async.t_cljs$core$async37255(flag__$1,meta37256));
});

}

return (new cljs.core.async.t_cljs$core$async37255(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async37284 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async37284 = (function (flag,cb,meta37285){
this.flag = flag;
this.cb = cb;
this.meta37285 = meta37285;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async37284.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_37286,meta37285__$1){
var self__ = this;
var _37286__$1 = this;
return (new cljs.core.async.t_cljs$core$async37284(self__.flag,self__.cb,meta37285__$1));
}));

(cljs.core.async.t_cljs$core$async37284.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_37286){
var self__ = this;
var _37286__$1 = this;
return self__.meta37285;
}));

(cljs.core.async.t_cljs$core$async37284.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async37284.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async37284.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async37284.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async37284.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta37285","meta37285",1729136305,null)], null);
}));

(cljs.core.async.t_cljs$core$async37284.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async37284.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async37284");

(cljs.core.async.t_cljs$core$async37284.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write(writer__4429__auto__,"cljs.core.async/t_cljs$core$async37284");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async37284.
 */
cljs.core.async.__GT_t_cljs$core$async37284 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async37284(flag__$1,cb__$1,meta37285){
return (new cljs.core.async.t_cljs$core$async37284(flag__$1,cb__$1,meta37285));
});

}

return (new cljs.core.async.t_cljs$core$async37284(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__37293_SHARP_){
var G__37311 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__37293_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__37311) : fret.call(null,G__37311));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__37294_SHARP_){
var G__37313 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__37294_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__37313) : fret.call(null,G__37313));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4185__auto__ = wport;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return port;
}
})()], null));
} else {
var G__39423 = (i + (1));
i = G__39423;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4185__auto__ = ret;
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5735__auto__ = (function (){var and__4174__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4174__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4174__auto__;
}
})();
if(cljs.core.truth_(temp__5735__auto__)){
var got = temp__5735__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4795__auto__ = [];
var len__4789__auto___39424 = arguments.length;
var i__4790__auto___39425 = (0);
while(true){
if((i__4790__auto___39425 < len__4789__auto___39424)){
args__4795__auto__.push((arguments[i__4790__auto___39425]));

var G__39428 = (i__4790__auto___39425 + (1));
i__4790__auto___39425 = G__39428;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((1) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4796__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__37333){
var map__37334 = p__37333;
var map__37334__$1 = (((((!((map__37334 == null))))?(((((map__37334.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37334.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__37334):map__37334);
var opts = map__37334__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq37331){
var G__37332 = cljs.core.first(seq37331);
var seq37331__$1 = cljs.core.next(seq37331);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__37332,seq37331__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__37339 = arguments.length;
switch (G__37339) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__37098__auto___39437 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__37099__auto__ = (function (){var switch__36879__auto__ = (function (state_37417){
var state_val_37418 = (state_37417[(1)]);
if((state_val_37418 === (7))){
var inst_37412 = (state_37417[(2)]);
var state_37417__$1 = state_37417;
var statearr_37419_39440 = state_37417__$1;
(statearr_37419_39440[(2)] = inst_37412);

(statearr_37419_39440[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37418 === (1))){
var state_37417__$1 = state_37417;
var statearr_37420_39442 = state_37417__$1;
(statearr_37420_39442[(2)] = null);

(statearr_37420_39442[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37418 === (4))){
var inst_37394 = (state_37417[(7)]);
var inst_37394__$1 = (state_37417[(2)]);
var inst_37396 = (inst_37394__$1 == null);
var state_37417__$1 = (function (){var statearr_37421 = state_37417;
(statearr_37421[(7)] = inst_37394__$1);

return statearr_37421;
})();
if(cljs.core.truth_(inst_37396)){
var statearr_37422_39443 = state_37417__$1;
(statearr_37422_39443[(1)] = (5));

} else {
var statearr_37423_39446 = state_37417__$1;
(statearr_37423_39446[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37418 === (13))){
var state_37417__$1 = state_37417;
var statearr_37424_39450 = state_37417__$1;
(statearr_37424_39450[(2)] = null);

(statearr_37424_39450[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37418 === (6))){
var inst_37394 = (state_37417[(7)]);
var state_37417__$1 = state_37417;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_37417__$1,(11),to,inst_37394);
} else {
if((state_val_37418 === (3))){
var inst_37415 = (state_37417[(2)]);
var state_37417__$1 = state_37417;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37417__$1,inst_37415);
} else {
if((state_val_37418 === (12))){
var state_37417__$1 = state_37417;
var statearr_37425_39461 = state_37417__$1;
(statearr_37425_39461[(2)] = null);

(statearr_37425_39461[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37418 === (2))){
var state_37417__$1 = state_37417;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37417__$1,(4),from);
} else {
if((state_val_37418 === (11))){
var inst_37405 = (state_37417[(2)]);
var state_37417__$1 = state_37417;
if(cljs.core.truth_(inst_37405)){
var statearr_37426_39464 = state_37417__$1;
(statearr_37426_39464[(1)] = (12));

} else {
var statearr_37427_39465 = state_37417__$1;
(statearr_37427_39465[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37418 === (9))){
var state_37417__$1 = state_37417;
var statearr_37428_39466 = state_37417__$1;
(statearr_37428_39466[(2)] = null);

(statearr_37428_39466[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37418 === (5))){
var state_37417__$1 = state_37417;
if(cljs.core.truth_(close_QMARK_)){
var statearr_37429_39467 = state_37417__$1;
(statearr_37429_39467[(1)] = (8));

} else {
var statearr_37430_39471 = state_37417__$1;
(statearr_37430_39471[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37418 === (14))){
var inst_37410 = (state_37417[(2)]);
var state_37417__$1 = state_37417;
var statearr_37431_39473 = state_37417__$1;
(statearr_37431_39473[(2)] = inst_37410);

(statearr_37431_39473[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37418 === (10))){
var inst_37402 = (state_37417[(2)]);
var state_37417__$1 = state_37417;
var statearr_37432_39485 = state_37417__$1;
(statearr_37432_39485[(2)] = inst_37402);

(statearr_37432_39485[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37418 === (8))){
var inst_37399 = cljs.core.async.close_BANG_(to);
var state_37417__$1 = state_37417;
var statearr_37433_39487 = state_37417__$1;
(statearr_37433_39487[(2)] = inst_37399);

(statearr_37433_39487[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__36880__auto__ = null;
var cljs$core$async$state_machine__36880__auto____0 = (function (){
var statearr_37434 = [null,null,null,null,null,null,null,null];
(statearr_37434[(0)] = cljs$core$async$state_machine__36880__auto__);

(statearr_37434[(1)] = (1));

return statearr_37434;
});
var cljs$core$async$state_machine__36880__auto____1 = (function (state_37417){
while(true){
var ret_value__36881__auto__ = (function (){try{while(true){
var result__36882__auto__ = switch__36879__auto__(state_37417);
if(cljs.core.keyword_identical_QMARK_(result__36882__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36882__auto__;
}
break;
}
}catch (e37435){if((e37435 instanceof Object)){
var ex__36883__auto__ = e37435;
var statearr_37436_39488 = state_37417;
(statearr_37436_39488[(5)] = ex__36883__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_37417);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e37435;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__36881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39490 = state_37417;
state_37417 = G__39490;
continue;
} else {
return ret_value__36881__auto__;
}
break;
}
});
cljs$core$async$state_machine__36880__auto__ = function(state_37417){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__36880__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__36880__auto____1.call(this,state_37417);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__36880__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__36880__auto____0;
cljs$core$async$state_machine__36880__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__36880__auto____1;
return cljs$core$async$state_machine__36880__auto__;
})()
})();
var state__37100__auto__ = (function (){var statearr_37437 = f__37099__auto__();
(statearr_37437[(6)] = c__37098__auto___39437);

return statearr_37437;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37100__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__37438){
var vec__37439 = p__37438;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37439,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37439,(1),null);
var job = vec__37439;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__37098__auto___39492 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__37099__auto__ = (function (){var switch__36879__auto__ = (function (state_37446){
var state_val_37447 = (state_37446[(1)]);
if((state_val_37447 === (1))){
var state_37446__$1 = state_37446;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_37446__$1,(2),res,v);
} else {
if((state_val_37447 === (2))){
var inst_37443 = (state_37446[(2)]);
var inst_37444 = cljs.core.async.close_BANG_(res);
var state_37446__$1 = (function (){var statearr_37448 = state_37446;
(statearr_37448[(7)] = inst_37443);

return statearr_37448;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_37446__$1,inst_37444);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__36880__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__36880__auto____0 = (function (){
var statearr_37449 = [null,null,null,null,null,null,null,null];
(statearr_37449[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__36880__auto__);

(statearr_37449[(1)] = (1));

return statearr_37449;
});
var cljs$core$async$pipeline_STAR__$_state_machine__36880__auto____1 = (function (state_37446){
while(true){
var ret_value__36881__auto__ = (function (){try{while(true){
var result__36882__auto__ = switch__36879__auto__(state_37446);
if(cljs.core.keyword_identical_QMARK_(result__36882__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36882__auto__;
}
break;
}
}catch (e37450){if((e37450 instanceof Object)){
var ex__36883__auto__ = e37450;
var statearr_37451_39493 = state_37446;
(statearr_37451_39493[(5)] = ex__36883__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_37446);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e37450;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__36881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39498 = state_37446;
state_37446 = G__39498;
continue;
} else {
return ret_value__36881__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__36880__auto__ = function(state_37446){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__36880__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__36880__auto____1.call(this,state_37446);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__36880__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__36880__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__36880__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__36880__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__36880__auto__;
})()
})();
var state__37100__auto__ = (function (){var statearr_37452 = f__37099__auto__();
(statearr_37452[(6)] = c__37098__auto___39492);

return statearr_37452;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37100__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__37453){
var vec__37454 = p__37453;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37454,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37454,(1),null);
var job = vec__37454;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4666__auto___39502 = n;
var __39503 = (0);
while(true){
if((__39503 < n__4666__auto___39502)){
var G__37457_39504 = type;
var G__37457_39505__$1 = (((G__37457_39504 instanceof cljs.core.Keyword))?G__37457_39504.fqn:null);
switch (G__37457_39505__$1) {
case "compute":
var c__37098__auto___39507 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__39503,c__37098__auto___39507,G__37457_39504,G__37457_39505__$1,n__4666__auto___39502,jobs,results,process,async){
return (function (){
var f__37099__auto__ = (function (){var switch__36879__auto__ = ((function (__39503,c__37098__auto___39507,G__37457_39504,G__37457_39505__$1,n__4666__auto___39502,jobs,results,process,async){
return (function (state_37470){
var state_val_37471 = (state_37470[(1)]);
if((state_val_37471 === (1))){
var state_37470__$1 = state_37470;
var statearr_37472_39509 = state_37470__$1;
(statearr_37472_39509[(2)] = null);

(statearr_37472_39509[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37471 === (2))){
var state_37470__$1 = state_37470;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37470__$1,(4),jobs);
} else {
if((state_val_37471 === (3))){
var inst_37468 = (state_37470[(2)]);
var state_37470__$1 = state_37470;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37470__$1,inst_37468);
} else {
if((state_val_37471 === (4))){
var inst_37460 = (state_37470[(2)]);
var inst_37461 = process(inst_37460);
var state_37470__$1 = state_37470;
if(cljs.core.truth_(inst_37461)){
var statearr_37473_39511 = state_37470__$1;
(statearr_37473_39511[(1)] = (5));

} else {
var statearr_37474_39512 = state_37470__$1;
(statearr_37474_39512[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37471 === (5))){
var state_37470__$1 = state_37470;
var statearr_37475_39515 = state_37470__$1;
(statearr_37475_39515[(2)] = null);

(statearr_37475_39515[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37471 === (6))){
var state_37470__$1 = state_37470;
var statearr_37476_39516 = state_37470__$1;
(statearr_37476_39516[(2)] = null);

(statearr_37476_39516[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37471 === (7))){
var inst_37466 = (state_37470[(2)]);
var state_37470__$1 = state_37470;
var statearr_37477_39517 = state_37470__$1;
(statearr_37477_39517[(2)] = inst_37466);

(statearr_37477_39517[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__39503,c__37098__auto___39507,G__37457_39504,G__37457_39505__$1,n__4666__auto___39502,jobs,results,process,async))
;
return ((function (__39503,switch__36879__auto__,c__37098__auto___39507,G__37457_39504,G__37457_39505__$1,n__4666__auto___39502,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__36880__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__36880__auto____0 = (function (){
var statearr_37478 = [null,null,null,null,null,null,null];
(statearr_37478[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__36880__auto__);

(statearr_37478[(1)] = (1));

return statearr_37478;
});
var cljs$core$async$pipeline_STAR__$_state_machine__36880__auto____1 = (function (state_37470){
while(true){
var ret_value__36881__auto__ = (function (){try{while(true){
var result__36882__auto__ = switch__36879__auto__(state_37470);
if(cljs.core.keyword_identical_QMARK_(result__36882__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36882__auto__;
}
break;
}
}catch (e37479){if((e37479 instanceof Object)){
var ex__36883__auto__ = e37479;
var statearr_37480_39522 = state_37470;
(statearr_37480_39522[(5)] = ex__36883__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_37470);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e37479;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__36881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39524 = state_37470;
state_37470 = G__39524;
continue;
} else {
return ret_value__36881__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__36880__auto__ = function(state_37470){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__36880__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__36880__auto____1.call(this,state_37470);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__36880__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__36880__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__36880__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__36880__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__36880__auto__;
})()
;})(__39503,switch__36879__auto__,c__37098__auto___39507,G__37457_39504,G__37457_39505__$1,n__4666__auto___39502,jobs,results,process,async))
})();
var state__37100__auto__ = (function (){var statearr_37481 = f__37099__auto__();
(statearr_37481[(6)] = c__37098__auto___39507);

return statearr_37481;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37100__auto__);
});})(__39503,c__37098__auto___39507,G__37457_39504,G__37457_39505__$1,n__4666__auto___39502,jobs,results,process,async))
);


break;
case "async":
var c__37098__auto___39525 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__39503,c__37098__auto___39525,G__37457_39504,G__37457_39505__$1,n__4666__auto___39502,jobs,results,process,async){
return (function (){
var f__37099__auto__ = (function (){var switch__36879__auto__ = ((function (__39503,c__37098__auto___39525,G__37457_39504,G__37457_39505__$1,n__4666__auto___39502,jobs,results,process,async){
return (function (state_37495){
var state_val_37496 = (state_37495[(1)]);
if((state_val_37496 === (1))){
var state_37495__$1 = state_37495;
var statearr_37497_39530 = state_37495__$1;
(statearr_37497_39530[(2)] = null);

(statearr_37497_39530[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37496 === (2))){
var state_37495__$1 = state_37495;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37495__$1,(4),jobs);
} else {
if((state_val_37496 === (3))){
var inst_37493 = (state_37495[(2)]);
var state_37495__$1 = state_37495;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37495__$1,inst_37493);
} else {
if((state_val_37496 === (4))){
var inst_37485 = (state_37495[(2)]);
var inst_37486 = async(inst_37485);
var state_37495__$1 = state_37495;
if(cljs.core.truth_(inst_37486)){
var statearr_37499_39540 = state_37495__$1;
(statearr_37499_39540[(1)] = (5));

} else {
var statearr_37500_39541 = state_37495__$1;
(statearr_37500_39541[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37496 === (5))){
var state_37495__$1 = state_37495;
var statearr_37501_39542 = state_37495__$1;
(statearr_37501_39542[(2)] = null);

(statearr_37501_39542[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37496 === (6))){
var state_37495__$1 = state_37495;
var statearr_37502_39544 = state_37495__$1;
(statearr_37502_39544[(2)] = null);

(statearr_37502_39544[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37496 === (7))){
var inst_37491 = (state_37495[(2)]);
var state_37495__$1 = state_37495;
var statearr_37503_39546 = state_37495__$1;
(statearr_37503_39546[(2)] = inst_37491);

(statearr_37503_39546[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__39503,c__37098__auto___39525,G__37457_39504,G__37457_39505__$1,n__4666__auto___39502,jobs,results,process,async))
;
return ((function (__39503,switch__36879__auto__,c__37098__auto___39525,G__37457_39504,G__37457_39505__$1,n__4666__auto___39502,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__36880__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__36880__auto____0 = (function (){
var statearr_37504 = [null,null,null,null,null,null,null];
(statearr_37504[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__36880__auto__);

(statearr_37504[(1)] = (1));

return statearr_37504;
});
var cljs$core$async$pipeline_STAR__$_state_machine__36880__auto____1 = (function (state_37495){
while(true){
var ret_value__36881__auto__ = (function (){try{while(true){
var result__36882__auto__ = switch__36879__auto__(state_37495);
if(cljs.core.keyword_identical_QMARK_(result__36882__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36882__auto__;
}
break;
}
}catch (e37505){if((e37505 instanceof Object)){
var ex__36883__auto__ = e37505;
var statearr_37506_39549 = state_37495;
(statearr_37506_39549[(5)] = ex__36883__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_37495);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e37505;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__36881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39551 = state_37495;
state_37495 = G__39551;
continue;
} else {
return ret_value__36881__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__36880__auto__ = function(state_37495){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__36880__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__36880__auto____1.call(this,state_37495);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__36880__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__36880__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__36880__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__36880__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__36880__auto__;
})()
;})(__39503,switch__36879__auto__,c__37098__auto___39525,G__37457_39504,G__37457_39505__$1,n__4666__auto___39502,jobs,results,process,async))
})();
var state__37100__auto__ = (function (){var statearr_37507 = f__37099__auto__();
(statearr_37507[(6)] = c__37098__auto___39525);

return statearr_37507;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37100__auto__);
});})(__39503,c__37098__auto___39525,G__37457_39504,G__37457_39505__$1,n__4666__auto___39502,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__37457_39505__$1)].join('')));

}

var G__39552 = (__39503 + (1));
__39503 = G__39552;
continue;
} else {
}
break;
}

var c__37098__auto___39553 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__37099__auto__ = (function (){var switch__36879__auto__ = (function (state_37530){
var state_val_37531 = (state_37530[(1)]);
if((state_val_37531 === (7))){
var inst_37526 = (state_37530[(2)]);
var state_37530__$1 = state_37530;
var statearr_37534_39555 = state_37530__$1;
(statearr_37534_39555[(2)] = inst_37526);

(statearr_37534_39555[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37531 === (1))){
var state_37530__$1 = state_37530;
var statearr_37535_39557 = state_37530__$1;
(statearr_37535_39557[(2)] = null);

(statearr_37535_39557[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37531 === (4))){
var inst_37510 = (state_37530[(7)]);
var inst_37510__$1 = (state_37530[(2)]);
var inst_37511 = (inst_37510__$1 == null);
var state_37530__$1 = (function (){var statearr_37537 = state_37530;
(statearr_37537[(7)] = inst_37510__$1);

return statearr_37537;
})();
if(cljs.core.truth_(inst_37511)){
var statearr_37538_39558 = state_37530__$1;
(statearr_37538_39558[(1)] = (5));

} else {
var statearr_37539_39559 = state_37530__$1;
(statearr_37539_39559[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37531 === (6))){
var inst_37515 = (state_37530[(8)]);
var inst_37510 = (state_37530[(7)]);
var inst_37515__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_37517 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37518 = [inst_37510,inst_37515__$1];
var inst_37519 = (new cljs.core.PersistentVector(null,2,(5),inst_37517,inst_37518,null));
var state_37530__$1 = (function (){var statearr_37540 = state_37530;
(statearr_37540[(8)] = inst_37515__$1);

return statearr_37540;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_37530__$1,(8),jobs,inst_37519);
} else {
if((state_val_37531 === (3))){
var inst_37528 = (state_37530[(2)]);
var state_37530__$1 = state_37530;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37530__$1,inst_37528);
} else {
if((state_val_37531 === (2))){
var state_37530__$1 = state_37530;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37530__$1,(4),from);
} else {
if((state_val_37531 === (9))){
var inst_37523 = (state_37530[(2)]);
var state_37530__$1 = (function (){var statearr_37541 = state_37530;
(statearr_37541[(9)] = inst_37523);

return statearr_37541;
})();
var statearr_37543_39562 = state_37530__$1;
(statearr_37543_39562[(2)] = null);

(statearr_37543_39562[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37531 === (5))){
var inst_37513 = cljs.core.async.close_BANG_(jobs);
var state_37530__$1 = state_37530;
var statearr_37544_39565 = state_37530__$1;
(statearr_37544_39565[(2)] = inst_37513);

(statearr_37544_39565[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37531 === (8))){
var inst_37515 = (state_37530[(8)]);
var inst_37521 = (state_37530[(2)]);
var state_37530__$1 = (function (){var statearr_37545 = state_37530;
(statearr_37545[(10)] = inst_37521);

return statearr_37545;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_37530__$1,(9),results,inst_37515);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__36880__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__36880__auto____0 = (function (){
var statearr_37546 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_37546[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__36880__auto__);

(statearr_37546[(1)] = (1));

return statearr_37546;
});
var cljs$core$async$pipeline_STAR__$_state_machine__36880__auto____1 = (function (state_37530){
while(true){
var ret_value__36881__auto__ = (function (){try{while(true){
var result__36882__auto__ = switch__36879__auto__(state_37530);
if(cljs.core.keyword_identical_QMARK_(result__36882__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36882__auto__;
}
break;
}
}catch (e37547){if((e37547 instanceof Object)){
var ex__36883__auto__ = e37547;
var statearr_37548_39572 = state_37530;
(statearr_37548_39572[(5)] = ex__36883__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_37530);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e37547;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__36881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39575 = state_37530;
state_37530 = G__39575;
continue;
} else {
return ret_value__36881__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__36880__auto__ = function(state_37530){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__36880__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__36880__auto____1.call(this,state_37530);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__36880__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__36880__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__36880__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__36880__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__36880__auto__;
})()
})();
var state__37100__auto__ = (function (){var statearr_37549 = f__37099__auto__();
(statearr_37549[(6)] = c__37098__auto___39553);

return statearr_37549;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37100__auto__);
}));


var c__37098__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__37099__auto__ = (function (){var switch__36879__auto__ = (function (state_37588){
var state_val_37589 = (state_37588[(1)]);
if((state_val_37589 === (7))){
var inst_37584 = (state_37588[(2)]);
var state_37588__$1 = state_37588;
var statearr_37591_39584 = state_37588__$1;
(statearr_37591_39584[(2)] = inst_37584);

(statearr_37591_39584[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37589 === (20))){
var state_37588__$1 = state_37588;
var statearr_37592_39587 = state_37588__$1;
(statearr_37592_39587[(2)] = null);

(statearr_37592_39587[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37589 === (1))){
var state_37588__$1 = state_37588;
var statearr_37593_39588 = state_37588__$1;
(statearr_37593_39588[(2)] = null);

(statearr_37593_39588[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37589 === (4))){
var inst_37553 = (state_37588[(7)]);
var inst_37553__$1 = (state_37588[(2)]);
var inst_37554 = (inst_37553__$1 == null);
var state_37588__$1 = (function (){var statearr_37594 = state_37588;
(statearr_37594[(7)] = inst_37553__$1);

return statearr_37594;
})();
if(cljs.core.truth_(inst_37554)){
var statearr_37595_39589 = state_37588__$1;
(statearr_37595_39589[(1)] = (5));

} else {
var statearr_37596_39590 = state_37588__$1;
(statearr_37596_39590[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37589 === (15))){
var inst_37566 = (state_37588[(8)]);
var state_37588__$1 = state_37588;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_37588__$1,(18),to,inst_37566);
} else {
if((state_val_37589 === (21))){
var inst_37579 = (state_37588[(2)]);
var state_37588__$1 = state_37588;
var statearr_37598_39593 = state_37588__$1;
(statearr_37598_39593[(2)] = inst_37579);

(statearr_37598_39593[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37589 === (13))){
var inst_37581 = (state_37588[(2)]);
var state_37588__$1 = (function (){var statearr_37599 = state_37588;
(statearr_37599[(9)] = inst_37581);

return statearr_37599;
})();
var statearr_37600_39596 = state_37588__$1;
(statearr_37600_39596[(2)] = null);

(statearr_37600_39596[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37589 === (6))){
var inst_37553 = (state_37588[(7)]);
var state_37588__$1 = state_37588;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37588__$1,(11),inst_37553);
} else {
if((state_val_37589 === (17))){
var inst_37574 = (state_37588[(2)]);
var state_37588__$1 = state_37588;
if(cljs.core.truth_(inst_37574)){
var statearr_37601_39598 = state_37588__$1;
(statearr_37601_39598[(1)] = (19));

} else {
var statearr_37602_39599 = state_37588__$1;
(statearr_37602_39599[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37589 === (3))){
var inst_37586 = (state_37588[(2)]);
var state_37588__$1 = state_37588;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37588__$1,inst_37586);
} else {
if((state_val_37589 === (12))){
var inst_37563 = (state_37588[(10)]);
var state_37588__$1 = state_37588;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37588__$1,(14),inst_37563);
} else {
if((state_val_37589 === (2))){
var state_37588__$1 = state_37588;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37588__$1,(4),results);
} else {
if((state_val_37589 === (19))){
var state_37588__$1 = state_37588;
var statearr_37603_39600 = state_37588__$1;
(statearr_37603_39600[(2)] = null);

(statearr_37603_39600[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37589 === (11))){
var inst_37563 = (state_37588[(2)]);
var state_37588__$1 = (function (){var statearr_37605 = state_37588;
(statearr_37605[(10)] = inst_37563);

return statearr_37605;
})();
var statearr_37606_39601 = state_37588__$1;
(statearr_37606_39601[(2)] = null);

(statearr_37606_39601[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37589 === (9))){
var state_37588__$1 = state_37588;
var statearr_37607_39603 = state_37588__$1;
(statearr_37607_39603[(2)] = null);

(statearr_37607_39603[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37589 === (5))){
var state_37588__$1 = state_37588;
if(cljs.core.truth_(close_QMARK_)){
var statearr_37608_39604 = state_37588__$1;
(statearr_37608_39604[(1)] = (8));

} else {
var statearr_37609_39605 = state_37588__$1;
(statearr_37609_39605[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37589 === (14))){
var inst_37566 = (state_37588[(8)]);
var inst_37566__$1 = (state_37588[(2)]);
var inst_37567 = (inst_37566__$1 == null);
var inst_37568 = cljs.core.not(inst_37567);
var state_37588__$1 = (function (){var statearr_37610 = state_37588;
(statearr_37610[(8)] = inst_37566__$1);

return statearr_37610;
})();
if(inst_37568){
var statearr_37611_39614 = state_37588__$1;
(statearr_37611_39614[(1)] = (15));

} else {
var statearr_37612_39615 = state_37588__$1;
(statearr_37612_39615[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37589 === (16))){
var state_37588__$1 = state_37588;
var statearr_37613_39616 = state_37588__$1;
(statearr_37613_39616[(2)] = false);

(statearr_37613_39616[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37589 === (10))){
var inst_37560 = (state_37588[(2)]);
var state_37588__$1 = state_37588;
var statearr_37614_39617 = state_37588__$1;
(statearr_37614_39617[(2)] = inst_37560);

(statearr_37614_39617[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37589 === (18))){
var inst_37571 = (state_37588[(2)]);
var state_37588__$1 = state_37588;
var statearr_37615_39618 = state_37588__$1;
(statearr_37615_39618[(2)] = inst_37571);

(statearr_37615_39618[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37589 === (8))){
var inst_37557 = cljs.core.async.close_BANG_(to);
var state_37588__$1 = state_37588;
var statearr_37617_39620 = state_37588__$1;
(statearr_37617_39620[(2)] = inst_37557);

(statearr_37617_39620[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__36880__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__36880__auto____0 = (function (){
var statearr_37618 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_37618[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__36880__auto__);

(statearr_37618[(1)] = (1));

return statearr_37618;
});
var cljs$core$async$pipeline_STAR__$_state_machine__36880__auto____1 = (function (state_37588){
while(true){
var ret_value__36881__auto__ = (function (){try{while(true){
var result__36882__auto__ = switch__36879__auto__(state_37588);
if(cljs.core.keyword_identical_QMARK_(result__36882__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36882__auto__;
}
break;
}
}catch (e37619){if((e37619 instanceof Object)){
var ex__36883__auto__ = e37619;
var statearr_37620_39634 = state_37588;
(statearr_37620_39634[(5)] = ex__36883__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_37588);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e37619;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__36881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39635 = state_37588;
state_37588 = G__39635;
continue;
} else {
return ret_value__36881__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__36880__auto__ = function(state_37588){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__36880__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__36880__auto____1.call(this,state_37588);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__36880__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__36880__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__36880__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__36880__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__36880__auto__;
})()
})();
var state__37100__auto__ = (function (){var statearr_37621 = f__37099__auto__();
(statearr_37621[(6)] = c__37098__auto__);

return statearr_37621;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37100__auto__);
}));

return c__37098__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__37624 = arguments.length;
switch (G__37624) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__37627 = arguments.length;
switch (G__37627) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__37630 = arguments.length;
switch (G__37630) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__37098__auto___39659 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__37099__auto__ = (function (){var switch__36879__auto__ = (function (state_37657){
var state_val_37658 = (state_37657[(1)]);
if((state_val_37658 === (7))){
var inst_37652 = (state_37657[(2)]);
var state_37657__$1 = state_37657;
var statearr_37659_39662 = state_37657__$1;
(statearr_37659_39662[(2)] = inst_37652);

(statearr_37659_39662[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37658 === (1))){
var state_37657__$1 = state_37657;
var statearr_37660_39663 = state_37657__$1;
(statearr_37660_39663[(2)] = null);

(statearr_37660_39663[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37658 === (4))){
var inst_37633 = (state_37657[(7)]);
var inst_37633__$1 = (state_37657[(2)]);
var inst_37634 = (inst_37633__$1 == null);
var state_37657__$1 = (function (){var statearr_37661 = state_37657;
(statearr_37661[(7)] = inst_37633__$1);

return statearr_37661;
})();
if(cljs.core.truth_(inst_37634)){
var statearr_37662_39670 = state_37657__$1;
(statearr_37662_39670[(1)] = (5));

} else {
var statearr_37663_39674 = state_37657__$1;
(statearr_37663_39674[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37658 === (13))){
var state_37657__$1 = state_37657;
var statearr_37665_39675 = state_37657__$1;
(statearr_37665_39675[(2)] = null);

(statearr_37665_39675[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37658 === (6))){
var inst_37633 = (state_37657[(7)]);
var inst_37639 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_37633) : p.call(null,inst_37633));
var state_37657__$1 = state_37657;
if(cljs.core.truth_(inst_37639)){
var statearr_37666_39679 = state_37657__$1;
(statearr_37666_39679[(1)] = (9));

} else {
var statearr_37667_39683 = state_37657__$1;
(statearr_37667_39683[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37658 === (3))){
var inst_37654 = (state_37657[(2)]);
var state_37657__$1 = state_37657;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37657__$1,inst_37654);
} else {
if((state_val_37658 === (12))){
var state_37657__$1 = state_37657;
var statearr_37668_39685 = state_37657__$1;
(statearr_37668_39685[(2)] = null);

(statearr_37668_39685[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37658 === (2))){
var state_37657__$1 = state_37657;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37657__$1,(4),ch);
} else {
if((state_val_37658 === (11))){
var inst_37633 = (state_37657[(7)]);
var inst_37643 = (state_37657[(2)]);
var state_37657__$1 = state_37657;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_37657__$1,(8),inst_37643,inst_37633);
} else {
if((state_val_37658 === (9))){
var state_37657__$1 = state_37657;
var statearr_37669_39689 = state_37657__$1;
(statearr_37669_39689[(2)] = tc);

(statearr_37669_39689[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37658 === (5))){
var inst_37636 = cljs.core.async.close_BANG_(tc);
var inst_37637 = cljs.core.async.close_BANG_(fc);
var state_37657__$1 = (function (){var statearr_37670 = state_37657;
(statearr_37670[(8)] = inst_37636);

return statearr_37670;
})();
var statearr_37671_39693 = state_37657__$1;
(statearr_37671_39693[(2)] = inst_37637);

(statearr_37671_39693[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37658 === (14))){
var inst_37650 = (state_37657[(2)]);
var state_37657__$1 = state_37657;
var statearr_37673_39695 = state_37657__$1;
(statearr_37673_39695[(2)] = inst_37650);

(statearr_37673_39695[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37658 === (10))){
var state_37657__$1 = state_37657;
var statearr_37674_39696 = state_37657__$1;
(statearr_37674_39696[(2)] = fc);

(statearr_37674_39696[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37658 === (8))){
var inst_37645 = (state_37657[(2)]);
var state_37657__$1 = state_37657;
if(cljs.core.truth_(inst_37645)){
var statearr_37675_39701 = state_37657__$1;
(statearr_37675_39701[(1)] = (12));

} else {
var statearr_37676_39713 = state_37657__$1;
(statearr_37676_39713[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__36880__auto__ = null;
var cljs$core$async$state_machine__36880__auto____0 = (function (){
var statearr_37677 = [null,null,null,null,null,null,null,null,null];
(statearr_37677[(0)] = cljs$core$async$state_machine__36880__auto__);

(statearr_37677[(1)] = (1));

return statearr_37677;
});
var cljs$core$async$state_machine__36880__auto____1 = (function (state_37657){
while(true){
var ret_value__36881__auto__ = (function (){try{while(true){
var result__36882__auto__ = switch__36879__auto__(state_37657);
if(cljs.core.keyword_identical_QMARK_(result__36882__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36882__auto__;
}
break;
}
}catch (e37678){if((e37678 instanceof Object)){
var ex__36883__auto__ = e37678;
var statearr_37679_39714 = state_37657;
(statearr_37679_39714[(5)] = ex__36883__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_37657);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e37678;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__36881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39718 = state_37657;
state_37657 = G__39718;
continue;
} else {
return ret_value__36881__auto__;
}
break;
}
});
cljs$core$async$state_machine__36880__auto__ = function(state_37657){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__36880__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__36880__auto____1.call(this,state_37657);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__36880__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__36880__auto____0;
cljs$core$async$state_machine__36880__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__36880__auto____1;
return cljs$core$async$state_machine__36880__auto__;
})()
})();
var state__37100__auto__ = (function (){var statearr_37681 = f__37099__auto__();
(statearr_37681[(6)] = c__37098__auto___39659);

return statearr_37681;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37100__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__37098__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__37099__auto__ = (function (){var switch__36879__auto__ = (function (state_37702){
var state_val_37703 = (state_37702[(1)]);
if((state_val_37703 === (7))){
var inst_37698 = (state_37702[(2)]);
var state_37702__$1 = state_37702;
var statearr_37705_39725 = state_37702__$1;
(statearr_37705_39725[(2)] = inst_37698);

(statearr_37705_39725[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37703 === (1))){
var inst_37682 = init;
var state_37702__$1 = (function (){var statearr_37706 = state_37702;
(statearr_37706[(7)] = inst_37682);

return statearr_37706;
})();
var statearr_37707_39729 = state_37702__$1;
(statearr_37707_39729[(2)] = null);

(statearr_37707_39729[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37703 === (4))){
var inst_37685 = (state_37702[(8)]);
var inst_37685__$1 = (state_37702[(2)]);
var inst_37686 = (inst_37685__$1 == null);
var state_37702__$1 = (function (){var statearr_37708 = state_37702;
(statearr_37708[(8)] = inst_37685__$1);

return statearr_37708;
})();
if(cljs.core.truth_(inst_37686)){
var statearr_37709_39732 = state_37702__$1;
(statearr_37709_39732[(1)] = (5));

} else {
var statearr_37710_39733 = state_37702__$1;
(statearr_37710_39733[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37703 === (6))){
var inst_37682 = (state_37702[(7)]);
var inst_37685 = (state_37702[(8)]);
var inst_37689 = (state_37702[(9)]);
var inst_37689__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_37682,inst_37685) : f.call(null,inst_37682,inst_37685));
var inst_37690 = cljs.core.reduced_QMARK_(inst_37689__$1);
var state_37702__$1 = (function (){var statearr_37711 = state_37702;
(statearr_37711[(9)] = inst_37689__$1);

return statearr_37711;
})();
if(inst_37690){
var statearr_37712_39737 = state_37702__$1;
(statearr_37712_39737[(1)] = (8));

} else {
var statearr_37713_39738 = state_37702__$1;
(statearr_37713_39738[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37703 === (3))){
var inst_37700 = (state_37702[(2)]);
var state_37702__$1 = state_37702;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37702__$1,inst_37700);
} else {
if((state_val_37703 === (2))){
var state_37702__$1 = state_37702;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37702__$1,(4),ch);
} else {
if((state_val_37703 === (9))){
var inst_37689 = (state_37702[(9)]);
var inst_37682 = inst_37689;
var state_37702__$1 = (function (){var statearr_37715 = state_37702;
(statearr_37715[(7)] = inst_37682);

return statearr_37715;
})();
var statearr_37716_39740 = state_37702__$1;
(statearr_37716_39740[(2)] = null);

(statearr_37716_39740[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37703 === (5))){
var inst_37682 = (state_37702[(7)]);
var state_37702__$1 = state_37702;
var statearr_37717_39744 = state_37702__$1;
(statearr_37717_39744[(2)] = inst_37682);

(statearr_37717_39744[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37703 === (10))){
var inst_37696 = (state_37702[(2)]);
var state_37702__$1 = state_37702;
var statearr_37718_39745 = state_37702__$1;
(statearr_37718_39745[(2)] = inst_37696);

(statearr_37718_39745[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37703 === (8))){
var inst_37689 = (state_37702[(9)]);
var inst_37692 = cljs.core.deref(inst_37689);
var state_37702__$1 = state_37702;
var statearr_37719_39746 = state_37702__$1;
(statearr_37719_39746[(2)] = inst_37692);

(statearr_37719_39746[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__36880__auto__ = null;
var cljs$core$async$reduce_$_state_machine__36880__auto____0 = (function (){
var statearr_37720 = [null,null,null,null,null,null,null,null,null,null];
(statearr_37720[(0)] = cljs$core$async$reduce_$_state_machine__36880__auto__);

(statearr_37720[(1)] = (1));

return statearr_37720;
});
var cljs$core$async$reduce_$_state_machine__36880__auto____1 = (function (state_37702){
while(true){
var ret_value__36881__auto__ = (function (){try{while(true){
var result__36882__auto__ = switch__36879__auto__(state_37702);
if(cljs.core.keyword_identical_QMARK_(result__36882__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36882__auto__;
}
break;
}
}catch (e37722){if((e37722 instanceof Object)){
var ex__36883__auto__ = e37722;
var statearr_37723_39748 = state_37702;
(statearr_37723_39748[(5)] = ex__36883__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_37702);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e37722;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__36881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39749 = state_37702;
state_37702 = G__39749;
continue;
} else {
return ret_value__36881__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__36880__auto__ = function(state_37702){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__36880__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__36880__auto____1.call(this,state_37702);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__36880__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__36880__auto____0;
cljs$core$async$reduce_$_state_machine__36880__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__36880__auto____1;
return cljs$core$async$reduce_$_state_machine__36880__auto__;
})()
})();
var state__37100__auto__ = (function (){var statearr_37724 = f__37099__auto__();
(statearr_37724[(6)] = c__37098__auto__);

return statearr_37724;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37100__auto__);
}));

return c__37098__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__37098__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__37099__auto__ = (function (){var switch__36879__auto__ = (function (state_37730){
var state_val_37731 = (state_37730[(1)]);
if((state_val_37731 === (1))){
var inst_37725 = cljs.core.async.reduce(f__$1,init,ch);
var state_37730__$1 = state_37730;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37730__$1,(2),inst_37725);
} else {
if((state_val_37731 === (2))){
var inst_37727 = (state_37730[(2)]);
var inst_37728 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_37727) : f__$1.call(null,inst_37727));
var state_37730__$1 = state_37730;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37730__$1,inst_37728);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__36880__auto__ = null;
var cljs$core$async$transduce_$_state_machine__36880__auto____0 = (function (){
var statearr_37733 = [null,null,null,null,null,null,null];
(statearr_37733[(0)] = cljs$core$async$transduce_$_state_machine__36880__auto__);

(statearr_37733[(1)] = (1));

return statearr_37733;
});
var cljs$core$async$transduce_$_state_machine__36880__auto____1 = (function (state_37730){
while(true){
var ret_value__36881__auto__ = (function (){try{while(true){
var result__36882__auto__ = switch__36879__auto__(state_37730);
if(cljs.core.keyword_identical_QMARK_(result__36882__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36882__auto__;
}
break;
}
}catch (e37734){if((e37734 instanceof Object)){
var ex__36883__auto__ = e37734;
var statearr_37735_39752 = state_37730;
(statearr_37735_39752[(5)] = ex__36883__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_37730);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e37734;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__36881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39753 = state_37730;
state_37730 = G__39753;
continue;
} else {
return ret_value__36881__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__36880__auto__ = function(state_37730){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__36880__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__36880__auto____1.call(this,state_37730);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__36880__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__36880__auto____0;
cljs$core$async$transduce_$_state_machine__36880__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__36880__auto____1;
return cljs$core$async$transduce_$_state_machine__36880__auto__;
})()
})();
var state__37100__auto__ = (function (){var statearr_37737 = f__37099__auto__();
(statearr_37737[(6)] = c__37098__auto__);

return statearr_37737;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37100__auto__);
}));

return c__37098__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__37739 = arguments.length;
switch (G__37739) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__37098__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__37099__auto__ = (function (){var switch__36879__auto__ = (function (state_37765){
var state_val_37766 = (state_37765[(1)]);
if((state_val_37766 === (7))){
var inst_37747 = (state_37765[(2)]);
var state_37765__$1 = state_37765;
var statearr_37767_39760 = state_37765__$1;
(statearr_37767_39760[(2)] = inst_37747);

(statearr_37767_39760[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37766 === (1))){
var inst_37740 = cljs.core.seq(coll);
var inst_37741 = inst_37740;
var state_37765__$1 = (function (){var statearr_37768 = state_37765;
(statearr_37768[(7)] = inst_37741);

return statearr_37768;
})();
var statearr_37769_39762 = state_37765__$1;
(statearr_37769_39762[(2)] = null);

(statearr_37769_39762[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37766 === (4))){
var inst_37741 = (state_37765[(7)]);
var inst_37745 = cljs.core.first(inst_37741);
var state_37765__$1 = state_37765;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_37765__$1,(7),ch,inst_37745);
} else {
if((state_val_37766 === (13))){
var inst_37759 = (state_37765[(2)]);
var state_37765__$1 = state_37765;
var statearr_37770_39766 = state_37765__$1;
(statearr_37770_39766[(2)] = inst_37759);

(statearr_37770_39766[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37766 === (6))){
var inst_37750 = (state_37765[(2)]);
var state_37765__$1 = state_37765;
if(cljs.core.truth_(inst_37750)){
var statearr_37772_39770 = state_37765__$1;
(statearr_37772_39770[(1)] = (8));

} else {
var statearr_37773_39771 = state_37765__$1;
(statearr_37773_39771[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37766 === (3))){
var inst_37763 = (state_37765[(2)]);
var state_37765__$1 = state_37765;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37765__$1,inst_37763);
} else {
if((state_val_37766 === (12))){
var state_37765__$1 = state_37765;
var statearr_37774_39780 = state_37765__$1;
(statearr_37774_39780[(2)] = null);

(statearr_37774_39780[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37766 === (2))){
var inst_37741 = (state_37765[(7)]);
var state_37765__$1 = state_37765;
if(cljs.core.truth_(inst_37741)){
var statearr_37775_39786 = state_37765__$1;
(statearr_37775_39786[(1)] = (4));

} else {
var statearr_37776_39788 = state_37765__$1;
(statearr_37776_39788[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37766 === (11))){
var inst_37756 = cljs.core.async.close_BANG_(ch);
var state_37765__$1 = state_37765;
var statearr_37777_39789 = state_37765__$1;
(statearr_37777_39789[(2)] = inst_37756);

(statearr_37777_39789[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37766 === (9))){
var state_37765__$1 = state_37765;
if(cljs.core.truth_(close_QMARK_)){
var statearr_37778_39790 = state_37765__$1;
(statearr_37778_39790[(1)] = (11));

} else {
var statearr_37779_39791 = state_37765__$1;
(statearr_37779_39791[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37766 === (5))){
var inst_37741 = (state_37765[(7)]);
var state_37765__$1 = state_37765;
var statearr_37780_39796 = state_37765__$1;
(statearr_37780_39796[(2)] = inst_37741);

(statearr_37780_39796[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37766 === (10))){
var inst_37761 = (state_37765[(2)]);
var state_37765__$1 = state_37765;
var statearr_37781_39799 = state_37765__$1;
(statearr_37781_39799[(2)] = inst_37761);

(statearr_37781_39799[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37766 === (8))){
var inst_37741 = (state_37765[(7)]);
var inst_37752 = cljs.core.next(inst_37741);
var inst_37741__$1 = inst_37752;
var state_37765__$1 = (function (){var statearr_37783 = state_37765;
(statearr_37783[(7)] = inst_37741__$1);

return statearr_37783;
})();
var statearr_37784_39800 = state_37765__$1;
(statearr_37784_39800[(2)] = null);

(statearr_37784_39800[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__36880__auto__ = null;
var cljs$core$async$state_machine__36880__auto____0 = (function (){
var statearr_37785 = [null,null,null,null,null,null,null,null];
(statearr_37785[(0)] = cljs$core$async$state_machine__36880__auto__);

(statearr_37785[(1)] = (1));

return statearr_37785;
});
var cljs$core$async$state_machine__36880__auto____1 = (function (state_37765){
while(true){
var ret_value__36881__auto__ = (function (){try{while(true){
var result__36882__auto__ = switch__36879__auto__(state_37765);
if(cljs.core.keyword_identical_QMARK_(result__36882__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36882__auto__;
}
break;
}
}catch (e37786){if((e37786 instanceof Object)){
var ex__36883__auto__ = e37786;
var statearr_37787_39807 = state_37765;
(statearr_37787_39807[(5)] = ex__36883__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_37765);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e37786;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__36881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39818 = state_37765;
state_37765 = G__39818;
continue;
} else {
return ret_value__36881__auto__;
}
break;
}
});
cljs$core$async$state_machine__36880__auto__ = function(state_37765){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__36880__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__36880__auto____1.call(this,state_37765);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__36880__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__36880__auto____0;
cljs$core$async$state_machine__36880__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__36880__auto____1;
return cljs$core$async$state_machine__36880__auto__;
})()
})();
var state__37100__auto__ = (function (){var statearr_37788 = f__37099__auto__();
(statearr_37788[(6)] = c__37098__auto__);

return statearr_37788;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37100__auto__);
}));

return c__37098__auto__;
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__4487__auto__ = (((_ == null))?null:_);
var m__4488__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return (m__4488__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4488__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4488__auto__.call(null,_));
} else {
var m__4485__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return (m__4485__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4485__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4485__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__4487__auto__ = (((m == null))?null:m);
var m__4488__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return (m__4488__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4488__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4488__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4485__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return (m__4485__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4485__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4485__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__4487__auto__ = (((m == null))?null:m);
var m__4488__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return (m__4488__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4488__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4488__auto__.call(null,m,ch));
} else {
var m__4485__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return (m__4485__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4485__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4485__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__4487__auto__ = (((m == null))?null:m);
var m__4488__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return (m__4488__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4488__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4488__auto__.call(null,m));
} else {
var m__4485__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return (m__4485__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4485__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4485__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async37792 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async37792 = (function (ch,cs,meta37793){
this.ch = ch;
this.cs = cs;
this.meta37793 = meta37793;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async37792.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_37794,meta37793__$1){
var self__ = this;
var _37794__$1 = this;
return (new cljs.core.async.t_cljs$core$async37792(self__.ch,self__.cs,meta37793__$1));
}));

(cljs.core.async.t_cljs$core$async37792.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_37794){
var self__ = this;
var _37794__$1 = this;
return self__.meta37793;
}));

(cljs.core.async.t_cljs$core$async37792.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async37792.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async37792.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async37792.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async37792.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async37792.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async37792.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta37793","meta37793",-745786669,null)], null);
}));

(cljs.core.async.t_cljs$core$async37792.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async37792.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async37792");

(cljs.core.async.t_cljs$core$async37792.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write(writer__4429__auto__,"cljs.core.async/t_cljs$core$async37792");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async37792.
 */
cljs.core.async.__GT_t_cljs$core$async37792 = (function cljs$core$async$mult_$___GT_t_cljs$core$async37792(ch__$1,cs__$1,meta37793){
return (new cljs.core.async.t_cljs$core$async37792(ch__$1,cs__$1,meta37793));
});

}

return (new cljs.core.async.t_cljs$core$async37792(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__37098__auto___39860 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__37099__auto__ = (function (){var switch__36879__auto__ = (function (state_37932){
var state_val_37933 = (state_37932[(1)]);
if((state_val_37933 === (7))){
var inst_37927 = (state_37932[(2)]);
var state_37932__$1 = state_37932;
var statearr_37934_39861 = state_37932__$1;
(statearr_37934_39861[(2)] = inst_37927);

(statearr_37934_39861[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37933 === (20))){
var inst_37831 = (state_37932[(7)]);
var inst_37843 = cljs.core.first(inst_37831);
var inst_37844 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37843,(0),null);
var inst_37845 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37843,(1),null);
var state_37932__$1 = (function (){var statearr_37935 = state_37932;
(statearr_37935[(8)] = inst_37844);

return statearr_37935;
})();
if(cljs.core.truth_(inst_37845)){
var statearr_37936_39870 = state_37932__$1;
(statearr_37936_39870[(1)] = (22));

} else {
var statearr_37937_39871 = state_37932__$1;
(statearr_37937_39871[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37933 === (27))){
var inst_37874 = (state_37932[(9)]);
var inst_37881 = (state_37932[(10)]);
var inst_37876 = (state_37932[(11)]);
var inst_37799 = (state_37932[(12)]);
var inst_37881__$1 = cljs.core._nth(inst_37874,inst_37876);
var inst_37882 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_37881__$1,inst_37799,done);
var state_37932__$1 = (function (){var statearr_37938 = state_37932;
(statearr_37938[(10)] = inst_37881__$1);

return statearr_37938;
})();
if(cljs.core.truth_(inst_37882)){
var statearr_37940_39875 = state_37932__$1;
(statearr_37940_39875[(1)] = (30));

} else {
var statearr_37941_39876 = state_37932__$1;
(statearr_37941_39876[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37933 === (1))){
var state_37932__$1 = state_37932;
var statearr_37942_39882 = state_37932__$1;
(statearr_37942_39882[(2)] = null);

(statearr_37942_39882[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37933 === (24))){
var inst_37831 = (state_37932[(7)]);
var inst_37850 = (state_37932[(2)]);
var inst_37851 = cljs.core.next(inst_37831);
var inst_37808 = inst_37851;
var inst_37809 = null;
var inst_37810 = (0);
var inst_37811 = (0);
var state_37932__$1 = (function (){var statearr_37943 = state_37932;
(statearr_37943[(13)] = inst_37809);

(statearr_37943[(14)] = inst_37810);

(statearr_37943[(15)] = inst_37811);

(statearr_37943[(16)] = inst_37850);

(statearr_37943[(17)] = inst_37808);

return statearr_37943;
})();
var statearr_37944_39885 = state_37932__$1;
(statearr_37944_39885[(2)] = null);

(statearr_37944_39885[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37933 === (39))){
var state_37932__$1 = state_37932;
var statearr_37949_39886 = state_37932__$1;
(statearr_37949_39886[(2)] = null);

(statearr_37949_39886[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37933 === (4))){
var inst_37799 = (state_37932[(12)]);
var inst_37799__$1 = (state_37932[(2)]);
var inst_37800 = (inst_37799__$1 == null);
var state_37932__$1 = (function (){var statearr_37950 = state_37932;
(statearr_37950[(12)] = inst_37799__$1);

return statearr_37950;
})();
if(cljs.core.truth_(inst_37800)){
var statearr_37951_39887 = state_37932__$1;
(statearr_37951_39887[(1)] = (5));

} else {
var statearr_37952_39888 = state_37932__$1;
(statearr_37952_39888[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37933 === (15))){
var inst_37809 = (state_37932[(13)]);
var inst_37810 = (state_37932[(14)]);
var inst_37811 = (state_37932[(15)]);
var inst_37808 = (state_37932[(17)]);
var inst_37827 = (state_37932[(2)]);
var inst_37828 = (inst_37811 + (1));
var tmp37945 = inst_37809;
var tmp37946 = inst_37810;
var tmp37947 = inst_37808;
var inst_37808__$1 = tmp37947;
var inst_37809__$1 = tmp37945;
var inst_37810__$1 = tmp37946;
var inst_37811__$1 = inst_37828;
var state_37932__$1 = (function (){var statearr_37953 = state_37932;
(statearr_37953[(13)] = inst_37809__$1);

(statearr_37953[(14)] = inst_37810__$1);

(statearr_37953[(15)] = inst_37811__$1);

(statearr_37953[(17)] = inst_37808__$1);

(statearr_37953[(18)] = inst_37827);

return statearr_37953;
})();
var statearr_37954_39905 = state_37932__$1;
(statearr_37954_39905[(2)] = null);

(statearr_37954_39905[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37933 === (21))){
var inst_37854 = (state_37932[(2)]);
var state_37932__$1 = state_37932;
var statearr_37958_39907 = state_37932__$1;
(statearr_37958_39907[(2)] = inst_37854);

(statearr_37958_39907[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37933 === (31))){
var inst_37881 = (state_37932[(10)]);
var inst_37885 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_37881);
var state_37932__$1 = state_37932;
var statearr_37960_39908 = state_37932__$1;
(statearr_37960_39908[(2)] = inst_37885);

(statearr_37960_39908[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37933 === (32))){
var inst_37874 = (state_37932[(9)]);
var inst_37873 = (state_37932[(19)]);
var inst_37876 = (state_37932[(11)]);
var inst_37875 = (state_37932[(20)]);
var inst_37887 = (state_37932[(2)]);
var inst_37888 = (inst_37876 + (1));
var tmp37955 = inst_37874;
var tmp37956 = inst_37873;
var tmp37957 = inst_37875;
var inst_37873__$1 = tmp37956;
var inst_37874__$1 = tmp37955;
var inst_37875__$1 = tmp37957;
var inst_37876__$1 = inst_37888;
var state_37932__$1 = (function (){var statearr_37961 = state_37932;
(statearr_37961[(21)] = inst_37887);

(statearr_37961[(9)] = inst_37874__$1);

(statearr_37961[(19)] = inst_37873__$1);

(statearr_37961[(11)] = inst_37876__$1);

(statearr_37961[(20)] = inst_37875__$1);

return statearr_37961;
})();
var statearr_37962_39920 = state_37932__$1;
(statearr_37962_39920[(2)] = null);

(statearr_37962_39920[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37933 === (40))){
var inst_37900 = (state_37932[(22)]);
var inst_37904 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_37900);
var state_37932__$1 = state_37932;
var statearr_37963_39926 = state_37932__$1;
(statearr_37963_39926[(2)] = inst_37904);

(statearr_37963_39926[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37933 === (33))){
var inst_37891 = (state_37932[(23)]);
var inst_37893 = cljs.core.chunked_seq_QMARK_(inst_37891);
var state_37932__$1 = state_37932;
if(inst_37893){
var statearr_37964_39927 = state_37932__$1;
(statearr_37964_39927[(1)] = (36));

} else {
var statearr_37965_39928 = state_37932__$1;
(statearr_37965_39928[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37933 === (13))){
var inst_37821 = (state_37932[(24)]);
var inst_37824 = cljs.core.async.close_BANG_(inst_37821);
var state_37932__$1 = state_37932;
var statearr_37967_39931 = state_37932__$1;
(statearr_37967_39931[(2)] = inst_37824);

(statearr_37967_39931[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37933 === (22))){
var inst_37844 = (state_37932[(8)]);
var inst_37847 = cljs.core.async.close_BANG_(inst_37844);
var state_37932__$1 = state_37932;
var statearr_37968_39932 = state_37932__$1;
(statearr_37968_39932[(2)] = inst_37847);

(statearr_37968_39932[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37933 === (36))){
var inst_37891 = (state_37932[(23)]);
var inst_37895 = cljs.core.chunk_first(inst_37891);
var inst_37896 = cljs.core.chunk_rest(inst_37891);
var inst_37897 = cljs.core.count(inst_37895);
var inst_37873 = inst_37896;
var inst_37874 = inst_37895;
var inst_37875 = inst_37897;
var inst_37876 = (0);
var state_37932__$1 = (function (){var statearr_37969 = state_37932;
(statearr_37969[(9)] = inst_37874);

(statearr_37969[(19)] = inst_37873);

(statearr_37969[(11)] = inst_37876);

(statearr_37969[(20)] = inst_37875);

return statearr_37969;
})();
var statearr_37970_39935 = state_37932__$1;
(statearr_37970_39935[(2)] = null);

(statearr_37970_39935[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37933 === (41))){
var inst_37891 = (state_37932[(23)]);
var inst_37906 = (state_37932[(2)]);
var inst_37907 = cljs.core.next(inst_37891);
var inst_37873 = inst_37907;
var inst_37874 = null;
var inst_37875 = (0);
var inst_37876 = (0);
var state_37932__$1 = (function (){var statearr_37971 = state_37932;
(statearr_37971[(9)] = inst_37874);

(statearr_37971[(19)] = inst_37873);

(statearr_37971[(25)] = inst_37906);

(statearr_37971[(11)] = inst_37876);

(statearr_37971[(20)] = inst_37875);

return statearr_37971;
})();
var statearr_37972_39936 = state_37932__$1;
(statearr_37972_39936[(2)] = null);

(statearr_37972_39936[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37933 === (43))){
var state_37932__$1 = state_37932;
var statearr_37974_39937 = state_37932__$1;
(statearr_37974_39937[(2)] = null);

(statearr_37974_39937[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37933 === (29))){
var inst_37915 = (state_37932[(2)]);
var state_37932__$1 = state_37932;
var statearr_37975_39942 = state_37932__$1;
(statearr_37975_39942[(2)] = inst_37915);

(statearr_37975_39942[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37933 === (44))){
var inst_37924 = (state_37932[(2)]);
var state_37932__$1 = (function (){var statearr_37976 = state_37932;
(statearr_37976[(26)] = inst_37924);

return statearr_37976;
})();
var statearr_37977_39947 = state_37932__$1;
(statearr_37977_39947[(2)] = null);

(statearr_37977_39947[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37933 === (6))){
var inst_37865 = (state_37932[(27)]);
var inst_37864 = cljs.core.deref(cs);
var inst_37865__$1 = cljs.core.keys(inst_37864);
var inst_37866 = cljs.core.count(inst_37865__$1);
var inst_37867 = cljs.core.reset_BANG_(dctr,inst_37866);
var inst_37872 = cljs.core.seq(inst_37865__$1);
var inst_37873 = inst_37872;
var inst_37874 = null;
var inst_37875 = (0);
var inst_37876 = (0);
var state_37932__$1 = (function (){var statearr_37978 = state_37932;
(statearr_37978[(27)] = inst_37865__$1);

(statearr_37978[(9)] = inst_37874);

(statearr_37978[(19)] = inst_37873);

(statearr_37978[(28)] = inst_37867);

(statearr_37978[(11)] = inst_37876);

(statearr_37978[(20)] = inst_37875);

return statearr_37978;
})();
var statearr_37980_39948 = state_37932__$1;
(statearr_37980_39948[(2)] = null);

(statearr_37980_39948[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37933 === (28))){
var inst_37891 = (state_37932[(23)]);
var inst_37873 = (state_37932[(19)]);
var inst_37891__$1 = cljs.core.seq(inst_37873);
var state_37932__$1 = (function (){var statearr_37981 = state_37932;
(statearr_37981[(23)] = inst_37891__$1);

return statearr_37981;
})();
if(inst_37891__$1){
var statearr_37982_39949 = state_37932__$1;
(statearr_37982_39949[(1)] = (33));

} else {
var statearr_37983_39950 = state_37932__$1;
(statearr_37983_39950[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37933 === (25))){
var inst_37876 = (state_37932[(11)]);
var inst_37875 = (state_37932[(20)]);
var inst_37878 = (inst_37876 < inst_37875);
var inst_37879 = inst_37878;
var state_37932__$1 = state_37932;
if(cljs.core.truth_(inst_37879)){
var statearr_37984_39951 = state_37932__$1;
(statearr_37984_39951[(1)] = (27));

} else {
var statearr_37985_39952 = state_37932__$1;
(statearr_37985_39952[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37933 === (34))){
var state_37932__$1 = state_37932;
var statearr_37986_39955 = state_37932__$1;
(statearr_37986_39955[(2)] = null);

(statearr_37986_39955[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37933 === (17))){
var state_37932__$1 = state_37932;
var statearr_37987_39956 = state_37932__$1;
(statearr_37987_39956[(2)] = null);

(statearr_37987_39956[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37933 === (3))){
var inst_37929 = (state_37932[(2)]);
var state_37932__$1 = state_37932;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37932__$1,inst_37929);
} else {
if((state_val_37933 === (12))){
var inst_37859 = (state_37932[(2)]);
var state_37932__$1 = state_37932;
var statearr_37989_39957 = state_37932__$1;
(statearr_37989_39957[(2)] = inst_37859);

(statearr_37989_39957[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37933 === (2))){
var state_37932__$1 = state_37932;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37932__$1,(4),ch);
} else {
if((state_val_37933 === (23))){
var state_37932__$1 = state_37932;
var statearr_37990_39958 = state_37932__$1;
(statearr_37990_39958[(2)] = null);

(statearr_37990_39958[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37933 === (35))){
var inst_37913 = (state_37932[(2)]);
var state_37932__$1 = state_37932;
var statearr_37991_39960 = state_37932__$1;
(statearr_37991_39960[(2)] = inst_37913);

(statearr_37991_39960[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37933 === (19))){
var inst_37831 = (state_37932[(7)]);
var inst_37835 = cljs.core.chunk_first(inst_37831);
var inst_37836 = cljs.core.chunk_rest(inst_37831);
var inst_37837 = cljs.core.count(inst_37835);
var inst_37808 = inst_37836;
var inst_37809 = inst_37835;
var inst_37810 = inst_37837;
var inst_37811 = (0);
var state_37932__$1 = (function (){var statearr_37992 = state_37932;
(statearr_37992[(13)] = inst_37809);

(statearr_37992[(14)] = inst_37810);

(statearr_37992[(15)] = inst_37811);

(statearr_37992[(17)] = inst_37808);

return statearr_37992;
})();
var statearr_37993_39962 = state_37932__$1;
(statearr_37993_39962[(2)] = null);

(statearr_37993_39962[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37933 === (11))){
var inst_37808 = (state_37932[(17)]);
var inst_37831 = (state_37932[(7)]);
var inst_37831__$1 = cljs.core.seq(inst_37808);
var state_37932__$1 = (function (){var statearr_37995 = state_37932;
(statearr_37995[(7)] = inst_37831__$1);

return statearr_37995;
})();
if(inst_37831__$1){
var statearr_37996_39963 = state_37932__$1;
(statearr_37996_39963[(1)] = (16));

} else {
var statearr_37997_39964 = state_37932__$1;
(statearr_37997_39964[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37933 === (9))){
var inst_37861 = (state_37932[(2)]);
var state_37932__$1 = state_37932;
var statearr_37998_39965 = state_37932__$1;
(statearr_37998_39965[(2)] = inst_37861);

(statearr_37998_39965[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37933 === (5))){
var inst_37806 = cljs.core.deref(cs);
var inst_37807 = cljs.core.seq(inst_37806);
var inst_37808 = inst_37807;
var inst_37809 = null;
var inst_37810 = (0);
var inst_37811 = (0);
var state_37932__$1 = (function (){var statearr_37999 = state_37932;
(statearr_37999[(13)] = inst_37809);

(statearr_37999[(14)] = inst_37810);

(statearr_37999[(15)] = inst_37811);

(statearr_37999[(17)] = inst_37808);

return statearr_37999;
})();
var statearr_38000_39967 = state_37932__$1;
(statearr_38000_39967[(2)] = null);

(statearr_38000_39967[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37933 === (14))){
var state_37932__$1 = state_37932;
var statearr_38001_39968 = state_37932__$1;
(statearr_38001_39968[(2)] = null);

(statearr_38001_39968[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37933 === (45))){
var inst_37921 = (state_37932[(2)]);
var state_37932__$1 = state_37932;
var statearr_38003_39970 = state_37932__$1;
(statearr_38003_39970[(2)] = inst_37921);

(statearr_38003_39970[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37933 === (26))){
var inst_37865 = (state_37932[(27)]);
var inst_37917 = (state_37932[(2)]);
var inst_37918 = cljs.core.seq(inst_37865);
var state_37932__$1 = (function (){var statearr_38004 = state_37932;
(statearr_38004[(29)] = inst_37917);

return statearr_38004;
})();
if(inst_37918){
var statearr_38005_39975 = state_37932__$1;
(statearr_38005_39975[(1)] = (42));

} else {
var statearr_38006_39976 = state_37932__$1;
(statearr_38006_39976[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37933 === (16))){
var inst_37831 = (state_37932[(7)]);
var inst_37833 = cljs.core.chunked_seq_QMARK_(inst_37831);
var state_37932__$1 = state_37932;
if(inst_37833){
var statearr_38007_39977 = state_37932__$1;
(statearr_38007_39977[(1)] = (19));

} else {
var statearr_38008_39978 = state_37932__$1;
(statearr_38008_39978[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37933 === (38))){
var inst_37910 = (state_37932[(2)]);
var state_37932__$1 = state_37932;
var statearr_38009_39979 = state_37932__$1;
(statearr_38009_39979[(2)] = inst_37910);

(statearr_38009_39979[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37933 === (30))){
var state_37932__$1 = state_37932;
var statearr_38010_39980 = state_37932__$1;
(statearr_38010_39980[(2)] = null);

(statearr_38010_39980[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37933 === (10))){
var inst_37809 = (state_37932[(13)]);
var inst_37811 = (state_37932[(15)]);
var inst_37820 = cljs.core._nth(inst_37809,inst_37811);
var inst_37821 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37820,(0),null);
var inst_37822 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37820,(1),null);
var state_37932__$1 = (function (){var statearr_38012 = state_37932;
(statearr_38012[(24)] = inst_37821);

return statearr_38012;
})();
if(cljs.core.truth_(inst_37822)){
var statearr_38013_39981 = state_37932__$1;
(statearr_38013_39981[(1)] = (13));

} else {
var statearr_38014_39985 = state_37932__$1;
(statearr_38014_39985[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37933 === (18))){
var inst_37857 = (state_37932[(2)]);
var state_37932__$1 = state_37932;
var statearr_38015_39986 = state_37932__$1;
(statearr_38015_39986[(2)] = inst_37857);

(statearr_38015_39986[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37933 === (42))){
var state_37932__$1 = state_37932;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37932__$1,(45),dchan);
} else {
if((state_val_37933 === (37))){
var inst_37900 = (state_37932[(22)]);
var inst_37891 = (state_37932[(23)]);
var inst_37799 = (state_37932[(12)]);
var inst_37900__$1 = cljs.core.first(inst_37891);
var inst_37901 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_37900__$1,inst_37799,done);
var state_37932__$1 = (function (){var statearr_38016 = state_37932;
(statearr_38016[(22)] = inst_37900__$1);

return statearr_38016;
})();
if(cljs.core.truth_(inst_37901)){
var statearr_38017_39987 = state_37932__$1;
(statearr_38017_39987[(1)] = (39));

} else {
var statearr_38018_39988 = state_37932__$1;
(statearr_38018_39988[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37933 === (8))){
var inst_37810 = (state_37932[(14)]);
var inst_37811 = (state_37932[(15)]);
var inst_37813 = (inst_37811 < inst_37810);
var inst_37814 = inst_37813;
var state_37932__$1 = state_37932;
if(cljs.core.truth_(inst_37814)){
var statearr_38020_39989 = state_37932__$1;
(statearr_38020_39989[(1)] = (10));

} else {
var statearr_38021_39990 = state_37932__$1;
(statearr_38021_39990[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__36880__auto__ = null;
var cljs$core$async$mult_$_state_machine__36880__auto____0 = (function (){
var statearr_38022 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38022[(0)] = cljs$core$async$mult_$_state_machine__36880__auto__);

(statearr_38022[(1)] = (1));

return statearr_38022;
});
var cljs$core$async$mult_$_state_machine__36880__auto____1 = (function (state_37932){
while(true){
var ret_value__36881__auto__ = (function (){try{while(true){
var result__36882__auto__ = switch__36879__auto__(state_37932);
if(cljs.core.keyword_identical_QMARK_(result__36882__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36882__auto__;
}
break;
}
}catch (e38023){if((e38023 instanceof Object)){
var ex__36883__auto__ = e38023;
var statearr_38024_39992 = state_37932;
(statearr_38024_39992[(5)] = ex__36883__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_37932);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e38023;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__36881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39997 = state_37932;
state_37932 = G__39997;
continue;
} else {
return ret_value__36881__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__36880__auto__ = function(state_37932){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__36880__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__36880__auto____1.call(this,state_37932);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__36880__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__36880__auto____0;
cljs$core$async$mult_$_state_machine__36880__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__36880__auto____1;
return cljs$core$async$mult_$_state_machine__36880__auto__;
})()
})();
var state__37100__auto__ = (function (){var statearr_38026 = f__37099__auto__();
(statearr_38026[(6)] = c__37098__auto___39860);

return statearr_38026;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37100__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__38028 = arguments.length;
switch (G__38028) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__4487__auto__ = (((m == null))?null:m);
var m__4488__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return (m__4488__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4488__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4488__auto__.call(null,m,ch));
} else {
var m__4485__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return (m__4485__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4485__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4485__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__4487__auto__ = (((m == null))?null:m);
var m__4488__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return (m__4488__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4488__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4488__auto__.call(null,m,ch));
} else {
var m__4485__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return (m__4485__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4485__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4485__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__4487__auto__ = (((m == null))?null:m);
var m__4488__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return (m__4488__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4488__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4488__auto__.call(null,m));
} else {
var m__4485__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return (m__4485__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4485__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4485__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__4487__auto__ = (((m == null))?null:m);
var m__4488__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return (m__4488__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4488__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4488__auto__.call(null,m,state_map));
} else {
var m__4485__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return (m__4485__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4485__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4485__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__4487__auto__ = (((m == null))?null:m);
var m__4488__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return (m__4488__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4488__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4488__auto__.call(null,m,mode));
} else {
var m__4485__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return (m__4485__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4485__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4485__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4795__auto__ = [];
var len__4789__auto___40024 = arguments.length;
var i__4790__auto___40025 = (0);
while(true){
if((i__4790__auto___40025 < len__4789__auto___40024)){
args__4795__auto__.push((arguments[i__4790__auto___40025]));

var G__40030 = (i__4790__auto___40025 + (1));
i__4790__auto___40025 = G__40030;
continue;
} else {
}
break;
}

var argseq__4796__auto__ = ((((3) < args__4795__auto__.length))?(new cljs.core.IndexedSeq(args__4795__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4796__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__38039){
var map__38040 = p__38039;
var map__38040__$1 = (((((!((map__38040 == null))))?(((((map__38040.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38040.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38040):map__38040);
var opts = map__38040__$1;
var statearr_38042_40031 = state;
(statearr_38042_40031[(1)] = cont_block);


var temp__5735__auto__ = cljs.core.async.do_alts((function (val){
var statearr_38043_40032 = state;
(statearr_38043_40032[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5735__auto__)){
var cb = temp__5735__auto__;
var statearr_38044_40033 = state;
(statearr_38044_40033[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq38033){
var G__38034 = cljs.core.first(seq38033);
var seq38033__$1 = cljs.core.next(seq38033);
var G__38035 = cljs.core.first(seq38033__$1);
var seq38033__$2 = cljs.core.next(seq38033__$1);
var G__38036 = cljs.core.first(seq38033__$2);
var seq38033__$3 = cljs.core.next(seq38033__$2);
var self__4776__auto__ = this;
return self__4776__auto__.cljs$core$IFn$_invoke$arity$variadic(G__38034,G__38035,G__38036,seq38033__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async38054 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async38054 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta38055){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta38055 = meta38055;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async38054.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_38056,meta38055__$1){
var self__ = this;
var _38056__$1 = this;
return (new cljs.core.async.t_cljs$core$async38054(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta38055__$1));
}));

(cljs.core.async.t_cljs$core$async38054.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_38056){
var self__ = this;
var _38056__$1 = this;
return self__.meta38055;
}));

(cljs.core.async.t_cljs$core$async38054.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async38054.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async38054.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async38054.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async38054.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async38054.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async38054.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async38054.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async38054.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta38055","meta38055",-1244440082,null)], null);
}));

(cljs.core.async.t_cljs$core$async38054.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async38054.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async38054");

(cljs.core.async.t_cljs$core$async38054.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write(writer__4429__auto__,"cljs.core.async/t_cljs$core$async38054");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async38054.
 */
cljs.core.async.__GT_t_cljs$core$async38054 = (function cljs$core$async$mix_$___GT_t_cljs$core$async38054(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta38055){
return (new cljs.core.async.t_cljs$core$async38054(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta38055));
});

}

return (new cljs.core.async.t_cljs$core$async38054(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__37098__auto___40044 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__37099__auto__ = (function (){var switch__36879__auto__ = (function (state_38179){
var state_val_38180 = (state_38179[(1)]);
if((state_val_38180 === (7))){
var inst_38085 = (state_38179[(2)]);
var state_38179__$1 = state_38179;
var statearr_38185_40045 = state_38179__$1;
(statearr_38185_40045[(2)] = inst_38085);

(statearr_38185_40045[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38180 === (20))){
var inst_38098 = (state_38179[(7)]);
var state_38179__$1 = state_38179;
var statearr_38186_40046 = state_38179__$1;
(statearr_38186_40046[(2)] = inst_38098);

(statearr_38186_40046[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38180 === (27))){
var state_38179__$1 = state_38179;
var statearr_38190_40047 = state_38179__$1;
(statearr_38190_40047[(2)] = null);

(statearr_38190_40047[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38180 === (1))){
var inst_38072 = (state_38179[(8)]);
var inst_38072__$1 = calc_state();
var inst_38074 = (inst_38072__$1 == null);
var inst_38075 = cljs.core.not(inst_38074);
var state_38179__$1 = (function (){var statearr_38191 = state_38179;
(statearr_38191[(8)] = inst_38072__$1);

return statearr_38191;
})();
if(inst_38075){
var statearr_38192_40056 = state_38179__$1;
(statearr_38192_40056[(1)] = (2));

} else {
var statearr_38194_40057 = state_38179__$1;
(statearr_38194_40057[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38180 === (24))){
var inst_38125 = (state_38179[(9)]);
var inst_38134 = (state_38179[(10)]);
var inst_38152 = (state_38179[(11)]);
var inst_38152__$1 = (inst_38125.cljs$core$IFn$_invoke$arity$1 ? inst_38125.cljs$core$IFn$_invoke$arity$1(inst_38134) : inst_38125.call(null,inst_38134));
var state_38179__$1 = (function (){var statearr_38195 = state_38179;
(statearr_38195[(11)] = inst_38152__$1);

return statearr_38195;
})();
if(cljs.core.truth_(inst_38152__$1)){
var statearr_38198_40059 = state_38179__$1;
(statearr_38198_40059[(1)] = (29));

} else {
var statearr_38200_40063 = state_38179__$1;
(statearr_38200_40063[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38180 === (4))){
var inst_38088 = (state_38179[(2)]);
var state_38179__$1 = state_38179;
if(cljs.core.truth_(inst_38088)){
var statearr_38202_40064 = state_38179__$1;
(statearr_38202_40064[(1)] = (8));

} else {
var statearr_38203_40065 = state_38179__$1;
(statearr_38203_40065[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38180 === (15))){
var inst_38119 = (state_38179[(2)]);
var state_38179__$1 = state_38179;
if(cljs.core.truth_(inst_38119)){
var statearr_38205_40066 = state_38179__$1;
(statearr_38205_40066[(1)] = (19));

} else {
var statearr_38206_40067 = state_38179__$1;
(statearr_38206_40067[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38180 === (21))){
var inst_38124 = (state_38179[(12)]);
var inst_38124__$1 = (state_38179[(2)]);
var inst_38125 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38124__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_38126 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38124__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_38127 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38124__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_38179__$1 = (function (){var statearr_38210 = state_38179;
(statearr_38210[(9)] = inst_38125);

(statearr_38210[(13)] = inst_38126);

(statearr_38210[(12)] = inst_38124__$1);

return statearr_38210;
})();
return cljs.core.async.ioc_alts_BANG_(state_38179__$1,(22),inst_38127);
} else {
if((state_val_38180 === (31))){
var inst_38160 = (state_38179[(2)]);
var state_38179__$1 = state_38179;
if(cljs.core.truth_(inst_38160)){
var statearr_38211_40069 = state_38179__$1;
(statearr_38211_40069[(1)] = (32));

} else {
var statearr_38213_40070 = state_38179__$1;
(statearr_38213_40070[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38180 === (32))){
var inst_38133 = (state_38179[(14)]);
var state_38179__$1 = state_38179;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38179__$1,(35),out,inst_38133);
} else {
if((state_val_38180 === (33))){
var inst_38124 = (state_38179[(12)]);
var inst_38098 = inst_38124;
var state_38179__$1 = (function (){var statearr_38215 = state_38179;
(statearr_38215[(7)] = inst_38098);

return statearr_38215;
})();
var statearr_38218_40072 = state_38179__$1;
(statearr_38218_40072[(2)] = null);

(statearr_38218_40072[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38180 === (13))){
var inst_38098 = (state_38179[(7)]);
var inst_38107 = inst_38098.cljs$lang$protocol_mask$partition0$;
var inst_38108 = (inst_38107 & (64));
var inst_38109 = inst_38098.cljs$core$ISeq$;
var inst_38110 = (cljs.core.PROTOCOL_SENTINEL === inst_38109);
var inst_38112 = ((inst_38108) || (inst_38110));
var state_38179__$1 = state_38179;
if(cljs.core.truth_(inst_38112)){
var statearr_38221_40076 = state_38179__$1;
(statearr_38221_40076[(1)] = (16));

} else {
var statearr_38222_40077 = state_38179__$1;
(statearr_38222_40077[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38180 === (22))){
var inst_38134 = (state_38179[(10)]);
var inst_38133 = (state_38179[(14)]);
var inst_38132 = (state_38179[(2)]);
var inst_38133__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38132,(0),null);
var inst_38134__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38132,(1),null);
var inst_38136 = (inst_38133__$1 == null);
var inst_38137 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_38134__$1,change);
var inst_38138 = ((inst_38136) || (inst_38137));
var state_38179__$1 = (function (){var statearr_38224 = state_38179;
(statearr_38224[(10)] = inst_38134__$1);

(statearr_38224[(14)] = inst_38133__$1);

return statearr_38224;
})();
if(cljs.core.truth_(inst_38138)){
var statearr_38227_40078 = state_38179__$1;
(statearr_38227_40078[(1)] = (23));

} else {
var statearr_38229_40079 = state_38179__$1;
(statearr_38229_40079[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38180 === (36))){
var inst_38124 = (state_38179[(12)]);
var inst_38098 = inst_38124;
var state_38179__$1 = (function (){var statearr_38230 = state_38179;
(statearr_38230[(7)] = inst_38098);

return statearr_38230;
})();
var statearr_38231_40081 = state_38179__$1;
(statearr_38231_40081[(2)] = null);

(statearr_38231_40081[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38180 === (29))){
var inst_38152 = (state_38179[(11)]);
var state_38179__$1 = state_38179;
var statearr_38233_40082 = state_38179__$1;
(statearr_38233_40082[(2)] = inst_38152);

(statearr_38233_40082[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38180 === (6))){
var state_38179__$1 = state_38179;
var statearr_38236_40083 = state_38179__$1;
(statearr_38236_40083[(2)] = false);

(statearr_38236_40083[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38180 === (28))){
var inst_38145 = (state_38179[(2)]);
var inst_38146 = calc_state();
var inst_38098 = inst_38146;
var state_38179__$1 = (function (){var statearr_38238 = state_38179;
(statearr_38238[(15)] = inst_38145);

(statearr_38238[(7)] = inst_38098);

return statearr_38238;
})();
var statearr_38239_40084 = state_38179__$1;
(statearr_38239_40084[(2)] = null);

(statearr_38239_40084[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38180 === (25))){
var inst_38174 = (state_38179[(2)]);
var state_38179__$1 = state_38179;
var statearr_38242_40086 = state_38179__$1;
(statearr_38242_40086[(2)] = inst_38174);

(statearr_38242_40086[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38180 === (34))){
var inst_38172 = (state_38179[(2)]);
var state_38179__$1 = state_38179;
var statearr_38246_40088 = state_38179__$1;
(statearr_38246_40088[(2)] = inst_38172);

(statearr_38246_40088[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38180 === (17))){
var state_38179__$1 = state_38179;
var statearr_38247_40089 = state_38179__$1;
(statearr_38247_40089[(2)] = false);

(statearr_38247_40089[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38180 === (3))){
var state_38179__$1 = state_38179;
var statearr_38252_40091 = state_38179__$1;
(statearr_38252_40091[(2)] = false);

(statearr_38252_40091[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38180 === (12))){
var inst_38176 = (state_38179[(2)]);
var state_38179__$1 = state_38179;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38179__$1,inst_38176);
} else {
if((state_val_38180 === (2))){
var inst_38072 = (state_38179[(8)]);
var inst_38077 = inst_38072.cljs$lang$protocol_mask$partition0$;
var inst_38078 = (inst_38077 & (64));
var inst_38079 = inst_38072.cljs$core$ISeq$;
var inst_38080 = (cljs.core.PROTOCOL_SENTINEL === inst_38079);
var inst_38081 = ((inst_38078) || (inst_38080));
var state_38179__$1 = state_38179;
if(cljs.core.truth_(inst_38081)){
var statearr_38253_40092 = state_38179__$1;
(statearr_38253_40092[(1)] = (5));

} else {
var statearr_38254_40096 = state_38179__$1;
(statearr_38254_40096[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38180 === (23))){
var inst_38133 = (state_38179[(14)]);
var inst_38140 = (inst_38133 == null);
var state_38179__$1 = state_38179;
if(cljs.core.truth_(inst_38140)){
var statearr_38260_40100 = state_38179__$1;
(statearr_38260_40100[(1)] = (26));

} else {
var statearr_38261_40101 = state_38179__$1;
(statearr_38261_40101[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38180 === (35))){
var inst_38163 = (state_38179[(2)]);
var state_38179__$1 = state_38179;
if(cljs.core.truth_(inst_38163)){
var statearr_38263_40103 = state_38179__$1;
(statearr_38263_40103[(1)] = (36));

} else {
var statearr_38264_40104 = state_38179__$1;
(statearr_38264_40104[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38180 === (19))){
var inst_38098 = (state_38179[(7)]);
var inst_38121 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_38098);
var state_38179__$1 = state_38179;
var statearr_38267_40105 = state_38179__$1;
(statearr_38267_40105[(2)] = inst_38121);

(statearr_38267_40105[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38180 === (11))){
var inst_38098 = (state_38179[(7)]);
var inst_38102 = (inst_38098 == null);
var inst_38103 = cljs.core.not(inst_38102);
var state_38179__$1 = state_38179;
if(inst_38103){
var statearr_38269_40107 = state_38179__$1;
(statearr_38269_40107[(1)] = (13));

} else {
var statearr_38270_40108 = state_38179__$1;
(statearr_38270_40108[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38180 === (9))){
var inst_38072 = (state_38179[(8)]);
var state_38179__$1 = state_38179;
var statearr_38272_40109 = state_38179__$1;
(statearr_38272_40109[(2)] = inst_38072);

(statearr_38272_40109[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38180 === (5))){
var state_38179__$1 = state_38179;
var statearr_38273_40110 = state_38179__$1;
(statearr_38273_40110[(2)] = true);

(statearr_38273_40110[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38180 === (14))){
var state_38179__$1 = state_38179;
var statearr_38276_40111 = state_38179__$1;
(statearr_38276_40111[(2)] = false);

(statearr_38276_40111[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38180 === (26))){
var inst_38134 = (state_38179[(10)]);
var inst_38142 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_38134);
var state_38179__$1 = state_38179;
var statearr_38278_40113 = state_38179__$1;
(statearr_38278_40113[(2)] = inst_38142);

(statearr_38278_40113[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38180 === (16))){
var state_38179__$1 = state_38179;
var statearr_38279_40115 = state_38179__$1;
(statearr_38279_40115[(2)] = true);

(statearr_38279_40115[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38180 === (38))){
var inst_38168 = (state_38179[(2)]);
var state_38179__$1 = state_38179;
var statearr_38281_40117 = state_38179__$1;
(statearr_38281_40117[(2)] = inst_38168);

(statearr_38281_40117[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38180 === (30))){
var inst_38125 = (state_38179[(9)]);
var inst_38134 = (state_38179[(10)]);
var inst_38126 = (state_38179[(13)]);
var inst_38155 = cljs.core.empty_QMARK_(inst_38125);
var inst_38156 = (inst_38126.cljs$core$IFn$_invoke$arity$1 ? inst_38126.cljs$core$IFn$_invoke$arity$1(inst_38134) : inst_38126.call(null,inst_38134));
var inst_38157 = cljs.core.not(inst_38156);
var inst_38158 = ((inst_38155) && (inst_38157));
var state_38179__$1 = state_38179;
var statearr_38285_40118 = state_38179__$1;
(statearr_38285_40118[(2)] = inst_38158);

(statearr_38285_40118[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38180 === (10))){
var inst_38072 = (state_38179[(8)]);
var inst_38094 = (state_38179[(2)]);
var inst_38095 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38094,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_38096 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38094,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_38097 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38094,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_38098 = inst_38072;
var state_38179__$1 = (function (){var statearr_38287 = state_38179;
(statearr_38287[(16)] = inst_38096);

(statearr_38287[(7)] = inst_38098);

(statearr_38287[(17)] = inst_38097);

(statearr_38287[(18)] = inst_38095);

return statearr_38287;
})();
var statearr_38288_40119 = state_38179__$1;
(statearr_38288_40119[(2)] = null);

(statearr_38288_40119[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38180 === (18))){
var inst_38116 = (state_38179[(2)]);
var state_38179__$1 = state_38179;
var statearr_38292_40120 = state_38179__$1;
(statearr_38292_40120[(2)] = inst_38116);

(statearr_38292_40120[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38180 === (37))){
var state_38179__$1 = state_38179;
var statearr_38293_40125 = state_38179__$1;
(statearr_38293_40125[(2)] = null);

(statearr_38293_40125[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38180 === (8))){
var inst_38072 = (state_38179[(8)]);
var inst_38091 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_38072);
var state_38179__$1 = state_38179;
var statearr_38294_40127 = state_38179__$1;
(statearr_38294_40127[(2)] = inst_38091);

(statearr_38294_40127[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__36880__auto__ = null;
var cljs$core$async$mix_$_state_machine__36880__auto____0 = (function (){
var statearr_38299 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38299[(0)] = cljs$core$async$mix_$_state_machine__36880__auto__);

(statearr_38299[(1)] = (1));

return statearr_38299;
});
var cljs$core$async$mix_$_state_machine__36880__auto____1 = (function (state_38179){
while(true){
var ret_value__36881__auto__ = (function (){try{while(true){
var result__36882__auto__ = switch__36879__auto__(state_38179);
if(cljs.core.keyword_identical_QMARK_(result__36882__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36882__auto__;
}
break;
}
}catch (e38301){if((e38301 instanceof Object)){
var ex__36883__auto__ = e38301;
var statearr_38305_40129 = state_38179;
(statearr_38305_40129[(5)] = ex__36883__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38179);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e38301;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__36881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40131 = state_38179;
state_38179 = G__40131;
continue;
} else {
return ret_value__36881__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__36880__auto__ = function(state_38179){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__36880__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__36880__auto____1.call(this,state_38179);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__36880__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__36880__auto____0;
cljs$core$async$mix_$_state_machine__36880__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__36880__auto____1;
return cljs$core$async$mix_$_state_machine__36880__auto__;
})()
})();
var state__37100__auto__ = (function (){var statearr_38309 = f__37099__auto__();
(statearr_38309[(6)] = c__37098__auto___40044);

return statearr_38309;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37100__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__4487__auto__ = (((p == null))?null:p);
var m__4488__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return (m__4488__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4488__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4488__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4485__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return (m__4485__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4485__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4485__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__4487__auto__ = (((p == null))?null:p);
var m__4488__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return (m__4488__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4488__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4488__auto__.call(null,p,v,ch));
} else {
var m__4485__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return (m__4485__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4485__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4485__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__38331 = arguments.length;
switch (G__38331) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__4487__auto__ = (((p == null))?null:p);
var m__4488__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return (m__4488__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4488__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4488__auto__.call(null,p));
} else {
var m__4485__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return (m__4485__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4485__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4485__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__4487__auto__ = (((p == null))?null:p);
var m__4488__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4487__auto__)]);
if((!((m__4488__auto__ == null)))){
return (m__4488__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4488__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4488__auto__.call(null,p,v));
} else {
var m__4485__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4485__auto__ == null)))){
return (m__4485__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4485__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4485__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__38346 = arguments.length;
switch (G__38346) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4185__auto__)){
return or__4185__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__38342_SHARP_){
if(cljs.core.truth_((p1__38342_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__38342_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__38342_SHARP_.call(null,topic)))){
return p1__38342_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__38342_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async38362 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async38362 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta38363){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta38363 = meta38363;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async38362.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_38364,meta38363__$1){
var self__ = this;
var _38364__$1 = this;
return (new cljs.core.async.t_cljs$core$async38362(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta38363__$1));
}));

(cljs.core.async.t_cljs$core$async38362.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_38364){
var self__ = this;
var _38364__$1 = this;
return self__.meta38363;
}));

(cljs.core.async.t_cljs$core$async38362.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async38362.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async38362.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async38362.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async38362.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5735__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5735__auto__)){
var m = temp__5735__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async38362.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async38362.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async38362.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta38363","meta38363",1086031182,null)], null);
}));

(cljs.core.async.t_cljs$core$async38362.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async38362.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async38362");

(cljs.core.async.t_cljs$core$async38362.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write(writer__4429__auto__,"cljs.core.async/t_cljs$core$async38362");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async38362.
 */
cljs.core.async.__GT_t_cljs$core$async38362 = (function cljs$core$async$__GT_t_cljs$core$async38362(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta38363){
return (new cljs.core.async.t_cljs$core$async38362(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta38363));
});

}

return (new cljs.core.async.t_cljs$core$async38362(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__37098__auto___40151 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__37099__auto__ = (function (){var switch__36879__auto__ = (function (state_38489){
var state_val_38490 = (state_38489[(1)]);
if((state_val_38490 === (7))){
var inst_38480 = (state_38489[(2)]);
var state_38489__$1 = state_38489;
var statearr_38493_40152 = state_38489__$1;
(statearr_38493_40152[(2)] = inst_38480);

(statearr_38493_40152[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38490 === (20))){
var state_38489__$1 = state_38489;
var statearr_38494_40153 = state_38489__$1;
(statearr_38494_40153[(2)] = null);

(statearr_38494_40153[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38490 === (1))){
var state_38489__$1 = state_38489;
var statearr_38501_40154 = state_38489__$1;
(statearr_38501_40154[(2)] = null);

(statearr_38501_40154[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38490 === (24))){
var inst_38458 = (state_38489[(7)]);
var inst_38467 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_38458);
var state_38489__$1 = state_38489;
var statearr_38503_40155 = state_38489__$1;
(statearr_38503_40155[(2)] = inst_38467);

(statearr_38503_40155[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38490 === (4))){
var inst_38406 = (state_38489[(8)]);
var inst_38406__$1 = (state_38489[(2)]);
var inst_38407 = (inst_38406__$1 == null);
var state_38489__$1 = (function (){var statearr_38508 = state_38489;
(statearr_38508[(8)] = inst_38406__$1);

return statearr_38508;
})();
if(cljs.core.truth_(inst_38407)){
var statearr_38510_40157 = state_38489__$1;
(statearr_38510_40157[(1)] = (5));

} else {
var statearr_38511_40158 = state_38489__$1;
(statearr_38511_40158[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38490 === (15))){
var inst_38452 = (state_38489[(2)]);
var state_38489__$1 = state_38489;
var statearr_38515_40159 = state_38489__$1;
(statearr_38515_40159[(2)] = inst_38452);

(statearr_38515_40159[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38490 === (21))){
var inst_38476 = (state_38489[(2)]);
var state_38489__$1 = (function (){var statearr_38519 = state_38489;
(statearr_38519[(9)] = inst_38476);

return statearr_38519;
})();
var statearr_38521_40160 = state_38489__$1;
(statearr_38521_40160[(2)] = null);

(statearr_38521_40160[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38490 === (13))){
var inst_38433 = (state_38489[(10)]);
var inst_38435 = cljs.core.chunked_seq_QMARK_(inst_38433);
var state_38489__$1 = state_38489;
if(inst_38435){
var statearr_38523_40161 = state_38489__$1;
(statearr_38523_40161[(1)] = (16));

} else {
var statearr_38524_40162 = state_38489__$1;
(statearr_38524_40162[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38490 === (22))){
var inst_38464 = (state_38489[(2)]);
var state_38489__$1 = state_38489;
if(cljs.core.truth_(inst_38464)){
var statearr_38527_40163 = state_38489__$1;
(statearr_38527_40163[(1)] = (23));

} else {
var statearr_38529_40164 = state_38489__$1;
(statearr_38529_40164[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38490 === (6))){
var inst_38406 = (state_38489[(8)]);
var inst_38458 = (state_38489[(7)]);
var inst_38460 = (state_38489[(11)]);
var inst_38458__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_38406) : topic_fn.call(null,inst_38406));
var inst_38459 = cljs.core.deref(mults);
var inst_38460__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38459,inst_38458__$1);
var state_38489__$1 = (function (){var statearr_38532 = state_38489;
(statearr_38532[(7)] = inst_38458__$1);

(statearr_38532[(11)] = inst_38460__$1);

return statearr_38532;
})();
if(cljs.core.truth_(inst_38460__$1)){
var statearr_38534_40169 = state_38489__$1;
(statearr_38534_40169[(1)] = (19));

} else {
var statearr_38535_40170 = state_38489__$1;
(statearr_38535_40170[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38490 === (25))){
var inst_38470 = (state_38489[(2)]);
var state_38489__$1 = state_38489;
var statearr_38538_40172 = state_38489__$1;
(statearr_38538_40172[(2)] = inst_38470);

(statearr_38538_40172[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38490 === (17))){
var inst_38433 = (state_38489[(10)]);
var inst_38443 = cljs.core.first(inst_38433);
var inst_38444 = cljs.core.async.muxch_STAR_(inst_38443);
var inst_38445 = cljs.core.async.close_BANG_(inst_38444);
var inst_38446 = cljs.core.next(inst_38433);
var inst_38416 = inst_38446;
var inst_38417 = null;
var inst_38418 = (0);
var inst_38419 = (0);
var state_38489__$1 = (function (){var statearr_38544 = state_38489;
(statearr_38544[(12)] = inst_38445);

(statearr_38544[(13)] = inst_38419);

(statearr_38544[(14)] = inst_38417);

(statearr_38544[(15)] = inst_38418);

(statearr_38544[(16)] = inst_38416);

return statearr_38544;
})();
var statearr_38549_40177 = state_38489__$1;
(statearr_38549_40177[(2)] = null);

(statearr_38549_40177[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38490 === (3))){
var inst_38483 = (state_38489[(2)]);
var state_38489__$1 = state_38489;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38489__$1,inst_38483);
} else {
if((state_val_38490 === (12))){
var inst_38454 = (state_38489[(2)]);
var state_38489__$1 = state_38489;
var statearr_38553_40178 = state_38489__$1;
(statearr_38553_40178[(2)] = inst_38454);

(statearr_38553_40178[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38490 === (2))){
var state_38489__$1 = state_38489;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38489__$1,(4),ch);
} else {
if((state_val_38490 === (23))){
var state_38489__$1 = state_38489;
var statearr_38558_40183 = state_38489__$1;
(statearr_38558_40183[(2)] = null);

(statearr_38558_40183[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38490 === (19))){
var inst_38406 = (state_38489[(8)]);
var inst_38460 = (state_38489[(11)]);
var inst_38462 = cljs.core.async.muxch_STAR_(inst_38460);
var state_38489__$1 = state_38489;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38489__$1,(22),inst_38462,inst_38406);
} else {
if((state_val_38490 === (11))){
var inst_38433 = (state_38489[(10)]);
var inst_38416 = (state_38489[(16)]);
var inst_38433__$1 = cljs.core.seq(inst_38416);
var state_38489__$1 = (function (){var statearr_38567 = state_38489;
(statearr_38567[(10)] = inst_38433__$1);

return statearr_38567;
})();
if(inst_38433__$1){
var statearr_38569_40188 = state_38489__$1;
(statearr_38569_40188[(1)] = (13));

} else {
var statearr_38570_40189 = state_38489__$1;
(statearr_38570_40189[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38490 === (9))){
var inst_38456 = (state_38489[(2)]);
var state_38489__$1 = state_38489;
var statearr_38573_40190 = state_38489__$1;
(statearr_38573_40190[(2)] = inst_38456);

(statearr_38573_40190[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38490 === (5))){
var inst_38413 = cljs.core.deref(mults);
var inst_38414 = cljs.core.vals(inst_38413);
var inst_38415 = cljs.core.seq(inst_38414);
var inst_38416 = inst_38415;
var inst_38417 = null;
var inst_38418 = (0);
var inst_38419 = (0);
var state_38489__$1 = (function (){var statearr_38579 = state_38489;
(statearr_38579[(13)] = inst_38419);

(statearr_38579[(14)] = inst_38417);

(statearr_38579[(15)] = inst_38418);

(statearr_38579[(16)] = inst_38416);

return statearr_38579;
})();
var statearr_38580_40200 = state_38489__$1;
(statearr_38580_40200[(2)] = null);

(statearr_38580_40200[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38490 === (14))){
var state_38489__$1 = state_38489;
var statearr_38584_40201 = state_38489__$1;
(statearr_38584_40201[(2)] = null);

(statearr_38584_40201[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38490 === (16))){
var inst_38433 = (state_38489[(10)]);
var inst_38437 = cljs.core.chunk_first(inst_38433);
var inst_38438 = cljs.core.chunk_rest(inst_38433);
var inst_38439 = cljs.core.count(inst_38437);
var inst_38416 = inst_38438;
var inst_38417 = inst_38437;
var inst_38418 = inst_38439;
var inst_38419 = (0);
var state_38489__$1 = (function (){var statearr_38587 = state_38489;
(statearr_38587[(13)] = inst_38419);

(statearr_38587[(14)] = inst_38417);

(statearr_38587[(15)] = inst_38418);

(statearr_38587[(16)] = inst_38416);

return statearr_38587;
})();
var statearr_38588_40213 = state_38489__$1;
(statearr_38588_40213[(2)] = null);

(statearr_38588_40213[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38490 === (10))){
var inst_38419 = (state_38489[(13)]);
var inst_38417 = (state_38489[(14)]);
var inst_38418 = (state_38489[(15)]);
var inst_38416 = (state_38489[(16)]);
var inst_38426 = cljs.core._nth(inst_38417,inst_38419);
var inst_38427 = cljs.core.async.muxch_STAR_(inst_38426);
var inst_38428 = cljs.core.async.close_BANG_(inst_38427);
var inst_38430 = (inst_38419 + (1));
var tmp38581 = inst_38417;
var tmp38582 = inst_38418;
var tmp38583 = inst_38416;
var inst_38416__$1 = tmp38583;
var inst_38417__$1 = tmp38581;
var inst_38418__$1 = tmp38582;
var inst_38419__$1 = inst_38430;
var state_38489__$1 = (function (){var statearr_38589 = state_38489;
(statearr_38589[(13)] = inst_38419__$1);

(statearr_38589[(14)] = inst_38417__$1);

(statearr_38589[(15)] = inst_38418__$1);

(statearr_38589[(17)] = inst_38428);

(statearr_38589[(16)] = inst_38416__$1);

return statearr_38589;
})();
var statearr_38590_40218 = state_38489__$1;
(statearr_38590_40218[(2)] = null);

(statearr_38590_40218[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38490 === (18))){
var inst_38449 = (state_38489[(2)]);
var state_38489__$1 = state_38489;
var statearr_38595_40223 = state_38489__$1;
(statearr_38595_40223[(2)] = inst_38449);

(statearr_38595_40223[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38490 === (8))){
var inst_38419 = (state_38489[(13)]);
var inst_38418 = (state_38489[(15)]);
var inst_38421 = (inst_38419 < inst_38418);
var inst_38422 = inst_38421;
var state_38489__$1 = state_38489;
if(cljs.core.truth_(inst_38422)){
var statearr_38600_40230 = state_38489__$1;
(statearr_38600_40230[(1)] = (10));

} else {
var statearr_38601_40231 = state_38489__$1;
(statearr_38601_40231[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__36880__auto__ = null;
var cljs$core$async$state_machine__36880__auto____0 = (function (){
var statearr_38602 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38602[(0)] = cljs$core$async$state_machine__36880__auto__);

(statearr_38602[(1)] = (1));

return statearr_38602;
});
var cljs$core$async$state_machine__36880__auto____1 = (function (state_38489){
while(true){
var ret_value__36881__auto__ = (function (){try{while(true){
var result__36882__auto__ = switch__36879__auto__(state_38489);
if(cljs.core.keyword_identical_QMARK_(result__36882__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36882__auto__;
}
break;
}
}catch (e38606){if((e38606 instanceof Object)){
var ex__36883__auto__ = e38606;
var statearr_38607_40239 = state_38489;
(statearr_38607_40239[(5)] = ex__36883__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38489);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e38606;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__36881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40243 = state_38489;
state_38489 = G__40243;
continue;
} else {
return ret_value__36881__auto__;
}
break;
}
});
cljs$core$async$state_machine__36880__auto__ = function(state_38489){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__36880__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__36880__auto____1.call(this,state_38489);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__36880__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__36880__auto____0;
cljs$core$async$state_machine__36880__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__36880__auto____1;
return cljs$core$async$state_machine__36880__auto__;
})()
})();
var state__37100__auto__ = (function (){var statearr_38609 = f__37099__auto__();
(statearr_38609[(6)] = c__37098__auto___40151);

return statearr_38609;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37100__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__38615 = arguments.length;
switch (G__38615) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__38621 = arguments.length;
switch (G__38621) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__38628 = arguments.length;
switch (G__38628) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__37098__auto___40265 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__37099__auto__ = (function (){var switch__36879__auto__ = (function (state_38669){
var state_val_38670 = (state_38669[(1)]);
if((state_val_38670 === (7))){
var state_38669__$1 = state_38669;
var statearr_38671_40269 = state_38669__$1;
(statearr_38671_40269[(2)] = null);

(statearr_38671_40269[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38670 === (1))){
var state_38669__$1 = state_38669;
var statearr_38672_40270 = state_38669__$1;
(statearr_38672_40270[(2)] = null);

(statearr_38672_40270[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38670 === (4))){
var inst_38631 = (state_38669[(7)]);
var inst_38634 = (inst_38631 < cnt);
var state_38669__$1 = state_38669;
if(cljs.core.truth_(inst_38634)){
var statearr_38673_40271 = state_38669__$1;
(statearr_38673_40271[(1)] = (6));

} else {
var statearr_38674_40272 = state_38669__$1;
(statearr_38674_40272[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38670 === (15))){
var inst_38665 = (state_38669[(2)]);
var state_38669__$1 = state_38669;
var statearr_38675_40275 = state_38669__$1;
(statearr_38675_40275[(2)] = inst_38665);

(statearr_38675_40275[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38670 === (13))){
var inst_38658 = cljs.core.async.close_BANG_(out);
var state_38669__$1 = state_38669;
var statearr_38676_40280 = state_38669__$1;
(statearr_38676_40280[(2)] = inst_38658);

(statearr_38676_40280[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38670 === (6))){
var state_38669__$1 = state_38669;
var statearr_38677_40282 = state_38669__$1;
(statearr_38677_40282[(2)] = null);

(statearr_38677_40282[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38670 === (3))){
var inst_38667 = (state_38669[(2)]);
var state_38669__$1 = state_38669;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38669__$1,inst_38667);
} else {
if((state_val_38670 === (12))){
var inst_38655 = (state_38669[(8)]);
var inst_38655__$1 = (state_38669[(2)]);
var inst_38656 = cljs.core.some(cljs.core.nil_QMARK_,inst_38655__$1);
var state_38669__$1 = (function (){var statearr_38678 = state_38669;
(statearr_38678[(8)] = inst_38655__$1);

return statearr_38678;
})();
if(cljs.core.truth_(inst_38656)){
var statearr_38679_40289 = state_38669__$1;
(statearr_38679_40289[(1)] = (13));

} else {
var statearr_38680_40290 = state_38669__$1;
(statearr_38680_40290[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38670 === (2))){
var inst_38630 = cljs.core.reset_BANG_(dctr,cnt);
var inst_38631 = (0);
var state_38669__$1 = (function (){var statearr_38681 = state_38669;
(statearr_38681[(9)] = inst_38630);

(statearr_38681[(7)] = inst_38631);

return statearr_38681;
})();
var statearr_38682_40291 = state_38669__$1;
(statearr_38682_40291[(2)] = null);

(statearr_38682_40291[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38670 === (11))){
var inst_38631 = (state_38669[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_38669,(10),Object,null,(9));
var inst_38642 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_38631) : chs__$1.call(null,inst_38631));
var inst_38643 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_38631) : done.call(null,inst_38631));
var inst_38644 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_38642,inst_38643);
var state_38669__$1 = state_38669;
var statearr_38683_40295 = state_38669__$1;
(statearr_38683_40295[(2)] = inst_38644);


cljs.core.async.impl.ioc_helpers.process_exception(state_38669__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38670 === (9))){
var inst_38631 = (state_38669[(7)]);
var inst_38646 = (state_38669[(2)]);
var inst_38647 = (inst_38631 + (1));
var inst_38631__$1 = inst_38647;
var state_38669__$1 = (function (){var statearr_38684 = state_38669;
(statearr_38684[(10)] = inst_38646);

(statearr_38684[(7)] = inst_38631__$1);

return statearr_38684;
})();
var statearr_38685_40297 = state_38669__$1;
(statearr_38685_40297[(2)] = null);

(statearr_38685_40297[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38670 === (5))){
var inst_38653 = (state_38669[(2)]);
var state_38669__$1 = (function (){var statearr_38686 = state_38669;
(statearr_38686[(11)] = inst_38653);

return statearr_38686;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38669__$1,(12),dchan);
} else {
if((state_val_38670 === (14))){
var inst_38655 = (state_38669[(8)]);
var inst_38660 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_38655);
var state_38669__$1 = state_38669;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38669__$1,(16),out,inst_38660);
} else {
if((state_val_38670 === (16))){
var inst_38662 = (state_38669[(2)]);
var state_38669__$1 = (function (){var statearr_38689 = state_38669;
(statearr_38689[(12)] = inst_38662);

return statearr_38689;
})();
var statearr_38690_40306 = state_38669__$1;
(statearr_38690_40306[(2)] = null);

(statearr_38690_40306[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38670 === (10))){
var inst_38637 = (state_38669[(2)]);
var inst_38638 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_38669__$1 = (function (){var statearr_38691 = state_38669;
(statearr_38691[(13)] = inst_38637);

return statearr_38691;
})();
var statearr_38692_40317 = state_38669__$1;
(statearr_38692_40317[(2)] = inst_38638);


cljs.core.async.impl.ioc_helpers.process_exception(state_38669__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38670 === (8))){
var inst_38651 = (state_38669[(2)]);
var state_38669__$1 = state_38669;
var statearr_38695_40320 = state_38669__$1;
(statearr_38695_40320[(2)] = inst_38651);

(statearr_38695_40320[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__36880__auto__ = null;
var cljs$core$async$state_machine__36880__auto____0 = (function (){
var statearr_38696 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38696[(0)] = cljs$core$async$state_machine__36880__auto__);

(statearr_38696[(1)] = (1));

return statearr_38696;
});
var cljs$core$async$state_machine__36880__auto____1 = (function (state_38669){
while(true){
var ret_value__36881__auto__ = (function (){try{while(true){
var result__36882__auto__ = switch__36879__auto__(state_38669);
if(cljs.core.keyword_identical_QMARK_(result__36882__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36882__auto__;
}
break;
}
}catch (e38697){if((e38697 instanceof Object)){
var ex__36883__auto__ = e38697;
var statearr_38698_40345 = state_38669;
(statearr_38698_40345[(5)] = ex__36883__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38669);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e38697;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__36881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40347 = state_38669;
state_38669 = G__40347;
continue;
} else {
return ret_value__36881__auto__;
}
break;
}
});
cljs$core$async$state_machine__36880__auto__ = function(state_38669){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__36880__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__36880__auto____1.call(this,state_38669);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__36880__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__36880__auto____0;
cljs$core$async$state_machine__36880__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__36880__auto____1;
return cljs$core$async$state_machine__36880__auto__;
})()
})();
var state__37100__auto__ = (function (){var statearr_38699 = f__37099__auto__();
(statearr_38699[(6)] = c__37098__auto___40265);

return statearr_38699;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37100__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__38704 = arguments.length;
switch (G__38704) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__37098__auto___40356 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__37099__auto__ = (function (){var switch__36879__auto__ = (function (state_38736){
var state_val_38737 = (state_38736[(1)]);
if((state_val_38737 === (7))){
var inst_38715 = (state_38736[(7)]);
var inst_38716 = (state_38736[(8)]);
var inst_38715__$1 = (state_38736[(2)]);
var inst_38716__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38715__$1,(0),null);
var inst_38717 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38715__$1,(1),null);
var inst_38718 = (inst_38716__$1 == null);
var state_38736__$1 = (function (){var statearr_38738 = state_38736;
(statearr_38738[(7)] = inst_38715__$1);

(statearr_38738[(8)] = inst_38716__$1);

(statearr_38738[(9)] = inst_38717);

return statearr_38738;
})();
if(cljs.core.truth_(inst_38718)){
var statearr_38739_40363 = state_38736__$1;
(statearr_38739_40363[(1)] = (8));

} else {
var statearr_38740_40365 = state_38736__$1;
(statearr_38740_40365[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38737 === (1))){
var inst_38705 = cljs.core.vec(chs);
var inst_38706 = inst_38705;
var state_38736__$1 = (function (){var statearr_38742 = state_38736;
(statearr_38742[(10)] = inst_38706);

return statearr_38742;
})();
var statearr_38744_40367 = state_38736__$1;
(statearr_38744_40367[(2)] = null);

(statearr_38744_40367[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38737 === (4))){
var inst_38706 = (state_38736[(10)]);
var state_38736__$1 = state_38736;
return cljs.core.async.ioc_alts_BANG_(state_38736__$1,(7),inst_38706);
} else {
if((state_val_38737 === (6))){
var inst_38732 = (state_38736[(2)]);
var state_38736__$1 = state_38736;
var statearr_38745_40385 = state_38736__$1;
(statearr_38745_40385[(2)] = inst_38732);

(statearr_38745_40385[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38737 === (3))){
var inst_38734 = (state_38736[(2)]);
var state_38736__$1 = state_38736;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38736__$1,inst_38734);
} else {
if((state_val_38737 === (2))){
var inst_38706 = (state_38736[(10)]);
var inst_38708 = cljs.core.count(inst_38706);
var inst_38709 = (inst_38708 > (0));
var state_38736__$1 = state_38736;
if(cljs.core.truth_(inst_38709)){
var statearr_38747_40393 = state_38736__$1;
(statearr_38747_40393[(1)] = (4));

} else {
var statearr_38748_40394 = state_38736__$1;
(statearr_38748_40394[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38737 === (11))){
var inst_38706 = (state_38736[(10)]);
var inst_38725 = (state_38736[(2)]);
var tmp38746 = inst_38706;
var inst_38706__$1 = tmp38746;
var state_38736__$1 = (function (){var statearr_38753 = state_38736;
(statearr_38753[(10)] = inst_38706__$1);

(statearr_38753[(11)] = inst_38725);

return statearr_38753;
})();
var statearr_38754_40405 = state_38736__$1;
(statearr_38754_40405[(2)] = null);

(statearr_38754_40405[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38737 === (9))){
var inst_38716 = (state_38736[(8)]);
var state_38736__$1 = state_38736;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38736__$1,(11),out,inst_38716);
} else {
if((state_val_38737 === (5))){
var inst_38730 = cljs.core.async.close_BANG_(out);
var state_38736__$1 = state_38736;
var statearr_38756_40424 = state_38736__$1;
(statearr_38756_40424[(2)] = inst_38730);

(statearr_38756_40424[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38737 === (10))){
var inst_38728 = (state_38736[(2)]);
var state_38736__$1 = state_38736;
var statearr_38757_40426 = state_38736__$1;
(statearr_38757_40426[(2)] = inst_38728);

(statearr_38757_40426[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38737 === (8))){
var inst_38706 = (state_38736[(10)]);
var inst_38715 = (state_38736[(7)]);
var inst_38716 = (state_38736[(8)]);
var inst_38717 = (state_38736[(9)]);
var inst_38720 = (function (){var cs = inst_38706;
var vec__38711 = inst_38715;
var v = inst_38716;
var c = inst_38717;
return (function (p1__38702_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__38702_SHARP_);
});
})();
var inst_38721 = cljs.core.filterv(inst_38720,inst_38706);
var inst_38706__$1 = inst_38721;
var state_38736__$1 = (function (){var statearr_38759 = state_38736;
(statearr_38759[(10)] = inst_38706__$1);

return statearr_38759;
})();
var statearr_38761_40428 = state_38736__$1;
(statearr_38761_40428[(2)] = null);

(statearr_38761_40428[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__36880__auto__ = null;
var cljs$core$async$state_machine__36880__auto____0 = (function (){
var statearr_38763 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38763[(0)] = cljs$core$async$state_machine__36880__auto__);

(statearr_38763[(1)] = (1));

return statearr_38763;
});
var cljs$core$async$state_machine__36880__auto____1 = (function (state_38736){
while(true){
var ret_value__36881__auto__ = (function (){try{while(true){
var result__36882__auto__ = switch__36879__auto__(state_38736);
if(cljs.core.keyword_identical_QMARK_(result__36882__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36882__auto__;
}
break;
}
}catch (e38766){if((e38766 instanceof Object)){
var ex__36883__auto__ = e38766;
var statearr_38767_40443 = state_38736;
(statearr_38767_40443[(5)] = ex__36883__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38736);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e38766;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__36881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40446 = state_38736;
state_38736 = G__40446;
continue;
} else {
return ret_value__36881__auto__;
}
break;
}
});
cljs$core$async$state_machine__36880__auto__ = function(state_38736){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__36880__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__36880__auto____1.call(this,state_38736);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__36880__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__36880__auto____0;
cljs$core$async$state_machine__36880__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__36880__auto____1;
return cljs$core$async$state_machine__36880__auto__;
})()
})();
var state__37100__auto__ = (function (){var statearr_38771 = f__37099__auto__();
(statearr_38771[(6)] = c__37098__auto___40356);

return statearr_38771;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37100__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__38773 = arguments.length;
switch (G__38773) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__37098__auto___40465 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__37099__auto__ = (function (){var switch__36879__auto__ = (function (state_38810){
var state_val_38811 = (state_38810[(1)]);
if((state_val_38811 === (7))){
var inst_38792 = (state_38810[(7)]);
var inst_38792__$1 = (state_38810[(2)]);
var inst_38793 = (inst_38792__$1 == null);
var inst_38794 = cljs.core.not(inst_38793);
var state_38810__$1 = (function (){var statearr_38818 = state_38810;
(statearr_38818[(7)] = inst_38792__$1);

return statearr_38818;
})();
if(inst_38794){
var statearr_38819_40474 = state_38810__$1;
(statearr_38819_40474[(1)] = (8));

} else {
var statearr_38820_40476 = state_38810__$1;
(statearr_38820_40476[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38811 === (1))){
var inst_38781 = (0);
var state_38810__$1 = (function (){var statearr_38821 = state_38810;
(statearr_38821[(8)] = inst_38781);

return statearr_38821;
})();
var statearr_38826_40487 = state_38810__$1;
(statearr_38826_40487[(2)] = null);

(statearr_38826_40487[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38811 === (4))){
var state_38810__$1 = state_38810;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38810__$1,(7),ch);
} else {
if((state_val_38811 === (6))){
var inst_38805 = (state_38810[(2)]);
var state_38810__$1 = state_38810;
var statearr_38830_40496 = state_38810__$1;
(statearr_38830_40496[(2)] = inst_38805);

(statearr_38830_40496[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38811 === (3))){
var inst_38807 = (state_38810[(2)]);
var inst_38808 = cljs.core.async.close_BANG_(out);
var state_38810__$1 = (function (){var statearr_38834 = state_38810;
(statearr_38834[(9)] = inst_38807);

return statearr_38834;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_38810__$1,inst_38808);
} else {
if((state_val_38811 === (2))){
var inst_38781 = (state_38810[(8)]);
var inst_38789 = (inst_38781 < n);
var state_38810__$1 = state_38810;
if(cljs.core.truth_(inst_38789)){
var statearr_38835_40497 = state_38810__$1;
(statearr_38835_40497[(1)] = (4));

} else {
var statearr_38839_40498 = state_38810__$1;
(statearr_38839_40498[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38811 === (11))){
var inst_38781 = (state_38810[(8)]);
var inst_38797 = (state_38810[(2)]);
var inst_38798 = (inst_38781 + (1));
var inst_38781__$1 = inst_38798;
var state_38810__$1 = (function (){var statearr_38840 = state_38810;
(statearr_38840[(10)] = inst_38797);

(statearr_38840[(8)] = inst_38781__$1);

return statearr_38840;
})();
var statearr_38841_40509 = state_38810__$1;
(statearr_38841_40509[(2)] = null);

(statearr_38841_40509[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38811 === (9))){
var state_38810__$1 = state_38810;
var statearr_38842_40515 = state_38810__$1;
(statearr_38842_40515[(2)] = null);

(statearr_38842_40515[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38811 === (5))){
var state_38810__$1 = state_38810;
var statearr_38843_40521 = state_38810__$1;
(statearr_38843_40521[(2)] = null);

(statearr_38843_40521[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38811 === (10))){
var inst_38802 = (state_38810[(2)]);
var state_38810__$1 = state_38810;
var statearr_38844_40526 = state_38810__$1;
(statearr_38844_40526[(2)] = inst_38802);

(statearr_38844_40526[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38811 === (8))){
var inst_38792 = (state_38810[(7)]);
var state_38810__$1 = state_38810;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38810__$1,(11),out,inst_38792);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__36880__auto__ = null;
var cljs$core$async$state_machine__36880__auto____0 = (function (){
var statearr_38845 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_38845[(0)] = cljs$core$async$state_machine__36880__auto__);

(statearr_38845[(1)] = (1));

return statearr_38845;
});
var cljs$core$async$state_machine__36880__auto____1 = (function (state_38810){
while(true){
var ret_value__36881__auto__ = (function (){try{while(true){
var result__36882__auto__ = switch__36879__auto__(state_38810);
if(cljs.core.keyword_identical_QMARK_(result__36882__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36882__auto__;
}
break;
}
}catch (e38846){if((e38846 instanceof Object)){
var ex__36883__auto__ = e38846;
var statearr_38847_40533 = state_38810;
(statearr_38847_40533[(5)] = ex__36883__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38810);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e38846;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__36881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40534 = state_38810;
state_38810 = G__40534;
continue;
} else {
return ret_value__36881__auto__;
}
break;
}
});
cljs$core$async$state_machine__36880__auto__ = function(state_38810){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__36880__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__36880__auto____1.call(this,state_38810);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__36880__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__36880__auto____0;
cljs$core$async$state_machine__36880__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__36880__auto____1;
return cljs$core$async$state_machine__36880__auto__;
})()
})();
var state__37100__auto__ = (function (){var statearr_38852 = f__37099__auto__();
(statearr_38852[(6)] = c__37098__auto___40465);

return statearr_38852;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37100__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async38854 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async38854 = (function (f,ch,meta38855){
this.f = f;
this.ch = ch;
this.meta38855 = meta38855;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async38854.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_38856,meta38855__$1){
var self__ = this;
var _38856__$1 = this;
return (new cljs.core.async.t_cljs$core$async38854(self__.f,self__.ch,meta38855__$1));
}));

(cljs.core.async.t_cljs$core$async38854.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_38856){
var self__ = this;
var _38856__$1 = this;
return self__.meta38855;
}));

(cljs.core.async.t_cljs$core$async38854.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async38854.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async38854.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async38854.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async38854.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async38861 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async38861 = (function (f,ch,meta38855,_,fn1,meta38862){
this.f = f;
this.ch = ch;
this.meta38855 = meta38855;
this._ = _;
this.fn1 = fn1;
this.meta38862 = meta38862;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async38861.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_38863,meta38862__$1){
var self__ = this;
var _38863__$1 = this;
return (new cljs.core.async.t_cljs$core$async38861(self__.f,self__.ch,self__.meta38855,self__._,self__.fn1,meta38862__$1));
}));

(cljs.core.async.t_cljs$core$async38861.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_38863){
var self__ = this;
var _38863__$1 = this;
return self__.meta38862;
}));

(cljs.core.async.t_cljs$core$async38861.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async38861.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async38861.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async38861.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__38853_SHARP_){
var G__38868 = (((p1__38853_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__38853_SHARP_) : self__.f.call(null,p1__38853_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__38868) : f1.call(null,G__38868));
});
}));

(cljs.core.async.t_cljs$core$async38861.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta38855","meta38855",1902869838,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async38854","cljs.core.async/t_cljs$core$async38854",1620756421,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta38862","meta38862",70303555,null)], null);
}));

(cljs.core.async.t_cljs$core$async38861.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async38861.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async38861");

(cljs.core.async.t_cljs$core$async38861.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write(writer__4429__auto__,"cljs.core.async/t_cljs$core$async38861");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async38861.
 */
cljs.core.async.__GT_t_cljs$core$async38861 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async38861(f__$1,ch__$1,meta38855__$1,___$2,fn1__$1,meta38862){
return (new cljs.core.async.t_cljs$core$async38861(f__$1,ch__$1,meta38855__$1,___$2,fn1__$1,meta38862));
});

}

return (new cljs.core.async.t_cljs$core$async38861(self__.f,self__.ch,self__.meta38855,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4174__auto__ = ret;
if(cljs.core.truth_(and__4174__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4174__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__38869 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__38869) : self__.f.call(null,G__38869));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async38854.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async38854.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async38854.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta38855","meta38855",1902869838,null)], null);
}));

(cljs.core.async.t_cljs$core$async38854.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async38854.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async38854");

(cljs.core.async.t_cljs$core$async38854.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write(writer__4429__auto__,"cljs.core.async/t_cljs$core$async38854");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async38854.
 */
cljs.core.async.__GT_t_cljs$core$async38854 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async38854(f__$1,ch__$1,meta38855){
return (new cljs.core.async.t_cljs$core$async38854(f__$1,ch__$1,meta38855));
});

}

return (new cljs.core.async.t_cljs$core$async38854(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async38877 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async38877 = (function (f,ch,meta38878){
this.f = f;
this.ch = ch;
this.meta38878 = meta38878;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async38877.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_38879,meta38878__$1){
var self__ = this;
var _38879__$1 = this;
return (new cljs.core.async.t_cljs$core$async38877(self__.f,self__.ch,meta38878__$1));
}));

(cljs.core.async.t_cljs$core$async38877.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_38879){
var self__ = this;
var _38879__$1 = this;
return self__.meta38878;
}));

(cljs.core.async.t_cljs$core$async38877.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async38877.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async38877.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async38877.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async38877.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async38877.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async38877.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta38878","meta38878",-2102394289,null)], null);
}));

(cljs.core.async.t_cljs$core$async38877.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async38877.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async38877");

(cljs.core.async.t_cljs$core$async38877.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write(writer__4429__auto__,"cljs.core.async/t_cljs$core$async38877");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async38877.
 */
cljs.core.async.__GT_t_cljs$core$async38877 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async38877(f__$1,ch__$1,meta38878){
return (new cljs.core.async.t_cljs$core$async38877(f__$1,ch__$1,meta38878));
});

}

return (new cljs.core.async.t_cljs$core$async38877(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async38880 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async38880 = (function (p,ch,meta38881){
this.p = p;
this.ch = ch;
this.meta38881 = meta38881;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async38880.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_38882,meta38881__$1){
var self__ = this;
var _38882__$1 = this;
return (new cljs.core.async.t_cljs$core$async38880(self__.p,self__.ch,meta38881__$1));
}));

(cljs.core.async.t_cljs$core$async38880.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_38882){
var self__ = this;
var _38882__$1 = this;
return self__.meta38881;
}));

(cljs.core.async.t_cljs$core$async38880.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async38880.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async38880.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async38880.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async38880.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async38880.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async38880.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async38880.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta38881","meta38881",1227267429,null)], null);
}));

(cljs.core.async.t_cljs$core$async38880.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async38880.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async38880");

(cljs.core.async.t_cljs$core$async38880.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__,opt__4430__auto__){
return cljs.core._write(writer__4429__auto__,"cljs.core.async/t_cljs$core$async38880");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async38880.
 */
cljs.core.async.__GT_t_cljs$core$async38880 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async38880(p__$1,ch__$1,meta38881){
return (new cljs.core.async.t_cljs$core$async38880(p__$1,ch__$1,meta38881));
});

}

return (new cljs.core.async.t_cljs$core$async38880(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__38895 = arguments.length;
switch (G__38895) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__37098__auto___40626 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__37099__auto__ = (function (){var switch__36879__auto__ = (function (state_38919){
var state_val_38920 = (state_38919[(1)]);
if((state_val_38920 === (7))){
var inst_38915 = (state_38919[(2)]);
var state_38919__$1 = state_38919;
var statearr_38921_40627 = state_38919__$1;
(statearr_38921_40627[(2)] = inst_38915);

(statearr_38921_40627[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38920 === (1))){
var state_38919__$1 = state_38919;
var statearr_38922_40628 = state_38919__$1;
(statearr_38922_40628[(2)] = null);

(statearr_38922_40628[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38920 === (4))){
var inst_38901 = (state_38919[(7)]);
var inst_38901__$1 = (state_38919[(2)]);
var inst_38902 = (inst_38901__$1 == null);
var state_38919__$1 = (function (){var statearr_38923 = state_38919;
(statearr_38923[(7)] = inst_38901__$1);

return statearr_38923;
})();
if(cljs.core.truth_(inst_38902)){
var statearr_38924_40629 = state_38919__$1;
(statearr_38924_40629[(1)] = (5));

} else {
var statearr_38925_40630 = state_38919__$1;
(statearr_38925_40630[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38920 === (6))){
var inst_38901 = (state_38919[(7)]);
var inst_38906 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_38901) : p.call(null,inst_38901));
var state_38919__$1 = state_38919;
if(cljs.core.truth_(inst_38906)){
var statearr_38926_40631 = state_38919__$1;
(statearr_38926_40631[(1)] = (8));

} else {
var statearr_38927_40632 = state_38919__$1;
(statearr_38927_40632[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38920 === (3))){
var inst_38917 = (state_38919[(2)]);
var state_38919__$1 = state_38919;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38919__$1,inst_38917);
} else {
if((state_val_38920 === (2))){
var state_38919__$1 = state_38919;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38919__$1,(4),ch);
} else {
if((state_val_38920 === (11))){
var inst_38909 = (state_38919[(2)]);
var state_38919__$1 = state_38919;
var statearr_38929_40634 = state_38919__$1;
(statearr_38929_40634[(2)] = inst_38909);

(statearr_38929_40634[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38920 === (9))){
var state_38919__$1 = state_38919;
var statearr_38933_40635 = state_38919__$1;
(statearr_38933_40635[(2)] = null);

(statearr_38933_40635[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38920 === (5))){
var inst_38904 = cljs.core.async.close_BANG_(out);
var state_38919__$1 = state_38919;
var statearr_38934_40637 = state_38919__$1;
(statearr_38934_40637[(2)] = inst_38904);

(statearr_38934_40637[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38920 === (10))){
var inst_38912 = (state_38919[(2)]);
var state_38919__$1 = (function (){var statearr_38935 = state_38919;
(statearr_38935[(8)] = inst_38912);

return statearr_38935;
})();
var statearr_38936_40642 = state_38919__$1;
(statearr_38936_40642[(2)] = null);

(statearr_38936_40642[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38920 === (8))){
var inst_38901 = (state_38919[(7)]);
var state_38919__$1 = state_38919;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38919__$1,(11),out,inst_38901);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__36880__auto__ = null;
var cljs$core$async$state_machine__36880__auto____0 = (function (){
var statearr_38941 = [null,null,null,null,null,null,null,null,null];
(statearr_38941[(0)] = cljs$core$async$state_machine__36880__auto__);

(statearr_38941[(1)] = (1));

return statearr_38941;
});
var cljs$core$async$state_machine__36880__auto____1 = (function (state_38919){
while(true){
var ret_value__36881__auto__ = (function (){try{while(true){
var result__36882__auto__ = switch__36879__auto__(state_38919);
if(cljs.core.keyword_identical_QMARK_(result__36882__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36882__auto__;
}
break;
}
}catch (e38942){if((e38942 instanceof Object)){
var ex__36883__auto__ = e38942;
var statearr_38943_40643 = state_38919;
(statearr_38943_40643[(5)] = ex__36883__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38919);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e38942;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__36881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40644 = state_38919;
state_38919 = G__40644;
continue;
} else {
return ret_value__36881__auto__;
}
break;
}
});
cljs$core$async$state_machine__36880__auto__ = function(state_38919){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__36880__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__36880__auto____1.call(this,state_38919);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__36880__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__36880__auto____0;
cljs$core$async$state_machine__36880__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__36880__auto____1;
return cljs$core$async$state_machine__36880__auto__;
})()
})();
var state__37100__auto__ = (function (){var statearr_38944 = f__37099__auto__();
(statearr_38944[(6)] = c__37098__auto___40626);

return statearr_38944;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37100__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__38946 = arguments.length;
switch (G__38946) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__37098__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__37099__auto__ = (function (){var switch__36879__auto__ = (function (state_39013){
var state_val_39014 = (state_39013[(1)]);
if((state_val_39014 === (7))){
var inst_39009 = (state_39013[(2)]);
var state_39013__$1 = state_39013;
var statearr_39015_40654 = state_39013__$1;
(statearr_39015_40654[(2)] = inst_39009);

(statearr_39015_40654[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39014 === (20))){
var inst_38976 = (state_39013[(7)]);
var inst_38990 = (state_39013[(2)]);
var inst_38991 = cljs.core.next(inst_38976);
var inst_38962 = inst_38991;
var inst_38963 = null;
var inst_38964 = (0);
var inst_38965 = (0);
var state_39013__$1 = (function (){var statearr_39016 = state_39013;
(statearr_39016[(8)] = inst_38963);

(statearr_39016[(9)] = inst_38990);

(statearr_39016[(10)] = inst_38964);

(statearr_39016[(11)] = inst_38965);

(statearr_39016[(12)] = inst_38962);

return statearr_39016;
})();
var statearr_39017_40656 = state_39013__$1;
(statearr_39017_40656[(2)] = null);

(statearr_39017_40656[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39014 === (1))){
var state_39013__$1 = state_39013;
var statearr_39018_40657 = state_39013__$1;
(statearr_39018_40657[(2)] = null);

(statearr_39018_40657[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39014 === (4))){
var inst_38951 = (state_39013[(13)]);
var inst_38951__$1 = (state_39013[(2)]);
var inst_38952 = (inst_38951__$1 == null);
var state_39013__$1 = (function (){var statearr_39019 = state_39013;
(statearr_39019[(13)] = inst_38951__$1);

return statearr_39019;
})();
if(cljs.core.truth_(inst_38952)){
var statearr_39020_40659 = state_39013__$1;
(statearr_39020_40659[(1)] = (5));

} else {
var statearr_39021_40660 = state_39013__$1;
(statearr_39021_40660[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39014 === (15))){
var state_39013__$1 = state_39013;
var statearr_39025_40661 = state_39013__$1;
(statearr_39025_40661[(2)] = null);

(statearr_39025_40661[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39014 === (21))){
var state_39013__$1 = state_39013;
var statearr_39026_40663 = state_39013__$1;
(statearr_39026_40663[(2)] = null);

(statearr_39026_40663[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39014 === (13))){
var inst_38963 = (state_39013[(8)]);
var inst_38964 = (state_39013[(10)]);
var inst_38965 = (state_39013[(11)]);
var inst_38962 = (state_39013[(12)]);
var inst_38972 = (state_39013[(2)]);
var inst_38973 = (inst_38965 + (1));
var tmp39022 = inst_38963;
var tmp39023 = inst_38964;
var tmp39024 = inst_38962;
var inst_38962__$1 = tmp39024;
var inst_38963__$1 = tmp39022;
var inst_38964__$1 = tmp39023;
var inst_38965__$1 = inst_38973;
var state_39013__$1 = (function (){var statearr_39027 = state_39013;
(statearr_39027[(8)] = inst_38963__$1);

(statearr_39027[(14)] = inst_38972);

(statearr_39027[(10)] = inst_38964__$1);

(statearr_39027[(11)] = inst_38965__$1);

(statearr_39027[(12)] = inst_38962__$1);

return statearr_39027;
})();
var statearr_39028_40664 = state_39013__$1;
(statearr_39028_40664[(2)] = null);

(statearr_39028_40664[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39014 === (22))){
var state_39013__$1 = state_39013;
var statearr_39029_40666 = state_39013__$1;
(statearr_39029_40666[(2)] = null);

(statearr_39029_40666[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39014 === (6))){
var inst_38951 = (state_39013[(13)]);
var inst_38960 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_38951) : f.call(null,inst_38951));
var inst_38961 = cljs.core.seq(inst_38960);
var inst_38962 = inst_38961;
var inst_38963 = null;
var inst_38964 = (0);
var inst_38965 = (0);
var state_39013__$1 = (function (){var statearr_39030 = state_39013;
(statearr_39030[(8)] = inst_38963);

(statearr_39030[(10)] = inst_38964);

(statearr_39030[(11)] = inst_38965);

(statearr_39030[(12)] = inst_38962);

return statearr_39030;
})();
var statearr_39031_40667 = state_39013__$1;
(statearr_39031_40667[(2)] = null);

(statearr_39031_40667[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39014 === (17))){
var inst_38976 = (state_39013[(7)]);
var inst_38983 = cljs.core.chunk_first(inst_38976);
var inst_38984 = cljs.core.chunk_rest(inst_38976);
var inst_38985 = cljs.core.count(inst_38983);
var inst_38962 = inst_38984;
var inst_38963 = inst_38983;
var inst_38964 = inst_38985;
var inst_38965 = (0);
var state_39013__$1 = (function (){var statearr_39032 = state_39013;
(statearr_39032[(8)] = inst_38963);

(statearr_39032[(10)] = inst_38964);

(statearr_39032[(11)] = inst_38965);

(statearr_39032[(12)] = inst_38962);

return statearr_39032;
})();
var statearr_39033_40674 = state_39013__$1;
(statearr_39033_40674[(2)] = null);

(statearr_39033_40674[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39014 === (3))){
var inst_39011 = (state_39013[(2)]);
var state_39013__$1 = state_39013;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39013__$1,inst_39011);
} else {
if((state_val_39014 === (12))){
var inst_38999 = (state_39013[(2)]);
var state_39013__$1 = state_39013;
var statearr_39034_40675 = state_39013__$1;
(statearr_39034_40675[(2)] = inst_38999);

(statearr_39034_40675[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39014 === (2))){
var state_39013__$1 = state_39013;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39013__$1,(4),in$);
} else {
if((state_val_39014 === (23))){
var inst_39007 = (state_39013[(2)]);
var state_39013__$1 = state_39013;
var statearr_39035_40676 = state_39013__$1;
(statearr_39035_40676[(2)] = inst_39007);

(statearr_39035_40676[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39014 === (19))){
var inst_38994 = (state_39013[(2)]);
var state_39013__$1 = state_39013;
var statearr_39036_40677 = state_39013__$1;
(statearr_39036_40677[(2)] = inst_38994);

(statearr_39036_40677[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39014 === (11))){
var inst_38976 = (state_39013[(7)]);
var inst_38962 = (state_39013[(12)]);
var inst_38976__$1 = cljs.core.seq(inst_38962);
var state_39013__$1 = (function (){var statearr_39037 = state_39013;
(statearr_39037[(7)] = inst_38976__$1);

return statearr_39037;
})();
if(inst_38976__$1){
var statearr_39038_40678 = state_39013__$1;
(statearr_39038_40678[(1)] = (14));

} else {
var statearr_39039_40679 = state_39013__$1;
(statearr_39039_40679[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39014 === (9))){
var inst_39001 = (state_39013[(2)]);
var inst_39002 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_39013__$1 = (function (){var statearr_39040 = state_39013;
(statearr_39040[(15)] = inst_39001);

return statearr_39040;
})();
if(cljs.core.truth_(inst_39002)){
var statearr_39041_40682 = state_39013__$1;
(statearr_39041_40682[(1)] = (21));

} else {
var statearr_39042_40683 = state_39013__$1;
(statearr_39042_40683[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39014 === (5))){
var inst_38954 = cljs.core.async.close_BANG_(out);
var state_39013__$1 = state_39013;
var statearr_39043_40692 = state_39013__$1;
(statearr_39043_40692[(2)] = inst_38954);

(statearr_39043_40692[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39014 === (14))){
var inst_38976 = (state_39013[(7)]);
var inst_38981 = cljs.core.chunked_seq_QMARK_(inst_38976);
var state_39013__$1 = state_39013;
if(inst_38981){
var statearr_39044_40698 = state_39013__$1;
(statearr_39044_40698[(1)] = (17));

} else {
var statearr_39046_40699 = state_39013__$1;
(statearr_39046_40699[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39014 === (16))){
var inst_38997 = (state_39013[(2)]);
var state_39013__$1 = state_39013;
var statearr_39047_40702 = state_39013__$1;
(statearr_39047_40702[(2)] = inst_38997);

(statearr_39047_40702[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39014 === (10))){
var inst_38963 = (state_39013[(8)]);
var inst_38965 = (state_39013[(11)]);
var inst_38970 = cljs.core._nth(inst_38963,inst_38965);
var state_39013__$1 = state_39013;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_39013__$1,(13),out,inst_38970);
} else {
if((state_val_39014 === (18))){
var inst_38976 = (state_39013[(7)]);
var inst_38988 = cljs.core.first(inst_38976);
var state_39013__$1 = state_39013;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_39013__$1,(20),out,inst_38988);
} else {
if((state_val_39014 === (8))){
var inst_38964 = (state_39013[(10)]);
var inst_38965 = (state_39013[(11)]);
var inst_38967 = (inst_38965 < inst_38964);
var inst_38968 = inst_38967;
var state_39013__$1 = state_39013;
if(cljs.core.truth_(inst_38968)){
var statearr_39048_40708 = state_39013__$1;
(statearr_39048_40708[(1)] = (10));

} else {
var statearr_39049_40709 = state_39013__$1;
(statearr_39049_40709[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__36880__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__36880__auto____0 = (function (){
var statearr_39050 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39050[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__36880__auto__);

(statearr_39050[(1)] = (1));

return statearr_39050;
});
var cljs$core$async$mapcat_STAR__$_state_machine__36880__auto____1 = (function (state_39013){
while(true){
var ret_value__36881__auto__ = (function (){try{while(true){
var result__36882__auto__ = switch__36879__auto__(state_39013);
if(cljs.core.keyword_identical_QMARK_(result__36882__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36882__auto__;
}
break;
}
}catch (e39051){if((e39051 instanceof Object)){
var ex__36883__auto__ = e39051;
var statearr_39052_40710 = state_39013;
(statearr_39052_40710[(5)] = ex__36883__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_39013);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e39051;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__36881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40711 = state_39013;
state_39013 = G__40711;
continue;
} else {
return ret_value__36881__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__36880__auto__ = function(state_39013){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__36880__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__36880__auto____1.call(this,state_39013);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__36880__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__36880__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__36880__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__36880__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__36880__auto__;
})()
})();
var state__37100__auto__ = (function (){var statearr_39056 = f__37099__auto__();
(statearr_39056[(6)] = c__37098__auto__);

return statearr_39056;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37100__auto__);
}));

return c__37098__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__39058 = arguments.length;
switch (G__39058) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__39064 = arguments.length;
switch (G__39064) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__39066 = arguments.length;
switch (G__39066) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__37098__auto___40735 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__37099__auto__ = (function (){var switch__36879__auto__ = (function (state_39090){
var state_val_39091 = (state_39090[(1)]);
if((state_val_39091 === (7))){
var inst_39085 = (state_39090[(2)]);
var state_39090__$1 = state_39090;
var statearr_39106_40741 = state_39090__$1;
(statearr_39106_40741[(2)] = inst_39085);

(statearr_39106_40741[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39091 === (1))){
var inst_39067 = null;
var state_39090__$1 = (function (){var statearr_39107 = state_39090;
(statearr_39107[(7)] = inst_39067);

return statearr_39107;
})();
var statearr_39108_40742 = state_39090__$1;
(statearr_39108_40742[(2)] = null);

(statearr_39108_40742[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39091 === (4))){
var inst_39070 = (state_39090[(8)]);
var inst_39070__$1 = (state_39090[(2)]);
var inst_39071 = (inst_39070__$1 == null);
var inst_39072 = cljs.core.not(inst_39071);
var state_39090__$1 = (function (){var statearr_39115 = state_39090;
(statearr_39115[(8)] = inst_39070__$1);

return statearr_39115;
})();
if(inst_39072){
var statearr_39116_40751 = state_39090__$1;
(statearr_39116_40751[(1)] = (5));

} else {
var statearr_39117_40752 = state_39090__$1;
(statearr_39117_40752[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39091 === (6))){
var state_39090__$1 = state_39090;
var statearr_39118_40753 = state_39090__$1;
(statearr_39118_40753[(2)] = null);

(statearr_39118_40753[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39091 === (3))){
var inst_39087 = (state_39090[(2)]);
var inst_39088 = cljs.core.async.close_BANG_(out);
var state_39090__$1 = (function (){var statearr_39119 = state_39090;
(statearr_39119[(9)] = inst_39087);

return statearr_39119;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_39090__$1,inst_39088);
} else {
if((state_val_39091 === (2))){
var state_39090__$1 = state_39090;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39090__$1,(4),ch);
} else {
if((state_val_39091 === (11))){
var inst_39070 = (state_39090[(8)]);
var inst_39079 = (state_39090[(2)]);
var inst_39067 = inst_39070;
var state_39090__$1 = (function (){var statearr_39134 = state_39090;
(statearr_39134[(10)] = inst_39079);

(statearr_39134[(7)] = inst_39067);

return statearr_39134;
})();
var statearr_39135_40759 = state_39090__$1;
(statearr_39135_40759[(2)] = null);

(statearr_39135_40759[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39091 === (9))){
var inst_39070 = (state_39090[(8)]);
var state_39090__$1 = state_39090;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_39090__$1,(11),out,inst_39070);
} else {
if((state_val_39091 === (5))){
var inst_39067 = (state_39090[(7)]);
var inst_39070 = (state_39090[(8)]);
var inst_39074 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_39070,inst_39067);
var state_39090__$1 = state_39090;
if(inst_39074){
var statearr_39143_40760 = state_39090__$1;
(statearr_39143_40760[(1)] = (8));

} else {
var statearr_39144_40762 = state_39090__$1;
(statearr_39144_40762[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39091 === (10))){
var inst_39082 = (state_39090[(2)]);
var state_39090__$1 = state_39090;
var statearr_39145_40763 = state_39090__$1;
(statearr_39145_40763[(2)] = inst_39082);

(statearr_39145_40763[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39091 === (8))){
var inst_39067 = (state_39090[(7)]);
var tmp39142 = inst_39067;
var inst_39067__$1 = tmp39142;
var state_39090__$1 = (function (){var statearr_39148 = state_39090;
(statearr_39148[(7)] = inst_39067__$1);

return statearr_39148;
})();
var statearr_39149_40764 = state_39090__$1;
(statearr_39149_40764[(2)] = null);

(statearr_39149_40764[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__36880__auto__ = null;
var cljs$core$async$state_machine__36880__auto____0 = (function (){
var statearr_39150 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_39150[(0)] = cljs$core$async$state_machine__36880__auto__);

(statearr_39150[(1)] = (1));

return statearr_39150;
});
var cljs$core$async$state_machine__36880__auto____1 = (function (state_39090){
while(true){
var ret_value__36881__auto__ = (function (){try{while(true){
var result__36882__auto__ = switch__36879__auto__(state_39090);
if(cljs.core.keyword_identical_QMARK_(result__36882__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36882__auto__;
}
break;
}
}catch (e39152){if((e39152 instanceof Object)){
var ex__36883__auto__ = e39152;
var statearr_39153_40769 = state_39090;
(statearr_39153_40769[(5)] = ex__36883__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_39090);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e39152;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__36881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40770 = state_39090;
state_39090 = G__40770;
continue;
} else {
return ret_value__36881__auto__;
}
break;
}
});
cljs$core$async$state_machine__36880__auto__ = function(state_39090){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__36880__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__36880__auto____1.call(this,state_39090);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__36880__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__36880__auto____0;
cljs$core$async$state_machine__36880__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__36880__auto____1;
return cljs$core$async$state_machine__36880__auto__;
})()
})();
var state__37100__auto__ = (function (){var statearr_39154 = f__37099__auto__();
(statearr_39154[(6)] = c__37098__auto___40735);

return statearr_39154;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37100__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__39159 = arguments.length;
switch (G__39159) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__37098__auto___40774 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__37099__auto__ = (function (){var switch__36879__auto__ = (function (state_39197){
var state_val_39198 = (state_39197[(1)]);
if((state_val_39198 === (7))){
var inst_39193 = (state_39197[(2)]);
var state_39197__$1 = state_39197;
var statearr_39199_40775 = state_39197__$1;
(statearr_39199_40775[(2)] = inst_39193);

(statearr_39199_40775[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39198 === (1))){
var inst_39160 = (new Array(n));
var inst_39161 = inst_39160;
var inst_39162 = (0);
var state_39197__$1 = (function (){var statearr_39200 = state_39197;
(statearr_39200[(7)] = inst_39162);

(statearr_39200[(8)] = inst_39161);

return statearr_39200;
})();
var statearr_39201_40779 = state_39197__$1;
(statearr_39201_40779[(2)] = null);

(statearr_39201_40779[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39198 === (4))){
var inst_39165 = (state_39197[(9)]);
var inst_39165__$1 = (state_39197[(2)]);
var inst_39166 = (inst_39165__$1 == null);
var inst_39167 = cljs.core.not(inst_39166);
var state_39197__$1 = (function (){var statearr_39202 = state_39197;
(statearr_39202[(9)] = inst_39165__$1);

return statearr_39202;
})();
if(inst_39167){
var statearr_39203_40780 = state_39197__$1;
(statearr_39203_40780[(1)] = (5));

} else {
var statearr_39204_40781 = state_39197__$1;
(statearr_39204_40781[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39198 === (15))){
var inst_39187 = (state_39197[(2)]);
var state_39197__$1 = state_39197;
var statearr_39205_40784 = state_39197__$1;
(statearr_39205_40784[(2)] = inst_39187);

(statearr_39205_40784[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39198 === (13))){
var state_39197__$1 = state_39197;
var statearr_39206_40786 = state_39197__$1;
(statearr_39206_40786[(2)] = null);

(statearr_39206_40786[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39198 === (6))){
var inst_39162 = (state_39197[(7)]);
var inst_39183 = (inst_39162 > (0));
var state_39197__$1 = state_39197;
if(cljs.core.truth_(inst_39183)){
var statearr_39207_40788 = state_39197__$1;
(statearr_39207_40788[(1)] = (12));

} else {
var statearr_39208_40789 = state_39197__$1;
(statearr_39208_40789[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39198 === (3))){
var inst_39195 = (state_39197[(2)]);
var state_39197__$1 = state_39197;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39197__$1,inst_39195);
} else {
if((state_val_39198 === (12))){
var inst_39161 = (state_39197[(8)]);
var inst_39185 = cljs.core.vec(inst_39161);
var state_39197__$1 = state_39197;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_39197__$1,(15),out,inst_39185);
} else {
if((state_val_39198 === (2))){
var state_39197__$1 = state_39197;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39197__$1,(4),ch);
} else {
if((state_val_39198 === (11))){
var inst_39177 = (state_39197[(2)]);
var inst_39178 = (new Array(n));
var inst_39161 = inst_39178;
var inst_39162 = (0);
var state_39197__$1 = (function (){var statearr_39209 = state_39197;
(statearr_39209[(10)] = inst_39177);

(statearr_39209[(7)] = inst_39162);

(statearr_39209[(8)] = inst_39161);

return statearr_39209;
})();
var statearr_39210_40800 = state_39197__$1;
(statearr_39210_40800[(2)] = null);

(statearr_39210_40800[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39198 === (9))){
var inst_39161 = (state_39197[(8)]);
var inst_39175 = cljs.core.vec(inst_39161);
var state_39197__$1 = state_39197;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_39197__$1,(11),out,inst_39175);
} else {
if((state_val_39198 === (5))){
var inst_39165 = (state_39197[(9)]);
var inst_39170 = (state_39197[(11)]);
var inst_39162 = (state_39197[(7)]);
var inst_39161 = (state_39197[(8)]);
var inst_39169 = (inst_39161[inst_39162] = inst_39165);
var inst_39170__$1 = (inst_39162 + (1));
var inst_39171 = (inst_39170__$1 < n);
var state_39197__$1 = (function (){var statearr_39211 = state_39197;
(statearr_39211[(12)] = inst_39169);

(statearr_39211[(11)] = inst_39170__$1);

return statearr_39211;
})();
if(cljs.core.truth_(inst_39171)){
var statearr_39212_40828 = state_39197__$1;
(statearr_39212_40828[(1)] = (8));

} else {
var statearr_39213_40829 = state_39197__$1;
(statearr_39213_40829[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39198 === (14))){
var inst_39190 = (state_39197[(2)]);
var inst_39191 = cljs.core.async.close_BANG_(out);
var state_39197__$1 = (function (){var statearr_39215 = state_39197;
(statearr_39215[(13)] = inst_39190);

return statearr_39215;
})();
var statearr_39216_40843 = state_39197__$1;
(statearr_39216_40843[(2)] = inst_39191);

(statearr_39216_40843[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39198 === (10))){
var inst_39181 = (state_39197[(2)]);
var state_39197__$1 = state_39197;
var statearr_39217_40853 = state_39197__$1;
(statearr_39217_40853[(2)] = inst_39181);

(statearr_39217_40853[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39198 === (8))){
var inst_39170 = (state_39197[(11)]);
var inst_39161 = (state_39197[(8)]);
var tmp39214 = inst_39161;
var inst_39161__$1 = tmp39214;
var inst_39162 = inst_39170;
var state_39197__$1 = (function (){var statearr_39218 = state_39197;
(statearr_39218[(7)] = inst_39162);

(statearr_39218[(8)] = inst_39161__$1);

return statearr_39218;
})();
var statearr_39219_40863 = state_39197__$1;
(statearr_39219_40863[(2)] = null);

(statearr_39219_40863[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__36880__auto__ = null;
var cljs$core$async$state_machine__36880__auto____0 = (function (){
var statearr_39220 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39220[(0)] = cljs$core$async$state_machine__36880__auto__);

(statearr_39220[(1)] = (1));

return statearr_39220;
});
var cljs$core$async$state_machine__36880__auto____1 = (function (state_39197){
while(true){
var ret_value__36881__auto__ = (function (){try{while(true){
var result__36882__auto__ = switch__36879__auto__(state_39197);
if(cljs.core.keyword_identical_QMARK_(result__36882__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36882__auto__;
}
break;
}
}catch (e39221){if((e39221 instanceof Object)){
var ex__36883__auto__ = e39221;
var statearr_39222_40880 = state_39197;
(statearr_39222_40880[(5)] = ex__36883__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_39197);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e39221;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__36881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40889 = state_39197;
state_39197 = G__40889;
continue;
} else {
return ret_value__36881__auto__;
}
break;
}
});
cljs$core$async$state_machine__36880__auto__ = function(state_39197){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__36880__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__36880__auto____1.call(this,state_39197);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__36880__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__36880__auto____0;
cljs$core$async$state_machine__36880__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__36880__auto____1;
return cljs$core$async$state_machine__36880__auto__;
})()
})();
var state__37100__auto__ = (function (){var statearr_39226 = f__37099__auto__();
(statearr_39226[(6)] = c__37098__auto___40774);

return statearr_39226;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37100__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__39236 = arguments.length;
switch (G__39236) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__37098__auto___40894 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__37099__auto__ = (function (){var switch__36879__auto__ = (function (state_39278){
var state_val_39279 = (state_39278[(1)]);
if((state_val_39279 === (7))){
var inst_39274 = (state_39278[(2)]);
var state_39278__$1 = state_39278;
var statearr_39280_40897 = state_39278__$1;
(statearr_39280_40897[(2)] = inst_39274);

(statearr_39280_40897[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39279 === (1))){
var inst_39237 = [];
var inst_39238 = inst_39237;
var inst_39239 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_39278__$1 = (function (){var statearr_39281 = state_39278;
(statearr_39281[(7)] = inst_39239);

(statearr_39281[(8)] = inst_39238);

return statearr_39281;
})();
var statearr_39282_40899 = state_39278__$1;
(statearr_39282_40899[(2)] = null);

(statearr_39282_40899[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39279 === (4))){
var inst_39242 = (state_39278[(9)]);
var inst_39242__$1 = (state_39278[(2)]);
var inst_39243 = (inst_39242__$1 == null);
var inst_39244 = cljs.core.not(inst_39243);
var state_39278__$1 = (function (){var statearr_39283 = state_39278;
(statearr_39283[(9)] = inst_39242__$1);

return statearr_39283;
})();
if(inst_39244){
var statearr_39284_40904 = state_39278__$1;
(statearr_39284_40904[(1)] = (5));

} else {
var statearr_39285_40905 = state_39278__$1;
(statearr_39285_40905[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39279 === (15))){
var inst_39268 = (state_39278[(2)]);
var state_39278__$1 = state_39278;
var statearr_39286_40910 = state_39278__$1;
(statearr_39286_40910[(2)] = inst_39268);

(statearr_39286_40910[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39279 === (13))){
var state_39278__$1 = state_39278;
var statearr_39287_40912 = state_39278__$1;
(statearr_39287_40912[(2)] = null);

(statearr_39287_40912[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39279 === (6))){
var inst_39238 = (state_39278[(8)]);
var inst_39263 = inst_39238.length;
var inst_39264 = (inst_39263 > (0));
var state_39278__$1 = state_39278;
if(cljs.core.truth_(inst_39264)){
var statearr_39288_40925 = state_39278__$1;
(statearr_39288_40925[(1)] = (12));

} else {
var statearr_39289_40926 = state_39278__$1;
(statearr_39289_40926[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39279 === (3))){
var inst_39276 = (state_39278[(2)]);
var state_39278__$1 = state_39278;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39278__$1,inst_39276);
} else {
if((state_val_39279 === (12))){
var inst_39238 = (state_39278[(8)]);
var inst_39266 = cljs.core.vec(inst_39238);
var state_39278__$1 = state_39278;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_39278__$1,(15),out,inst_39266);
} else {
if((state_val_39279 === (2))){
var state_39278__$1 = state_39278;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39278__$1,(4),ch);
} else {
if((state_val_39279 === (11))){
var inst_39242 = (state_39278[(9)]);
var inst_39246 = (state_39278[(10)]);
var inst_39256 = (state_39278[(2)]);
var inst_39257 = [];
var inst_39258 = inst_39257.push(inst_39242);
var inst_39238 = inst_39257;
var inst_39239 = inst_39246;
var state_39278__$1 = (function (){var statearr_39291 = state_39278;
(statearr_39291[(11)] = inst_39256);

(statearr_39291[(12)] = inst_39258);

(statearr_39291[(7)] = inst_39239);

(statearr_39291[(8)] = inst_39238);

return statearr_39291;
})();
var statearr_39293_40937 = state_39278__$1;
(statearr_39293_40937[(2)] = null);

(statearr_39293_40937[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39279 === (9))){
var inst_39238 = (state_39278[(8)]);
var inst_39254 = cljs.core.vec(inst_39238);
var state_39278__$1 = state_39278;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_39278__$1,(11),out,inst_39254);
} else {
if((state_val_39279 === (5))){
var inst_39242 = (state_39278[(9)]);
var inst_39246 = (state_39278[(10)]);
var inst_39239 = (state_39278[(7)]);
var inst_39246__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_39242) : f.call(null,inst_39242));
var inst_39247 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_39246__$1,inst_39239);
var inst_39248 = cljs.core.keyword_identical_QMARK_(inst_39239,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_39249 = ((inst_39247) || (inst_39248));
var state_39278__$1 = (function (){var statearr_39296 = state_39278;
(statearr_39296[(10)] = inst_39246__$1);

return statearr_39296;
})();
if(cljs.core.truth_(inst_39249)){
var statearr_39297_40946 = state_39278__$1;
(statearr_39297_40946[(1)] = (8));

} else {
var statearr_39298_40947 = state_39278__$1;
(statearr_39298_40947[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39279 === (14))){
var inst_39271 = (state_39278[(2)]);
var inst_39272 = cljs.core.async.close_BANG_(out);
var state_39278__$1 = (function (){var statearr_39302 = state_39278;
(statearr_39302[(13)] = inst_39271);

return statearr_39302;
})();
var statearr_39303_40948 = state_39278__$1;
(statearr_39303_40948[(2)] = inst_39272);

(statearr_39303_40948[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39279 === (10))){
var inst_39261 = (state_39278[(2)]);
var state_39278__$1 = state_39278;
var statearr_39304_40950 = state_39278__$1;
(statearr_39304_40950[(2)] = inst_39261);

(statearr_39304_40950[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39279 === (8))){
var inst_39242 = (state_39278[(9)]);
var inst_39246 = (state_39278[(10)]);
var inst_39238 = (state_39278[(8)]);
var inst_39251 = inst_39238.push(inst_39242);
var tmp39300 = inst_39238;
var inst_39238__$1 = tmp39300;
var inst_39239 = inst_39246;
var state_39278__$1 = (function (){var statearr_39305 = state_39278;
(statearr_39305[(14)] = inst_39251);

(statearr_39305[(7)] = inst_39239);

(statearr_39305[(8)] = inst_39238__$1);

return statearr_39305;
})();
var statearr_39306_40953 = state_39278__$1;
(statearr_39306_40953[(2)] = null);

(statearr_39306_40953[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__36880__auto__ = null;
var cljs$core$async$state_machine__36880__auto____0 = (function (){
var statearr_39310 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39310[(0)] = cljs$core$async$state_machine__36880__auto__);

(statearr_39310[(1)] = (1));

return statearr_39310;
});
var cljs$core$async$state_machine__36880__auto____1 = (function (state_39278){
while(true){
var ret_value__36881__auto__ = (function (){try{while(true){
var result__36882__auto__ = switch__36879__auto__(state_39278);
if(cljs.core.keyword_identical_QMARK_(result__36882__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__36882__auto__;
}
break;
}
}catch (e39311){if((e39311 instanceof Object)){
var ex__36883__auto__ = e39311;
var statearr_39312_40969 = state_39278;
(statearr_39312_40969[(5)] = ex__36883__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_39278);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e39311;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__36881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40972 = state_39278;
state_39278 = G__40972;
continue;
} else {
return ret_value__36881__auto__;
}
break;
}
});
cljs$core$async$state_machine__36880__auto__ = function(state_39278){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__36880__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__36880__auto____1.call(this,state_39278);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__36880__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__36880__auto____0;
cljs$core$async$state_machine__36880__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__36880__auto____1;
return cljs$core$async$state_machine__36880__auto__;
})()
})();
var state__37100__auto__ = (function (){var statearr_39313 = f__37099__auto__();
(statearr_39313[(6)] = c__37098__auto___40894);

return statearr_39313;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__37100__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
