goog.provide('shadow.dom');
goog.require('cljs.core');
goog.require('goog.dom');
goog.require('goog.dom.forms');
goog.require('goog.dom.classlist');
goog.require('goog.style');
goog.require('goog.style.transition');
goog.require('goog.string');
goog.require('clojure.string');
goog.require('cljs.core.async');
shadow.dom.transition_supported_QMARK_ = (((typeof window !== 'undefined'))?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
var x__4433__auto__ = (((this$ == null))?null:this$);
var m__4434__auto__ = (shadow.dom._to_dom[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4434__auto__.call(null,this$));
} else {
var m__4431__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4431__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
var x__4433__auto__ = (((this$ == null))?null:this$);
var m__4434__auto__ = (shadow.dom._to_svg[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4434__auto__.call(null,this$));
} else {
var m__4431__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4431__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__42783 = coll;
var G__42784 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__42783,G__42784) : shadow.dom.lazy_native_coll_seq.call(null,G__42783,G__42784));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
});

shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
});

shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__4131__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return not_found;
}
});

shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
});

shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
});

shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL;

shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
});

shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
});

shadow.dom.NativeColl.cljs$lang$type = true;

shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl";

shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"shadow.dom/NativeColl");
});

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__42821 = arguments.length;
switch (G__42821) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
});

shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
});

shadow.dom.query_one.cljs$lang$maxFixedArity = 2;

shadow.dom.query = (function shadow$dom$query(var_args){
var G__42832 = arguments.length;
switch (G__42832) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
});

shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
});

shadow.dom.query.cljs$lang$maxFixedArity = 2;

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__42841 = arguments.length;
switch (G__42841) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
});

shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
});

shadow.dom.by_id.cljs$lang$maxFixedArity = 2;

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__42850 = arguments.length;
switch (G__42850) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
e.cancelBubble = true;

e.returnValue = false;
}

return e;
});

shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
});

shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
});

shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4;

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__42858 = arguments.length;
switch (G__42858) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
var G__42870 = document;
var G__42871 = shadow.dom.dom_node(el);
return goog.dom.contains(G__42870,G__42871);
});

shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
var G__42873 = shadow.dom.dom_node(parent);
var G__42874 = shadow.dom.dom_node(el);
return goog.dom.contains(G__42873,G__42874);
});

shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2;

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
var G__42876 = shadow.dom.dom_node(el);
var G__42877 = cls;
return goog.dom.classlist.add(G__42876,G__42877);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
var G__42879 = shadow.dom.dom_node(el);
var G__42880 = cls;
return goog.dom.classlist.remove(G__42879,G__42880);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__42886 = arguments.length;
switch (G__42886) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
var G__42888 = shadow.dom.dom_node(el);
var G__42889 = cls;
return goog.dom.classlist.toggle(G__42888,G__42889);
});

shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
});

shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3;

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__4131__auto__ = (!((typeof document !== 'undefined')));
if(or__4131__auto__){
return or__4131__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e42896){if((e42896 instanceof Object)){
var e = e42896;
return console.log("didnt support attachEvent",el,e);
} else {
throw e42896;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__4131__auto__ = (!((typeof document !== 'undefined')));
if(or__4131__auto__){
return or__4131__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__42909 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__42910 = null;
var count__42911 = (0);
var i__42912 = (0);
while(true){
if((i__42912 < count__42911)){
var el = chunk__42910.cljs$core$IIndexed$_nth$arity$2(null,i__42912);
var handler_43943__$1 = ((function (seq__42909,chunk__42910,count__42911,i__42912,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__42909,chunk__42910,count__42911,i__42912,el))
;
var G__42930_43945 = el;
var G__42931_43946 = cljs.core.name(ev);
var G__42932_43947 = handler_43943__$1;
(shadow.dom.dom_listen.cljs$core$IFn$_invoke$arity$3 ? shadow.dom.dom_listen.cljs$core$IFn$_invoke$arity$3(G__42930_43945,G__42931_43946,G__42932_43947) : shadow.dom.dom_listen.call(null,G__42930_43945,G__42931_43946,G__42932_43947));


var G__43949 = seq__42909;
var G__43950 = chunk__42910;
var G__43951 = count__42911;
var G__43952 = (i__42912 + (1));
seq__42909 = G__43949;
chunk__42910 = G__43950;
count__42911 = G__43951;
i__42912 = G__43952;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__42909);
if(temp__5735__auto__){
var seq__42909__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__42909__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__42909__$1);
var G__43953 = cljs.core.chunk_rest(seq__42909__$1);
var G__43954 = c__4550__auto__;
var G__43955 = cljs.core.count(c__4550__auto__);
var G__43956 = (0);
seq__42909 = G__43953;
chunk__42910 = G__43954;
count__42911 = G__43955;
i__42912 = G__43956;
continue;
} else {
var el = cljs.core.first(seq__42909__$1);
var handler_43957__$1 = ((function (seq__42909,chunk__42910,count__42911,i__42912,el,seq__42909__$1,temp__5735__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__42909,chunk__42910,count__42911,i__42912,el,seq__42909__$1,temp__5735__auto__))
;
var G__42941_43959 = el;
var G__42942_43960 = cljs.core.name(ev);
var G__42943_43961 = handler_43957__$1;
(shadow.dom.dom_listen.cljs$core$IFn$_invoke$arity$3 ? shadow.dom.dom_listen.cljs$core$IFn$_invoke$arity$3(G__42941_43959,G__42942_43960,G__42943_43961) : shadow.dom.dom_listen.call(null,G__42941_43959,G__42942_43960,G__42943_43961));


var G__43963 = cljs.core.next(seq__42909__$1);
var G__43964 = null;
var G__43965 = (0);
var G__43966 = (0);
seq__42909 = G__43963;
chunk__42910 = G__43964;
count__42911 = G__43965;
i__42912 = G__43966;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__42953 = arguments.length;
switch (G__42953) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
});

shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
var G__42963 = shadow.dom.dom_node(el);
var G__42964 = cljs.core.name(ev);
var G__42965 = handler__$1;
return (shadow.dom.dom_listen.cljs$core$IFn$_invoke$arity$3 ? shadow.dom.dom_listen.cljs$core$IFn$_invoke$arity$3(G__42963,G__42964,G__42965) : shadow.dom.dom_listen.call(null,G__42963,G__42964,G__42965));
}
});

shadow.dom.on.cljs$lang$maxFixedArity = 4;

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
var G__42967 = shadow.dom.dom_node(el);
var G__42968 = cljs.core.name(ev);
var G__42969 = handler;
return (shadow.dom.dom_listen_remove.cljs$core$IFn$_invoke$arity$3 ? shadow.dom.dom_listen_remove.cljs$core$IFn$_invoke$arity$3(G__42967,G__42968,G__42969) : shadow.dom.dom_listen_remove.call(null,G__42967,G__42968,G__42969));
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__42971 = cljs.core.seq(events);
var chunk__42972 = null;
var count__42973 = (0);
var i__42974 = (0);
while(true){
if((i__42974 < count__42973)){
var vec__42989 = chunk__42972.cljs$core$IIndexed$_nth$arity$2(null,i__42974);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42989,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42989,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__43971 = seq__42971;
var G__43972 = chunk__42972;
var G__43973 = count__42973;
var G__43974 = (i__42974 + (1));
seq__42971 = G__43971;
chunk__42972 = G__43972;
count__42973 = G__43973;
i__42974 = G__43974;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__42971);
if(temp__5735__auto__){
var seq__42971__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__42971__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__42971__$1);
var G__43976 = cljs.core.chunk_rest(seq__42971__$1);
var G__43977 = c__4550__auto__;
var G__43978 = cljs.core.count(c__4550__auto__);
var G__43979 = (0);
seq__42971 = G__43976;
chunk__42972 = G__43977;
count__42973 = G__43978;
i__42974 = G__43979;
continue;
} else {
var vec__42994 = cljs.core.first(seq__42971__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42994,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42994,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__43981 = cljs.core.next(seq__42971__$1);
var G__43982 = null;
var G__43983 = (0);
var G__43984 = (0);
seq__42971 = G__43981;
chunk__42972 = G__43982;
count__42973 = G__43983;
i__42974 = G__43984;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__43003 = cljs.core.seq(styles);
var chunk__43004 = null;
var count__43005 = (0);
var i__43006 = (0);
while(true){
if((i__43006 < count__43005)){
var vec__43040 = chunk__43004.cljs$core$IIndexed$_nth$arity$2(null,i__43006);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43040,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43040,(1),null);
var G__43043_43988 = dom;
var G__43044_43989 = cljs.core.name(k);
var G__43045_43990 = (((v == null))?"":v);
goog.style.setStyle(G__43043_43988,G__43044_43989,G__43045_43990);


var G__43992 = seq__43003;
var G__43993 = chunk__43004;
var G__43994 = count__43005;
var G__43995 = (i__43006 + (1));
seq__43003 = G__43992;
chunk__43004 = G__43993;
count__43005 = G__43994;
i__43006 = G__43995;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__43003);
if(temp__5735__auto__){
var seq__43003__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__43003__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__43003__$1);
var G__43996 = cljs.core.chunk_rest(seq__43003__$1);
var G__43997 = c__4550__auto__;
var G__43998 = cljs.core.count(c__4550__auto__);
var G__43999 = (0);
seq__43003 = G__43996;
chunk__43004 = G__43997;
count__43005 = G__43998;
i__43006 = G__43999;
continue;
} else {
var vec__43047 = cljs.core.first(seq__43003__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43047,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43047,(1),null);
var G__43050_44002 = dom;
var G__43051_44003 = cljs.core.name(k);
var G__43052_44004 = (((v == null))?"":v);
goog.style.setStyle(G__43050_44002,G__43051_44003,G__43052_44004);


var G__44006 = cljs.core.next(seq__43003__$1);
var G__44007 = null;
var G__44008 = (0);
var G__44009 = (0);
seq__43003 = G__44006;
chunk__43004 = G__44007;
count__43005 = G__44008;
i__43006 = G__44009;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__43059_44010 = key;
var G__43059_44011__$1 = (((G__43059_44010 instanceof cljs.core.Keyword))?G__43059_44010.fqn:null);
switch (G__43059_44011__$1) {
case "id":
el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value);

break;
case "class":
el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value);

break;
case "for":
el.htmlFor = value;

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_44018 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__4131__auto__ = goog.string.startsWith(ks_44018,"data-");
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return goog.string.startsWith(ks_44018,"aria-");
}
})())){
el.setAttribute(ks_44018,value);
} else {
(el[ks_44018] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
var G__43064 = shadow.dom.dom_node(el);
var G__43065 = cls;
return goog.dom.classlist.contains(G__43064,G__43065);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__43073){
var map__43074 = p__43073;
var map__43074__$1 = (((((!((map__43074 == null))))?(((((map__43074.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43074.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__43074):map__43074);
var props = map__43074__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43074__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__43077 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43077,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43077,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43077,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__43080 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__43080,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__43080;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__43082 = arguments.length;
switch (G__43082) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5735__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5735__auto__)){
var n = temp__5735__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
});

shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5735__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5735__auto__)){
var n = temp__5735__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
});

shadow.dom.append.cljs$lang$maxFixedArity = 2;

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__43090){
var vec__43091 = p__43090;
var seq__43092 = cljs.core.seq(vec__43091);
var first__43093 = cljs.core.first(seq__43092);
var seq__43092__$1 = cljs.core.next(seq__43092);
var nn = first__43093;
var first__43093__$1 = cljs.core.first(seq__43092__$1);
var seq__43092__$2 = cljs.core.next(seq__43092__$1);
var np = first__43093__$1;
var nc = seq__43092__$2;
var node = vec__43091;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__43094 = nn;
var G__43095 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__43094,G__43095) : create_fn.call(null,G__43094,G__43095));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__43096 = nn;
var G__43097 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__43096,G__43097) : create_fn.call(null,G__43096,G__43097));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__43098 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43098,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43098,(1),null);
var seq__43101_44042 = cljs.core.seq(node_children);
var chunk__43102_44043 = null;
var count__43103_44044 = (0);
var i__43104_44045 = (0);
while(true){
if((i__43104_44045 < count__43103_44044)){
var child_struct_44047 = chunk__43102_44043.cljs$core$IIndexed$_nth$arity$2(null,i__43104_44045);
var children_44048 = shadow.dom.dom_node(child_struct_44047);
if(cljs.core.seq_QMARK_(children_44048)){
var seq__43140_44050 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_44048));
var chunk__43142_44051 = null;
var count__43143_44052 = (0);
var i__43144_44053 = (0);
while(true){
if((i__43144_44053 < count__43143_44052)){
var child_44056 = chunk__43142_44051.cljs$core$IIndexed$_nth$arity$2(null,i__43144_44053);
if(cljs.core.truth_(child_44056)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_44056);


var G__44058 = seq__43140_44050;
var G__44059 = chunk__43142_44051;
var G__44060 = count__43143_44052;
var G__44061 = (i__43144_44053 + (1));
seq__43140_44050 = G__44058;
chunk__43142_44051 = G__44059;
count__43143_44052 = G__44060;
i__43144_44053 = G__44061;
continue;
} else {
var G__44062 = seq__43140_44050;
var G__44063 = chunk__43142_44051;
var G__44064 = count__43143_44052;
var G__44065 = (i__43144_44053 + (1));
seq__43140_44050 = G__44062;
chunk__43142_44051 = G__44063;
count__43143_44052 = G__44064;
i__43144_44053 = G__44065;
continue;
}
} else {
var temp__5735__auto___44066 = cljs.core.seq(seq__43140_44050);
if(temp__5735__auto___44066){
var seq__43140_44067__$1 = temp__5735__auto___44066;
if(cljs.core.chunked_seq_QMARK_(seq__43140_44067__$1)){
var c__4550__auto___44068 = cljs.core.chunk_first(seq__43140_44067__$1);
var G__44069 = cljs.core.chunk_rest(seq__43140_44067__$1);
var G__44070 = c__4550__auto___44068;
var G__44071 = cljs.core.count(c__4550__auto___44068);
var G__44072 = (0);
seq__43140_44050 = G__44069;
chunk__43142_44051 = G__44070;
count__43143_44052 = G__44071;
i__43144_44053 = G__44072;
continue;
} else {
var child_44073 = cljs.core.first(seq__43140_44067__$1);
if(cljs.core.truth_(child_44073)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_44073);


var G__44076 = cljs.core.next(seq__43140_44067__$1);
var G__44077 = null;
var G__44078 = (0);
var G__44079 = (0);
seq__43140_44050 = G__44076;
chunk__43142_44051 = G__44077;
count__43143_44052 = G__44078;
i__43144_44053 = G__44079;
continue;
} else {
var G__44081 = cljs.core.next(seq__43140_44067__$1);
var G__44082 = null;
var G__44083 = (0);
var G__44084 = (0);
seq__43140_44050 = G__44081;
chunk__43142_44051 = G__44082;
count__43143_44052 = G__44083;
i__43144_44053 = G__44084;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_44048);
}


var G__44085 = seq__43101_44042;
var G__44086 = chunk__43102_44043;
var G__44087 = count__43103_44044;
var G__44088 = (i__43104_44045 + (1));
seq__43101_44042 = G__44085;
chunk__43102_44043 = G__44086;
count__43103_44044 = G__44087;
i__43104_44045 = G__44088;
continue;
} else {
var temp__5735__auto___44089 = cljs.core.seq(seq__43101_44042);
if(temp__5735__auto___44089){
var seq__43101_44090__$1 = temp__5735__auto___44089;
if(cljs.core.chunked_seq_QMARK_(seq__43101_44090__$1)){
var c__4550__auto___44091 = cljs.core.chunk_first(seq__43101_44090__$1);
var G__44093 = cljs.core.chunk_rest(seq__43101_44090__$1);
var G__44094 = c__4550__auto___44091;
var G__44095 = cljs.core.count(c__4550__auto___44091);
var G__44096 = (0);
seq__43101_44042 = G__44093;
chunk__43102_44043 = G__44094;
count__43103_44044 = G__44095;
i__43104_44045 = G__44096;
continue;
} else {
var child_struct_44098 = cljs.core.first(seq__43101_44090__$1);
var children_44100 = shadow.dom.dom_node(child_struct_44098);
if(cljs.core.seq_QMARK_(children_44100)){
var seq__43149_44102 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_44100));
var chunk__43151_44103 = null;
var count__43152_44104 = (0);
var i__43153_44105 = (0);
while(true){
if((i__43153_44105 < count__43152_44104)){
var child_44107 = chunk__43151_44103.cljs$core$IIndexed$_nth$arity$2(null,i__43153_44105);
if(cljs.core.truth_(child_44107)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_44107);


var G__44110 = seq__43149_44102;
var G__44111 = chunk__43151_44103;
var G__44112 = count__43152_44104;
var G__44113 = (i__43153_44105 + (1));
seq__43149_44102 = G__44110;
chunk__43151_44103 = G__44111;
count__43152_44104 = G__44112;
i__43153_44105 = G__44113;
continue;
} else {
var G__44114 = seq__43149_44102;
var G__44115 = chunk__43151_44103;
var G__44116 = count__43152_44104;
var G__44117 = (i__43153_44105 + (1));
seq__43149_44102 = G__44114;
chunk__43151_44103 = G__44115;
count__43152_44104 = G__44116;
i__43153_44105 = G__44117;
continue;
}
} else {
var temp__5735__auto___44118__$1 = cljs.core.seq(seq__43149_44102);
if(temp__5735__auto___44118__$1){
var seq__43149_44119__$1 = temp__5735__auto___44118__$1;
if(cljs.core.chunked_seq_QMARK_(seq__43149_44119__$1)){
var c__4550__auto___44120 = cljs.core.chunk_first(seq__43149_44119__$1);
var G__44121 = cljs.core.chunk_rest(seq__43149_44119__$1);
var G__44122 = c__4550__auto___44120;
var G__44123 = cljs.core.count(c__4550__auto___44120);
var G__44124 = (0);
seq__43149_44102 = G__44121;
chunk__43151_44103 = G__44122;
count__43152_44104 = G__44123;
i__43153_44105 = G__44124;
continue;
} else {
var child_44127 = cljs.core.first(seq__43149_44119__$1);
if(cljs.core.truth_(child_44127)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_44127);


var G__44129 = cljs.core.next(seq__43149_44119__$1);
var G__44130 = null;
var G__44131 = (0);
var G__44132 = (0);
seq__43149_44102 = G__44129;
chunk__43151_44103 = G__44130;
count__43152_44104 = G__44131;
i__43153_44105 = G__44132;
continue;
} else {
var G__44133 = cljs.core.next(seq__43149_44119__$1);
var G__44134 = null;
var G__44135 = (0);
var G__44136 = (0);
seq__43149_44102 = G__44133;
chunk__43151_44103 = G__44134;
count__43152_44104 = G__44135;
i__43153_44105 = G__44136;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_44100);
}


var G__44139 = cljs.core.next(seq__43101_44090__$1);
var G__44140 = null;
var G__44141 = (0);
var G__44142 = (0);
seq__43101_44042 = G__44139;
chunk__43102_44043 = G__44140;
count__43103_44044 = G__44141;
i__43104_44045 = G__44142;
continue;
}
} else {
}
}
break;
}

return node;
});
cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
});

cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
});

cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
});
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL;

HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
});
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL;

DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
});
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
var G__43163 = shadow.dom.dom_node(node);
return goog.dom.removeChildren(G__43163);
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__43165 = cljs.core.seq(node);
var chunk__43166 = null;
var count__43167 = (0);
var i__43168 = (0);
while(true){
if((i__43168 < count__43167)){
var n = chunk__43166.cljs$core$IIndexed$_nth$arity$2(null,i__43168);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__44152 = seq__43165;
var G__44153 = chunk__43166;
var G__44154 = count__43167;
var G__44155 = (i__43168 + (1));
seq__43165 = G__44152;
chunk__43166 = G__44153;
count__43167 = G__44154;
i__43168 = G__44155;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__43165);
if(temp__5735__auto__){
var seq__43165__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__43165__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__43165__$1);
var G__44156 = cljs.core.chunk_rest(seq__43165__$1);
var G__44157 = c__4550__auto__;
var G__44158 = cljs.core.count(c__4550__auto__);
var G__44159 = (0);
seq__43165 = G__44156;
chunk__43166 = G__44157;
count__43167 = G__44158;
i__43168 = G__44159;
continue;
} else {
var n = cljs.core.first(seq__43165__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__44162 = cljs.core.next(seq__43165__$1);
var G__44163 = null;
var G__44164 = (0);
var G__44165 = (0);
seq__43165 = G__44162;
chunk__43166 = G__44163;
count__43167 = G__44164;
i__43168 = G__44165;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
var G__43172 = shadow.dom.dom_node(new$);
var G__43173 = shadow.dom.dom_node(old);
return goog.dom.replaceNode(G__43172,G__43173);
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__43178 = arguments.length;
switch (G__43178) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return shadow.dom.dom_node(el).innerText = new_text;
});

shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
});

shadow.dom.text.cljs$lang$maxFixedArity = 2;

shadow.dom.check = (function shadow$dom$check(var_args){
var G__43180 = arguments.length;
switch (G__43180) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
});

shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return shadow.dom.dom_node(el).checked = checked;
});

shadow.dom.check.cljs$lang$maxFixedArity = 2;

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__43185 = arguments.length;
switch (G__43185) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
});

shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__4131__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return default$;
}
});

shadow.dom.attr.cljs$lang$maxFixedArity = 3;

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.name(key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.name(key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return shadow.dom.dom_node(node).innerHTML = text;
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__4736__auto__ = [];
var len__4730__auto___44183 = arguments.length;
var i__4731__auto___44184 = (0);
while(true){
if((i__4731__auto___44184 < len__4730__auto___44183)){
args__4736__auto__.push((arguments[i__4731__auto___44184]));

var G__44185 = (i__4731__auto___44184 + (1));
i__4731__auto___44184 = G__44185;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__43200_44186 = cljs.core.seq(nodes);
var chunk__43201_44187 = null;
var count__43202_44188 = (0);
var i__43203_44189 = (0);
while(true){
if((i__43203_44189 < count__43202_44188)){
var node_44190 = chunk__43201_44187.cljs$core$IIndexed$_nth$arity$2(null,i__43203_44189);
fragment.appendChild(shadow.dom._to_dom(node_44190));


var G__44191 = seq__43200_44186;
var G__44192 = chunk__43201_44187;
var G__44193 = count__43202_44188;
var G__44194 = (i__43203_44189 + (1));
seq__43200_44186 = G__44191;
chunk__43201_44187 = G__44192;
count__43202_44188 = G__44193;
i__43203_44189 = G__44194;
continue;
} else {
var temp__5735__auto___44195 = cljs.core.seq(seq__43200_44186);
if(temp__5735__auto___44195){
var seq__43200_44197__$1 = temp__5735__auto___44195;
if(cljs.core.chunked_seq_QMARK_(seq__43200_44197__$1)){
var c__4550__auto___44199 = cljs.core.chunk_first(seq__43200_44197__$1);
var G__44200 = cljs.core.chunk_rest(seq__43200_44197__$1);
var G__44201 = c__4550__auto___44199;
var G__44202 = cljs.core.count(c__4550__auto___44199);
var G__44203 = (0);
seq__43200_44186 = G__44200;
chunk__43201_44187 = G__44201;
count__43202_44188 = G__44202;
i__43203_44189 = G__44203;
continue;
} else {
var node_44204 = cljs.core.first(seq__43200_44197__$1);
fragment.appendChild(shadow.dom._to_dom(node_44204));


var G__44205 = cljs.core.next(seq__43200_44197__$1);
var G__44206 = null;
var G__44207 = (0);
var G__44208 = (0);
seq__43200_44186 = G__44205;
chunk__43201_44187 = G__44206;
count__43202_44188 = G__44207;
i__43203_44189 = G__44208;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
});

shadow.dom.fragment.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
shadow.dom.fragment.cljs$lang$applyTo = (function (seq43196){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq43196));
});

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__43216_44210 = cljs.core.seq(scripts);
var chunk__43217_44211 = null;
var count__43218_44212 = (0);
var i__43219_44213 = (0);
while(true){
if((i__43219_44213 < count__43218_44212)){
var vec__43226_44215 = chunk__43217_44211.cljs$core$IIndexed$_nth$arity$2(null,i__43219_44213);
var script_tag_44216 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43226_44215,(0),null);
var script_body_44217 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43226_44215,(1),null);
eval(script_body_44217);


var G__44219 = seq__43216_44210;
var G__44220 = chunk__43217_44211;
var G__44221 = count__43218_44212;
var G__44222 = (i__43219_44213 + (1));
seq__43216_44210 = G__44219;
chunk__43217_44211 = G__44220;
count__43218_44212 = G__44221;
i__43219_44213 = G__44222;
continue;
} else {
var temp__5735__auto___44223 = cljs.core.seq(seq__43216_44210);
if(temp__5735__auto___44223){
var seq__43216_44224__$1 = temp__5735__auto___44223;
if(cljs.core.chunked_seq_QMARK_(seq__43216_44224__$1)){
var c__4550__auto___44226 = cljs.core.chunk_first(seq__43216_44224__$1);
var G__44227 = cljs.core.chunk_rest(seq__43216_44224__$1);
var G__44228 = c__4550__auto___44226;
var G__44229 = cljs.core.count(c__4550__auto___44226);
var G__44230 = (0);
seq__43216_44210 = G__44227;
chunk__43217_44211 = G__44228;
count__43218_44212 = G__44229;
i__43219_44213 = G__44230;
continue;
} else {
var vec__43231_44231 = cljs.core.first(seq__43216_44224__$1);
var script_tag_44232 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43231_44231,(0),null);
var script_body_44233 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43231_44231,(1),null);
eval(script_body_44233);


var G__44234 = cljs.core.next(seq__43216_44224__$1);
var G__44235 = null;
var G__44236 = (0);
var G__44237 = (0);
seq__43216_44210 = G__44234;
chunk__43217_44211 = G__44235;
count__43218_44212 = G__44236;
i__43219_44213 = G__44237;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (scripts){
return (function (s__$1,p__43235){
var vec__43237 = p__43235;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43237,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43237,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
});})(scripts))
,s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
el.innerHTML = s;

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
var G__43242 = shadow.dom.dom_node(el);
var G__43243 = cls;
return goog.dom.getAncestorByClass(G__43242,G__43243);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__43247 = arguments.length;
switch (G__43247) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
var G__43252 = shadow.dom.dom_node(el);
var G__43253 = cljs.core.name(tag);
return goog.dom.getAncestorByTagNameAndClass(G__43252,G__43253);
});

shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
var G__43254 = shadow.dom.dom_node(el);
var G__43255 = cljs.core.name(tag);
var G__43256 = cljs.core.name(cls);
return goog.dom.getAncestorByTagNameAndClass(G__43254,G__43255,G__43256);
});

shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3;

shadow.dom.get_value = (function shadow$dom$get_value(dom){
var G__43257 = shadow.dom.dom_node(dom);
return goog.dom.forms.getValue(G__43257);
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
var G__43260 = shadow.dom.dom_node(dom);
var G__43261 = value;
return goog.dom.forms.setValue(G__43260,G__43261);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__43270 = cljs.core.seq(style_keys);
var chunk__43271 = null;
var count__43272 = (0);
var i__43273 = (0);
while(true){
if((i__43273 < count__43272)){
var it = chunk__43271.cljs$core$IIndexed$_nth$arity$2(null,i__43273);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__44257 = seq__43270;
var G__44258 = chunk__43271;
var G__44259 = count__43272;
var G__44260 = (i__43273 + (1));
seq__43270 = G__44257;
chunk__43271 = G__44258;
count__43272 = G__44259;
i__43273 = G__44260;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__43270);
if(temp__5735__auto__){
var seq__43270__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__43270__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__43270__$1);
var G__44261 = cljs.core.chunk_rest(seq__43270__$1);
var G__44262 = c__4550__auto__;
var G__44263 = cljs.core.count(c__4550__auto__);
var G__44264 = (0);
seq__43270 = G__44261;
chunk__43271 = G__44262;
count__43272 = G__44263;
i__43273 = G__44264;
continue;
} else {
var it = cljs.core.first(seq__43270__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__44266 = cljs.core.next(seq__43270__$1);
var G__44267 = null;
var G__44268 = (0);
var G__44269 = (0);
seq__43270 = G__44266;
chunk__43271 = G__44267;
count__43272 = G__44268;
i__43273 = G__44269;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4385__auto__,k__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
return this__4385__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4386__auto__,null);
});

shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4387__auto__,k43294,else__4388__auto__){
var self__ = this;
var this__4387__auto____$1 = this;
var G__43313 = k43294;
var G__43313__$1 = (((G__43313 instanceof cljs.core.Keyword))?G__43313.fqn:null);
switch (G__43313__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k43294,else__4388__auto__);

}
});

shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4404__auto__,f__4405__auto__,init__4406__auto__){
var self__ = this;
var this__4404__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (this__4404__auto____$1){
return (function (ret__4407__auto__,p__43326){
var vec__43328 = p__43326;
var k__4408__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43328,(0),null);
var v__4409__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43328,(1),null);
return (f__4405__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4405__auto__.cljs$core$IFn$_invoke$arity$3(ret__4407__auto__,k__4408__auto__,v__4409__auto__) : f__4405__auto__.call(null,ret__4407__auto__,k__4408__auto__,v__4409__auto__));
});})(this__4404__auto____$1))
,init__4406__auto__,this__4404__auto____$1);
});

shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4399__auto__,writer__4400__auto__,opts__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
var pr_pair__4402__auto__ = ((function (this__4399__auto____$1){
return (function (keyval__4403__auto__){
return cljs.core.pr_sequential_writer(writer__4400__auto__,cljs.core.pr_writer,""," ","",opts__4401__auto__,keyval__4403__auto__);
});})(this__4399__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__4400__auto__,pr_pair__4402__auto__,"#shadow.dom.Coordinate{",", ","}",opts__4401__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
});

shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__43293){
var self__ = this;
var G__43293__$1 = this;
return (new cljs.core.RecordIter((0),G__43293__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
});

shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4383__auto__){
var self__ = this;
var this__4383__auto____$1 = this;
return self__.__meta;
});

shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4380__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
});

shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4389__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
});

shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4381__auto__){
var self__ = this;
var this__4381__auto____$1 = this;
var h__4243__auto__ = self__.__hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = (function (){var fexpr__43372 = ((function (h__4243__auto__,this__4381__auto____$1){
return (function (coll__4382__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__4382__auto__));
});})(h__4243__auto__,this__4381__auto____$1))
;
return fexpr__43372(this__4381__auto____$1);
})();
self__.__hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this43295,other43296){
var self__ = this;
var this43295__$1 = this;
return (((!((other43296 == null)))) && ((this43295__$1.constructor === other43296.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43295__$1.x,other43296.x)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43295__$1.y,other43296.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43295__$1.__extmap,other43296.__extmap)));
});

shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4394__auto__,k__4395__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__4395__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4394__auto____$1),self__.__meta),k__4395__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4395__auto__)),null));
}
});

shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4392__auto__,k__4393__auto__,G__43293){
var self__ = this;
var this__4392__auto____$1 = this;
var pred__43382 = cljs.core.keyword_identical_QMARK_;
var expr__43383 = k__4393__auto__;
if(cljs.core.truth_((function (){var G__43385 = new cljs.core.Keyword(null,"x","x",2099068185);
var G__43386 = expr__43383;
return (pred__43382.cljs$core$IFn$_invoke$arity$2 ? pred__43382.cljs$core$IFn$_invoke$arity$2(G__43385,G__43386) : pred__43382.call(null,G__43385,G__43386));
})())){
return (new shadow.dom.Coordinate(G__43293,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43387 = new cljs.core.Keyword(null,"y","y",-1757859776);
var G__43388 = expr__43383;
return (pred__43382.cljs$core$IFn$_invoke$arity$2 ? pred__43382.cljs$core$IFn$_invoke$arity$2(G__43387,G__43388) : pred__43382.call(null,G__43387,G__43388));
})())){
return (new shadow.dom.Coordinate(self__.x,G__43293,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4393__auto__,G__43293),null));
}
}
});

shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4397__auto__){
var self__ = this;
var this__4397__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
});

shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4384__auto__,G__43293){
var self__ = this;
var this__4384__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__43293,self__.__extmap,self__.__hash));
});

shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4390__auto__,entry__4391__auto__){
var self__ = this;
var this__4390__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4391__auto__)){
return this__4390__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4391__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4391__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4390__auto____$1,entry__4391__auto__);
}
});

shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
});

shadow.dom.Coordinate.cljs$lang$type = true;

shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__4428__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
});

shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__){
return cljs.core._write(writer__4429__auto__,"shadow.dom/Coordinate");
});

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__43297){
var extmap__4424__auto__ = (function (){var G__43416 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__43297,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__43297)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__43416);
} else {
return G__43416;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__43297),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__43297),null,cljs.core.not_empty(extmap__4424__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = (function (){var G__43419 = shadow.dom.dom_node(el);
return goog.style.getPosition(G__43419);
})();
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = (function (){var G__43422 = shadow.dom.dom_node(el);
return goog.style.getClientPosition(G__43422);
})();
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = (function (){var G__43425 = shadow.dom.dom_node(el);
return goog.style.getPageOffset(G__43425);
})();
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4385__auto__,k__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
return this__4385__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4386__auto__,null);
});

shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4387__auto__,k43434,else__4388__auto__){
var self__ = this;
var this__4387__auto____$1 = this;
var G__43462 = k43434;
var G__43462__$1 = (((G__43462 instanceof cljs.core.Keyword))?G__43462.fqn:null);
switch (G__43462__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k43434,else__4388__auto__);

}
});

shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4404__auto__,f__4405__auto__,init__4406__auto__){
var self__ = this;
var this__4404__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (this__4404__auto____$1){
return (function (ret__4407__auto__,p__43475){
var vec__43477 = p__43475;
var k__4408__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43477,(0),null);
var v__4409__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43477,(1),null);
return (f__4405__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4405__auto__.cljs$core$IFn$_invoke$arity$3(ret__4407__auto__,k__4408__auto__,v__4409__auto__) : f__4405__auto__.call(null,ret__4407__auto__,k__4408__auto__,v__4409__auto__));
});})(this__4404__auto____$1))
,init__4406__auto__,this__4404__auto____$1);
});

shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4399__auto__,writer__4400__auto__,opts__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
var pr_pair__4402__auto__ = ((function (this__4399__auto____$1){
return (function (keyval__4403__auto__){
return cljs.core.pr_sequential_writer(writer__4400__auto__,cljs.core.pr_writer,""," ","",opts__4401__auto__,keyval__4403__auto__);
});})(this__4399__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__4400__auto__,pr_pair__4402__auto__,"#shadow.dom.Size{",", ","}",opts__4401__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
});

shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__43433){
var self__ = this;
var G__43433__$1 = this;
return (new cljs.core.RecordIter((0),G__43433__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
});

shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4383__auto__){
var self__ = this;
var this__4383__auto____$1 = this;
return self__.__meta;
});

shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4380__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
});

shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4389__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
});

shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4381__auto__){
var self__ = this;
var this__4381__auto____$1 = this;
var h__4243__auto__ = self__.__hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = (function (){var fexpr__43521 = ((function (h__4243__auto__,this__4381__auto____$1){
return (function (coll__4382__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__4382__auto__));
});})(h__4243__auto__,this__4381__auto____$1))
;
return fexpr__43521(this__4381__auto____$1);
})();
self__.__hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this43435,other43436){
var self__ = this;
var this43435__$1 = this;
return (((!((other43436 == null)))) && ((this43435__$1.constructor === other43436.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43435__$1.w,other43436.w)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43435__$1.h,other43436.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43435__$1.__extmap,other43436.__extmap)));
});

shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4394__auto__,k__4395__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__4395__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4394__auto____$1),self__.__meta),k__4395__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4395__auto__)),null));
}
});

shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4392__auto__,k__4393__auto__,G__43433){
var self__ = this;
var this__4392__auto____$1 = this;
var pred__43548 = cljs.core.keyword_identical_QMARK_;
var expr__43549 = k__4393__auto__;
if(cljs.core.truth_((function (){var G__43556 = new cljs.core.Keyword(null,"w","w",354169001);
var G__43557 = expr__43549;
return (pred__43548.cljs$core$IFn$_invoke$arity$2 ? pred__43548.cljs$core$IFn$_invoke$arity$2(G__43556,G__43557) : pred__43548.call(null,G__43556,G__43557));
})())){
return (new shadow.dom.Size(G__43433,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43560 = new cljs.core.Keyword(null,"h","h",1109658740);
var G__43561 = expr__43549;
return (pred__43548.cljs$core$IFn$_invoke$arity$2 ? pred__43548.cljs$core$IFn$_invoke$arity$2(G__43560,G__43561) : pred__43548.call(null,G__43560,G__43561));
})())){
return (new shadow.dom.Size(self__.w,G__43433,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4393__auto__,G__43433),null));
}
}
});

shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4397__auto__){
var self__ = this;
var this__4397__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
});

shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4384__auto__,G__43433){
var self__ = this;
var this__4384__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__43433,self__.__extmap,self__.__hash));
});

shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4390__auto__,entry__4391__auto__){
var self__ = this;
var this__4390__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4391__auto__)){
return this__4390__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4391__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4391__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4390__auto____$1,entry__4391__auto__);
}
});

shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
});

shadow.dom.Size.cljs$lang$type = true;

shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__4428__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
});

shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__){
return cljs.core._write(writer__4429__auto__,"shadow.dom/Size");
});

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__43440){
var extmap__4424__auto__ = (function (){var G__43580 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__43440,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__43440)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__43580);
} else {
return G__43580;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__43440),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__43440),null,cljs.core.not_empty(extmap__4424__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj((function (){var G__43583 = shadow.dom.dom_node(el);
return goog.style.getSize(G__43583);
})());
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(shadow.dom.get_size(el));
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__4604__auto__ = opts;
var l__4605__auto__ = a__4604__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__4605__auto__)){
var G__44306 = (i + (1));
var G__44307 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__44306;
ret = G__44307;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__43597){
var vec__43598 = p__43597;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43598,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43598,(1),null);
return [cljs.core.name(k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params)))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__43604 = arguments.length;
switch (G__43604) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
});

shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
});

shadow.dom.redirect.cljs$lang$maxFixedArity = 2;

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return document.location.href = document.location.href;
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
var G__43622_44315 = new_node;
var G__43623_44316 = shadow.dom.dom_node(ref);
goog.dom.insertSiblingAfter(G__43622_44315,G__43623_44316);

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
var G__43626_44317 = new_node;
var G__43627_44318 = shadow.dom.dom_node(ref);
goog.dom.insertSiblingBefore(G__43626_44317,G__43627_44318);

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5733__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5733__auto__)){
var child = temp__5733__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__44319 = ps;
var G__44320 = (i + (1));
el__$1 = G__44319;
i = G__44320;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
var G__43639 = shadow.dom.dom_node(el);
return goog.dom.getParentElement(G__43639);
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,((function (parent){
return (function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
});})(parent))
,null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
var G__43653 = shadow.dom.dom_node(el);
return goog.dom.getNextElementSibling(G__43653);
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
var G__43654 = shadow.dom.dom_node(el);
return goog.dom.getPreviousElementSibling(G__43654);
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__43655 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43655,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43655,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43655,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__43660_44321 = cljs.core.seq(props);
var chunk__43661_44322 = null;
var count__43662_44323 = (0);
var i__43663_44324 = (0);
while(true){
if((i__43663_44324 < count__43662_44323)){
var vec__43694_44325 = chunk__43661_44322.cljs$core$IIndexed$_nth$arity$2(null,i__43663_44324);
var k_44326 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43694_44325,(0),null);
var v_44327 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43694_44325,(1),null);
el.setAttributeNS((function (){var temp__5735__auto__ = cljs.core.namespace(k_44326);
if(cljs.core.truth_(temp__5735__auto__)){
var ns = temp__5735__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_44326),v_44327);


var G__44332 = seq__43660_44321;
var G__44333 = chunk__43661_44322;
var G__44334 = count__43662_44323;
var G__44335 = (i__43663_44324 + (1));
seq__43660_44321 = G__44332;
chunk__43661_44322 = G__44333;
count__43662_44323 = G__44334;
i__43663_44324 = G__44335;
continue;
} else {
var temp__5735__auto___44336 = cljs.core.seq(seq__43660_44321);
if(temp__5735__auto___44336){
var seq__43660_44337__$1 = temp__5735__auto___44336;
if(cljs.core.chunked_seq_QMARK_(seq__43660_44337__$1)){
var c__4550__auto___44338 = cljs.core.chunk_first(seq__43660_44337__$1);
var G__44339 = cljs.core.chunk_rest(seq__43660_44337__$1);
var G__44340 = c__4550__auto___44338;
var G__44341 = cljs.core.count(c__4550__auto___44338);
var G__44342 = (0);
seq__43660_44321 = G__44339;
chunk__43661_44322 = G__44340;
count__43662_44323 = G__44341;
i__43663_44324 = G__44342;
continue;
} else {
var vec__43700_44343 = cljs.core.first(seq__43660_44337__$1);
var k_44344 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43700_44343,(0),null);
var v_44345 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43700_44343,(1),null);
el.setAttributeNS((function (){var temp__5735__auto____$1 = cljs.core.namespace(k_44344);
if(cljs.core.truth_(temp__5735__auto____$1)){
var ns = temp__5735__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_44344),v_44345);


var G__44349 = cljs.core.next(seq__43660_44337__$1);
var G__44350 = null;
var G__44351 = (0);
var G__44352 = (0);
seq__43660_44321 = G__44349;
chunk__43661_44322 = G__44350;
count__43662_44323 = G__44351;
i__43663_44324 = G__44352;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__43725 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43725,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43725,(1),null);
var seq__43729_44353 = cljs.core.seq(node_children);
var chunk__43731_44354 = null;
var count__43732_44355 = (0);
var i__43733_44356 = (0);
while(true){
if((i__43733_44356 < count__43732_44355)){
var child_struct_44357 = chunk__43731_44354.cljs$core$IIndexed$_nth$arity$2(null,i__43733_44356);
if((!((child_struct_44357 == null)))){
if(typeof child_struct_44357 === 'string'){
var text_44359 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_44359),child_struct_44357].join(''));
} else {
var children_44360 = shadow.dom.svg_node(child_struct_44357);
if(cljs.core.seq_QMARK_(children_44360)){
var seq__43833_44361 = cljs.core.seq(children_44360);
var chunk__43836_44363 = null;
var count__43837_44364 = (0);
var i__43838_44365 = (0);
while(true){
if((i__43838_44365 < count__43837_44364)){
var child_44367 = chunk__43836_44363.cljs$core$IIndexed$_nth$arity$2(null,i__43838_44365);
if(cljs.core.truth_(child_44367)){
node.appendChild(child_44367);


var G__44368 = seq__43833_44361;
var G__44369 = chunk__43836_44363;
var G__44370 = count__43837_44364;
var G__44371 = (i__43838_44365 + (1));
seq__43833_44361 = G__44368;
chunk__43836_44363 = G__44369;
count__43837_44364 = G__44370;
i__43838_44365 = G__44371;
continue;
} else {
var G__44373 = seq__43833_44361;
var G__44374 = chunk__43836_44363;
var G__44375 = count__43837_44364;
var G__44376 = (i__43838_44365 + (1));
seq__43833_44361 = G__44373;
chunk__43836_44363 = G__44374;
count__43837_44364 = G__44375;
i__43838_44365 = G__44376;
continue;
}
} else {
var temp__5735__auto___44378 = cljs.core.seq(seq__43833_44361);
if(temp__5735__auto___44378){
var seq__43833_44379__$1 = temp__5735__auto___44378;
if(cljs.core.chunked_seq_QMARK_(seq__43833_44379__$1)){
var c__4550__auto___44380 = cljs.core.chunk_first(seq__43833_44379__$1);
var G__44381 = cljs.core.chunk_rest(seq__43833_44379__$1);
var G__44382 = c__4550__auto___44380;
var G__44383 = cljs.core.count(c__4550__auto___44380);
var G__44384 = (0);
seq__43833_44361 = G__44381;
chunk__43836_44363 = G__44382;
count__43837_44364 = G__44383;
i__43838_44365 = G__44384;
continue;
} else {
var child_44385 = cljs.core.first(seq__43833_44379__$1);
if(cljs.core.truth_(child_44385)){
node.appendChild(child_44385);


var G__44386 = cljs.core.next(seq__43833_44379__$1);
var G__44387 = null;
var G__44388 = (0);
var G__44389 = (0);
seq__43833_44361 = G__44386;
chunk__43836_44363 = G__44387;
count__43837_44364 = G__44388;
i__43838_44365 = G__44389;
continue;
} else {
var G__44390 = cljs.core.next(seq__43833_44379__$1);
var G__44391 = null;
var G__44392 = (0);
var G__44394 = (0);
seq__43833_44361 = G__44390;
chunk__43836_44363 = G__44391;
count__43837_44364 = G__44392;
i__43838_44365 = G__44394;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_44360);
}
}


var G__44395 = seq__43729_44353;
var G__44396 = chunk__43731_44354;
var G__44397 = count__43732_44355;
var G__44398 = (i__43733_44356 + (1));
seq__43729_44353 = G__44395;
chunk__43731_44354 = G__44396;
count__43732_44355 = G__44397;
i__43733_44356 = G__44398;
continue;
} else {
var G__44400 = seq__43729_44353;
var G__44401 = chunk__43731_44354;
var G__44402 = count__43732_44355;
var G__44403 = (i__43733_44356 + (1));
seq__43729_44353 = G__44400;
chunk__43731_44354 = G__44401;
count__43732_44355 = G__44402;
i__43733_44356 = G__44403;
continue;
}
} else {
var temp__5735__auto___44404 = cljs.core.seq(seq__43729_44353);
if(temp__5735__auto___44404){
var seq__43729_44405__$1 = temp__5735__auto___44404;
if(cljs.core.chunked_seq_QMARK_(seq__43729_44405__$1)){
var c__4550__auto___44406 = cljs.core.chunk_first(seq__43729_44405__$1);
var G__44407 = cljs.core.chunk_rest(seq__43729_44405__$1);
var G__44408 = c__4550__auto___44406;
var G__44409 = cljs.core.count(c__4550__auto___44406);
var G__44410 = (0);
seq__43729_44353 = G__44407;
chunk__43731_44354 = G__44408;
count__43732_44355 = G__44409;
i__43733_44356 = G__44410;
continue;
} else {
var child_struct_44411 = cljs.core.first(seq__43729_44405__$1);
if((!((child_struct_44411 == null)))){
if(typeof child_struct_44411 === 'string'){
var text_44412 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_44412),child_struct_44411].join(''));
} else {
var children_44413 = shadow.dom.svg_node(child_struct_44411);
if(cljs.core.seq_QMARK_(children_44413)){
var seq__43846_44414 = cljs.core.seq(children_44413);
var chunk__43848_44415 = null;
var count__43849_44416 = (0);
var i__43850_44417 = (0);
while(true){
if((i__43850_44417 < count__43849_44416)){
var child_44418 = chunk__43848_44415.cljs$core$IIndexed$_nth$arity$2(null,i__43850_44417);
if(cljs.core.truth_(child_44418)){
node.appendChild(child_44418);


var G__44419 = seq__43846_44414;
var G__44420 = chunk__43848_44415;
var G__44421 = count__43849_44416;
var G__44422 = (i__43850_44417 + (1));
seq__43846_44414 = G__44419;
chunk__43848_44415 = G__44420;
count__43849_44416 = G__44421;
i__43850_44417 = G__44422;
continue;
} else {
var G__44423 = seq__43846_44414;
var G__44424 = chunk__43848_44415;
var G__44425 = count__43849_44416;
var G__44426 = (i__43850_44417 + (1));
seq__43846_44414 = G__44423;
chunk__43848_44415 = G__44424;
count__43849_44416 = G__44425;
i__43850_44417 = G__44426;
continue;
}
} else {
var temp__5735__auto___44427__$1 = cljs.core.seq(seq__43846_44414);
if(temp__5735__auto___44427__$1){
var seq__43846_44428__$1 = temp__5735__auto___44427__$1;
if(cljs.core.chunked_seq_QMARK_(seq__43846_44428__$1)){
var c__4550__auto___44431 = cljs.core.chunk_first(seq__43846_44428__$1);
var G__44432 = cljs.core.chunk_rest(seq__43846_44428__$1);
var G__44433 = c__4550__auto___44431;
var G__44434 = cljs.core.count(c__4550__auto___44431);
var G__44435 = (0);
seq__43846_44414 = G__44432;
chunk__43848_44415 = G__44433;
count__43849_44416 = G__44434;
i__43850_44417 = G__44435;
continue;
} else {
var child_44436 = cljs.core.first(seq__43846_44428__$1);
if(cljs.core.truth_(child_44436)){
node.appendChild(child_44436);


var G__44437 = cljs.core.next(seq__43846_44428__$1);
var G__44438 = null;
var G__44439 = (0);
var G__44440 = (0);
seq__43846_44414 = G__44437;
chunk__43848_44415 = G__44438;
count__43849_44416 = G__44439;
i__43850_44417 = G__44440;
continue;
} else {
var G__44441 = cljs.core.next(seq__43846_44428__$1);
var G__44442 = null;
var G__44443 = (0);
var G__44444 = (0);
seq__43846_44414 = G__44441;
chunk__43848_44415 = G__44442;
count__43849_44416 = G__44443;
i__43850_44417 = G__44444;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_44413);
}
}


var G__44445 = cljs.core.next(seq__43729_44405__$1);
var G__44446 = null;
var G__44447 = (0);
var G__44448 = (0);
seq__43729_44353 = G__44445;
chunk__43731_44354 = G__44446;
count__43732_44355 = G__44447;
i__43733_44356 = G__44448;
continue;
} else {
var G__44449 = cljs.core.next(seq__43729_44405__$1);
var G__44450 = null;
var G__44451 = (0);
var G__44452 = (0);
seq__43729_44353 = G__44449;
chunk__43731_44354 = G__44450;
count__43732_44355 = G__44451;
i__43733_44356 = G__44452;
continue;
}
}
} else {
}
}
break;
}

return node;
});
goog.object.set(shadow.dom.SVGElement,"string",true);

var G__43856_44453 = shadow.dom._to_svg;
var G__43857_44454 = "string";
var G__43858_44455 = ((function (G__43856_44453,G__43857_44454){
return (function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
});})(G__43856_44453,G__43857_44454))
;
goog.object.set(G__43856_44453,G__43857_44454,G__43858_44455);

cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
});

cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
});

goog.object.set(shadow.dom.SVGElement,"null",true);

var G__43861_44459 = shadow.dom._to_svg;
var G__43862_44460 = "null";
var G__43863_44461 = ((function (G__43861_44459,G__43862_44460){
return (function (_){
return null;
});})(G__43861_44459,G__43862_44460))
;
goog.object.set(G__43861_44459,G__43862_44460,G__43863_44461);
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__4736__auto__ = [];
var len__4730__auto___44465 = arguments.length;
var i__4731__auto___44466 = (0);
while(true){
if((i__4731__auto___44466 < len__4730__auto___44465)){
args__4736__auto__.push((arguments[i__4731__auto___44466]));

var G__44468 = (i__4731__auto___44466 + (1));
i__4731__auto___44466 = G__44468;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
});

shadow.dom.svg.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
shadow.dom.svg.cljs$lang$applyTo = (function (seq43866){
var G__43867 = cljs.core.first(seq43866);
var seq43866__$1 = cljs.core.next(seq43866);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43867,seq43866__$1);
});

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__43874 = arguments.length;
switch (G__43874) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,null,false);
});

shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,xf,false);
});

shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer((1));
var chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(buf,xf);
var event_fn = ((function (buf,chan){
return (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler(el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_(chan);
} else {
return null;
}
});})(buf,chan))
;
var G__43880_44484 = shadow.dom.dom_node(el);
var G__43881_44485 = cljs.core.name(event);
var G__43882_44486 = event_fn;
(shadow.dom.dom_listen.cljs$core$IFn$_invoke$arity$3 ? shadow.dom.dom_listen.cljs$core$IFn$_invoke$arity$3(G__43880_44484,G__43881_44485,G__43882_44486) : shadow.dom.dom_listen.call(null,G__43880_44484,G__43881_44485,G__43882_44486));

if(cljs.core.truth_((function (){var and__4120__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__4120__auto__)){
return (!(once_or_cleanup === true));
} else {
return and__4120__auto__;
}
})())){
var c__39413__auto___44488 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__39413__auto___44488,buf,chan,event_fn){
return (function (){
var f__39414__auto__ = (function (){var switch__39111__auto__ = ((function (c__39413__auto___44488,buf,chan,event_fn){
return (function (state_43889){
var state_val_43890 = (state_43889[(1)]);
if((state_val_43890 === (1))){
var state_43889__$1 = state_43889;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43889__$1,(2),once_or_cleanup);
} else {
if((state_val_43890 === (2))){
var inst_43886 = (state_43889[(2)]);
var inst_43887 = shadow.dom.remove_event_handler(el,event,event_fn);
var state_43889__$1 = (function (){var statearr_43893 = state_43889;
(statearr_43893[(7)] = inst_43886);

return statearr_43893;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_43889__$1,inst_43887);
} else {
return null;
}
}
});})(c__39413__auto___44488,buf,chan,event_fn))
;
return ((function (switch__39111__auto__,c__39413__auto___44488,buf,chan,event_fn){
return (function() {
var shadow$dom$state_machine__39112__auto__ = null;
var shadow$dom$state_machine__39112__auto____0 = (function (){
var statearr_43894 = [null,null,null,null,null,null,null,null];
(statearr_43894[(0)] = shadow$dom$state_machine__39112__auto__);

(statearr_43894[(1)] = (1));

return statearr_43894;
});
var shadow$dom$state_machine__39112__auto____1 = (function (state_43889){
while(true){
var ret_value__39113__auto__ = (function (){try{while(true){
var result__39114__auto__ = switch__39111__auto__(state_43889);
if(cljs.core.keyword_identical_QMARK_(result__39114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__39114__auto__;
}
break;
}
}catch (e43895){if((e43895 instanceof Object)){
var ex__39115__auto__ = e43895;
var statearr_43896_44492 = state_43889;
(statearr_43896_44492[(5)] = ex__39115__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_43889);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e43895;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__39113__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__44494 = state_43889;
state_43889 = G__44494;
continue;
} else {
return ret_value__39113__auto__;
}
break;
}
});
shadow$dom$state_machine__39112__auto__ = function(state_43889){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__39112__auto____0.call(this);
case 1:
return shadow$dom$state_machine__39112__auto____1.call(this,state_43889);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$dom$state_machine__39112__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__39112__auto____0;
shadow$dom$state_machine__39112__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__39112__auto____1;
return shadow$dom$state_machine__39112__auto__;
})()
;})(switch__39111__auto__,c__39413__auto___44488,buf,chan,event_fn))
})();
var state__39415__auto__ = (function (){var statearr_43898 = (f__39414__auto__.cljs$core$IFn$_invoke$arity$0 ? f__39414__auto__.cljs$core$IFn$_invoke$arity$0() : f__39414__auto__.call(null));
(statearr_43898[(6)] = c__39413__auto___44488);

return statearr_43898;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__39415__auto__);
});})(c__39413__auto___44488,buf,chan,event_fn))
);

} else {
}

return chan;
});

shadow.dom.event_chan.cljs$lang$maxFixedArity = 4;


//# sourceMappingURL=shadow.dom.js.map
