goog.provide('shadow.cljs.devtools.client.browser');
goog.require('cljs.core');
goog.require('cljs.reader');
goog.require('clojure.string');
goog.require('goog.dom');
goog.require('goog.userAgent.product');
goog.require('goog.Uri');
goog.require('goog.net.XhrIo');
goog.require('shadow.cljs.devtools.client.env');
goog.require('shadow.cljs.devtools.client.console');
goog.require('shadow.cljs.devtools.client.hud');
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.browser !== 'undefined') && (typeof shadow.cljs.devtools.client.browser.active_modules_ref !== 'undefined')){
} else {
shadow.cljs.devtools.client.browser.active_modules_ref = cljs.core.volatile_BANG_(cljs.core.PersistentHashSet.EMPTY);
}
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.browser !== 'undefined') && (typeof shadow.cljs.devtools.client.browser.repl_ns_ref !== 'undefined')){
} else {
shadow.cljs.devtools.client.browser.repl_ns_ref = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
}
shadow.cljs.devtools.client.browser.module_loaded = (function shadow$cljs$devtools$client$browser$module_loaded(name){
return shadow.cljs.devtools.client.browser.active_modules_ref.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(shadow.cljs.devtools.client.browser.active_modules_ref.cljs$core$IDeref$_deref$arity$1(null),cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(name)));
});
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.browser !== 'undefined') && (typeof shadow.cljs.devtools.client.browser.socket_ref !== 'undefined')){
} else {
shadow.cljs.devtools.client.browser.socket_ref = cljs.core.volatile_BANG_(null);
}
shadow.cljs.devtools.client.browser.devtools_msg = (function shadow$cljs$devtools$client$browser$devtools_msg(var_args){
var args__4736__auto__ = [];
var len__4730__auto___47178 = arguments.length;
var i__4731__auto___47179 = (0);
while(true){
if((i__4731__auto___47179 < len__4730__auto___47178)){
args__4736__auto__.push((arguments[i__4731__auto___47179]));

var G__47180 = (i__4731__auto___47179 + (1));
i__4731__auto___47179 = G__47180;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic = (function (msg,args){
return console.log.apply(console,cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [["%cshadow-cljs: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg)].join(''),"color: blue;"], null),args)));
});

shadow.cljs.devtools.client.browser.devtools_msg.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
shadow.cljs.devtools.client.browser.devtools_msg.cljs$lang$applyTo = (function (seq46939){
var G__46940 = cljs.core.first(seq46939);
var seq46939__$1 = cljs.core.next(seq46939);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__46940,seq46939__$1);
});

shadow.cljs.devtools.client.browser.ws_msg = (function shadow$cljs$devtools$client$browser$ws_msg(msg){
var temp__5733__auto__ = cljs.core.deref(shadow.cljs.devtools.client.browser.socket_ref);
if(cljs.core.truth_(temp__5733__auto__)){
var s = temp__5733__auto__;
return s.send(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([msg], 0)));
} else {
return console.warn("WEBSOCKET NOT CONNECTED",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([msg], 0)));
}
});
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.browser !== 'undefined') && (typeof shadow.cljs.devtools.client.browser.scripts_to_load !== 'undefined')){
} else {
shadow.cljs.devtools.client.browser.scripts_to_load = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY);
}
shadow.cljs.devtools.client.browser.loaded_QMARK_ = goog.isProvided_;
shadow.cljs.devtools.client.browser.goog_is_loaded_QMARK_ = (function shadow$cljs$devtools$client$browser$goog_is_loaded_QMARK_(name){
return $CLJS.SHADOW_ENV.isLoaded(name);
});
shadow.cljs.devtools.client.browser.goog_base_rc = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("shadow.build.classpath","resource","shadow.build.classpath/resource",-879517823),"goog/base.js"], null);
shadow.cljs.devtools.client.browser.src_is_loaded_QMARK_ = (function shadow$cljs$devtools$client$browser$src_is_loaded_QMARK_(p__46947){
var map__46948 = p__46947;
var map__46948__$1 = (((((!((map__46948 == null))))?(((((map__46948.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46948.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46948):map__46948);
var src = map__46948__$1;
var resource_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46948__$1,new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582));
var output_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46948__$1,new cljs.core.Keyword(null,"output-name","output-name",-1769107767));
var or__4131__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(shadow.cljs.devtools.client.browser.goog_base_rc,resource_id);
if(or__4131__auto__){
return or__4131__auto__;
} else {
return shadow.cljs.devtools.client.browser.goog_is_loaded_QMARK_(output_name);
}
});
shadow.cljs.devtools.client.browser.module_is_active_QMARK_ = (function shadow$cljs$devtools$client$browser$module_is_active_QMARK_(module){
return cljs.core.contains_QMARK_(cljs.core.deref(shadow.cljs.devtools.client.browser.active_modules_ref),module);
});
shadow.cljs.devtools.client.browser.script_eval = (function shadow$cljs$devtools$client$browser$script_eval(code){
return goog.globalEval(code);
});
shadow.cljs.devtools.client.browser.do_js_load = (function shadow$cljs$devtools$client$browser$do_js_load(sources){
var seq__46951 = cljs.core.seq(sources);
var chunk__46952 = null;
var count__46953 = (0);
var i__46954 = (0);
while(true){
if((i__46954 < count__46953)){
var map__46964 = chunk__46952.cljs$core$IIndexed$_nth$arity$2(null,i__46954);
var map__46964__$1 = (((((!((map__46964 == null))))?(((((map__46964.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46964.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46964):map__46964);
var src = map__46964__$1;
var resource_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46964__$1,new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582));
var output_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46964__$1,new cljs.core.Keyword(null,"output-name","output-name",-1769107767));
var resource_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46964__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
var js = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46964__$1,new cljs.core.Keyword(null,"js","js",1768080579));
$CLJS.SHADOW_ENV.setLoaded(output_name);

shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("load JS",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([resource_name], 0));

shadow.cljs.devtools.client.env.before_load_src(src);

try{shadow.cljs.devtools.client.browser.script_eval([cljs.core.str.cljs$core$IFn$_invoke$arity$1(js),"\n//# sourceURL=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name)].join(''));
}catch (e46971){var e_47185 = e46971;
console.error(["Failed to load ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name)].join(''),e_47185);

throw (new Error(["Failed to load ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(e_47185.message)].join('')));
}

var G__47186 = seq__46951;
var G__47187 = chunk__46952;
var G__47188 = count__46953;
var G__47189 = (i__46954 + (1));
seq__46951 = G__47186;
chunk__46952 = G__47187;
count__46953 = G__47188;
i__46954 = G__47189;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__46951);
if(temp__5735__auto__){
var seq__46951__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__46951__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__46951__$1);
var G__47192 = cljs.core.chunk_rest(seq__46951__$1);
var G__47193 = c__4550__auto__;
var G__47194 = cljs.core.count(c__4550__auto__);
var G__47195 = (0);
seq__46951 = G__47192;
chunk__46952 = G__47193;
count__46953 = G__47194;
i__46954 = G__47195;
continue;
} else {
var map__46973 = cljs.core.first(seq__46951__$1);
var map__46973__$1 = (((((!((map__46973 == null))))?(((((map__46973.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46973.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46973):map__46973);
var src = map__46973__$1;
var resource_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46973__$1,new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582));
var output_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46973__$1,new cljs.core.Keyword(null,"output-name","output-name",-1769107767));
var resource_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46973__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
var js = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46973__$1,new cljs.core.Keyword(null,"js","js",1768080579));
$CLJS.SHADOW_ENV.setLoaded(output_name);

shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("load JS",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([resource_name], 0));

shadow.cljs.devtools.client.env.before_load_src(src);

try{shadow.cljs.devtools.client.browser.script_eval([cljs.core.str.cljs$core$IFn$_invoke$arity$1(js),"\n//# sourceURL=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name)].join(''));
}catch (e46975){var e_47198 = e46975;
console.error(["Failed to load ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name)].join(''),e_47198);

throw (new Error(["Failed to load ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(e_47198.message)].join('')));
}

var G__47199 = cljs.core.next(seq__46951__$1);
var G__47200 = null;
var G__47201 = (0);
var G__47202 = (0);
seq__46951 = G__47199;
chunk__46952 = G__47200;
count__46953 = G__47201;
i__46954 = G__47202;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.cljs.devtools.client.browser.do_js_reload = (function shadow$cljs$devtools$client$browser$do_js_reload(msg,sources,complete_fn,failure_fn){
return shadow.cljs.devtools.client.env.do_js_reload.cljs$core$IFn$_invoke$arity$4(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(msg,new cljs.core.Keyword(null,"log-missing-fn","log-missing-fn",732676765),(function (fn_sym){
return shadow.cljs.devtools.client.browser.devtools_msg(["can't find fn ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_sym)].join(''));
}),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"log-call-async","log-call-async",183826192),(function (fn_sym){
return shadow.cljs.devtools.client.browser.devtools_msg(["call async ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_sym)].join(''));
}),new cljs.core.Keyword(null,"log-call","log-call",412404391),(function (fn_sym){
return shadow.cljs.devtools.client.browser.devtools_msg(["call ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_sym)].join(''));
})], 0)),(function (){
return shadow.cljs.devtools.client.browser.do_js_load(sources);
}),complete_fn,failure_fn);
});
/**
 * when (require '["some-str" :as x]) is done at the REPL we need to manually call the shadow.js.require for it
 * since the file only adds the shadow$provide. only need to do this for shadow-js.
 */
shadow.cljs.devtools.client.browser.do_js_requires = (function shadow$cljs$devtools$client$browser$do_js_requires(js_requires){
var seq__46982 = cljs.core.seq(js_requires);
var chunk__46983 = null;
var count__46984 = (0);
var i__46985 = (0);
while(true){
if((i__46985 < count__46984)){
var js_ns = chunk__46983.cljs$core$IIndexed$_nth$arity$2(null,i__46985);
var require_str_47205 = ["var ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_ns)," = shadow.js.require(\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_ns),"\");"].join('');
shadow.cljs.devtools.client.browser.script_eval(require_str_47205);


var G__47206 = seq__46982;
var G__47207 = chunk__46983;
var G__47208 = count__46984;
var G__47209 = (i__46985 + (1));
seq__46982 = G__47206;
chunk__46983 = G__47207;
count__46984 = G__47208;
i__46985 = G__47209;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__46982);
if(temp__5735__auto__){
var seq__46982__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__46982__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__46982__$1);
var G__47210 = cljs.core.chunk_rest(seq__46982__$1);
var G__47211 = c__4550__auto__;
var G__47212 = cljs.core.count(c__4550__auto__);
var G__47213 = (0);
seq__46982 = G__47210;
chunk__46983 = G__47211;
count__46984 = G__47212;
i__46985 = G__47213;
continue;
} else {
var js_ns = cljs.core.first(seq__46982__$1);
var require_str_47214 = ["var ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_ns)," = shadow.js.require(\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_ns),"\");"].join('');
shadow.cljs.devtools.client.browser.script_eval(require_str_47214);


var G__47215 = cljs.core.next(seq__46982__$1);
var G__47216 = null;
var G__47217 = (0);
var G__47218 = (0);
seq__46982 = G__47215;
chunk__46983 = G__47216;
count__46984 = G__47217;
i__46985 = G__47218;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.cljs.devtools.client.browser.load_sources = (function shadow$cljs$devtools$client$browser$load_sources(sources,callback){
if(cljs.core.empty_QMARK_(sources)){
var G__46988 = cljs.core.PersistentVector.EMPTY;
return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(G__46988) : callback.call(null,G__46988));
} else {
var G__46991 = shadow.cljs.devtools.client.env.files_url();
var G__46992 = ((function (G__46991){
return (function (res){
var req = this;
var content = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(req.getResponseText());
return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(content) : callback.call(null,content));
});})(G__46991))
;
var G__46993 = "POST";
var G__46994 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"client","client",-1323448117),new cljs.core.Keyword(null,"browser","browser",828191719),new cljs.core.Keyword(null,"sources","sources",-321166424),cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582)),sources)], null)], 0));
var G__46995 = ({"content-type": "application/edn; charset=utf-8"});
return goog.net.XhrIo.send(G__46991,G__46992,G__46993,G__46994,G__46995);
}
});
shadow.cljs.devtools.client.browser.handle_build_complete = (function shadow$cljs$devtools$client$browser$handle_build_complete(p__46999){
var map__47000 = p__46999;
var map__47000__$1 = (((((!((map__47000 == null))))?(((((map__47000.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__47000.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__47000):map__47000);
var msg = map__47000__$1;
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47000__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var reload_info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47000__$1,new cljs.core.Keyword(null,"reload-info","reload-info",1648088086));
var map__47002 = info;
var map__47002__$1 = (((((!((map__47002 == null))))?(((((map__47002.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__47002.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__47002):map__47002);
var sources = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47002__$1,new cljs.core.Keyword(null,"sources","sources",-321166424));
var compiled = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47002__$1,new cljs.core.Keyword(null,"compiled","compiled",850043082));
var warnings = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.distinct.cljs$core$IFn$_invoke$arity$1((function (){var iter__4523__auto__ = ((function (map__47002,map__47002__$1,sources,compiled,map__47000,map__47000__$1,msg,info,reload_info){
return (function shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__47004(s__47005){
return (new cljs.core.LazySeq(null,((function (map__47002,map__47002__$1,sources,compiled,map__47000,map__47000__$1,msg,info,reload_info){
return (function (){
var s__47005__$1 = s__47005;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__47005__$1);
if(temp__5735__auto__){
var xs__6292__auto__ = temp__5735__auto__;
var map__47010 = cljs.core.first(xs__6292__auto__);
var map__47010__$1 = (((((!((map__47010 == null))))?(((((map__47010.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__47010.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__47010):map__47010);
var src = map__47010__$1;
var resource_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47010__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
var warnings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47010__$1,new cljs.core.Keyword(null,"warnings","warnings",-735437651));
if(cljs.core.not(new cljs.core.Keyword(null,"from-jar","from-jar",1050932827).cljs$core$IFn$_invoke$arity$1(src))){
var iterys__4519__auto__ = ((function (s__47005__$1,map__47010,map__47010__$1,src,resource_name,warnings,xs__6292__auto__,temp__5735__auto__,map__47002,map__47002__$1,sources,compiled,map__47000,map__47000__$1,msg,info,reload_info){
return (function shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__47004_$_iter__47006(s__47007){
return (new cljs.core.LazySeq(null,((function (s__47005__$1,map__47010,map__47010__$1,src,resource_name,warnings,xs__6292__auto__,temp__5735__auto__,map__47002,map__47002__$1,sources,compiled,map__47000,map__47000__$1,msg,info,reload_info){
return (function (){
var s__47007__$1 = s__47007;
while(true){
var temp__5735__auto____$1 = cljs.core.seq(s__47007__$1);
if(temp__5735__auto____$1){
var s__47007__$2 = temp__5735__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__47007__$2)){
var c__4521__auto__ = cljs.core.chunk_first(s__47007__$2);
var size__4522__auto__ = cljs.core.count(c__4521__auto__);
var b__47009 = cljs.core.chunk_buffer(size__4522__auto__);
if((function (){var i__47008 = (0);
while(true){
if((i__47008 < size__4522__auto__)){
var warning = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4521__auto__,i__47008);
cljs.core.chunk_append(b__47009,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(warning,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100),resource_name));

var G__47223 = (i__47008 + (1));
i__47008 = G__47223;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__47009),shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__47004_$_iter__47006(cljs.core.chunk_rest(s__47007__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__47009),null);
}
} else {
var warning = cljs.core.first(s__47007__$2);
return cljs.core.cons(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(warning,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100),resource_name),shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__47004_$_iter__47006(cljs.core.rest(s__47007__$2)));
}
} else {
return null;
}
break;
}
});})(s__47005__$1,map__47010,map__47010__$1,src,resource_name,warnings,xs__6292__auto__,temp__5735__auto__,map__47002,map__47002__$1,sources,compiled,map__47000,map__47000__$1,msg,info,reload_info))
,null,null));
});})(s__47005__$1,map__47010,map__47010__$1,src,resource_name,warnings,xs__6292__auto__,temp__5735__auto__,map__47002,map__47002__$1,sources,compiled,map__47000,map__47000__$1,msg,info,reload_info))
;
var fs__4520__auto__ = cljs.core.seq(iterys__4519__auto__(warnings));
if(fs__4520__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4520__auto__,shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__47004(cljs.core.rest(s__47005__$1)));
} else {
var G__47226 = cljs.core.rest(s__47005__$1);
s__47005__$1 = G__47226;
continue;
}
} else {
var G__47228 = cljs.core.rest(s__47005__$1);
s__47005__$1 = G__47228;
continue;
}
} else {
return null;
}
break;
}
});})(map__47002,map__47002__$1,sources,compiled,map__47000,map__47000__$1,msg,info,reload_info))
,null,null));
});})(map__47002,map__47002__$1,sources,compiled,map__47000,map__47000__$1,msg,info,reload_info))
;
return iter__4523__auto__(sources);
})()));
var seq__47016_47229 = cljs.core.seq(warnings);
var chunk__47017_47230 = null;
var count__47018_47231 = (0);
var i__47019_47232 = (0);
while(true){
if((i__47019_47232 < count__47018_47231)){
var map__47029_47233 = chunk__47017_47230.cljs$core$IIndexed$_nth$arity$2(null,i__47019_47232);
var map__47029_47234__$1 = (((((!((map__47029_47233 == null))))?(((((map__47029_47233.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__47029_47233.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__47029_47233):map__47029_47233);
var w_47235 = map__47029_47234__$1;
var msg_47236__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47029_47234__$1,new cljs.core.Keyword(null,"msg","msg",-1386103444));
var line_47237 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47029_47234__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_47238 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47029_47234__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var resource_name_47239 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47029_47234__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
console.warn(["BUILD-WARNING in ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name_47239)," at [",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line_47237),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column_47238),"]\n\t",cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg_47236__$1)].join(''));


var G__47241 = seq__47016_47229;
var G__47242 = chunk__47017_47230;
var G__47243 = count__47018_47231;
var G__47244 = (i__47019_47232 + (1));
seq__47016_47229 = G__47241;
chunk__47017_47230 = G__47242;
count__47018_47231 = G__47243;
i__47019_47232 = G__47244;
continue;
} else {
var temp__5735__auto___47245 = cljs.core.seq(seq__47016_47229);
if(temp__5735__auto___47245){
var seq__47016_47246__$1 = temp__5735__auto___47245;
if(cljs.core.chunked_seq_QMARK_(seq__47016_47246__$1)){
var c__4550__auto___47247 = cljs.core.chunk_first(seq__47016_47246__$1);
var G__47248 = cljs.core.chunk_rest(seq__47016_47246__$1);
var G__47249 = c__4550__auto___47247;
var G__47250 = cljs.core.count(c__4550__auto___47247);
var G__47251 = (0);
seq__47016_47229 = G__47248;
chunk__47017_47230 = G__47249;
count__47018_47231 = G__47250;
i__47019_47232 = G__47251;
continue;
} else {
var map__47032_47252 = cljs.core.first(seq__47016_47246__$1);
var map__47032_47253__$1 = (((((!((map__47032_47252 == null))))?(((((map__47032_47252.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__47032_47252.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__47032_47252):map__47032_47252);
var w_47254 = map__47032_47253__$1;
var msg_47255__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47032_47253__$1,new cljs.core.Keyword(null,"msg","msg",-1386103444));
var line_47256 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47032_47253__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_47257 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47032_47253__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var resource_name_47258 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47032_47253__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
console.warn(["BUILD-WARNING in ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name_47258)," at [",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line_47256),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column_47257),"]\n\t",cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg_47255__$1)].join(''));


var G__47262 = cljs.core.next(seq__47016_47246__$1);
var G__47263 = null;
var G__47264 = (0);
var G__47265 = (0);
seq__47016_47229 = G__47262;
chunk__47017_47230 = G__47263;
count__47018_47231 = G__47264;
i__47019_47232 = G__47265;
continue;
}
} else {
}
}
break;
}

if((!(shadow.cljs.devtools.client.env.autoload))){
return shadow.cljs.devtools.client.hud.load_end_success();
} else {
if(((cljs.core.empty_QMARK_(warnings)) || (shadow.cljs.devtools.client.env.ignore_warnings))){
var sources_to_get = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (map__47002,map__47002__$1,sources,compiled,warnings,map__47000,map__47000__$1,msg,info,reload_info){
return (function (p__47038){
var map__47039 = p__47038;
var map__47039__$1 = (((((!((map__47039 == null))))?(((((map__47039.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__47039.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__47039):map__47039);
var src = map__47039__$1;
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47039__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var resource_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47039__$1,new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582));
return ((cljs.core.contains_QMARK_(new cljs.core.Keyword(null,"always-load","always-load",66405637).cljs$core$IFn$_invoke$arity$1(reload_info),ns)) || (cljs.core.not(shadow.cljs.devtools.client.browser.src_is_loaded_QMARK_(src))) || (((cljs.core.contains_QMARK_(compiled,resource_id)) && (cljs.core.not(new cljs.core.Keyword(null,"from-jar","from-jar",1050932827).cljs$core$IFn$_invoke$arity$1(src))))));
});})(map__47002,map__47002__$1,sources,compiled,warnings,map__47000,map__47000__$1,msg,info,reload_info))
,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(((function (map__47002,map__47002__$1,sources,compiled,warnings,map__47000,map__47000__$1,msg,info,reload_info){
return (function (p__47041){
var map__47042 = p__47041;
var map__47042__$1 = (((((!((map__47042 == null))))?(((((map__47042.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__47042.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__47042):map__47042);
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47042__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
return cljs.core.contains_QMARK_(new cljs.core.Keyword(null,"never-load","never-load",1300896819).cljs$core$IFn$_invoke$arity$1(reload_info),ns);
});})(map__47002,map__47002__$1,sources,compiled,warnings,map__47000,map__47000__$1,msg,info,reload_info))
,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (map__47002,map__47002__$1,sources,compiled,warnings,map__47000,map__47000__$1,msg,info,reload_info){
return (function (p__47044){
var map__47045 = p__47044;
var map__47045__$1 = (((((!((map__47045 == null))))?(((((map__47045.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__47045.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__47045):map__47045);
var rc = map__47045__$1;
var module = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47045__$1,new cljs.core.Keyword(null,"module","module",1424618191));
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("js",shadow.cljs.devtools.client.env.module_format)) || (shadow.cljs.devtools.client.browser.module_is_active_QMARK_(module)));
});})(map__47002,map__47002__$1,sources,compiled,warnings,map__47000,map__47000__$1,msg,info,reload_info))
,sources))));
if(cljs.core.not(cljs.core.seq(sources_to_get))){
return shadow.cljs.devtools.client.hud.load_end_success();
} else {
if(cljs.core.seq(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(msg,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"reload-info","reload-info",1648088086),new cljs.core.Keyword(null,"after-load","after-load",-1278503285)], null)))){
} else {
shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("reloading code but no :after-load hooks are configured!",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["https://shadow-cljs.github.io/docs/UsersGuide.html#_lifecycle_hooks"], 0));
}

return shadow.cljs.devtools.client.browser.load_sources(sources_to_get,((function (sources_to_get,map__47002,map__47002__$1,sources,compiled,warnings,map__47000,map__47000__$1,msg,info,reload_info){
return (function (p1__46998_SHARP_){
return shadow.cljs.devtools.client.browser.do_js_reload(msg,p1__46998_SHARP_,shadow.cljs.devtools.client.hud.load_end_success,shadow.cljs.devtools.client.hud.load_failure);
});})(sources_to_get,map__47002,map__47002__$1,sources,compiled,warnings,map__47000,map__47000__$1,msg,info,reload_info))
);
}
} else {
return null;
}
}
});
shadow.cljs.devtools.client.browser.page_load_uri = (cljs.core.truth_(goog.global.document)?goog.Uri.parse(document.location.href):null);
shadow.cljs.devtools.client.browser.match_paths = (function shadow$cljs$devtools$client$browser$match_paths(old,new$){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("file",shadow.cljs.devtools.client.browser.page_load_uri.getScheme())){
var rel_new = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(new$,(1));
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(old,rel_new)) || (clojure.string.starts_with_QMARK_(old,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(rel_new),"?"].join(''))))){
return rel_new;
} else {
return null;
}
} else {
var node_uri = goog.Uri.parse(old);
var node_uri_resolved = shadow.cljs.devtools.client.browser.page_load_uri.resolve(node_uri);
var node_abs = node_uri_resolved.getPath();
var and__4120__auto__ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1(shadow.cljs.devtools.client.browser.page_load_uri.hasSameDomainAs(node_uri))) || (cljs.core.not(node_uri.hasDomain())));
if(and__4120__auto__){
var and__4120__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(node_abs,new$);
if(and__4120__auto____$1){
return new$;
} else {
return and__4120__auto____$1;
}
} else {
return and__4120__auto__;
}
}
});
shadow.cljs.devtools.client.browser.handle_asset_watch = (function shadow$cljs$devtools$client$browser$handle_asset_watch(p__47053){
var map__47054 = p__47053;
var map__47054__$1 = (((((!((map__47054 == null))))?(((((map__47054.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__47054.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__47054):map__47054);
var msg = map__47054__$1;
var updates = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47054__$1,new cljs.core.Keyword(null,"updates","updates",2013983452));
var seq__47056 = cljs.core.seq(updates);
var chunk__47058 = null;
var count__47059 = (0);
var i__47060 = (0);
while(true){
if((i__47060 < count__47059)){
var path = chunk__47058.cljs$core$IIndexed$_nth$arity$2(null,i__47060);
if(clojure.string.ends_with_QMARK_(path,"css")){
var seq__47098_47271 = cljs.core.seq(cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1(document.querySelectorAll("link[rel=\"stylesheet\"]")));
var chunk__47101_47272 = null;
var count__47102_47273 = (0);
var i__47103_47274 = (0);
while(true){
if((i__47103_47274 < count__47102_47273)){
var node_47275 = chunk__47101_47272.cljs$core$IIndexed$_nth$arity$2(null,i__47103_47274);
var path_match_47276 = shadow.cljs.devtools.client.browser.match_paths(node_47275.getAttribute("href"),path);
if(cljs.core.truth_(path_match_47276)){
var new_link_47277 = (function (){var G__47114 = node_47275.cloneNode(true);
G__47114.setAttribute("href",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(path_match_47276),"?r=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.rand.cljs$core$IFn$_invoke$arity$0())].join(''));

return G__47114;
})();
shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("load CSS",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([path_match_47276], 0));

goog.dom.insertSiblingAfter(new_link_47277,node_47275);

goog.dom.removeNode(node_47275);


var G__47280 = seq__47098_47271;
var G__47281 = chunk__47101_47272;
var G__47282 = count__47102_47273;
var G__47283 = (i__47103_47274 + (1));
seq__47098_47271 = G__47280;
chunk__47101_47272 = G__47281;
count__47102_47273 = G__47282;
i__47103_47274 = G__47283;
continue;
} else {
var G__47284 = seq__47098_47271;
var G__47285 = chunk__47101_47272;
var G__47286 = count__47102_47273;
var G__47287 = (i__47103_47274 + (1));
seq__47098_47271 = G__47284;
chunk__47101_47272 = G__47285;
count__47102_47273 = G__47286;
i__47103_47274 = G__47287;
continue;
}
} else {
var temp__5735__auto___47288 = cljs.core.seq(seq__47098_47271);
if(temp__5735__auto___47288){
var seq__47098_47289__$1 = temp__5735__auto___47288;
if(cljs.core.chunked_seq_QMARK_(seq__47098_47289__$1)){
var c__4550__auto___47290 = cljs.core.chunk_first(seq__47098_47289__$1);
var G__47291 = cljs.core.chunk_rest(seq__47098_47289__$1);
var G__47292 = c__4550__auto___47290;
var G__47293 = cljs.core.count(c__4550__auto___47290);
var G__47294 = (0);
seq__47098_47271 = G__47291;
chunk__47101_47272 = G__47292;
count__47102_47273 = G__47293;
i__47103_47274 = G__47294;
continue;
} else {
var node_47296 = cljs.core.first(seq__47098_47289__$1);
var path_match_47297 = shadow.cljs.devtools.client.browser.match_paths(node_47296.getAttribute("href"),path);
if(cljs.core.truth_(path_match_47297)){
var new_link_47298 = (function (){var G__47115 = node_47296.cloneNode(true);
G__47115.setAttribute("href",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(path_match_47297),"?r=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.rand.cljs$core$IFn$_invoke$arity$0())].join(''));

return G__47115;
})();
shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("load CSS",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([path_match_47297], 0));

goog.dom.insertSiblingAfter(new_link_47298,node_47296);

goog.dom.removeNode(node_47296);


var G__47299 = cljs.core.next(seq__47098_47289__$1);
var G__47300 = null;
var G__47301 = (0);
var G__47302 = (0);
seq__47098_47271 = G__47299;
chunk__47101_47272 = G__47300;
count__47102_47273 = G__47301;
i__47103_47274 = G__47302;
continue;
} else {
var G__47303 = cljs.core.next(seq__47098_47289__$1);
var G__47304 = null;
var G__47305 = (0);
var G__47306 = (0);
seq__47098_47271 = G__47303;
chunk__47101_47272 = G__47304;
count__47102_47273 = G__47305;
i__47103_47274 = G__47306;
continue;
}
}
} else {
}
}
break;
}


var G__47307 = seq__47056;
var G__47308 = chunk__47058;
var G__47309 = count__47059;
var G__47310 = (i__47060 + (1));
seq__47056 = G__47307;
chunk__47058 = G__47308;
count__47059 = G__47309;
i__47060 = G__47310;
continue;
} else {
var G__47311 = seq__47056;
var G__47312 = chunk__47058;
var G__47313 = count__47059;
var G__47314 = (i__47060 + (1));
seq__47056 = G__47311;
chunk__47058 = G__47312;
count__47059 = G__47313;
i__47060 = G__47314;
continue;
}
} else {
var temp__5735__auto__ = cljs.core.seq(seq__47056);
if(temp__5735__auto__){
var seq__47056__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__47056__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__47056__$1);
var G__47316 = cljs.core.chunk_rest(seq__47056__$1);
var G__47317 = c__4550__auto__;
var G__47318 = cljs.core.count(c__4550__auto__);
var G__47319 = (0);
seq__47056 = G__47316;
chunk__47058 = G__47317;
count__47059 = G__47318;
i__47060 = G__47319;
continue;
} else {
var path = cljs.core.first(seq__47056__$1);
if(clojure.string.ends_with_QMARK_(path,"css")){
var seq__47117_47320 = cljs.core.seq(cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1(document.querySelectorAll("link[rel=\"stylesheet\"]")));
var chunk__47120_47321 = null;
var count__47121_47322 = (0);
var i__47122_47323 = (0);
while(true){
if((i__47122_47323 < count__47121_47322)){
var node_47324 = chunk__47120_47321.cljs$core$IIndexed$_nth$arity$2(null,i__47122_47323);
var path_match_47325 = shadow.cljs.devtools.client.browser.match_paths(node_47324.getAttribute("href"),path);
if(cljs.core.truth_(path_match_47325)){
var new_link_47327 = (function (){var G__47131 = node_47324.cloneNode(true);
G__47131.setAttribute("href",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(path_match_47325),"?r=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.rand.cljs$core$IFn$_invoke$arity$0())].join(''));

return G__47131;
})();
shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("load CSS",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([path_match_47325], 0));

goog.dom.insertSiblingAfter(new_link_47327,node_47324);

goog.dom.removeNode(node_47324);


var G__47330 = seq__47117_47320;
var G__47331 = chunk__47120_47321;
var G__47332 = count__47121_47322;
var G__47333 = (i__47122_47323 + (1));
seq__47117_47320 = G__47330;
chunk__47120_47321 = G__47331;
count__47121_47322 = G__47332;
i__47122_47323 = G__47333;
continue;
} else {
var G__47334 = seq__47117_47320;
var G__47335 = chunk__47120_47321;
var G__47336 = count__47121_47322;
var G__47337 = (i__47122_47323 + (1));
seq__47117_47320 = G__47334;
chunk__47120_47321 = G__47335;
count__47121_47322 = G__47336;
i__47122_47323 = G__47337;
continue;
}
} else {
var temp__5735__auto___47338__$1 = cljs.core.seq(seq__47117_47320);
if(temp__5735__auto___47338__$1){
var seq__47117_47340__$1 = temp__5735__auto___47338__$1;
if(cljs.core.chunked_seq_QMARK_(seq__47117_47340__$1)){
var c__4550__auto___47341 = cljs.core.chunk_first(seq__47117_47340__$1);
var G__47342 = cljs.core.chunk_rest(seq__47117_47340__$1);
var G__47343 = c__4550__auto___47341;
var G__47344 = cljs.core.count(c__4550__auto___47341);
var G__47345 = (0);
seq__47117_47320 = G__47342;
chunk__47120_47321 = G__47343;
count__47121_47322 = G__47344;
i__47122_47323 = G__47345;
continue;
} else {
var node_47346 = cljs.core.first(seq__47117_47340__$1);
var path_match_47347 = shadow.cljs.devtools.client.browser.match_paths(node_47346.getAttribute("href"),path);
if(cljs.core.truth_(path_match_47347)){
var new_link_47348 = (function (){var G__47133 = node_47346.cloneNode(true);
G__47133.setAttribute("href",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(path_match_47347),"?r=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.rand.cljs$core$IFn$_invoke$arity$0())].join(''));

return G__47133;
})();
shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("load CSS",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([path_match_47347], 0));

goog.dom.insertSiblingAfter(new_link_47348,node_47346);

goog.dom.removeNode(node_47346);


var G__47349 = cljs.core.next(seq__47117_47340__$1);
var G__47350 = null;
var G__47351 = (0);
var G__47352 = (0);
seq__47117_47320 = G__47349;
chunk__47120_47321 = G__47350;
count__47121_47322 = G__47351;
i__47122_47323 = G__47352;
continue;
} else {
var G__47353 = cljs.core.next(seq__47117_47340__$1);
var G__47354 = null;
var G__47355 = (0);
var G__47356 = (0);
seq__47117_47320 = G__47353;
chunk__47120_47321 = G__47354;
count__47121_47322 = G__47355;
i__47122_47323 = G__47356;
continue;
}
}
} else {
}
}
break;
}


var G__47357 = cljs.core.next(seq__47056__$1);
var G__47358 = null;
var G__47359 = (0);
var G__47360 = (0);
seq__47056 = G__47357;
chunk__47058 = G__47358;
count__47059 = G__47359;
i__47060 = G__47360;
continue;
} else {
var G__47361 = cljs.core.next(seq__47056__$1);
var G__47362 = null;
var G__47363 = (0);
var G__47364 = (0);
seq__47056 = G__47361;
chunk__47058 = G__47362;
count__47059 = G__47363;
i__47060 = G__47364;
continue;
}
}
} else {
return null;
}
}
break;
}
});
shadow.cljs.devtools.client.browser.get_ua_product = (function shadow$cljs$devtools$client$browser$get_ua_product(){
if(cljs.core.truth_(goog.userAgent.product.SAFARI)){
return new cljs.core.Keyword(null,"safari","safari",497115653);
} else {
if(cljs.core.truth_(goog.userAgent.product.CHROME)){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.FIREFOX)){
return new cljs.core.Keyword(null,"firefox","firefox",1283768880);
} else {
if(cljs.core.truth_(goog.userAgent.product.IE)){
return new cljs.core.Keyword(null,"ie","ie",2038473780);
} else {
return null;
}
}
}
}
});
shadow.cljs.devtools.client.browser.get_asset_root = (function shadow$cljs$devtools$client$browser$get_asset_root(){
var loc = (new goog.Uri(document.location.href));
var cbp = (new goog.Uri(CLOSURE_BASE_PATH));
var s = loc.resolve(cbp).toString();
return clojure.string.replace(s,/^file:\//,"file:///");
});
shadow.cljs.devtools.client.browser.repl_error = (function shadow$cljs$devtools$client$browser$repl_error(e){
console.error("repl/invoke error",e);

return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(shadow.cljs.devtools.client.env.repl_error(e),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),shadow.cljs.devtools.client.browser.get_ua_product(),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"asset-root","asset-root",1771735072),shadow.cljs.devtools.client.browser.get_asset_root()], 0));
});
shadow.cljs.devtools.client.browser.global_eval = (function shadow$cljs$devtools$client$browser$global_eval(js){
return (0,eval)(js);;
});
shadow.cljs.devtools.client.browser.repl_invoke = (function shadow$cljs$devtools$client$browser$repl_invoke(p__47138){
var map__47139 = p__47138;
var map__47139__$1 = (((((!((map__47139 == null))))?(((((map__47139.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__47139.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__47139):map__47139);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47139__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var js = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47139__$1,new cljs.core.Keyword(null,"js","js",1768080579));
var result = shadow.cljs.devtools.client.env.repl_call(((function (map__47139,map__47139__$1,id,js){
return (function (){
return shadow.cljs.devtools.client.browser.global_eval(js);
});})(map__47139,map__47139__$1,id,js))
,shadow.cljs.devtools.client.browser.repl_error);
return shadow.cljs.devtools.client.browser.ws_msg(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.Keyword(null,"id","id",-1388402092),id));
});
shadow.cljs.devtools.client.browser.repl_require = (function shadow$cljs$devtools$client$browser$repl_require(p__47141,done){
var map__47142 = p__47141;
var map__47142__$1 = (((((!((map__47142 == null))))?(((((map__47142.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__47142.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__47142):map__47142);
var msg = map__47142__$1;
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47142__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var sources = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47142__$1,new cljs.core.Keyword(null,"sources","sources",-321166424));
var reload_namespaces = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47142__$1,new cljs.core.Keyword(null,"reload-namespaces","reload-namespaces",250210134));
var js_requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47142__$1,new cljs.core.Keyword(null,"js-requires","js-requires",-1311472051));
var sources_to_load = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(((function (map__47142,map__47142__$1,msg,id,sources,reload_namespaces,js_requires){
return (function (p__47144){
var map__47145 = p__47144;
var map__47145__$1 = (((((!((map__47145 == null))))?(((((map__47145.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__47145.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__47145):map__47145);
var src = map__47145__$1;
var provides = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47145__$1,new cljs.core.Keyword(null,"provides","provides",-1634397992));
var and__4120__auto__ = shadow.cljs.devtools.client.browser.src_is_loaded_QMARK_(src);
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core.not(cljs.core.some(reload_namespaces,provides));
} else {
return and__4120__auto__;
}
});})(map__47142,map__47142__$1,msg,id,sources,reload_namespaces,js_requires))
,sources));
return shadow.cljs.devtools.client.browser.load_sources(sources_to_load,((function (sources_to_load,map__47142,map__47142__$1,msg,id,sources,reload_namespaces,js_requires){
return (function (sources__$1){
try{shadow.cljs.devtools.client.browser.do_js_load(sources__$1);

if(cljs.core.seq(js_requires)){
shadow.cljs.devtools.client.browser.do_js_requires(js_requires);
} else {
}

return shadow.cljs.devtools.client.browser.ws_msg(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","require-complete","repl/require-complete",-2140254719),new cljs.core.Keyword(null,"id","id",-1388402092),id], null));
}catch (e47147){var e = e47147;
return shadow.cljs.devtools.client.browser.ws_msg(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","require-error","repl/require-error",1689310021),new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"error","error",-978969032),e.message], null));
}finally {(done.cljs$core$IFn$_invoke$arity$0 ? done.cljs$core$IFn$_invoke$arity$0() : done.call(null));
}});})(sources_to_load,map__47142,map__47142__$1,msg,id,sources,reload_namespaces,js_requires))
);
});
shadow.cljs.devtools.client.browser.repl_init = (function shadow$cljs$devtools$client$browser$repl_init(p__47148,done){
var map__47149 = p__47148;
var map__47149__$1 = (((((!((map__47149 == null))))?(((((map__47149.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__47149.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__47149):map__47149);
var repl_state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47149__$1,new cljs.core.Keyword(null,"repl-state","repl-state",-1733780387));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47149__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
return shadow.cljs.devtools.client.browser.load_sources(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(shadow.cljs.devtools.client.browser.src_is_loaded_QMARK_,new cljs.core.Keyword(null,"repl-sources","repl-sources",723867535).cljs$core$IFn$_invoke$arity$1(repl_state))),((function (map__47149,map__47149__$1,repl_state,id){
return (function (sources){
shadow.cljs.devtools.client.browser.do_js_load(sources);

shadow.cljs.devtools.client.browser.ws_msg(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","init-complete","repl/init-complete",-162252879),new cljs.core.Keyword(null,"id","id",-1388402092),id], null));

shadow.cljs.devtools.client.browser.devtools_msg("REPL session start successful");

return (done.cljs$core$IFn$_invoke$arity$0 ? done.cljs$core$IFn$_invoke$arity$0() : done.call(null));
});})(map__47149,map__47149__$1,repl_state,id))
);
});
shadow.cljs.devtools.client.browser.repl_set_ns = (function shadow$cljs$devtools$client$browser$repl_set_ns(p__47153){
var map__47154 = p__47153;
var map__47154__$1 = (((((!((map__47154 == null))))?(((((map__47154.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__47154.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__47154):map__47154);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47154__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47154__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
return shadow.cljs.devtools.client.browser.ws_msg(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","set-ns-complete","repl/set-ns-complete",680944662),new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"ns","ns",441598760),ns], null));
});
shadow.cljs.devtools.client.browser.close_reason_ref = cljs.core.volatile_BANG_(null);
shadow.cljs.devtools.client.browser.handle_message = (function shadow$cljs$devtools$client$browser$handle_message(p__47158,done){
var map__47159 = p__47158;
var map__47159__$1 = (((((!((map__47159 == null))))?(((((map__47159.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__47159.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__47159):map__47159);
var msg = map__47159__$1;
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47159__$1,new cljs.core.Keyword(null,"type","type",1174270348));
shadow.cljs.devtools.client.hud.connection_error_clear_BANG_();

var G__47161_47379 = type;
var G__47161_47380__$1 = (((G__47161_47379 instanceof cljs.core.Keyword))?G__47161_47379.fqn:null);
switch (G__47161_47380__$1) {
case "asset-watch":
shadow.cljs.devtools.client.browser.handle_asset_watch(msg);

break;
case "repl/invoke":
shadow.cljs.devtools.client.browser.repl_invoke(msg);

break;
case "repl/require":
shadow.cljs.devtools.client.browser.repl_require(msg,done);

break;
case "repl/set-ns":
shadow.cljs.devtools.client.browser.repl_set_ns(msg);

break;
case "repl/init":
shadow.cljs.devtools.client.browser.repl_init(msg,done);

break;
case "repl/session-start":
shadow.cljs.devtools.client.browser.repl_init(msg,done);

break;
case "build-complete":
shadow.cljs.devtools.client.hud.hud_warnings(msg);

shadow.cljs.devtools.client.browser.handle_build_complete(msg);

break;
case "build-failure":
shadow.cljs.devtools.client.hud.load_end();

shadow.cljs.devtools.client.hud.hud_error(msg);

break;
case "build-init":
shadow.cljs.devtools.client.hud.hud_warnings(msg);

break;
case "build-start":
shadow.cljs.devtools.client.hud.hud_hide();

shadow.cljs.devtools.client.hud.load_start();

break;
case "pong":

break;
case "client/stale":
cljs.core.vreset_BANG_(shadow.cljs.devtools.client.browser.close_reason_ref,"Stale Client! You are not using the latest compilation output!");

break;
case "client/no-worker":
cljs.core.vreset_BANG_(shadow.cljs.devtools.client.browser.close_reason_ref,["watch for build \"",shadow.cljs.devtools.client.env.build_id,"\" not running"].join(''));

break;
case "custom-msg":
shadow.cljs.devtools.client.env.publish_BANG_(new cljs.core.Keyword(null,"payload","payload",-383036092).cljs$core$IFn$_invoke$arity$1(msg));

break;
default:

}

if(cljs.core.contains_QMARK_(shadow.cljs.devtools.client.env.async_ops,type)){
return null;
} else {
return (done.cljs$core$IFn$_invoke$arity$0 ? done.cljs$core$IFn$_invoke$arity$0() : done.call(null));
}
});
shadow.cljs.devtools.client.browser.compile = (function shadow$cljs$devtools$client$browser$compile(text,callback){
var G__47164 = ["http",((shadow.cljs.devtools.client.env.ssl)?"s":null),"://",shadow.cljs.devtools.client.env.server_host,":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.cljs.devtools.client.env.server_port),"/worker/compile/",shadow.cljs.devtools.client.env.build_id,"/",shadow.cljs.devtools.client.env.proc_id,"/browser"].join('');
var G__47165 = ((function (G__47164){
return (function (res){
var req = this;
var actions = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(req.getResponseText());
if(cljs.core.truth_(callback)){
return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(actions) : callback.call(null,actions));
} else {
return null;
}
});})(G__47164))
;
var G__47166 = "POST";
var G__47167 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"input","input",556931961),text], null)], 0));
var G__47168 = ({"content-type": "application/edn; charset=utf-8"});
return goog.net.XhrIo.send(G__47164,G__47165,G__47166,G__47167,G__47168);
});
shadow.cljs.devtools.client.browser.heartbeat_BANG_ = (function shadow$cljs$devtools$client$browser$heartbeat_BANG_(){
var temp__5735__auto__ = cljs.core.deref(shadow.cljs.devtools.client.browser.socket_ref);
if(cljs.core.truth_(temp__5735__auto__)){
var s = temp__5735__auto__;
s.send(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"ping","ping",-1670114784),new cljs.core.Keyword(null,"v","v",21465059),Date.now()], null)], 0)));

return setTimeout(shadow.cljs.devtools.client.browser.heartbeat_BANG_,(30000));
} else {
return null;
}
});
shadow.cljs.devtools.client.browser.ws_connect = (function shadow$cljs$devtools$client$browser$ws_connect(){
try{var print_fn = cljs.core._STAR_print_fn_STAR_;
var ws_url = shadow.cljs.devtools.client.env.ws_url(new cljs.core.Keyword(null,"browser","browser",828191719));
var socket = (new WebSocket(ws_url));
cljs.core.vreset_BANG_(shadow.cljs.devtools.client.browser.socket_ref,socket);

socket.onmessage = ((function (print_fn,ws_url,socket){
return (function (e){
return shadow.cljs.devtools.client.env.process_ws_msg(e.data,shadow.cljs.devtools.client.browser.handle_message);
});})(print_fn,ws_url,socket))
;

socket.onopen = ((function (print_fn,ws_url,socket){
return (function (e){
shadow.cljs.devtools.client.hud.connection_error_clear_BANG_();

cljs.core.vreset_BANG_(shadow.cljs.devtools.client.browser.close_reason_ref,null);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("goog",shadow.cljs.devtools.client.env.module_format)){
goog.provide = goog.constructNamespace_;
} else {
}

shadow.cljs.devtools.client.env.set_print_fns_BANG_(shadow.cljs.devtools.client.browser.ws_msg);

return shadow.cljs.devtools.client.browser.devtools_msg("WebSocket connected!");
});})(print_fn,ws_url,socket))
;

socket.onclose = ((function (print_fn,ws_url,socket){
return (function (e){
shadow.cljs.devtools.client.browser.devtools_msg("WebSocket disconnected!");

shadow.cljs.devtools.client.hud.connection_error((function (){var or__4131__auto__ = cljs.core.deref(shadow.cljs.devtools.client.browser.close_reason_ref);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return "Connection closed!";
}
})());

cljs.core.vreset_BANG_(shadow.cljs.devtools.client.browser.socket_ref,null);

return shadow.cljs.devtools.client.env.reset_print_fns_BANG_();
});})(print_fn,ws_url,socket))
;

socket.onerror = ((function (print_fn,ws_url,socket){
return (function (e){
shadow.cljs.devtools.client.hud.connection_error("Connection failed!");

return shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("websocket error",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e], 0));
});})(print_fn,ws_url,socket))
;

return setTimeout(shadow.cljs.devtools.client.browser.heartbeat_BANG_,(30000));
}catch (e47172){var e = e47172;
return shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("WebSocket setup failed",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e], 0));
}});
if(shadow.cljs.devtools.client.env.enabled){
var temp__5735__auto___47389 = cljs.core.deref(shadow.cljs.devtools.client.browser.socket_ref);
if(cljs.core.truth_(temp__5735__auto___47389)){
var s_47390 = temp__5735__auto___47389;
shadow.cljs.devtools.client.browser.devtools_msg("connection reset!");

s_47390.onclose = ((function (s_47390,temp__5735__auto___47389){
return (function (e){
return null;
});})(s_47390,temp__5735__auto___47389))
;

s_47390.close();

cljs.core.vreset_BANG_(shadow.cljs.devtools.client.browser.socket_ref,null);
} else {
}

window.addEventListener("beforeunload",(function (){
var temp__5735__auto__ = cljs.core.deref(shadow.cljs.devtools.client.browser.socket_ref);
if(cljs.core.truth_(temp__5735__auto__)){
var s = temp__5735__auto__;
return s.close();
} else {
return null;
}
}));

if(cljs.core.truth_((function (){var and__4120__auto__ = document;
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("loading",document.readyState);
} else {
return and__4120__auto__;
}
})())){
window.addEventListener("DOMContentLoaded",shadow.cljs.devtools.client.browser.ws_connect);
} else {
setTimeout(shadow.cljs.devtools.client.browser.ws_connect,(10));
}
} else {
}

//# sourceMappingURL=shadow.cljs.devtools.client.browser.js.map
