goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('goog.string');
goog.require('sablono.normalize');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('goog.dom');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__45709__delegate = function (args){
if(cljs.core.map_QMARK_(cljs.core.first(args))){
var vec__45396 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(func,cljs.core.rest(args));
var seq__45397 = cljs.core.seq(vec__45396);
var first__45398 = cljs.core.first(seq__45397);
var seq__45397__$1 = cljs.core.next(seq__45397);
var tag = first__45398;
var body = seq__45397__$1;
if(cljs.core.map_QMARK_(cljs.core.first(body))){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tag,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.first(body),cljs.core.first(args)], 0))], null),cljs.core.rest(body));
} else {
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tag,cljs.core.first(args)], null),body);
}
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(func,args);
}
};
var G__45709 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__45710__i = 0, G__45710__a = new Array(arguments.length -  0);
while (G__45710__i < G__45710__a.length) {G__45710__a[G__45710__i] = arguments[G__45710__i + 0]; ++G__45710__i;}
  args = new cljs.core.IndexedSeq(G__45710__a,0,null);
} 
return G__45709__delegate.call(this,args);};
G__45709.cljs$lang$maxFixedArity = 0;
G__45709.cljs$lang$applyTo = (function (arglist__45711){
var args = cljs.core.seq(arglist__45711);
return G__45709__delegate(args);
});
G__45709.cljs$core$IFn$_invoke$arity$variadic = G__45709__delegate;
return G__45709;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__4523__auto__ = (function sablono$core$update_arglists_$_iter__45400(s__45401){
return (new cljs.core.LazySeq(null,(function (){
var s__45401__$1 = s__45401;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__45401__$1);
if(temp__5735__auto__){
var s__45401__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(s__45401__$2)){
var c__4521__auto__ = cljs.core.chunk_first(s__45401__$2);
var size__4522__auto__ = cljs.core.count(c__4521__auto__);
var b__45403 = cljs.core.chunk_buffer(size__4522__auto__);
if((function (){var i__45402 = (0);
while(true){
if((i__45402 < size__4522__auto__)){
var args = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4521__auto__,i__45402);
cljs.core.chunk_append(b__45403,cljs.core.vec(cljs.core.cons(new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)));

var G__45713 = (i__45402 + (1));
i__45402 = G__45713;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__45403),sablono$core$update_arglists_$_iter__45400(cljs.core.chunk_rest(s__45401__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__45403),null);
}
} else {
var args = cljs.core.first(s__45401__$2);
return cljs.core.cons(cljs.core.vec(cljs.core.cons(new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)),sablono$core$update_arglists_$_iter__45400(cljs.core.rest(s__45401__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4523__auto__(arglists);
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__4736__auto__ = [];
var len__4730__auto___45714 = arguments.length;
var i__4731__auto___45715 = (0);
while(true){
if((i__4731__auto___45715 < len__4730__auto___45714)){
args__4736__auto__.push((arguments[i__4731__auto___45715]));

var G__45716 = (i__4731__auto___45715 + (1));
i__4731__auto___45715 = G__45716;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__4523__auto__ = (function sablono$core$iter__45408(s__45409){
return (new cljs.core.LazySeq(null,(function (){
var s__45409__$1 = s__45409;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__45409__$1);
if(temp__5735__auto__){
var s__45409__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(s__45409__$2)){
var c__4521__auto__ = cljs.core.chunk_first(s__45409__$2);
var size__4522__auto__ = cljs.core.count(c__4521__auto__);
var b__45411 = cljs.core.chunk_buffer(size__4522__auto__);
if((function (){var i__45410 = (0);
while(true){
if((i__45410 < size__4522__auto__)){
var style = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4521__auto__,i__45410);
cljs.core.chunk_append(b__45411,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([style], 0)),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null));

var G__45722 = (i__45410 + (1));
i__45410 = G__45722;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__45411),sablono$core$iter__45408(cljs.core.chunk_rest(s__45409__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__45411),null);
}
} else {
var style = cljs.core.first(s__45409__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([style], 0)),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null),sablono$core$iter__45408(cljs.core.rest(s__45409__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4523__auto__(styles);
});

sablono.core.include_css.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
sablono.core.include_css.cljs$lang$applyTo = (function (seq45407){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq45407));
});

/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
var G__45415 = goog.dom.getDocument().body;
var G__45416 = (function (){var G__45417 = "script";
var G__45418 = ({"src": src});
return goog.dom.createDom(G__45417,G__45418);
})();
return goog.dom.appendChild(G__45415,G__45416);
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js("http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to45420 = (function sablono$core$link_to45420(var_args){
var args__4736__auto__ = [];
var len__4730__auto___45725 = arguments.length;
var i__4731__auto___45726 = (0);
while(true){
if((i__4731__auto___45726 < len__4730__auto___45725)){
args__4736__auto__.push((arguments[i__4731__auto___45726]));

var G__45727 = (i__4731__auto___45726 + (1));
i__4731__auto___45726 = G__45727;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return sablono.core.link_to45420.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

sablono.core.link_to45420.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([url], 0))], null),content], null);
});

sablono.core.link_to45420.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
sablono.core.link_to45420.cljs$lang$applyTo = (function (seq45424){
var G__45425 = cljs.core.first(seq45424);
var seq45424__$1 = cljs.core.next(seq45424);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__45425,seq45424__$1);
});


sablono.core.link_to = sablono.core.wrap_attrs(sablono.core.link_to45420);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to45435 = (function sablono$core$mail_to45435(var_args){
var args__4736__auto__ = [];
var len__4730__auto___45728 = arguments.length;
var i__4731__auto___45729 = (0);
while(true){
if((i__4731__auto___45729 < len__4730__auto___45728)){
args__4736__auto__.push((arguments[i__4731__auto___45729]));

var G__45731 = (i__4731__auto___45729 + (1));
i__4731__auto___45729 = G__45731;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return sablono.core.mail_to45435.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

sablono.core.mail_to45435.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__45443){
var vec__45444 = p__45443;
var content = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45444,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),["mailto:",cljs.core.str.cljs$core$IFn$_invoke$arity$1(e_mail)].join('')], null),(function (){var or__4131__auto__ = content;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return e_mail;
}
})()], null);
});

sablono.core.mail_to45435.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
sablono.core.mail_to45435.cljs$lang$applyTo = (function (seq45436){
var G__45437 = cljs.core.first(seq45436);
var seq45436__$1 = cljs.core.next(seq45436);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__45437,seq45436__$1);
});


sablono.core.mail_to = sablono.core.wrap_attrs(sablono.core.mail_to45435);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list45451 = (function sablono$core$unordered_list45451(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),(function (){var iter__4523__auto__ = (function sablono$core$unordered_list45451_$_iter__45453(s__45454){
return (new cljs.core.LazySeq(null,(function (){
var s__45454__$1 = s__45454;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__45454__$1);
if(temp__5735__auto__){
var s__45454__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(s__45454__$2)){
var c__4521__auto__ = cljs.core.chunk_first(s__45454__$2);
var size__4522__auto__ = cljs.core.count(c__4521__auto__);
var b__45456 = cljs.core.chunk_buffer(size__4522__auto__);
if((function (){var i__45455 = (0);
while(true){
if((i__45455 < size__4522__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4521__auto__,i__45455);
cljs.core.chunk_append(b__45456,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__45733 = (i__45455 + (1));
i__45455 = G__45733;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__45456),sablono$core$unordered_list45451_$_iter__45453(cljs.core.chunk_rest(s__45454__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__45456),null);
}
} else {
var x = cljs.core.first(s__45454__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$unordered_list45451_$_iter__45453(cljs.core.rest(s__45454__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4523__auto__(coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs(sablono.core.unordered_list45451);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list45465 = (function sablono$core$ordered_list45465(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ol","ol",932524051),(function (){var iter__4523__auto__ = (function sablono$core$ordered_list45465_$_iter__45466(s__45467){
return (new cljs.core.LazySeq(null,(function (){
var s__45467__$1 = s__45467;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__45467__$1);
if(temp__5735__auto__){
var s__45467__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(s__45467__$2)){
var c__4521__auto__ = cljs.core.chunk_first(s__45467__$2);
var size__4522__auto__ = cljs.core.count(c__4521__auto__);
var b__45469 = cljs.core.chunk_buffer(size__4522__auto__);
if((function (){var i__45468 = (0);
while(true){
if((i__45468 < size__4522__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4521__auto__,i__45468);
cljs.core.chunk_append(b__45469,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__45734 = (i__45468 + (1));
i__45468 = G__45734;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__45469),sablono$core$ordered_list45465_$_iter__45466(cljs.core.chunk_rest(s__45467__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__45469),null);
}
} else {
var x = cljs.core.first(s__45467__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$ordered_list45465_$_iter__45466(cljs.core.rest(s__45467__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4523__auto__(coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs(sablono.core.ordered_list45465);
/**
 * Create an image element.
 */
sablono.core.image45474 = (function sablono$core$image45474(var_args){
var G__45478 = arguments.length;
switch (G__45478) {
case 1:
return sablono.core.image45474.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image45474.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.image45474.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([src], 0))], null)], null);
});

sablono.core.image45474.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([src], 0)),new cljs.core.Keyword(null,"alt","alt",-3214426),alt], null)], null);
});

sablono.core.image45474.cljs$lang$maxFixedArity = 2;


sablono.core.image = sablono.core.wrap_attrs(sablono.core.image45474);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (p1__45487_SHARP_,p2__45488_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__45487_SHARP_),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p2__45488_SHARP_),"]"].join('');
}),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(sablono.core._STAR_group_STAR_,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([name], 0))));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (p1__45490_SHARP_,p2__45491_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__45490_SHARP_),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p2__45491_SHARP_)].join('');
}),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(sablono.core._STAR_group_STAR_,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([name], 0))));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(var_args){
var G__45495 = arguments.length;
switch (G__45495) {
case 2:
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (type,name){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id(name)], null)], null);
});

sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3 = (function (type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id(name),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__4131__auto__ = value;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return undefined;
}
})()], null)], null);
});

sablono.core.input_field_STAR_.cljs$lang$maxFixedArity = 3;

/**
 * Creates a color input field.
 */
sablono.core.color_field45502 = (function sablono$core$color_field45502(var_args){
var G__45507 = arguments.length;
switch (G__45507) {
case 1:
return sablono.core.color_field45502.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field45502.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.color_field45502.cljs$core$IFn$_invoke$arity$1 = (function (name__45386__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"color","color",-1642760596,null)),name__45386__auto__);
});

sablono.core.color_field45502.cljs$core$IFn$_invoke$arity$2 = (function (name__45386__auto__,value__45387__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"color","color",-1642760596,null)),name__45386__auto__,value__45387__auto__);
});

sablono.core.color_field45502.cljs$lang$maxFixedArity = 2;


sablono.core.color_field = sablono.core.wrap_attrs(sablono.core.color_field45502);

/**
 * Creates a date input field.
 */
sablono.core.date_field45509 = (function sablono$core$date_field45509(var_args){
var G__45511 = arguments.length;
switch (G__45511) {
case 1:
return sablono.core.date_field45509.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field45509.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.date_field45509.cljs$core$IFn$_invoke$arity$1 = (function (name__45386__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"date","date",177097065,null)),name__45386__auto__);
});

sablono.core.date_field45509.cljs$core$IFn$_invoke$arity$2 = (function (name__45386__auto__,value__45387__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"date","date",177097065,null)),name__45386__auto__,value__45387__auto__);
});

sablono.core.date_field45509.cljs$lang$maxFixedArity = 2;


sablono.core.date_field = sablono.core.wrap_attrs(sablono.core.date_field45509);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field45514 = (function sablono$core$datetime_field45514(var_args){
var G__45519 = arguments.length;
switch (G__45519) {
case 1:
return sablono.core.datetime_field45514.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field45514.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.datetime_field45514.cljs$core$IFn$_invoke$arity$1 = (function (name__45386__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null)),name__45386__auto__);
});

sablono.core.datetime_field45514.cljs$core$IFn$_invoke$arity$2 = (function (name__45386__auto__,value__45387__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null)),name__45386__auto__,value__45387__auto__);
});

sablono.core.datetime_field45514.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_field = sablono.core.wrap_attrs(sablono.core.datetime_field45514);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field45524 = (function sablono$core$datetime_local_field45524(var_args){
var G__45526 = arguments.length;
switch (G__45526) {
case 1:
return sablono.core.datetime_local_field45524.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field45524.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.datetime_local_field45524.cljs$core$IFn$_invoke$arity$1 = (function (name__45386__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null)),name__45386__auto__);
});

sablono.core.datetime_local_field45524.cljs$core$IFn$_invoke$arity$2 = (function (name__45386__auto__,value__45387__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null)),name__45386__auto__,value__45387__auto__);
});

sablono.core.datetime_local_field45524.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_local_field = sablono.core.wrap_attrs(sablono.core.datetime_local_field45524);

/**
 * Creates a email input field.
 */
sablono.core.email_field45528 = (function sablono$core$email_field45528(var_args){
var G__45530 = arguments.length;
switch (G__45530) {
case 1:
return sablono.core.email_field45528.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field45528.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.email_field45528.cljs$core$IFn$_invoke$arity$1 = (function (name__45386__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"email","email",-1238619063,null)),name__45386__auto__);
});

sablono.core.email_field45528.cljs$core$IFn$_invoke$arity$2 = (function (name__45386__auto__,value__45387__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"email","email",-1238619063,null)),name__45386__auto__,value__45387__auto__);
});

sablono.core.email_field45528.cljs$lang$maxFixedArity = 2;


sablono.core.email_field = sablono.core.wrap_attrs(sablono.core.email_field45528);

/**
 * Creates a file input field.
 */
sablono.core.file_field45531 = (function sablono$core$file_field45531(var_args){
var G__45533 = arguments.length;
switch (G__45533) {
case 1:
return sablono.core.file_field45531.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field45531.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.file_field45531.cljs$core$IFn$_invoke$arity$1 = (function (name__45386__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"file","file",370885649,null)),name__45386__auto__);
});

sablono.core.file_field45531.cljs$core$IFn$_invoke$arity$2 = (function (name__45386__auto__,value__45387__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"file","file",370885649,null)),name__45386__auto__,value__45387__auto__);
});

sablono.core.file_field45531.cljs$lang$maxFixedArity = 2;


sablono.core.file_field = sablono.core.wrap_attrs(sablono.core.file_field45531);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field45541 = (function sablono$core$hidden_field45541(var_args){
var G__45546 = arguments.length;
switch (G__45546) {
case 1:
return sablono.core.hidden_field45541.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field45541.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.hidden_field45541.cljs$core$IFn$_invoke$arity$1 = (function (name__45386__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null)),name__45386__auto__);
});

sablono.core.hidden_field45541.cljs$core$IFn$_invoke$arity$2 = (function (name__45386__auto__,value__45387__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null)),name__45386__auto__,value__45387__auto__);
});

sablono.core.hidden_field45541.cljs$lang$maxFixedArity = 2;


sablono.core.hidden_field = sablono.core.wrap_attrs(sablono.core.hidden_field45541);

/**
 * Creates a month input field.
 */
sablono.core.month_field45547 = (function sablono$core$month_field45547(var_args){
var G__45549 = arguments.length;
switch (G__45549) {
case 1:
return sablono.core.month_field45547.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field45547.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.month_field45547.cljs$core$IFn$_invoke$arity$1 = (function (name__45386__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"month","month",-319717006,null)),name__45386__auto__);
});

sablono.core.month_field45547.cljs$core$IFn$_invoke$arity$2 = (function (name__45386__auto__,value__45387__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"month","month",-319717006,null)),name__45386__auto__,value__45387__auto__);
});

sablono.core.month_field45547.cljs$lang$maxFixedArity = 2;


sablono.core.month_field = sablono.core.wrap_attrs(sablono.core.month_field45547);

/**
 * Creates a number input field.
 */
sablono.core.number_field45558 = (function sablono$core$number_field45558(var_args){
var G__45566 = arguments.length;
switch (G__45566) {
case 1:
return sablono.core.number_field45558.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field45558.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.number_field45558.cljs$core$IFn$_invoke$arity$1 = (function (name__45386__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"number","number",-1084057331,null)),name__45386__auto__);
});

sablono.core.number_field45558.cljs$core$IFn$_invoke$arity$2 = (function (name__45386__auto__,value__45387__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"number","number",-1084057331,null)),name__45386__auto__,value__45387__auto__);
});

sablono.core.number_field45558.cljs$lang$maxFixedArity = 2;


sablono.core.number_field = sablono.core.wrap_attrs(sablono.core.number_field45558);

/**
 * Creates a password input field.
 */
sablono.core.password_field45568 = (function sablono$core$password_field45568(var_args){
var G__45574 = arguments.length;
switch (G__45574) {
case 1:
return sablono.core.password_field45568.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field45568.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.password_field45568.cljs$core$IFn$_invoke$arity$1 = (function (name__45386__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"password","password",2057553998,null)),name__45386__auto__);
});

sablono.core.password_field45568.cljs$core$IFn$_invoke$arity$2 = (function (name__45386__auto__,value__45387__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"password","password",2057553998,null)),name__45386__auto__,value__45387__auto__);
});

sablono.core.password_field45568.cljs$lang$maxFixedArity = 2;


sablono.core.password_field = sablono.core.wrap_attrs(sablono.core.password_field45568);

/**
 * Creates a range input field.
 */
sablono.core.range_field45576 = (function sablono$core$range_field45576(var_args){
var G__45578 = arguments.length;
switch (G__45578) {
case 1:
return sablono.core.range_field45576.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field45576.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.range_field45576.cljs$core$IFn$_invoke$arity$1 = (function (name__45386__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"range","range",-1014743483,null)),name__45386__auto__);
});

sablono.core.range_field45576.cljs$core$IFn$_invoke$arity$2 = (function (name__45386__auto__,value__45387__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"range","range",-1014743483,null)),name__45386__auto__,value__45387__auto__);
});

sablono.core.range_field45576.cljs$lang$maxFixedArity = 2;


sablono.core.range_field = sablono.core.wrap_attrs(sablono.core.range_field45576);

/**
 * Creates a search input field.
 */
sablono.core.search_field45583 = (function sablono$core$search_field45583(var_args){
var G__45586 = arguments.length;
switch (G__45586) {
case 1:
return sablono.core.search_field45583.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field45583.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.search_field45583.cljs$core$IFn$_invoke$arity$1 = (function (name__45386__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"search","search",-1089495947,null)),name__45386__auto__);
});

sablono.core.search_field45583.cljs$core$IFn$_invoke$arity$2 = (function (name__45386__auto__,value__45387__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"search","search",-1089495947,null)),name__45386__auto__,value__45387__auto__);
});

sablono.core.search_field45583.cljs$lang$maxFixedArity = 2;


sablono.core.search_field = sablono.core.wrap_attrs(sablono.core.search_field45583);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field45588 = (function sablono$core$tel_field45588(var_args){
var G__45590 = arguments.length;
switch (G__45590) {
case 1:
return sablono.core.tel_field45588.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field45588.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.tel_field45588.cljs$core$IFn$_invoke$arity$1 = (function (name__45386__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"tel","tel",1864669686,null)),name__45386__auto__);
});

sablono.core.tel_field45588.cljs$core$IFn$_invoke$arity$2 = (function (name__45386__auto__,value__45387__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"tel","tel",1864669686,null)),name__45386__auto__,value__45387__auto__);
});

sablono.core.tel_field45588.cljs$lang$maxFixedArity = 2;


sablono.core.tel_field = sablono.core.wrap_attrs(sablono.core.tel_field45588);

/**
 * Creates a text input field.
 */
sablono.core.text_field45594 = (function sablono$core$text_field45594(var_args){
var G__45596 = arguments.length;
switch (G__45596) {
case 1:
return sablono.core.text_field45594.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field45594.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.text_field45594.cljs$core$IFn$_invoke$arity$1 = (function (name__45386__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"text","text",-150030170,null)),name__45386__auto__);
});

sablono.core.text_field45594.cljs$core$IFn$_invoke$arity$2 = (function (name__45386__auto__,value__45387__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"text","text",-150030170,null)),name__45386__auto__,value__45387__auto__);
});

sablono.core.text_field45594.cljs$lang$maxFixedArity = 2;


sablono.core.text_field = sablono.core.wrap_attrs(sablono.core.text_field45594);

/**
 * Creates a time input field.
 */
sablono.core.time_field45601 = (function sablono$core$time_field45601(var_args){
var G__45603 = arguments.length;
switch (G__45603) {
case 1:
return sablono.core.time_field45601.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field45601.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.time_field45601.cljs$core$IFn$_invoke$arity$1 = (function (name__45386__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"time","time",-1268547887,null)),name__45386__auto__);
});

sablono.core.time_field45601.cljs$core$IFn$_invoke$arity$2 = (function (name__45386__auto__,value__45387__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"time","time",-1268547887,null)),name__45386__auto__,value__45387__auto__);
});

sablono.core.time_field45601.cljs$lang$maxFixedArity = 2;


sablono.core.time_field = sablono.core.wrap_attrs(sablono.core.time_field45601);

/**
 * Creates a url input field.
 */
sablono.core.url_field45604 = (function sablono$core$url_field45604(var_args){
var G__45613 = arguments.length;
switch (G__45613) {
case 1:
return sablono.core.url_field45604.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field45604.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.url_field45604.cljs$core$IFn$_invoke$arity$1 = (function (name__45386__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"url","url",1916828573,null)),name__45386__auto__);
});

sablono.core.url_field45604.cljs$core$IFn$_invoke$arity$2 = (function (name__45386__auto__,value__45387__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"url","url",1916828573,null)),name__45386__auto__,value__45387__auto__);
});

sablono.core.url_field45604.cljs$lang$maxFixedArity = 2;


sablono.core.url_field = sablono.core.wrap_attrs(sablono.core.url_field45604);

/**
 * Creates a week input field.
 */
sablono.core.week_field45616 = (function sablono$core$week_field45616(var_args){
var G__45623 = arguments.length;
switch (G__45623) {
case 1:
return sablono.core.week_field45616.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field45616.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.week_field45616.cljs$core$IFn$_invoke$arity$1 = (function (name__45386__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"week","week",314058249,null)),name__45386__auto__);
});

sablono.core.week_field45616.cljs$core$IFn$_invoke$arity$2 = (function (name__45386__auto__,value__45387__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"week","week",314058249,null)),name__45386__auto__,value__45387__auto__);
});

sablono.core.week_field45616.cljs$lang$maxFixedArity = 2;


sablono.core.week_field = sablono.core.wrap_attrs(sablono.core.week_field45616);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box45627 = (function sablono$core$check_box45627(var_args){
var G__45629 = arguments.length;
switch (G__45629) {
case 1:
return sablono.core.check_box45627.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box45627.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box45627.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.check_box45627.cljs$core$IFn$_invoke$arity$1 = (function (name){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id(name)], null)], null);
});

sablono.core.check_box45627.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id(name),new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.check_box45627.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id(name),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.check_box45627.cljs$lang$maxFixedArity = 3;


sablono.core.check_box = sablono.core.wrap_attrs(sablono.core.check_box45627);
/**
 * Creates a radio button.
 */
sablono.core.radio_button45633 = (function sablono$core$radio_button45633(var_args){
var G__45635 = arguments.length;
switch (G__45635) {
case 1:
return sablono.core.radio_button45633.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button45633.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button45633.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.radio_button45633.cljs$core$IFn$_invoke$arity$1 = (function (group){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id(sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([group], 0)))], null)], null);
});

sablono.core.radio_button45633.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id(sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([group], 0))),new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.radio_button45633.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id([cljs.core.str.cljs$core$IFn$_invoke$arity$1(sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([group], 0))),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([value], 0)))].join('')),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.radio_button45633.cljs$lang$maxFixedArity = 3;


sablono.core.radio_button = sablono.core.wrap_attrs(sablono.core.radio_button45633);
sablono.core.hash_key = (function sablono$core$hash_key(x){
var G__45641 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([x], 0));
return goog.string.hashCode(G__45641);
});
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options45642 = (function sablono$core$select_options45642(coll){
var iter__4523__auto__ = (function sablono$core$select_options45642_$_iter__45644(s__45645){
return (new cljs.core.LazySeq(null,(function (){
var s__45645__$1 = s__45645;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__45645__$1);
if(temp__5735__auto__){
var s__45645__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(s__45645__$2)){
var c__4521__auto__ = cljs.core.chunk_first(s__45645__$2);
var size__4522__auto__ = cljs.core.count(c__4521__auto__);
var b__45647 = cljs.core.chunk_buffer(size__4522__auto__);
if((function (){var i__45646 = (0);
while(true){
if((i__45646 < size__4522__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4521__auto__,i__45646);
cljs.core.chunk_append(b__45647,((cljs.core.sequential_QMARK_(x))?(function (){var vec__45649 = x;
var text = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45649,(0),null);
var val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45649,(1),null);
var disabled_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45649,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$(disabled_QMARK_);
if(cljs.core.sequential_QMARK_(val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key(text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),(sablono.core.select_options45642.cljs$core$IFn$_invoke$arity$1 ? sablono.core.select_options45642.cljs$core$IFn$_invoke$arity$1(val) : sablono.core.select_options45642.call(null,val))], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key(val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key(x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)));

var G__45805 = (i__45646 + (1));
i__45646 = G__45805;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__45647),sablono$core$select_options45642_$_iter__45644(cljs.core.chunk_rest(s__45645__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__45647),null);
}
} else {
var x = cljs.core.first(s__45645__$2);
return cljs.core.cons(((cljs.core.sequential_QMARK_(x))?(function (){var vec__45654 = x;
var text = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45654,(0),null);
var val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45654,(1),null);
var disabled_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45654,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$(disabled_QMARK_);
if(cljs.core.sequential_QMARK_(val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key(text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),(sablono.core.select_options45642.cljs$core$IFn$_invoke$arity$1 ? sablono.core.select_options45642.cljs$core$IFn$_invoke$arity$1(val) : sablono.core.select_options45642.call(null,val))], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key(val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key(x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)),sablono$core$select_options45642_$_iter__45644(cljs.core.rest(s__45645__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4523__auto__(coll);
});

sablono.core.select_options = sablono.core.wrap_attrs(sablono.core.select_options45642);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down45658 = (function sablono$core$drop_down45658(var_args){
var G__45660 = arguments.length;
switch (G__45660) {
case 2:
return sablono.core.drop_down45658.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down45658.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.drop_down45658.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down45658.cljs$core$IFn$_invoke$arity$3(name,options,null);
});

sablono.core.drop_down45658.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id(name)], null),(sablono.core.select_options.cljs$core$IFn$_invoke$arity$2 ? sablono.core.select_options.cljs$core$IFn$_invoke$arity$2(options,selected) : sablono.core.select_options.call(null,options,selected))], null);
});

sablono.core.drop_down45658.cljs$lang$maxFixedArity = 3;


sablono.core.drop_down = sablono.core.wrap_attrs(sablono.core.drop_down45658);
/**
 * Creates a text area element.
 */
sablono.core.text_area45661 = (function sablono$core$text_area45661(var_args){
var G__45663 = arguments.length;
switch (G__45663) {
case 1:
return sablono.core.text_area45661.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area45661.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

sablono.core.text_area45661.cljs$core$IFn$_invoke$arity$1 = (function (name){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id(name)], null)], null);
});

sablono.core.text_area45661.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id(name),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__4131__auto__ = value;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return undefined;
}
})()], null)], null);
});

sablono.core.text_area45661.cljs$lang$maxFixedArity = 2;


sablono.core.text_area = sablono.core.wrap_attrs(sablono.core.text_area45661);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label45670 = (function sablono$core$label45670(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"htmlFor","htmlFor",-1050291720),sablono.core.make_id(name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs(sablono.core.label45670);
/**
 * Creates a submit button.
 */
sablono.core.submit_button45676 = (function sablono$core$submit_button45676(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"submit",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs(sablono.core.submit_button45676);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button45688 = (function sablono$core$reset_button45688(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"reset",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs(sablono.core.reset_button45688);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to45694 = (function sablono$core$form_to45694(var_args){
var args__4736__auto__ = [];
var len__4730__auto___45812 = arguments.length;
var i__4731__auto___45813 = (0);
while(true){
if((i__4731__auto___45813 < len__4730__auto___45812)){
args__4736__auto__.push((arguments[i__4731__auto___45813]));

var G__45814 = (i__4731__auto___45813 + (1));
i__4731__auto___45813 = G__45814;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return sablono.core.form_to45694.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

sablono.core.form_to45694.cljs$core$IFn$_invoke$arity$variadic = (function (p__45698,body){
var vec__45699 = p__45698;
var method = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45699,(0),null);
var action = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45699,(1),null);
var method_str = clojure.string.upper_case(cljs.core.name(method));
var action_uri = sablono.util.to_uri(action);
return cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(((cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"get","get",1683182755),null,new cljs.core.Keyword(null,"post","post",269697687),null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),method_str,new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),"POST",new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null),(function (){var G__45706 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),(3735928559)], null);
var G__45707 = "_method";
var G__45708 = method_str;
return (sablono.core.hidden_field.cljs$core$IFn$_invoke$arity$3 ? sablono.core.hidden_field.cljs$core$IFn$_invoke$arity$3(G__45706,G__45707,G__45708) : sablono.core.hidden_field.call(null,G__45706,G__45707,G__45708));
})()], null)),body));
});

sablono.core.form_to45694.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
sablono.core.form_to45694.cljs$lang$applyTo = (function (seq45695){
var G__45696 = cljs.core.first(seq45695);
var seq45695__$1 = cljs.core.next(seq45695);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__45696,seq45695__$1);
});


sablono.core.form_to = sablono.core.wrap_attrs(sablono.core.form_to45694);

//# sourceMappingURL=sablono.core.js.map
