goog.provide('helix.impl.props');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs_bean.core');
goog.require('goog.object');
helix.impl.props.aria_data_special_case_re = /^(aria-|data-).*/;
helix.impl.props.camel_regexp = RegExp("-(\\w)","g");
/**
 * Returns camel case version of the string, e.g. "http-equiv" becomes "httpEquiv".
 */
helix.impl.props.camel_case = (function helix$impl$props$camel_case(s){
if((((s instanceof cljs.core.Keyword)) || (typeof s === 'string') || ((s instanceof cljs.core.Symbol)))){
var name_str = cljs.core.name(s);
if((!((name_str.match(helix.impl.props.aria_data_special_case_re) == null)))){
return name_str;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(name_str.substring((0),(1)),"'")){
return name_str.substring((1));
} else {
return name_str.replace(helix.impl.props.camel_regexp,((function (name_str){
return (function (p1__43221_SHARP_,p2__43220_SHARP_){
return p2__43220_SHARP_.toUpperCase();
});})(name_str))
);

}
}
} else {
return s;
}
});
helix.impl.props.kw__GT_str = (function helix$impl$props$kw__GT_str(kw){
var kw_ns = cljs.core.namespace(kw);
var kw_name = cljs.core.name(kw);
if((kw_ns == null)){
return kw_name;
} else {
return [kw_ns,"/",kw_name].join('');
}
});
helix.impl.props.set_obj = (function helix$impl$props$set_obj(o,k,v){
var G__43227 = o;
goog.object.set(G__43227,k,v);

return G__43227;
});
helix.impl.props.__GT_js = (function helix$impl$props$__GT_js(x){
return cljs.core.clj__GT_js.cljs$core$IFn$_invoke$arity$variadic(x,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keyword-fn","keyword-fn",-64566675),cljs.core.comp.cljs$core$IFn$_invoke$arity$2(helix.impl.props.camel_case,cljs.core.name)], 0));
});
helix.impl.props.primitive_obj = (function helix$impl$props$primitive_obj(var_args){
var G__43234 = arguments.length;
switch (G__43234) {
case 0:
return helix.impl.props.primitive_obj.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return helix.impl.props.primitive_obj.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return helix.impl.props.primitive_obj.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

helix.impl.props.primitive_obj.cljs$core$IFn$_invoke$arity$0 = (function (){
return ({});
});

helix.impl.props.primitive_obj.cljs$core$IFn$_invoke$arity$1 = (function (m){
return helix.impl.props.primitive_obj.cljs$core$IFn$_invoke$arity$2(m,helix.impl.props.primitive_obj.cljs$core$IFn$_invoke$arity$0());
});

helix.impl.props.primitive_obj.cljs$core$IFn$_invoke$arity$2 = (function (m,o){
while(true){
if(cljs.core.seq(m)){
var G__43269 = cljs.core.rest(m);
var G__43270 = (function (){var entry = cljs.core.first(m);
return helix.impl.props.set_obj(o,helix.impl.props.camel_case(helix.impl.props.kw__GT_str(cljs.core.key(entry))),helix.impl.props.__GT_js(cljs.core.val(entry)));
})();
m = G__43269;
o = G__43270;
continue;
} else {
return o;
}
break;
}
});

helix.impl.props.primitive_obj.cljs$lang$maxFixedArity = 2;

helix.impl.props.into_js_array = (function helix$impl$props$into_js_array(aseq){
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(aseq);
});
helix.impl.props.merge_obj = (function helix$impl$props$merge_obj(o1,o2){
return Object.assign(o1,o2);
});
helix.impl.props._native_props = (function helix$impl$props$_native_props(var_args){
var G__43252 = arguments.length;
switch (G__43252) {
case 1:
return helix.impl.props._native_props.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return helix.impl.props._native_props.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

helix.impl.props._native_props.cljs$core$IFn$_invoke$arity$1 = (function (m){
return helix.impl.props._native_props.cljs$core$IFn$_invoke$arity$2(m,helix.impl.props.primitive_obj.cljs$core$IFn$_invoke$arity$0());
});

helix.impl.props._native_props.cljs$core$IFn$_invoke$arity$2 = (function (m,o){
while(true){
if(cljs.core.seq(m)){
var G__43277 = cljs.core.rest(m);
var G__43278 = (function (){var entry = cljs.core.first(m);
var k = cljs.core.key(entry);
var v = cljs.core.val(entry);
var G__43258 = k;
var G__43258__$1 = (((G__43258 instanceof cljs.core.Keyword))?G__43258.fqn:null);
switch (G__43258__$1) {
case "class":
return helix.impl.props.set_obj(o,"className",v);

break;
case "for":
return helix.impl.props.set_obj(o,"htmlFor",v);

break;
case "style":
return helix.impl.props.set_obj(o,"style",((cljs.core.vector_QMARK_(v))?helix.impl.props.into_js_array(cljs.core.map.cljs$core$IFn$_invoke$arity$2(helix.impl.props.primitive_obj,v)):helix.impl.props.primitive_obj.cljs$core$IFn$_invoke$arity$1(v)));

break;
default:
return helix.impl.props.set_obj(o,helix.impl.props.camel_case(helix.impl.props.kw__GT_str(k)),v);

}
})();
m = G__43277;
o = G__43278;
continue;
} else {
return o;
}
break;
}
});

helix.impl.props._native_props.cljs$lang$maxFixedArity = 2;

helix.impl.props._props = (function helix$impl$props$_props(var_args){
var G__43260 = arguments.length;
switch (G__43260) {
case 1:
return helix.impl.props._props.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return helix.impl.props._props.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

helix.impl.props._props.cljs$core$IFn$_invoke$arity$1 = (function (m){
var temp__5733__auto__ = (function (){var G__43261 = new cljs.core.Symbol(null,"&","&",-2144855648,null);
return (m.cljs$core$IFn$_invoke$arity$1 ? m.cljs$core$IFn$_invoke$arity$1(G__43261) : m.call(null,G__43261));
})();
if(cljs.core.truth_(temp__5733__auto__)){
var spread_sym = temp__5733__auto__;
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol("helix.impl.props","merge-obj","helix.impl.props/merge-obj",-1237733234,null),null,(1),null)),(new cljs.core.List(null,helix.impl.props._props.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(m,new cljs.core.Symbol(null,"&","&",-2144855648,null)),helix.impl.props.primitive_obj.cljs$core$IFn$_invoke$arity$0()),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("helix.impl.props","-props","helix.impl.props/-props",-819122824,null),null,(1),null)),(new cljs.core.List(null,spread_sym,null,(1),null))))),null,(1),null))], 0))));
} else {
return helix.impl.props._props.cljs$core$IFn$_invoke$arity$2(m,helix.impl.props.primitive_obj.cljs$core$IFn$_invoke$arity$0());
}
});

helix.impl.props._props.cljs$core$IFn$_invoke$arity$2 = (function (m,o){
while(true){
if(cljs.core.seq(m)){
var G__43285 = cljs.core.rest(m);
var G__43286 = (function (){var entry = cljs.core.first(m);
return helix.impl.props.set_obj(o,helix.impl.props.kw__GT_str(cljs.core.key(entry)),cljs.core.val(entry));
})();
m = G__43285;
o = G__43286;
continue;
} else {
return o;
}
break;
}
});

helix.impl.props._props.cljs$lang$maxFixedArity = 2;


//# sourceMappingURL=helix.impl.props.js.map
