goog.provide('helix.hooks');
goog.require('cljs.core');
var module$node_modules$react$index=shadow.js.require("module$node_modules$react$index", {});
goog.require('goog.object');
helix.hooks.raw_use_effect = module$node_modules$react$index.useEffect;

helix.hooks.raw_use_layout_effect = module$node_modules$react$index.useLayoutEffect;

helix.hooks.raw_use_memo = module$node_modules$react$index.useMemo;

helix.hooks.raw_use_callback = module$node_modules$react$index.useCallback;

helix.hooks.raw_use_imperative_handle = module$node_modules$react$index.useImperativeHandle;
/**
 * Like `react/useState`, but the update function returned can be used similar
 *   to `swap!`.
 * 
 *   Example:
 *   ```
 *   (let [[state set-state] (use-state {:count 0})]
 * ;; ...
 * (set-state update :count inc))
 *   ```
 */
helix.hooks.use_state = (function helix$hooks$use_state(initial){
var vec__43222 = module$node_modules$react$index.useState(initial);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43222,(0),null);
var u = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43222,(1),null);
var updater = (function (){var G__43225 = ((function (vec__43222,v,u){
return (function() {
var helix$hooks$use_state_$_updater = null;
var helix$hooks$use_state_$_updater__1 = (function (x){
return (u.cljs$core$IFn$_invoke$arity$1 ? u.cljs$core$IFn$_invoke$arity$1(x) : u.call(null,x));
});
var helix$hooks$use_state_$_updater__2 = (function() { 
var G__43300__delegate = function (f,xs){
return helix$hooks$use_state_$_updater.cljs$core$IFn$_invoke$arity$1(((function (vec__43222,v,u){
return (function helix$hooks$use_state_$_updater_$_spread_updater(x){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f,x,xs);
});})(vec__43222,v,u))
);
};
var G__43300 = function (f,var_args){
var xs = null;
if (arguments.length > 1) {
var G__43301__i = 0, G__43301__a = new Array(arguments.length -  1);
while (G__43301__i < G__43301__a.length) {G__43301__a[G__43301__i] = arguments[G__43301__i + 1]; ++G__43301__i;}
  xs = new cljs.core.IndexedSeq(G__43301__a,0,null);
} 
return G__43300__delegate.call(this,f,xs);};
G__43300.cljs$lang$maxFixedArity = 1;
G__43300.cljs$lang$applyTo = (function (arglist__43302){
var f = cljs.core.first(arglist__43302);
var xs = cljs.core.rest(arglist__43302);
return G__43300__delegate(f,xs);
});
G__43300.cljs$core$IFn$_invoke$arity$variadic = G__43300__delegate;
return G__43300;
})()
;
helix$hooks$use_state_$_updater = function(f,var_args){
var xs = var_args;
switch(arguments.length){
case 1:
return helix$hooks$use_state_$_updater__1.call(this,f);
default:
var G__43303 = null;
if (arguments.length > 1) {
var G__43304__i = 0, G__43304__a = new Array(arguments.length -  1);
while (G__43304__i < G__43304__a.length) {G__43304__a[G__43304__i] = arguments[G__43304__i + 1]; ++G__43304__i;}
G__43303 = new cljs.core.IndexedSeq(G__43304__a,0,null);
}
return helix$hooks$use_state_$_updater__2.cljs$core$IFn$_invoke$arity$variadic(f, G__43303);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
helix$hooks$use_state_$_updater.cljs$lang$maxFixedArity = 1;
helix$hooks$use_state_$_updater.cljs$lang$applyTo = helix$hooks$use_state_$_updater__2.cljs$lang$applyTo;
helix$hooks$use_state_$_updater.cljs$core$IFn$_invoke$arity$1 = helix$hooks$use_state_$_updater__1;
helix$hooks$use_state_$_updater.cljs$core$IFn$_invoke$arity$variadic = helix$hooks$use_state_$_updater__2.cljs$core$IFn$_invoke$arity$variadic;
return helix$hooks$use_state_$_updater;
})()
;})(vec__43222,v,u))
;
var G__43226 = [];
return module$node_modules$react$index.useCallback(G__43225,G__43226);
})();
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [v,updater], null);
});
/**
 * Just like react/useRef. Supports accessing the "current" property via
 *   dereference (@) and updating the "current" property via `reset!` and `swap!`
 */
helix.hooks.use_ref = (function helix$hooks$use_ref(x){
var ref = module$node_modules$react$index.useRef(null);
if((ref.current == null)){
ref.current = (function (){var x43228 = ({"current": x});
x43228.cljs$core$IDeref$ = cljs.core.PROTOCOL_SENTINEL;

x43228.cljs$core$IDeref$_deref$arity$1 = ((function (x43228,ref){
return (function (this$){
var this$__$1 = this;
return this$__$1.current;
});})(x43228,ref))
;

x43228.cljs$core$IReset$ = cljs.core.PROTOCOL_SENTINEL;

x43228.cljs$core$IReset$_reset_BANG_$arity$2 = ((function (x43228,ref){
return (function (this$,v){
var this$__$1 = this;
return goog.object.set(this$__$1,"current",v);
});})(x43228,ref))
;

x43228.cljs$core$ISwap$ = cljs.core.PROTOCOL_SENTINEL;

x43228.cljs$core$ISwap$_swap_BANG_$arity$2 = ((function (x43228,ref){
return (function (this$,f){
var this$__$1 = this;
var G__43230 = this$__$1;
var G__43231 = "current";
var G__43232 = (function (){var G__43233 = this$__$1.current;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__43233) : f.call(null,G__43233));
})();
return goog.object.set(G__43230,G__43231,G__43232);
});})(x43228,ref))
;

x43228.cljs$core$ISwap$_swap_BANG_$arity$3 = ((function (x43228,ref){
return (function (this$,f,a){
var this$__$1 = this;
var G__43235 = this$__$1;
var G__43236 = "current";
var G__43237 = (function (){var G__43238 = this$__$1.current;
var G__43239 = a;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__43238,G__43239) : f.call(null,G__43238,G__43239));
})();
return goog.object.set(G__43235,G__43236,G__43237);
});})(x43228,ref))
;

x43228.cljs$core$ISwap$_swap_BANG_$arity$4 = ((function (x43228,ref){
return (function (this$,f,a,b){
var this$__$1 = this;
var G__43240 = this$__$1;
var G__43241 = "current";
var G__43242 = (function (){var G__43243 = this$__$1.current;
var G__43244 = a;
var G__43245 = b;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__43243,G__43244,G__43245) : f.call(null,G__43243,G__43244,G__43245));
})();
return goog.object.set(G__43240,G__43241,G__43242);
});})(x43228,ref))
;

x43228.cljs$core$ISwap$_swap_BANG_$arity$5 = ((function (x43228,ref){
return (function (this$,f,a,b,xs){
var this$__$1 = this;
var G__43246 = this$__$1;
var G__43247 = "current";
var G__43248 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,this$__$1.current,a,b,xs);
return goog.object.set(G__43246,G__43247,G__43248);
});})(x43228,ref))
;

return x43228;
})();
} else {
}

return ref.current;
});
/**
 * Just react/useReducer.
 */
helix.hooks.use_reducer = (function helix$hooks$use_reducer(var_args){
var G__43250 = arguments.length;
switch (G__43250) {
case 2:
return helix.hooks.use_reducer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return helix.hooks.use_reducer.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

helix.hooks.use_reducer.cljs$core$IFn$_invoke$arity$2 = (function (reducer,init_state){
return helix.hooks.use_reducer.cljs$core$IFn$_invoke$arity$3(reducer,init_state,undefined);
});

helix.hooks.use_reducer.cljs$core$IFn$_invoke$arity$3 = (function (reducer,init_state,init){
var G__43253 = (function (){var G__43256 = (function (){
if((((!(cljs.core.fn_QMARK_(reducer)))) && (cljs.core.ifn_QMARK_(reducer)))){
return (function helix$hooks$wrap_ifn(state,action){
return (reducer.cljs$core$IFn$_invoke$arity$2 ? reducer.cljs$core$IFn$_invoke$arity$2(state,action) : reducer.call(null,state,action));
});
} else {
return reducer;
}
});
var G__43257 = [reducer];
return module$node_modules$react$index.useMemo(G__43256,G__43257);
})();
var G__43254 = init_state;
var G__43255 = init;
return module$node_modules$react$index.useReducer(G__43253,G__43254,G__43255);
});

helix.hooks.use_reducer.cljs$lang$maxFixedArity = 3;

/**
 * Just react/useContext
 */
helix.hooks.use_context = module$node_modules$react$index.useContext;
helix.hooks.wrap_fx = (function helix$hooks$wrap_fx(f){
return (function helix$hooks$wrap_fx_$_wrap_fx_return(){
var x = (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
if(cljs.core.fn_QMARK_(x)){
return x;
} else {
return undefined;
}
});
});
helix.hooks.simple_body_QMARK_ = (function helix$hooks$simple_body_QMARK_(body){
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(body),(1))) && ((cljs.core.first(body) instanceof cljs.core.Symbol)));
});
helix.hooks.determine_deps = (function helix$hooks$determine_deps(deps){
var G__43262 = deps;
var G__43262__$1 = (((G__43262 instanceof cljs.core.Keyword))?G__43262.fqn:null);
switch (G__43262__$1) {
case "once":
return [];

break;
case "always":
return undefined;

break;
case "auto-deps":
throw (new Error("Cannot use :auto-deps outside of macro."));

break;
default:
return cljs.core.to_array(deps);

}
});
helix.hooks.use_effect_STAR_ = (function helix$hooks$use_effect_STAR_(var_args){
var G__43264 = arguments.length;
switch (G__43264) {
case 1:
return helix.hooks.use_effect_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return helix.hooks.use_effect_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

helix.hooks.use_effect_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (f){
var G__43265 = helix.hooks.wrap_fx(f);
return module$node_modules$react$index.useEffect(G__43265);
});

helix.hooks.use_effect_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (f,deps){
if(cljs.core.truth_(goog.DEBUG)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(deps,new cljs.core.Keyword(null,"auto-deps","auto-deps",-2124919365))){
throw (new Error("Can't use `:auto-deps` with `use-effect*`; use `use-effect` macro for that"));
} else {
}
} else {
}

var G__43266 = helix.hooks.wrap_fx(f);
var G__43267 = cljs.core.to_array(deps);
return module$node_modules$react$index.useEffect(G__43266,G__43267);
});

helix.hooks.use_effect_STAR_.cljs$lang$maxFixedArity = 2;

helix.hooks.use_layout_effect_STAR_ = (function helix$hooks$use_layout_effect_STAR_(var_args){
var G__43272 = arguments.length;
switch (G__43272) {
case 1:
return helix.hooks.use_layout_effect_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return helix.hooks.use_layout_effect_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

helix.hooks.use_layout_effect_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (f){
var G__43276 = helix.hooks.wrap_fx(f);
return module$node_modules$react$index.useLayoutEffect(G__43276);
});

helix.hooks.use_layout_effect_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (f,deps){
if(cljs.core.truth_(goog.DEBUG)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(deps,new cljs.core.Keyword(null,"auto-deps","auto-deps",-2124919365))){
throw (new Error("Can't use `:auto-deps` with `use-layout-effect*`; use `use-layout-effect` macro for that"));
} else {
}
} else {
}

var G__43280 = helix.hooks.wrap_fx(f);
var G__43281 = cljs.core.to_array(deps);
return module$node_modules$react$index.useLayoutEffect(G__43280,G__43281);
});

helix.hooks.use_layout_effect_STAR_.cljs$lang$maxFixedArity = 2;

helix.hooks.use_memo_STAR_ = (function helix$hooks$use_memo_STAR_(var_args){
var G__43284 = arguments.length;
switch (G__43284) {
case 1:
return helix.hooks.use_memo_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return helix.hooks.use_memo_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

helix.hooks.use_memo_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (f){
return module$node_modules$react$index.useMemo(f);
});

helix.hooks.use_memo_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (f,deps){
if(cljs.core.truth_(goog.DEBUG)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(deps,new cljs.core.Keyword(null,"auto-deps","auto-deps",-2124919365))){
throw (new Error("Can't use `:auto-deps` with `use-memo*`; use `use-memo` macro for that"));
} else {
}
} else {
}

var G__43287 = f;
var G__43288 = cljs.core.to_array(deps);
return module$node_modules$react$index.useMemo(G__43287,G__43288);
});

helix.hooks.use_memo_STAR_.cljs$lang$maxFixedArity = 2;

helix.hooks.use_callback_STAR_ = (function helix$hooks$use_callback_STAR_(var_args){
var G__43290 = arguments.length;
switch (G__43290) {
case 1:
return helix.hooks.use_callback_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return helix.hooks.use_callback_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

helix.hooks.use_callback_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (f){
return module$node_modules$react$index.useCallback(f);
});

helix.hooks.use_callback_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (f,deps){
if(cljs.core.truth_(goog.DEBUG)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(deps,new cljs.core.Keyword(null,"auto-deps","auto-deps",-2124919365))){
throw (new Error("Can't use `:auto-deps` with `use-callback*`; use `use-callback` macro for that"));
} else {
}
} else {
}

var G__43291 = f;
var G__43292 = cljs.core.to_array(deps);
return module$node_modules$react$index.useCallback(G__43291,G__43292);
});

helix.hooks.use_callback_STAR_.cljs$lang$maxFixedArity = 2;

helix.hooks.use_imperative_handle_STAR_ = (function helix$hooks$use_imperative_handle_STAR_(var_args){
var G__43295 = arguments.length;
switch (G__43295) {
case 2:
return helix.hooks.use_imperative_handle_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return helix.hooks.use_imperative_handle_STAR_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

helix.hooks.use_imperative_handle_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (ref,f){
return module$node_modules$react$index.useImperativeHandle(ref,f);
});

helix.hooks.use_imperative_handle_STAR_.cljs$core$IFn$_invoke$arity$3 = (function (ref,f,deps){
if(cljs.core.truth_(goog.DEBUG)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(deps,new cljs.core.Keyword(null,"auto-deps","auto-deps",-2124919365))){
throw (new Error("Can't use `:auto-deps` with `use-imperative-handle*`; use `use-imperative-handle` macro for that"));
} else {
}
} else {
}

var G__43297 = ref;
var G__43298 = f;
var G__43299 = cljs.core.to_array(deps);
return module$node_modules$react$index.useImperativeHandle(G__43297,G__43298,G__43299);
});

helix.hooks.use_imperative_handle_STAR_.cljs$lang$maxFixedArity = 3;

/**
 * just react/useDebugValue
 */
helix.hooks.use_debug_value = module$node_modules$react$index.debugValue;

//# sourceMappingURL=helix.hooks.js.map
