goog.provide('clojure.data');
goog.require('cljs.core');
goog.require('clojure.set');
/**
 * Internal helper for diff.
 */
clojure.data.atom_diff = (function clojure$data$atom_diff(a,b){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a,b)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null,a], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,null], null);
}
});
/**
 * Convert an associative-by-numeric-index collection into
 * an equivalent vector, with nil for any missing keys
 */
clojure.data.vectorize = (function clojure$data$vectorize(m){
if(cljs.core.seq(m)){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (result,p__32378){
var vec__32379 = p__32378;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32379,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32379,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(result,k,v);
}),cljs.core.vec(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.keys(m)),null)),m);
} else {
return null;
}
});
/**
 * Diff associative things a and b, comparing only the key k.
 */
clojure.data.diff_associative_key = (function clojure$data$diff_associative_key(a,b,k){
var va = cljs.core.get.cljs$core$IFn$_invoke$arity$2(a,k);
var vb = cljs.core.get.cljs$core$IFn$_invoke$arity$2(b,k);
var vec__32387 = clojure.data.diff(va,vb);
var a_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32387,(0),null);
var b_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32387,(1),null);
var ab = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32387,(2),null);
var in_a = cljs.core.contains_QMARK_(a,k);
var in_b = cljs.core.contains_QMARK_(b,k);
var same = ((in_a) && (in_b) && ((((!((ab == null)))) || ((((va == null)) && ((vb == null)))))));
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [((((in_a) && ((((!((a_STAR_ == null)))) || ((!(same)))))))?cljs.core.PersistentArrayMap.createAsIfByAssoc([k,a_STAR_]):null),((((in_b) && ((((!((b_STAR_ == null)))) || ((!(same)))))))?cljs.core.PersistentArrayMap.createAsIfByAssoc([k,b_STAR_]):null),((same)?cljs.core.PersistentArrayMap.createAsIfByAssoc([k,ab]):null)], null);
});
/**
 * Diff associative things a and b, comparing only keys in ks (if supplied).
 */
clojure.data.diff_associative = (function clojure$data$diff_associative(var_args){
var G__32441 = arguments.length;
switch (G__32441) {
case 2:
return clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
return clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$3(a,b,clojure.set.union.cljs$core$IFn$_invoke$arity$2(cljs.core.keys(a),cljs.core.keys(b)));
});

clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$3 = (function (a,b,ks){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (diff1,diff2){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.merge,diff1,diff2));
}),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null,null], null),cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$3(clojure.data.diff_associative_key,a,b),ks));
});

clojure.data.diff_associative.cljs$lang$maxFixedArity = 3;

clojure.data.diff_sequential = (function clojure$data$diff_sequential(a,b){
return cljs.core.vec(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.data.vectorize,clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$3(((cljs.core.vector_QMARK_(a))?a:cljs.core.vec(a)),((cljs.core.vector_QMARK_(b))?b:cljs.core.vec(b)),cljs.core.range.cljs$core$IFn$_invoke$arity$1((function (){var x__4219__auto__ = cljs.core.count(a);
var y__4220__auto__ = cljs.core.count(b);
return ((x__4219__auto__ > y__4220__auto__) ? x__4219__auto__ : y__4220__auto__);
})()))));
});
clojure.data.diff_set = (function clojure$data$diff_set(a,b){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.not_empty(clojure.set.difference.cljs$core$IFn$_invoke$arity$2(a,b)),cljs.core.not_empty(clojure.set.difference.cljs$core$IFn$_invoke$arity$2(b,a)),cljs.core.not_empty(clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(a,b))], null);
});

/**
 * Implementation detail. Subject to change.
 * @interface
 */
clojure.data.EqualityPartition = function(){};

/**
 * Implementation detail. Subject to change.
 */
clojure.data.equality_partition = (function clojure$data$equality_partition(x){
if((((!((x == null)))) && ((!((x.clojure$data$EqualityPartition$equality_partition$arity$1 == null)))))){
return x.clojure$data$EqualityPartition$equality_partition$arity$1(x);
} else {
var x__4433__auto__ = (((x == null))?null:x);
var m__4434__auto__ = (clojure.data.equality_partition[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__4434__auto__.call(null,x));
} else {
var m__4431__auto__ = (clojure.data.equality_partition["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__4431__auto__.call(null,x));
} else {
throw cljs.core.missing_protocol("EqualityPartition.equality-partition",x);
}
}
}
});


/**
 * Implementation detail. Subject to change.
 * @interface
 */
clojure.data.Diff = function(){};

/**
 * Implementation detail. Subject to change.
 */
clojure.data.diff_similar = (function clojure$data$diff_similar(a,b){
if((((!((a == null)))) && ((!((a.clojure$data$Diff$diff_similar$arity$2 == null)))))){
return a.clojure$data$Diff$diff_similar$arity$2(a,b);
} else {
var x__4433__auto__ = (((a == null))?null:a);
var m__4434__auto__ = (clojure.data.diff_similar[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(a,b) : m__4434__auto__.call(null,a,b));
} else {
var m__4431__auto__ = (clojure.data.diff_similar["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(a,b) : m__4431__auto__.call(null,a,b));
} else {
throw cljs.core.missing_protocol("Diff.diff-similar",a);
}
}
}
});

goog.object.set(clojure.data.EqualityPartition,"null",true);

var G__32520_32755 = clojure.data.equality_partition;
var G__32521_32756 = "null";
var G__32522_32757 = ((function (G__32520_32755,G__32521_32756){
return (function (x){
return new cljs.core.Keyword(null,"atom","atom",-397043653);
});})(G__32520_32755,G__32521_32756))
;
goog.object.set(G__32520_32755,G__32521_32756,G__32522_32757);

goog.object.set(clojure.data.EqualityPartition,"string",true);

var G__32531_32763 = clojure.data.equality_partition;
var G__32532_32764 = "string";
var G__32533_32765 = ((function (G__32531_32763,G__32532_32764){
return (function (x){
return new cljs.core.Keyword(null,"atom","atom",-397043653);
});})(G__32531_32763,G__32532_32764))
;
goog.object.set(G__32531_32763,G__32532_32764,G__32533_32765);

goog.object.set(clojure.data.EqualityPartition,"number",true);

var G__32537_32777 = clojure.data.equality_partition;
var G__32538_32778 = "number";
var G__32539_32779 = ((function (G__32537_32777,G__32538_32778){
return (function (x){
return new cljs.core.Keyword(null,"atom","atom",-397043653);
});})(G__32537_32777,G__32538_32778))
;
goog.object.set(G__32537_32777,G__32538_32778,G__32539_32779);

goog.object.set(clojure.data.EqualityPartition,"array",true);

var G__32542_32784 = clojure.data.equality_partition;
var G__32543_32785 = "array";
var G__32544_32786 = ((function (G__32542_32784,G__32543_32785){
return (function (x){
return new cljs.core.Keyword(null,"sequential","sequential",-1082983960);
});})(G__32542_32784,G__32543_32785))
;
goog.object.set(G__32542_32784,G__32543_32785,G__32544_32786);

goog.object.set(clojure.data.EqualityPartition,"function",true);

var G__32547_32787 = clojure.data.equality_partition;
var G__32548_32788 = "function";
var G__32549_32789 = ((function (G__32547_32787,G__32548_32788){
return (function (x){
return new cljs.core.Keyword(null,"atom","atom",-397043653);
});})(G__32547_32787,G__32548_32788))
;
goog.object.set(G__32547_32787,G__32548_32788,G__32549_32789);

goog.object.set(clojure.data.EqualityPartition,"boolean",true);

var G__32556_32790 = clojure.data.equality_partition;
var G__32557_32791 = "boolean";
var G__32558_32792 = ((function (G__32556_32790,G__32557_32791){
return (function (x){
return new cljs.core.Keyword(null,"atom","atom",-397043653);
});})(G__32556_32790,G__32557_32791))
;
goog.object.set(G__32556_32790,G__32557_32791,G__32558_32792);

goog.object.set(clojure.data.EqualityPartition,"_",true);

var G__32561_32795 = clojure.data.equality_partition;
var G__32562_32796 = "_";
var G__32563_32797 = ((function (G__32561_32795,G__32562_32796){
return (function (x){
if((((!((x == null))))?(((((x.cljs$lang$protocol_mask$partition0$ & (1024))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IMap$))))?true:(((!x.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.IMap,x):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IMap,x))){
return new cljs.core.Keyword(null,"map","map",1371690461);
} else {
if((((!((x == null))))?(((((x.cljs$lang$protocol_mask$partition0$ & (4096))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISet$))))?true:(((!x.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.ISet,x):false)):cljs.core.native_satisfies_QMARK_(cljs.core.ISet,x))){
return new cljs.core.Keyword(null,"set","set",304602554);
} else {
if((((!((x == null))))?(((((x.cljs$lang$protocol_mask$partition0$ & (16777216))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISequential$))))?true:(((!x.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,x):false)):cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,x))){
return new cljs.core.Keyword(null,"sequential","sequential",-1082983960);
} else {
return new cljs.core.Keyword(null,"atom","atom",-397043653);

}
}
}
});})(G__32561_32795,G__32562_32796))
;
goog.object.set(G__32561_32795,G__32562_32796,G__32563_32797);
goog.object.set(clojure.data.Diff,"null",true);

var G__32590_32810 = clojure.data.diff_similar;
var G__32591_32811 = "null";
var G__32592_32812 = ((function (G__32590_32810,G__32591_32811){
return (function (a,b){
return clojure.data.atom_diff(a,b);
});})(G__32590_32810,G__32591_32811))
;
goog.object.set(G__32590_32810,G__32591_32811,G__32592_32812);

goog.object.set(clojure.data.Diff,"string",true);

var G__32601_32813 = clojure.data.diff_similar;
var G__32602_32814 = "string";
var G__32604_32815 = ((function (G__32601_32813,G__32602_32814){
return (function (a,b){
return clojure.data.atom_diff(a,b);
});})(G__32601_32813,G__32602_32814))
;
goog.object.set(G__32601_32813,G__32602_32814,G__32604_32815);

goog.object.set(clojure.data.Diff,"number",true);

var G__32610_32818 = clojure.data.diff_similar;
var G__32611_32819 = "number";
var G__32612_32820 = ((function (G__32610_32818,G__32611_32819){
return (function (a,b){
return clojure.data.atom_diff(a,b);
});})(G__32610_32818,G__32611_32819))
;
goog.object.set(G__32610_32818,G__32611_32819,G__32612_32820);

goog.object.set(clojure.data.Diff,"array",true);

var G__32616_32826 = clojure.data.diff_similar;
var G__32617_32827 = "array";
var G__32618_32828 = ((function (G__32616_32826,G__32617_32827){
return (function (a,b){
return clojure.data.diff_sequential(a,b);
});})(G__32616_32826,G__32617_32827))
;
goog.object.set(G__32616_32826,G__32617_32827,G__32618_32828);

goog.object.set(clojure.data.Diff,"function",true);

var G__32624_32831 = clojure.data.diff_similar;
var G__32625_32832 = "function";
var G__32626_32833 = ((function (G__32624_32831,G__32625_32832){
return (function (a,b){
return clojure.data.atom_diff(a,b);
});})(G__32624_32831,G__32625_32832))
;
goog.object.set(G__32624_32831,G__32625_32832,G__32626_32833);

goog.object.set(clojure.data.Diff,"boolean",true);

var G__32629_32837 = clojure.data.diff_similar;
var G__32630_32838 = "boolean";
var G__32631_32839 = ((function (G__32629_32837,G__32630_32838){
return (function (a,b){
return clojure.data.atom_diff(a,b);
});})(G__32629_32837,G__32630_32838))
;
goog.object.set(G__32629_32837,G__32630_32838,G__32631_32839);

goog.object.set(clojure.data.Diff,"_",true);

var G__32634_32842 = clojure.data.diff_similar;
var G__32635_32843 = "_";
var G__32636_32844 = ((function (G__32634_32842,G__32635_32843){
return (function (a,b){
var fexpr__32644 = (function (){var G__32649 = clojure.data.equality_partition(a);
var G__32649__$1 = (((G__32649 instanceof cljs.core.Keyword))?G__32649.fqn:null);
switch (G__32649__$1) {
case "atom":
return clojure.data.atom_diff;

break;
case "set":
return clojure.data.diff_set;

break;
case "sequential":
return clojure.data.diff_sequential;

break;
case "map":
return clojure.data.diff_associative;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__32649__$1)].join('')));

}
})();
return (fexpr__32644.cljs$core$IFn$_invoke$arity$2 ? fexpr__32644.cljs$core$IFn$_invoke$arity$2(a,b) : fexpr__32644.call(null,a,b));
});})(G__32634_32842,G__32635_32843))
;
goog.object.set(G__32634_32842,G__32635_32843,G__32636_32844);
/**
 * Recursively compares a and b, returning a tuple of
 *   [things-only-in-a things-only-in-b things-in-both].
 *   Comparison rules:
 * 
 *   * For equal a and b, return [nil nil a].
 *   * Maps are subdiffed where keys match and values differ.
 *   * Sets are never subdiffed.
 *   * All sequential things are treated as associative collections
 *  by their indexes, with results returned as vectors.
 *   * Everything else (including strings!) is treated as
 *  an atom and compared for equality.
 */
clojure.data.diff = (function clojure$data$diff(a,b){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a,b)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null,a], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(clojure.data.equality_partition(a),clojure.data.equality_partition(b))){
return clojure.data.diff_similar(a,b);
} else {
return clojure.data.atom_diff(a,b);
}
}
});

//# sourceMappingURL=clojure.data.js.map
