goog.provide('cljs.repl');
goog.require('cljs.core');
goog.require('cljs.spec.alpha');
goog.require('goog.string');
goog.require('goog.string.format');
cljs.repl.print_doc = (function cljs$repl$print_doc(p__39185){
var map__39186 = p__39185;
var map__39186__$1 = (((((!((map__39186 == null))))?(((((map__39186.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39186.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39186):map__39186);
var m = map__39186__$1;
var n = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39186__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var nm = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39186__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["-------------------------"], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(function (){var or__4131__auto__ = new cljs.core.Keyword(null,"spec","spec",347520401).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return [(function (){var temp__5735__auto__ = new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_(temp__5735__auto__)){
var ns = temp__5735__auto__;
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/"].join('');
} else {
return null;
}
})(),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(m))].join('');
}
})()], 0));

if(cljs.core.truth_(new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Protocol"], 0));
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"forms","forms",2045992350).cljs$core$IFn$_invoke$arity$1(m))){
var seq__39188_39422 = cljs.core.seq(new cljs.core.Keyword(null,"forms","forms",2045992350).cljs$core$IFn$_invoke$arity$1(m));
var chunk__39189_39423 = null;
var count__39190_39424 = (0);
var i__39191_39425 = (0);
while(true){
if((i__39191_39425 < count__39190_39424)){
var f_39426 = chunk__39189_39423.cljs$core$IIndexed$_nth$arity$2(null,i__39191_39425);
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["  ",f_39426], 0));


var G__39427 = seq__39188_39422;
var G__39428 = chunk__39189_39423;
var G__39429 = count__39190_39424;
var G__39430 = (i__39191_39425 + (1));
seq__39188_39422 = G__39427;
chunk__39189_39423 = G__39428;
count__39190_39424 = G__39429;
i__39191_39425 = G__39430;
continue;
} else {
var temp__5735__auto___39431 = cljs.core.seq(seq__39188_39422);
if(temp__5735__auto___39431){
var seq__39188_39433__$1 = temp__5735__auto___39431;
if(cljs.core.chunked_seq_QMARK_(seq__39188_39433__$1)){
var c__4550__auto___39435 = cljs.core.chunk_first(seq__39188_39433__$1);
var G__39436 = cljs.core.chunk_rest(seq__39188_39433__$1);
var G__39437 = c__4550__auto___39435;
var G__39438 = cljs.core.count(c__4550__auto___39435);
var G__39439 = (0);
seq__39188_39422 = G__39436;
chunk__39189_39423 = G__39437;
count__39190_39424 = G__39438;
i__39191_39425 = G__39439;
continue;
} else {
var f_39440 = cljs.core.first(seq__39188_39433__$1);
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["  ",f_39440], 0));


var G__39441 = cljs.core.next(seq__39188_39433__$1);
var G__39442 = null;
var G__39443 = (0);
var G__39444 = (0);
seq__39188_39422 = G__39441;
chunk__39189_39423 = G__39442;
count__39190_39424 = G__39443;
i__39191_39425 = G__39444;
continue;
}
} else {
}
}
break;
}
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"arglists","arglists",1661989754).cljs$core$IFn$_invoke$arity$1(m))){
var arglists_39447 = new cljs.core.Keyword(null,"arglists","arglists",1661989754).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_((function (){var or__4131__auto__ = new cljs.core.Keyword(null,"macro","macro",-867863404).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return new cljs.core.Keyword(null,"repl-special-function","repl-special-function",1262603725).cljs$core$IFn$_invoke$arity$1(m);
}
})())){
cljs.core.prn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arglists_39447], 0));
} else {
cljs.core.prn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.first(arglists_39447)))?cljs.core.second(arglists_39447):arglists_39447)], 0));
}
} else {
}
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"special-form","special-form",-1326536374).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Special Form"], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" ",new cljs.core.Keyword(null,"doc","doc",1913296891).cljs$core$IFn$_invoke$arity$1(m)], 0));

if(cljs.core.contains_QMARK_(m,new cljs.core.Keyword(null,"url","url",276297046))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(m))){
return cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["\n  Please see http://clojure.org/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(m))].join('')], 0));
} else {
return null;
}
} else {
return cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["\n  Please see http://clojure.org/special_forms#",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(m))].join('')], 0));
}
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"macro","macro",-867863404).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Macro"], 0));
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"spec","spec",347520401).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Spec"], 0));
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"repl-special-function","repl-special-function",1262603725).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["REPL Special Function"], 0));
} else {
}

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" ",new cljs.core.Keyword(null,"doc","doc",1913296891).cljs$core$IFn$_invoke$arity$1(m)], 0));

if(cljs.core.truth_(new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(m))){
var seq__39197_39454 = cljs.core.seq(new cljs.core.Keyword(null,"methods","methods",453930866).cljs$core$IFn$_invoke$arity$1(m));
var chunk__39198_39455 = null;
var count__39199_39456 = (0);
var i__39200_39457 = (0);
while(true){
if((i__39200_39457 < count__39199_39456)){
var vec__39223_39460 = chunk__39198_39455.cljs$core$IIndexed$_nth$arity$2(null,i__39200_39457);
var name_39461 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39223_39460,(0),null);
var map__39226_39462 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39223_39460,(1),null);
var map__39226_39463__$1 = (((((!((map__39226_39462 == null))))?(((((map__39226_39462.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39226_39462.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39226_39462):map__39226_39462);
var doc_39464 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39226_39463__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var arglists_39465 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39226_39463__$1,new cljs.core.Keyword(null,"arglists","arglists",1661989754));
cljs.core.println();

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" ",name_39461], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" ",arglists_39465], 0));

if(cljs.core.truth_(doc_39464)){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" ",doc_39464], 0));
} else {
}


var G__39475 = seq__39197_39454;
var G__39476 = chunk__39198_39455;
var G__39477 = count__39199_39456;
var G__39478 = (i__39200_39457 + (1));
seq__39197_39454 = G__39475;
chunk__39198_39455 = G__39476;
count__39199_39456 = G__39477;
i__39200_39457 = G__39478;
continue;
} else {
var temp__5735__auto___39482 = cljs.core.seq(seq__39197_39454);
if(temp__5735__auto___39482){
var seq__39197_39483__$1 = temp__5735__auto___39482;
if(cljs.core.chunked_seq_QMARK_(seq__39197_39483__$1)){
var c__4550__auto___39484 = cljs.core.chunk_first(seq__39197_39483__$1);
var G__39485 = cljs.core.chunk_rest(seq__39197_39483__$1);
var G__39486 = c__4550__auto___39484;
var G__39487 = cljs.core.count(c__4550__auto___39484);
var G__39488 = (0);
seq__39197_39454 = G__39485;
chunk__39198_39455 = G__39486;
count__39199_39456 = G__39487;
i__39200_39457 = G__39488;
continue;
} else {
var vec__39231_39492 = cljs.core.first(seq__39197_39483__$1);
var name_39493 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39231_39492,(0),null);
var map__39234_39494 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39231_39492,(1),null);
var map__39234_39495__$1 = (((((!((map__39234_39494 == null))))?(((((map__39234_39494.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39234_39494.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39234_39494):map__39234_39494);
var doc_39496 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39234_39495__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var arglists_39497 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39234_39495__$1,new cljs.core.Keyword(null,"arglists","arglists",1661989754));
cljs.core.println();

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" ",name_39493], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" ",arglists_39497], 0));

if(cljs.core.truth_(doc_39496)){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" ",doc_39496], 0));
} else {
}


var G__39509 = cljs.core.next(seq__39197_39483__$1);
var G__39510 = null;
var G__39511 = (0);
var G__39512 = (0);
seq__39197_39454 = G__39509;
chunk__39198_39455 = G__39510;
count__39199_39456 = G__39511;
i__39200_39457 = G__39512;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(n)){
var temp__5735__auto__ = cljs.spec.alpha.get_spec(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.ns_name(n)),cljs.core.name(nm)));
if(cljs.core.truth_(temp__5735__auto__)){
var fnspec = temp__5735__auto__;
cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Spec"], 0));

var seq__39236 = cljs.core.seq(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Keyword(null,"fn","fn",-1175266204)], null));
var chunk__39237 = null;
var count__39238 = (0);
var i__39239 = (0);
while(true){
if((i__39239 < count__39238)){
var role = chunk__39237.cljs$core$IIndexed$_nth$arity$2(null,i__39239);
var temp__5735__auto___39515__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fnspec,role);
if(cljs.core.truth_(temp__5735__auto___39515__$1)){
var spec_39516 = temp__5735__auto___39515__$1;
cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["\n ",cljs.core.name(role),":"].join(''),cljs.spec.alpha.describe(spec_39516)], 0));
} else {
}


var G__39519 = seq__39236;
var G__39520 = chunk__39237;
var G__39521 = count__39238;
var G__39522 = (i__39239 + (1));
seq__39236 = G__39519;
chunk__39237 = G__39520;
count__39238 = G__39521;
i__39239 = G__39522;
continue;
} else {
var temp__5735__auto____$1 = cljs.core.seq(seq__39236);
if(temp__5735__auto____$1){
var seq__39236__$1 = temp__5735__auto____$1;
if(cljs.core.chunked_seq_QMARK_(seq__39236__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__39236__$1);
var G__39529 = cljs.core.chunk_rest(seq__39236__$1);
var G__39530 = c__4550__auto__;
var G__39531 = cljs.core.count(c__4550__auto__);
var G__39532 = (0);
seq__39236 = G__39529;
chunk__39237 = G__39530;
count__39238 = G__39531;
i__39239 = G__39532;
continue;
} else {
var role = cljs.core.first(seq__39236__$1);
var temp__5735__auto___39533__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fnspec,role);
if(cljs.core.truth_(temp__5735__auto___39533__$2)){
var spec_39534 = temp__5735__auto___39533__$2;
cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["\n ",cljs.core.name(role),":"].join(''),cljs.spec.alpha.describe(spec_39534)], 0));
} else {
}


var G__39537 = cljs.core.next(seq__39236__$1);
var G__39538 = null;
var G__39539 = (0);
var G__39540 = (0);
seq__39236 = G__39537;
chunk__39237 = G__39538;
count__39238 = G__39539;
i__39239 = G__39540;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Constructs a data representation for a Error with keys:
 *  :cause - root cause message
 *  :phase - error phase
 *  :via - cause chain, with cause keys:
 *           :type - exception class symbol
 *           :message - exception message
 *           :data - ex-data
 *           :at - top stack element
 *  :trace - root cause stack elements
 */
cljs.repl.Error__GT_map = (function cljs$repl$Error__GT_map(o){
var base = (function (t){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"type","type",1174270348),(((t instanceof cljs.core.ExceptionInfo))?new cljs.core.Symbol(null,"ExceptionInfo","ExceptionInfo",294935087,null):(((t instanceof EvalError))?new cljs.core.Symbol("js","EvalError","js/EvalError",1793498501,null):(((t instanceof RangeError))?new cljs.core.Symbol("js","RangeError","js/RangeError",1703848089,null):(((t instanceof ReferenceError))?new cljs.core.Symbol("js","ReferenceError","js/ReferenceError",-198403224,null):(((t instanceof SyntaxError))?new cljs.core.Symbol("js","SyntaxError","js/SyntaxError",-1527651665,null):(((t instanceof URIError))?new cljs.core.Symbol("js","URIError","js/URIError",505061350,null):(((t instanceof Error))?new cljs.core.Symbol("js","Error","js/Error",-1692659266,null):null
)))))))], null),(function (){var temp__5735__auto__ = cljs.core.ex_message(t);
if(cljs.core.truth_(temp__5735__auto__)){
var msg = temp__5735__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"message","message",-406056002),msg], null);
} else {
return null;
}
})(),(function (){var temp__5735__auto__ = cljs.core.ex_data(t);
if(cljs.core.truth_(temp__5735__auto__)){
var ed = temp__5735__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),ed], null);
} else {
return null;
}
})()], 0));
});
var via = (function (){var via = cljs.core.PersistentVector.EMPTY;
var t = o;
while(true){
if(cljs.core.truth_(t)){
var G__39542 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(via,t);
var G__39543 = cljs.core.ex_cause(t);
via = G__39542;
t = G__39543;
continue;
} else {
return via;
}
break;
}
})();
var root = cljs.core.peek(via);
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"via","via",-1904457336),cljs.core.vec(cljs.core.map.cljs$core$IFn$_invoke$arity$2(base,via)),new cljs.core.Keyword(null,"trace","trace",-1082747415),null], null),(function (){var temp__5735__auto__ = cljs.core.ex_message(root);
if(cljs.core.truth_(temp__5735__auto__)){
var root_msg = temp__5735__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"cause","cause",231901252),root_msg], null);
} else {
return null;
}
})(),(function (){var temp__5735__auto__ = cljs.core.ex_data(root);
if(cljs.core.truth_(temp__5735__auto__)){
var data = temp__5735__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),data], null);
} else {
return null;
}
})(),(function (){var temp__5735__auto__ = new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358).cljs$core$IFn$_invoke$arity$1(cljs.core.ex_data(o));
if(cljs.core.truth_(temp__5735__auto__)){
var phase = temp__5735__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"phase","phase",575722892),phase], null);
} else {
return null;
}
})()], 0));
});
/**
 * Returns an analysis of the phase, error, cause, and location of an error that occurred
 *   based on Throwable data, as returned by Throwable->map. All attributes other than phase
 *   are optional:
 *  :clojure.error/phase - keyword phase indicator, one of:
 *    :read-source :compile-syntax-check :compilation :macro-syntax-check :macroexpansion
 *    :execution :read-eval-result :print-eval-result
 *  :clojure.error/source - file name (no path)
 *  :clojure.error/line - integer line number
 *  :clojure.error/column - integer column number
 *  :clojure.error/symbol - symbol being expanded/compiled/invoked
 *  :clojure.error/class - cause exception class symbol
 *  :clojure.error/cause - cause exception message
 *  :clojure.error/spec - explain-data for spec error
 */
cljs.repl.ex_triage = (function cljs$repl$ex_triage(datafied_throwable){
var map__39262 = datafied_throwable;
var map__39262__$1 = (((((!((map__39262 == null))))?(((((map__39262.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39262.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39262):map__39262);
var via = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39262__$1,new cljs.core.Keyword(null,"via","via",-1904457336));
var trace = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39262__$1,new cljs.core.Keyword(null,"trace","trace",-1082747415));
var phase = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__39262__$1,new cljs.core.Keyword(null,"phase","phase",575722892),new cljs.core.Keyword(null,"execution","execution",253283524));
var map__39263 = cljs.core.last(via);
var map__39263__$1 = (((((!((map__39263 == null))))?(((((map__39263.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39263.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39263):map__39263);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39263__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var message = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39263__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39263__$1,new cljs.core.Keyword(null,"data","data",-232669377));
var map__39264 = data;
var map__39264__$1 = (((((!((map__39264 == null))))?(((((map__39264.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39264.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39264):map__39264);
var problems = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39264__$1,new cljs.core.Keyword("cljs.spec.alpha","problems","cljs.spec.alpha/problems",447400814));
var fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39264__$1,new cljs.core.Keyword("cljs.spec.alpha","fn","cljs.spec.alpha/fn",408600443));
var caller = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39264__$1,new cljs.core.Keyword("cljs.spec.test.alpha","caller","cljs.spec.test.alpha/caller",-398302390));
var map__39265 = new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.first(via));
var map__39265__$1 = (((((!((map__39265 == null))))?(((((map__39265.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39265.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39265):map__39265);
var top_data = map__39265__$1;
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39265__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3((function (){var G__39276 = phase;
var G__39276__$1 = (((G__39276 instanceof cljs.core.Keyword))?G__39276.fqn:null);
switch (G__39276__$1) {
case "read-source":
var map__39282 = data;
var map__39282__$1 = (((((!((map__39282 == null))))?(((((map__39282.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39282.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39282):map__39282);
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39282__$1,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471));
var column = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39282__$1,new cljs.core.Keyword("clojure.error","column","clojure.error/column",304721553));
var G__39287 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.second(via)),top_data], 0));
var G__39287__$1 = (cljs.core.truth_(source)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__39287,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),source):G__39287);
var G__39287__$2 = (cljs.core.truth_((function (){var fexpr__39288 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["NO_SOURCE_PATH",null,"NO_SOURCE_FILE",null], null), null);
return (fexpr__39288.cljs$core$IFn$_invoke$arity$1 ? fexpr__39288.cljs$core$IFn$_invoke$arity$1(source) : fexpr__39288.call(null,source));
})())?cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(G__39287__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397)):G__39287__$1);
if(cljs.core.truth_(message)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__39287__$2,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message);
} else {
return G__39287__$2;
}

break;
case "compile-syntax-check":
case "compilation":
case "macro-syntax-check":
case "macroexpansion":
var G__39290 = top_data;
var G__39290__$1 = (cljs.core.truth_(source)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__39290,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),source):G__39290);
var G__39290__$2 = (cljs.core.truth_((function (){var fexpr__39292 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["NO_SOURCE_PATH",null,"NO_SOURCE_FILE",null], null), null);
return (fexpr__39292.cljs$core$IFn$_invoke$arity$1 ? fexpr__39292.cljs$core$IFn$_invoke$arity$1(source) : fexpr__39292.call(null,source));
})())?cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(G__39290__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397)):G__39290__$1);
var G__39290__$3 = (cljs.core.truth_(type)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__39290__$2,new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890),type):G__39290__$2);
var G__39290__$4 = (cljs.core.truth_(message)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__39290__$3,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message):G__39290__$3);
if(cljs.core.truth_(problems)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__39290__$4,new cljs.core.Keyword("clojure.error","spec","clojure.error/spec",2055032595),data);
} else {
return G__39290__$4;
}

break;
case "read-eval-result":
case "print-eval-result":
var vec__39293 = cljs.core.first(trace);
var source__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39293,(0),null);
var method = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39293,(1),null);
var file = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39293,(2),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39293,(3),null);
var G__39298 = top_data;
var G__39298__$1 = (cljs.core.truth_(line)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__39298,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471),line):G__39298);
var G__39298__$2 = (cljs.core.truth_(file)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__39298__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),file):G__39298__$1);
var G__39298__$3 = (cljs.core.truth_((function (){var and__4120__auto__ = source__$1;
if(cljs.core.truth_(and__4120__auto__)){
return method;
} else {
return and__4120__auto__;
}
})())?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__39298__$2,new cljs.core.Keyword("clojure.error","symbol","clojure.error/symbol",1544821994),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[source__$1,method],null))):G__39298__$2);
var G__39298__$4 = (cljs.core.truth_(type)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__39298__$3,new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890),type):G__39298__$3);
if(cljs.core.truth_(message)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__39298__$4,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message);
} else {
return G__39298__$4;
}

break;
case "execution":
var vec__39306 = cljs.core.first(trace);
var source__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39306,(0),null);
var method = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39306,(1),null);
var file = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39306,(2),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39306,(3),null);
var file__$1 = cljs.core.first(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(((function (vec__39306,source__$1,method,file,line,G__39276,G__39276__$1,map__39262,map__39262__$1,via,trace,phase,map__39263,map__39263__$1,type,message,data,map__39264,map__39264__$1,problems,fn,caller,map__39265,map__39265__$1,top_data,source){
return (function (p1__39261_SHARP_){
var or__4131__auto__ = (p1__39261_SHARP_ == null);
if(or__4131__auto__){
return or__4131__auto__;
} else {
var fexpr__39310 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["NO_SOURCE_PATH",null,"NO_SOURCE_FILE",null], null), null);
return (fexpr__39310.cljs$core$IFn$_invoke$arity$1 ? fexpr__39310.cljs$core$IFn$_invoke$arity$1(p1__39261_SHARP_) : fexpr__39310.call(null,p1__39261_SHARP_));
}
});})(vec__39306,source__$1,method,file,line,G__39276,G__39276__$1,map__39262,map__39262__$1,via,trace,phase,map__39263,map__39263__$1,type,message,data,map__39264,map__39264__$1,problems,fn,caller,map__39265,map__39265__$1,top_data,source))
,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(caller),file], null)));
var err_line = (function (){var or__4131__auto__ = new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(caller);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return line;
}
})();
var G__39312 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890),type], null);
var G__39312__$1 = (cljs.core.truth_(err_line)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__39312,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471),err_line):G__39312);
var G__39312__$2 = (cljs.core.truth_(message)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__39312__$1,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message):G__39312__$1);
var G__39312__$3 = (cljs.core.truth_((function (){var or__4131__auto__ = fn;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var and__4120__auto__ = source__$1;
if(cljs.core.truth_(and__4120__auto__)){
return method;
} else {
return and__4120__auto__;
}
}
})())?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__39312__$2,new cljs.core.Keyword("clojure.error","symbol","clojure.error/symbol",1544821994),(function (){var or__4131__auto__ = fn;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[source__$1,method],null));
}
})()):G__39312__$2);
var G__39312__$4 = (cljs.core.truth_(file__$1)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__39312__$3,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),file__$1):G__39312__$3);
if(cljs.core.truth_(problems)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__39312__$4,new cljs.core.Keyword("clojure.error","spec","clojure.error/spec",2055032595),data);
} else {
return G__39312__$4;
}

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__39276__$1)].join('')));

}
})(),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),phase);
});
/**
 * Returns a string from exception data, as produced by ex-triage.
 *   The first line summarizes the exception phase and location.
 *   The subsequent lines describe the cause.
 */
cljs.repl.ex_str = (function cljs$repl$ex_str(p__39331){
var map__39332 = p__39331;
var map__39332__$1 = (((((!((map__39332 == null))))?(((((map__39332.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39332.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39332):map__39332);
var triage_data = map__39332__$1;
var phase = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39332__$1,new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39332__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39332__$1,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471));
var column = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39332__$1,new cljs.core.Keyword("clojure.error","column","clojure.error/column",304721553));
var symbol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39332__$1,new cljs.core.Keyword("clojure.error","symbol","clojure.error/symbol",1544821994));
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39332__$1,new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890));
var cause = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39332__$1,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742));
var spec = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39332__$1,new cljs.core.Keyword("clojure.error","spec","clojure.error/spec",2055032595));
var loc = [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4131__auto__ = source;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return "<cljs repl>";
}
})()),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4131__auto__ = line;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return (1);
}
})()),(cljs.core.truth_(column)?[":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column)].join(''):"")].join('');
var class_name = cljs.core.name((function (){var or__4131__auto__ = class$;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return "";
}
})());
var simple_class = class_name;
var cause_type = ((cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["RuntimeException",null,"Exception",null], null), null),simple_class))?"":[" (",simple_class,")"].join(''));
var format = goog.string.format;
var G__39341 = phase;
var G__39341__$1 = (((G__39341 instanceof cljs.core.Keyword))?G__39341.fqn:null);
switch (G__39341__$1) {
case "read-source":
return (format.cljs$core$IFn$_invoke$arity$3 ? format.cljs$core$IFn$_invoke$arity$3("Syntax error reading source at (%s).\n%s\n",loc,cause) : format.call(null,"Syntax error reading source at (%s).\n%s\n",loc,cause));

break;
case "macro-syntax-check":
var G__39342 = "Syntax error macroexpanding %sat (%s).\n%s";
var G__39343 = (cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):"");
var G__39344 = loc;
var G__39345 = (cljs.core.truth_(spec)?(function (){var sb__4661__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__39350_39602 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__39351_39603 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__39352_39604 = true;
var _STAR_print_fn_STAR__temp_val__39353_39605 = ((function (_STAR_print_newline_STAR__orig_val__39350_39602,_STAR_print_fn_STAR__orig_val__39351_39603,_STAR_print_newline_STAR__temp_val__39352_39604,sb__4661__auto__,G__39342,G__39343,G__39344,G__39341,G__39341__$1,loc,class_name,simple_class,cause_type,format,map__39332,map__39332__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec){
return (function (x__4662__auto__){
return sb__4661__auto__.append(x__4662__auto__);
});})(_STAR_print_newline_STAR__orig_val__39350_39602,_STAR_print_fn_STAR__orig_val__39351_39603,_STAR_print_newline_STAR__temp_val__39352_39604,sb__4661__auto__,G__39342,G__39343,G__39344,G__39341,G__39341__$1,loc,class_name,simple_class,cause_type,format,map__39332,map__39332__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec))
;
cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__39352_39604;

cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__39353_39605;

try{cljs.spec.alpha.explain_out(cljs.core.update.cljs$core$IFn$_invoke$arity$3(spec,new cljs.core.Keyword("cljs.spec.alpha","problems","cljs.spec.alpha/problems",447400814),((function (_STAR_print_newline_STAR__orig_val__39350_39602,_STAR_print_fn_STAR__orig_val__39351_39603,_STAR_print_newline_STAR__temp_val__39352_39604,_STAR_print_fn_STAR__temp_val__39353_39605,sb__4661__auto__,G__39342,G__39343,G__39344,G__39341,G__39341__$1,loc,class_name,simple_class,cause_type,format,map__39332,map__39332__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec){
return (function (probs){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (_STAR_print_newline_STAR__orig_val__39350_39602,_STAR_print_fn_STAR__orig_val__39351_39603,_STAR_print_newline_STAR__temp_val__39352_39604,_STAR_print_fn_STAR__temp_val__39353_39605,sb__4661__auto__,G__39342,G__39343,G__39344,G__39341,G__39341__$1,loc,class_name,simple_class,cause_type,format,map__39332,map__39332__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec){
return (function (p1__39329_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__39329_SHARP_,new cljs.core.Keyword(null,"in","in",-1531184865));
});})(_STAR_print_newline_STAR__orig_val__39350_39602,_STAR_print_fn_STAR__orig_val__39351_39603,_STAR_print_newline_STAR__temp_val__39352_39604,_STAR_print_fn_STAR__temp_val__39353_39605,sb__4661__auto__,G__39342,G__39343,G__39344,G__39341,G__39341__$1,loc,class_name,simple_class,cause_type,format,map__39332,map__39332__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec))
,probs);
});})(_STAR_print_newline_STAR__orig_val__39350_39602,_STAR_print_fn_STAR__orig_val__39351_39603,_STAR_print_newline_STAR__temp_val__39352_39604,_STAR_print_fn_STAR__temp_val__39353_39605,sb__4661__auto__,G__39342,G__39343,G__39344,G__39341,G__39341__$1,loc,class_name,simple_class,cause_type,format,map__39332,map__39332__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec))
)
);
}finally {cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__39351_39603;

cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__39350_39602;
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4661__auto__);
})():(format.cljs$core$IFn$_invoke$arity$2 ? format.cljs$core$IFn$_invoke$arity$2("%s\n",cause) : format.call(null,"%s\n",cause)));
return (format.cljs$core$IFn$_invoke$arity$4 ? format.cljs$core$IFn$_invoke$arity$4(G__39342,G__39343,G__39344,G__39345) : format.call(null,G__39342,G__39343,G__39344,G__39345));

break;
case "macroexpansion":
var G__39364 = "Unexpected error%s macroexpanding %sat (%s).\n%s\n";
var G__39365 = cause_type;
var G__39366 = (cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):"");
var G__39367 = loc;
var G__39368 = cause;
return (format.cljs$core$IFn$_invoke$arity$5 ? format.cljs$core$IFn$_invoke$arity$5(G__39364,G__39365,G__39366,G__39367,G__39368) : format.call(null,G__39364,G__39365,G__39366,G__39367,G__39368));

break;
case "compile-syntax-check":
var G__39373 = "Syntax error%s compiling %sat (%s).\n%s\n";
var G__39374 = cause_type;
var G__39375 = (cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):"");
var G__39376 = loc;
var G__39377 = cause;
return (format.cljs$core$IFn$_invoke$arity$5 ? format.cljs$core$IFn$_invoke$arity$5(G__39373,G__39374,G__39375,G__39376,G__39377) : format.call(null,G__39373,G__39374,G__39375,G__39376,G__39377));

break;
case "compilation":
var G__39381 = "Unexpected error%s compiling %sat (%s).\n%s\n";
var G__39382 = cause_type;
var G__39383 = (cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):"");
var G__39384 = loc;
var G__39385 = cause;
return (format.cljs$core$IFn$_invoke$arity$5 ? format.cljs$core$IFn$_invoke$arity$5(G__39381,G__39382,G__39383,G__39384,G__39385) : format.call(null,G__39381,G__39382,G__39383,G__39384,G__39385));

break;
case "read-eval-result":
return (format.cljs$core$IFn$_invoke$arity$5 ? format.cljs$core$IFn$_invoke$arity$5("Error reading eval result%s at %s (%s).\n%s\n",cause_type,symbol,loc,cause) : format.call(null,"Error reading eval result%s at %s (%s).\n%s\n",cause_type,symbol,loc,cause));

break;
case "print-eval-result":
return (format.cljs$core$IFn$_invoke$arity$5 ? format.cljs$core$IFn$_invoke$arity$5("Error printing return value%s at %s (%s).\n%s\n",cause_type,symbol,loc,cause) : format.call(null,"Error printing return value%s at %s (%s).\n%s\n",cause_type,symbol,loc,cause));

break;
case "execution":
if(cljs.core.truth_(spec)){
var G__39387 = "Execution error - invalid arguments to %s at (%s).\n%s";
var G__39388 = symbol;
var G__39389 = loc;
var G__39390 = (function (){var sb__4661__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__39391_39633 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__39392_39634 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__39393_39635 = true;
var _STAR_print_fn_STAR__temp_val__39394_39636 = ((function (_STAR_print_newline_STAR__orig_val__39391_39633,_STAR_print_fn_STAR__orig_val__39392_39634,_STAR_print_newline_STAR__temp_val__39393_39635,sb__4661__auto__,G__39387,G__39388,G__39389,G__39341,G__39341__$1,loc,class_name,simple_class,cause_type,format,map__39332,map__39332__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec){
return (function (x__4662__auto__){
return sb__4661__auto__.append(x__4662__auto__);
});})(_STAR_print_newline_STAR__orig_val__39391_39633,_STAR_print_fn_STAR__orig_val__39392_39634,_STAR_print_newline_STAR__temp_val__39393_39635,sb__4661__auto__,G__39387,G__39388,G__39389,G__39341,G__39341__$1,loc,class_name,simple_class,cause_type,format,map__39332,map__39332__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec))
;
cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__39393_39635;

cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__39394_39636;

try{cljs.spec.alpha.explain_out(cljs.core.update.cljs$core$IFn$_invoke$arity$3(spec,new cljs.core.Keyword("cljs.spec.alpha","problems","cljs.spec.alpha/problems",447400814),((function (_STAR_print_newline_STAR__orig_val__39391_39633,_STAR_print_fn_STAR__orig_val__39392_39634,_STAR_print_newline_STAR__temp_val__39393_39635,_STAR_print_fn_STAR__temp_val__39394_39636,sb__4661__auto__,G__39387,G__39388,G__39389,G__39341,G__39341__$1,loc,class_name,simple_class,cause_type,format,map__39332,map__39332__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec){
return (function (probs){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (_STAR_print_newline_STAR__orig_val__39391_39633,_STAR_print_fn_STAR__orig_val__39392_39634,_STAR_print_newline_STAR__temp_val__39393_39635,_STAR_print_fn_STAR__temp_val__39394_39636,sb__4661__auto__,G__39387,G__39388,G__39389,G__39341,G__39341__$1,loc,class_name,simple_class,cause_type,format,map__39332,map__39332__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec){
return (function (p1__39330_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__39330_SHARP_,new cljs.core.Keyword(null,"in","in",-1531184865));
});})(_STAR_print_newline_STAR__orig_val__39391_39633,_STAR_print_fn_STAR__orig_val__39392_39634,_STAR_print_newline_STAR__temp_val__39393_39635,_STAR_print_fn_STAR__temp_val__39394_39636,sb__4661__auto__,G__39387,G__39388,G__39389,G__39341,G__39341__$1,loc,class_name,simple_class,cause_type,format,map__39332,map__39332__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec))
,probs);
});})(_STAR_print_newline_STAR__orig_val__39391_39633,_STAR_print_fn_STAR__orig_val__39392_39634,_STAR_print_newline_STAR__temp_val__39393_39635,_STAR_print_fn_STAR__temp_val__39394_39636,sb__4661__auto__,G__39387,G__39388,G__39389,G__39341,G__39341__$1,loc,class_name,simple_class,cause_type,format,map__39332,map__39332__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec))
)
);
}finally {cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__39392_39634;

cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__39391_39633;
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4661__auto__);
})();
return (format.cljs$core$IFn$_invoke$arity$4 ? format.cljs$core$IFn$_invoke$arity$4(G__39387,G__39388,G__39389,G__39390) : format.call(null,G__39387,G__39388,G__39389,G__39390));
} else {
var G__39404 = "Execution error%s at %s(%s).\n%s\n";
var G__39405 = cause_type;
var G__39406 = (cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):"");
var G__39407 = loc;
var G__39408 = cause;
return (format.cljs$core$IFn$_invoke$arity$5 ? format.cljs$core$IFn$_invoke$arity$5(G__39404,G__39405,G__39406,G__39407,G__39408) : format.call(null,G__39404,G__39405,G__39406,G__39407,G__39408));
}

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__39341__$1)].join('')));

}
});
cljs.repl.error__GT_str = (function cljs$repl$error__GT_str(error){
return cljs.repl.ex_str(cljs.repl.ex_triage(cljs.repl.Error__GT_map(error)));
});

//# sourceMappingURL=cljs.repl.js.map
