goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('goog.array');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__39567 = arguments.length;
switch (G__39567) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async39570 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async39570 = (function (f,blockable,meta39571){
this.f = f;
this.blockable = blockable;
this.meta39571 = meta39571;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async39570.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_39572,meta39571__$1){
var self__ = this;
var _39572__$1 = this;
return (new cljs.core.async.t_cljs$core$async39570(self__.f,self__.blockable,meta39571__$1));
});

cljs.core.async.t_cljs$core$async39570.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_39572){
var self__ = this;
var _39572__$1 = this;
return self__.meta39571;
});

cljs.core.async.t_cljs$core$async39570.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async39570.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async39570.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async39570.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async39570.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta39571","meta39571",-1028842661,null)], null);
});

cljs.core.async.t_cljs$core$async39570.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async39570.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async39570";

cljs.core.async.t_cljs$core$async39570.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core.async/t_cljs$core$async39570");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async39570.
 */
cljs.core.async.__GT_t_cljs$core$async39570 = (function cljs$core$async$__GT_t_cljs$core$async39570(f__$1,blockable__$1,meta39571){
return (new cljs.core.async.t_cljs$core$async39570(f__$1,blockable__$1,meta39571));
});

}

return (new cljs.core.async.t_cljs$core$async39570(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__39582 = arguments.length;
switch (G__39582) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__39601 = arguments.length;
switch (G__39601) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__39630 = arguments.length;
switch (G__39630) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_41942 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_41942) : fn1.call(null,val_41942));
} else {
cljs.core.async.impl.dispatch.run(((function (val_41942,ret){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_41942) : fn1.call(null,val_41942));
});})(val_41942,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__39658 = arguments.length;
switch (G__39658) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5733__auto__)){
var ret = temp__5733__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5733__auto__)){
var retb = temp__5733__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run(((function (ret,retb,temp__5733__auto__){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
});})(ret,retb,temp__5733__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4607__auto___41953 = n;
var x_41954 = (0);
while(true){
if((x_41954 < n__4607__auto___41953)){
(a[x_41954] = x_41954);

var G__41955 = (x_41954 + (1));
x_41954 = G__41955;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async39660 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async39660 = (function (flag,meta39661){
this.flag = flag;
this.meta39661 = meta39661;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async39660.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_39662,meta39661__$1){
var self__ = this;
var _39662__$1 = this;
return (new cljs.core.async.t_cljs$core$async39660(self__.flag,meta39661__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async39660.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_39662){
var self__ = this;
var _39662__$1 = this;
return self__.meta39661;
});})(flag))
;

cljs.core.async.t_cljs$core$async39660.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async39660.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async39660.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async39660.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async39660.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta39661","meta39661",-1010140511,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async39660.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async39660.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async39660";

cljs.core.async.t_cljs$core$async39660.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core.async/t_cljs$core$async39660");
});})(flag))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async39660.
 */
cljs.core.async.__GT_t_cljs$core$async39660 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async39660(flag__$1,meta39661){
return (new cljs.core.async.t_cljs$core$async39660(flag__$1,meta39661));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async39660(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async39669 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async39669 = (function (flag,cb,meta39670){
this.flag = flag;
this.cb = cb;
this.meta39670 = meta39670;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async39669.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_39671,meta39670__$1){
var self__ = this;
var _39671__$1 = this;
return (new cljs.core.async.t_cljs$core$async39669(self__.flag,self__.cb,meta39670__$1));
});

cljs.core.async.t_cljs$core$async39669.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_39671){
var self__ = this;
var _39671__$1 = this;
return self__.meta39670;
});

cljs.core.async.t_cljs$core$async39669.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async39669.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
});

cljs.core.async.t_cljs$core$async39669.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async39669.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async39669.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta39670","meta39670",-1489689291,null)], null);
});

cljs.core.async.t_cljs$core$async39669.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async39669.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async39669";

cljs.core.async.t_cljs$core$async39669.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core.async/t_cljs$core$async39669");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async39669.
 */
cljs.core.async.__GT_t_cljs$core$async39669 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async39669(flag__$1,cb__$1,meta39670){
return (new cljs.core.async.t_cljs$core$async39669(flag__$1,cb__$1,meta39670));
});

}

return (new cljs.core.async.t_cljs$core$async39669(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__39674_SHARP_){
var G__39680 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__39674_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__39680) : fret.call(null,G__39680));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__39675_SHARP_){
var G__39681 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__39675_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__39681) : fret.call(null,G__39681));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4131__auto__ = wport;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return port;
}
})()], null));
} else {
var G__41976 = (i + (1));
i = G__41976;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4131__auto__ = ret;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5735__auto__ = (function (){var and__4120__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4120__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4120__auto__;
}
})();
if(cljs.core.truth_(temp__5735__auto__)){
var got = temp__5735__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___41978 = arguments.length;
var i__4731__auto___41979 = (0);
while(true){
if((i__4731__auto___41979 < len__4730__auto___41978)){
args__4736__auto__.push((arguments[i__4731__auto___41979]));

var G__41981 = (i__4731__auto___41979 + (1));
i__4731__auto___41979 = G__41981;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__39688){
var map__39689 = p__39688;
var map__39689__$1 = (((((!((map__39689 == null))))?(((((map__39689.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39689.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39689):map__39689);
var opts = map__39689__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq39682){
var G__39683 = cljs.core.first(seq39682);
var seq39682__$1 = cljs.core.next(seq39682);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__39683,seq39682__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__39713 = arguments.length;
switch (G__39713) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__39413__auto___41991 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__39413__auto___41991){
return (function (){
var f__39414__auto__ = (function (){var switch__39111__auto__ = ((function (c__39413__auto___41991){
return (function (state_39760){
var state_val_39761 = (state_39760[(1)]);
if((state_val_39761 === (7))){
var inst_39755 = (state_39760[(2)]);
var state_39760__$1 = state_39760;
var statearr_39764_41992 = state_39760__$1;
(statearr_39764_41992[(2)] = inst_39755);

(statearr_39764_41992[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39761 === (1))){
var state_39760__$1 = state_39760;
var statearr_39767_41994 = state_39760__$1;
(statearr_39767_41994[(2)] = null);

(statearr_39767_41994[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39761 === (4))){
var inst_39734 = (state_39760[(7)]);
var inst_39734__$1 = (state_39760[(2)]);
var inst_39737 = (inst_39734__$1 == null);
var state_39760__$1 = (function (){var statearr_39768 = state_39760;
(statearr_39768[(7)] = inst_39734__$1);

return statearr_39768;
})();
if(cljs.core.truth_(inst_39737)){
var statearr_39771_41995 = state_39760__$1;
(statearr_39771_41995[(1)] = (5));

} else {
var statearr_39772_41996 = state_39760__$1;
(statearr_39772_41996[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39761 === (13))){
var state_39760__$1 = state_39760;
var statearr_39775_41999 = state_39760__$1;
(statearr_39775_41999[(2)] = null);

(statearr_39775_41999[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39761 === (6))){
var inst_39734 = (state_39760[(7)]);
var state_39760__$1 = state_39760;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_39760__$1,(11),to,inst_39734);
} else {
if((state_val_39761 === (3))){
var inst_39757 = (state_39760[(2)]);
var state_39760__$1 = state_39760;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39760__$1,inst_39757);
} else {
if((state_val_39761 === (12))){
var state_39760__$1 = state_39760;
var statearr_39793_42002 = state_39760__$1;
(statearr_39793_42002[(2)] = null);

(statearr_39793_42002[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39761 === (2))){
var state_39760__$1 = state_39760;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39760__$1,(4),from);
} else {
if((state_val_39761 === (11))){
var inst_39746 = (state_39760[(2)]);
var state_39760__$1 = state_39760;
if(cljs.core.truth_(inst_39746)){
var statearr_39805_42004 = state_39760__$1;
(statearr_39805_42004[(1)] = (12));

} else {
var statearr_39806_42005 = state_39760__$1;
(statearr_39806_42005[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39761 === (9))){
var state_39760__$1 = state_39760;
var statearr_39814_42006 = state_39760__$1;
(statearr_39814_42006[(2)] = null);

(statearr_39814_42006[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39761 === (5))){
var state_39760__$1 = state_39760;
if(cljs.core.truth_(close_QMARK_)){
var statearr_39822_42009 = state_39760__$1;
(statearr_39822_42009[(1)] = (8));

} else {
var statearr_39826_42010 = state_39760__$1;
(statearr_39826_42010[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39761 === (14))){
var inst_39753 = (state_39760[(2)]);
var state_39760__$1 = state_39760;
var statearr_39830_42013 = state_39760__$1;
(statearr_39830_42013[(2)] = inst_39753);

(statearr_39830_42013[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39761 === (10))){
var inst_39743 = (state_39760[(2)]);
var state_39760__$1 = state_39760;
var statearr_39835_42014 = state_39760__$1;
(statearr_39835_42014[(2)] = inst_39743);

(statearr_39835_42014[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39761 === (8))){
var inst_39740 = cljs.core.async.close_BANG_(to);
var state_39760__$1 = state_39760;
var statearr_39836_42016 = state_39760__$1;
(statearr_39836_42016[(2)] = inst_39740);

(statearr_39836_42016[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__39413__auto___41991))
;
return ((function (switch__39111__auto__,c__39413__auto___41991){
return (function() {
var cljs$core$async$state_machine__39112__auto__ = null;
var cljs$core$async$state_machine__39112__auto____0 = (function (){
var statearr_39837 = [null,null,null,null,null,null,null,null];
(statearr_39837[(0)] = cljs$core$async$state_machine__39112__auto__);

(statearr_39837[(1)] = (1));

return statearr_39837;
});
var cljs$core$async$state_machine__39112__auto____1 = (function (state_39760){
while(true){
var ret_value__39113__auto__ = (function (){try{while(true){
var result__39114__auto__ = switch__39111__auto__(state_39760);
if(cljs.core.keyword_identical_QMARK_(result__39114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__39114__auto__;
}
break;
}
}catch (e39839){if((e39839 instanceof Object)){
var ex__39115__auto__ = e39839;
var statearr_39840_42019 = state_39760;
(statearr_39840_42019[(5)] = ex__39115__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_39760);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e39839;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__39113__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42022 = state_39760;
state_39760 = G__42022;
continue;
} else {
return ret_value__39113__auto__;
}
break;
}
});
cljs$core$async$state_machine__39112__auto__ = function(state_39760){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__39112__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__39112__auto____1.call(this,state_39760);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__39112__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__39112__auto____0;
cljs$core$async$state_machine__39112__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__39112__auto____1;
return cljs$core$async$state_machine__39112__auto__;
})()
;})(switch__39111__auto__,c__39413__auto___41991))
})();
var state__39415__auto__ = (function (){var statearr_39841 = (f__39414__auto__.cljs$core$IFn$_invoke$arity$0 ? f__39414__auto__.cljs$core$IFn$_invoke$arity$0() : f__39414__auto__.call(null));
(statearr_39841[(6)] = c__39413__auto___41991);

return statearr_39841;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__39415__auto__);
});})(c__39413__auto___41991))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = ((function (jobs,results){
return (function (p__39843){
var vec__39844 = p__39843;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39844,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39844,(1),null);
var job = vec__39844;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__39413__auto___42026 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__39413__auto___42026,res,vec__39844,v,p,job,jobs,results){
return (function (){
var f__39414__auto__ = (function (){var switch__39111__auto__ = ((function (c__39413__auto___42026,res,vec__39844,v,p,job,jobs,results){
return (function (state_39852){
var state_val_39853 = (state_39852[(1)]);
if((state_val_39853 === (1))){
var state_39852__$1 = state_39852;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_39852__$1,(2),res,v);
} else {
if((state_val_39853 === (2))){
var inst_39849 = (state_39852[(2)]);
var inst_39850 = cljs.core.async.close_BANG_(res);
var state_39852__$1 = (function (){var statearr_39856 = state_39852;
(statearr_39856[(7)] = inst_39849);

return statearr_39856;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_39852__$1,inst_39850);
} else {
return null;
}
}
});})(c__39413__auto___42026,res,vec__39844,v,p,job,jobs,results))
;
return ((function (switch__39111__auto__,c__39413__auto___42026,res,vec__39844,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__39112__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__39112__auto____0 = (function (){
var statearr_39857 = [null,null,null,null,null,null,null,null];
(statearr_39857[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__39112__auto__);

(statearr_39857[(1)] = (1));

return statearr_39857;
});
var cljs$core$async$pipeline_STAR__$_state_machine__39112__auto____1 = (function (state_39852){
while(true){
var ret_value__39113__auto__ = (function (){try{while(true){
var result__39114__auto__ = switch__39111__auto__(state_39852);
if(cljs.core.keyword_identical_QMARK_(result__39114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__39114__auto__;
}
break;
}
}catch (e39858){if((e39858 instanceof Object)){
var ex__39115__auto__ = e39858;
var statearr_39859_42032 = state_39852;
(statearr_39859_42032[(5)] = ex__39115__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_39852);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e39858;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__39113__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42035 = state_39852;
state_39852 = G__42035;
continue;
} else {
return ret_value__39113__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__39112__auto__ = function(state_39852){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__39112__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__39112__auto____1.call(this,state_39852);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__39112__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__39112__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__39112__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__39112__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__39112__auto__;
})()
;})(switch__39111__auto__,c__39413__auto___42026,res,vec__39844,v,p,job,jobs,results))
})();
var state__39415__auto__ = (function (){var statearr_39861 = (f__39414__auto__.cljs$core$IFn$_invoke$arity$0 ? f__39414__auto__.cljs$core$IFn$_invoke$arity$0() : f__39414__auto__.call(null));
(statearr_39861[(6)] = c__39413__auto___42026);

return statearr_39861;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__39415__auto__);
});})(c__39413__auto___42026,res,vec__39844,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__39863){
var vec__39864 = p__39863;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39864,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39864,(1),null);
var job = vec__39864;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results,process))
;
var n__4607__auto___42039 = n;
var __42040 = (0);
while(true){
if((__42040 < n__4607__auto___42039)){
var G__39871_42041 = type;
var G__39871_42042__$1 = (((G__39871_42041 instanceof cljs.core.Keyword))?G__39871_42041.fqn:null);
switch (G__39871_42042__$1) {
case "compute":
var c__39413__auto___42046 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__42040,c__39413__auto___42046,G__39871_42041,G__39871_42042__$1,n__4607__auto___42039,jobs,results,process,async){
return (function (){
var f__39414__auto__ = (function (){var switch__39111__auto__ = ((function (__42040,c__39413__auto___42046,G__39871_42041,G__39871_42042__$1,n__4607__auto___42039,jobs,results,process,async){
return (function (state_39887){
var state_val_39888 = (state_39887[(1)]);
if((state_val_39888 === (1))){
var state_39887__$1 = state_39887;
var statearr_39891_42047 = state_39887__$1;
(statearr_39891_42047[(2)] = null);

(statearr_39891_42047[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39888 === (2))){
var state_39887__$1 = state_39887;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39887__$1,(4),jobs);
} else {
if((state_val_39888 === (3))){
var inst_39885 = (state_39887[(2)]);
var state_39887__$1 = state_39887;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39887__$1,inst_39885);
} else {
if((state_val_39888 === (4))){
var inst_39877 = (state_39887[(2)]);
var inst_39878 = process(inst_39877);
var state_39887__$1 = state_39887;
if(cljs.core.truth_(inst_39878)){
var statearr_39894_42049 = state_39887__$1;
(statearr_39894_42049[(1)] = (5));

} else {
var statearr_39895_42052 = state_39887__$1;
(statearr_39895_42052[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39888 === (5))){
var state_39887__$1 = state_39887;
var statearr_39897_42053 = state_39887__$1;
(statearr_39897_42053[(2)] = null);

(statearr_39897_42053[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39888 === (6))){
var state_39887__$1 = state_39887;
var statearr_39899_42056 = state_39887__$1;
(statearr_39899_42056[(2)] = null);

(statearr_39899_42056[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39888 === (7))){
var inst_39883 = (state_39887[(2)]);
var state_39887__$1 = state_39887;
var statearr_39902_42057 = state_39887__$1;
(statearr_39902_42057[(2)] = inst_39883);

(statearr_39902_42057[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__42040,c__39413__auto___42046,G__39871_42041,G__39871_42042__$1,n__4607__auto___42039,jobs,results,process,async))
;
return ((function (__42040,switch__39111__auto__,c__39413__auto___42046,G__39871_42041,G__39871_42042__$1,n__4607__auto___42039,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__39112__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__39112__auto____0 = (function (){
var statearr_39906 = [null,null,null,null,null,null,null];
(statearr_39906[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__39112__auto__);

(statearr_39906[(1)] = (1));

return statearr_39906;
});
var cljs$core$async$pipeline_STAR__$_state_machine__39112__auto____1 = (function (state_39887){
while(true){
var ret_value__39113__auto__ = (function (){try{while(true){
var result__39114__auto__ = switch__39111__auto__(state_39887);
if(cljs.core.keyword_identical_QMARK_(result__39114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__39114__auto__;
}
break;
}
}catch (e39907){if((e39907 instanceof Object)){
var ex__39115__auto__ = e39907;
var statearr_39910_42059 = state_39887;
(statearr_39910_42059[(5)] = ex__39115__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_39887);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e39907;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__39113__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42062 = state_39887;
state_39887 = G__42062;
continue;
} else {
return ret_value__39113__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__39112__auto__ = function(state_39887){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__39112__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__39112__auto____1.call(this,state_39887);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__39112__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__39112__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__39112__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__39112__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__39112__auto__;
})()
;})(__42040,switch__39111__auto__,c__39413__auto___42046,G__39871_42041,G__39871_42042__$1,n__4607__auto___42039,jobs,results,process,async))
})();
var state__39415__auto__ = (function (){var statearr_39911 = (f__39414__auto__.cljs$core$IFn$_invoke$arity$0 ? f__39414__auto__.cljs$core$IFn$_invoke$arity$0() : f__39414__auto__.call(null));
(statearr_39911[(6)] = c__39413__auto___42046);

return statearr_39911;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__39415__auto__);
});})(__42040,c__39413__auto___42046,G__39871_42041,G__39871_42042__$1,n__4607__auto___42039,jobs,results,process,async))
);


break;
case "async":
var c__39413__auto___42065 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__42040,c__39413__auto___42065,G__39871_42041,G__39871_42042__$1,n__4607__auto___42039,jobs,results,process,async){
return (function (){
var f__39414__auto__ = (function (){var switch__39111__auto__ = ((function (__42040,c__39413__auto___42065,G__39871_42041,G__39871_42042__$1,n__4607__auto___42039,jobs,results,process,async){
return (function (state_39925){
var state_val_39926 = (state_39925[(1)]);
if((state_val_39926 === (1))){
var state_39925__$1 = state_39925;
var statearr_39927_42066 = state_39925__$1;
(statearr_39927_42066[(2)] = null);

(statearr_39927_42066[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39926 === (2))){
var state_39925__$1 = state_39925;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39925__$1,(4),jobs);
} else {
if((state_val_39926 === (3))){
var inst_39923 = (state_39925[(2)]);
var state_39925__$1 = state_39925;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39925__$1,inst_39923);
} else {
if((state_val_39926 === (4))){
var inst_39915 = (state_39925[(2)]);
var inst_39916 = async(inst_39915);
var state_39925__$1 = state_39925;
if(cljs.core.truth_(inst_39916)){
var statearr_39928_42068 = state_39925__$1;
(statearr_39928_42068[(1)] = (5));

} else {
var statearr_39929_42069 = state_39925__$1;
(statearr_39929_42069[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39926 === (5))){
var state_39925__$1 = state_39925;
var statearr_39930_42072 = state_39925__$1;
(statearr_39930_42072[(2)] = null);

(statearr_39930_42072[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39926 === (6))){
var state_39925__$1 = state_39925;
var statearr_39931_42073 = state_39925__$1;
(statearr_39931_42073[(2)] = null);

(statearr_39931_42073[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39926 === (7))){
var inst_39921 = (state_39925[(2)]);
var state_39925__$1 = state_39925;
var statearr_39932_42076 = state_39925__$1;
(statearr_39932_42076[(2)] = inst_39921);

(statearr_39932_42076[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__42040,c__39413__auto___42065,G__39871_42041,G__39871_42042__$1,n__4607__auto___42039,jobs,results,process,async))
;
return ((function (__42040,switch__39111__auto__,c__39413__auto___42065,G__39871_42041,G__39871_42042__$1,n__4607__auto___42039,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__39112__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__39112__auto____0 = (function (){
var statearr_39933 = [null,null,null,null,null,null,null];
(statearr_39933[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__39112__auto__);

(statearr_39933[(1)] = (1));

return statearr_39933;
});
var cljs$core$async$pipeline_STAR__$_state_machine__39112__auto____1 = (function (state_39925){
while(true){
var ret_value__39113__auto__ = (function (){try{while(true){
var result__39114__auto__ = switch__39111__auto__(state_39925);
if(cljs.core.keyword_identical_QMARK_(result__39114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__39114__auto__;
}
break;
}
}catch (e39934){if((e39934 instanceof Object)){
var ex__39115__auto__ = e39934;
var statearr_39935_42078 = state_39925;
(statearr_39935_42078[(5)] = ex__39115__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_39925);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e39934;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__39113__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42079 = state_39925;
state_39925 = G__42079;
continue;
} else {
return ret_value__39113__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__39112__auto__ = function(state_39925){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__39112__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__39112__auto____1.call(this,state_39925);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__39112__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__39112__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__39112__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__39112__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__39112__auto__;
})()
;})(__42040,switch__39111__auto__,c__39413__auto___42065,G__39871_42041,G__39871_42042__$1,n__4607__auto___42039,jobs,results,process,async))
})();
var state__39415__auto__ = (function (){var statearr_39936 = (f__39414__auto__.cljs$core$IFn$_invoke$arity$0 ? f__39414__auto__.cljs$core$IFn$_invoke$arity$0() : f__39414__auto__.call(null));
(statearr_39936[(6)] = c__39413__auto___42065);

return statearr_39936;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__39415__auto__);
});})(__42040,c__39413__auto___42065,G__39871_42041,G__39871_42042__$1,n__4607__auto___42039,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__39871_42042__$1)].join('')));

}

var G__42083 = (__42040 + (1));
__42040 = G__42083;
continue;
} else {
}
break;
}

var c__39413__auto___42085 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__39413__auto___42085,jobs,results,process,async){
return (function (){
var f__39414__auto__ = (function (){var switch__39111__auto__ = ((function (c__39413__auto___42085,jobs,results,process,async){
return (function (state_39958){
var state_val_39959 = (state_39958[(1)]);
if((state_val_39959 === (7))){
var inst_39954 = (state_39958[(2)]);
var state_39958__$1 = state_39958;
var statearr_39960_42086 = state_39958__$1;
(statearr_39960_42086[(2)] = inst_39954);

(statearr_39960_42086[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39959 === (1))){
var state_39958__$1 = state_39958;
var statearr_39961_42088 = state_39958__$1;
(statearr_39961_42088[(2)] = null);

(statearr_39961_42088[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39959 === (4))){
var inst_39939 = (state_39958[(7)]);
var inst_39939__$1 = (state_39958[(2)]);
var inst_39940 = (inst_39939__$1 == null);
var state_39958__$1 = (function (){var statearr_39962 = state_39958;
(statearr_39962[(7)] = inst_39939__$1);

return statearr_39962;
})();
if(cljs.core.truth_(inst_39940)){
var statearr_39963_42089 = state_39958__$1;
(statearr_39963_42089[(1)] = (5));

} else {
var statearr_39964_42090 = state_39958__$1;
(statearr_39964_42090[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39959 === (6))){
var inst_39944 = (state_39958[(8)]);
var inst_39939 = (state_39958[(7)]);
var inst_39944__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_39945 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39946 = [inst_39939,inst_39944__$1];
var inst_39947 = (new cljs.core.PersistentVector(null,2,(5),inst_39945,inst_39946,null));
var state_39958__$1 = (function (){var statearr_39965 = state_39958;
(statearr_39965[(8)] = inst_39944__$1);

return statearr_39965;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_39958__$1,(8),jobs,inst_39947);
} else {
if((state_val_39959 === (3))){
var inst_39956 = (state_39958[(2)]);
var state_39958__$1 = state_39958;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39958__$1,inst_39956);
} else {
if((state_val_39959 === (2))){
var state_39958__$1 = state_39958;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39958__$1,(4),from);
} else {
if((state_val_39959 === (9))){
var inst_39951 = (state_39958[(2)]);
var state_39958__$1 = (function (){var statearr_39968 = state_39958;
(statearr_39968[(9)] = inst_39951);

return statearr_39968;
})();
var statearr_39969_42095 = state_39958__$1;
(statearr_39969_42095[(2)] = null);

(statearr_39969_42095[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39959 === (5))){
var inst_39942 = cljs.core.async.close_BANG_(jobs);
var state_39958__$1 = state_39958;
var statearr_39973_42096 = state_39958__$1;
(statearr_39973_42096[(2)] = inst_39942);

(statearr_39973_42096[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39959 === (8))){
var inst_39944 = (state_39958[(8)]);
var inst_39949 = (state_39958[(2)]);
var state_39958__$1 = (function (){var statearr_39975 = state_39958;
(statearr_39975[(10)] = inst_39949);

return statearr_39975;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_39958__$1,(9),results,inst_39944);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__39413__auto___42085,jobs,results,process,async))
;
return ((function (switch__39111__auto__,c__39413__auto___42085,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__39112__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__39112__auto____0 = (function (){
var statearr_39976 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_39976[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__39112__auto__);

(statearr_39976[(1)] = (1));

return statearr_39976;
});
var cljs$core$async$pipeline_STAR__$_state_machine__39112__auto____1 = (function (state_39958){
while(true){
var ret_value__39113__auto__ = (function (){try{while(true){
var result__39114__auto__ = switch__39111__auto__(state_39958);
if(cljs.core.keyword_identical_QMARK_(result__39114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__39114__auto__;
}
break;
}
}catch (e39977){if((e39977 instanceof Object)){
var ex__39115__auto__ = e39977;
var statearr_39978_42100 = state_39958;
(statearr_39978_42100[(5)] = ex__39115__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_39958);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e39977;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__39113__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42101 = state_39958;
state_39958 = G__42101;
continue;
} else {
return ret_value__39113__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__39112__auto__ = function(state_39958){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__39112__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__39112__auto____1.call(this,state_39958);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__39112__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__39112__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__39112__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__39112__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__39112__auto__;
})()
;})(switch__39111__auto__,c__39413__auto___42085,jobs,results,process,async))
})();
var state__39415__auto__ = (function (){var statearr_39979 = (f__39414__auto__.cljs$core$IFn$_invoke$arity$0 ? f__39414__auto__.cljs$core$IFn$_invoke$arity$0() : f__39414__auto__.call(null));
(statearr_39979[(6)] = c__39413__auto___42085);

return statearr_39979;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__39415__auto__);
});})(c__39413__auto___42085,jobs,results,process,async))
);


var c__39413__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__39413__auto__,jobs,results,process,async){
return (function (){
var f__39414__auto__ = (function (){var switch__39111__auto__ = ((function (c__39413__auto__,jobs,results,process,async){
return (function (state_40019){
var state_val_40020 = (state_40019[(1)]);
if((state_val_40020 === (7))){
var inst_40015 = (state_40019[(2)]);
var state_40019__$1 = state_40019;
var statearr_40025_42105 = state_40019__$1;
(statearr_40025_42105[(2)] = inst_40015);

(statearr_40025_42105[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40020 === (20))){
var state_40019__$1 = state_40019;
var statearr_40026_42106 = state_40019__$1;
(statearr_40026_42106[(2)] = null);

(statearr_40026_42106[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40020 === (1))){
var state_40019__$1 = state_40019;
var statearr_40027_42107 = state_40019__$1;
(statearr_40027_42107[(2)] = null);

(statearr_40027_42107[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40020 === (4))){
var inst_39983 = (state_40019[(7)]);
var inst_39983__$1 = (state_40019[(2)]);
var inst_39984 = (inst_39983__$1 == null);
var state_40019__$1 = (function (){var statearr_40029 = state_40019;
(statearr_40029[(7)] = inst_39983__$1);

return statearr_40029;
})();
if(cljs.core.truth_(inst_39984)){
var statearr_40030_42110 = state_40019__$1;
(statearr_40030_42110[(1)] = (5));

} else {
var statearr_40031_42111 = state_40019__$1;
(statearr_40031_42111[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40020 === (15))){
var inst_39996 = (state_40019[(8)]);
var state_40019__$1 = state_40019;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_40019__$1,(18),to,inst_39996);
} else {
if((state_val_40020 === (21))){
var inst_40010 = (state_40019[(2)]);
var state_40019__$1 = state_40019;
var statearr_40035_42114 = state_40019__$1;
(statearr_40035_42114[(2)] = inst_40010);

(statearr_40035_42114[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40020 === (13))){
var inst_40012 = (state_40019[(2)]);
var state_40019__$1 = (function (){var statearr_40037 = state_40019;
(statearr_40037[(9)] = inst_40012);

return statearr_40037;
})();
var statearr_40038_42115 = state_40019__$1;
(statearr_40038_42115[(2)] = null);

(statearr_40038_42115[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40020 === (6))){
var inst_39983 = (state_40019[(7)]);
var state_40019__$1 = state_40019;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40019__$1,(11),inst_39983);
} else {
if((state_val_40020 === (17))){
var inst_40004 = (state_40019[(2)]);
var state_40019__$1 = state_40019;
if(cljs.core.truth_(inst_40004)){
var statearr_40039_42117 = state_40019__$1;
(statearr_40039_42117[(1)] = (19));

} else {
var statearr_40040_42118 = state_40019__$1;
(statearr_40040_42118[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40020 === (3))){
var inst_40017 = (state_40019[(2)]);
var state_40019__$1 = state_40019;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40019__$1,inst_40017);
} else {
if((state_val_40020 === (12))){
var inst_39993 = (state_40019[(10)]);
var state_40019__$1 = state_40019;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40019__$1,(14),inst_39993);
} else {
if((state_val_40020 === (2))){
var state_40019__$1 = state_40019;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40019__$1,(4),results);
} else {
if((state_val_40020 === (19))){
var state_40019__$1 = state_40019;
var statearr_40041_42121 = state_40019__$1;
(statearr_40041_42121[(2)] = null);

(statearr_40041_42121[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40020 === (11))){
var inst_39993 = (state_40019[(2)]);
var state_40019__$1 = (function (){var statearr_40042 = state_40019;
(statearr_40042[(10)] = inst_39993);

return statearr_40042;
})();
var statearr_40043_42124 = state_40019__$1;
(statearr_40043_42124[(2)] = null);

(statearr_40043_42124[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40020 === (9))){
var state_40019__$1 = state_40019;
var statearr_40044_42125 = state_40019__$1;
(statearr_40044_42125[(2)] = null);

(statearr_40044_42125[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40020 === (5))){
var state_40019__$1 = state_40019;
if(cljs.core.truth_(close_QMARK_)){
var statearr_40045_42126 = state_40019__$1;
(statearr_40045_42126[(1)] = (8));

} else {
var statearr_40046_42127 = state_40019__$1;
(statearr_40046_42127[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40020 === (14))){
var inst_39998 = (state_40019[(11)]);
var inst_39996 = (state_40019[(8)]);
var inst_39996__$1 = (state_40019[(2)]);
var inst_39997 = (inst_39996__$1 == null);
var inst_39998__$1 = cljs.core.not(inst_39997);
var state_40019__$1 = (function (){var statearr_40047 = state_40019;
(statearr_40047[(11)] = inst_39998__$1);

(statearr_40047[(8)] = inst_39996__$1);

return statearr_40047;
})();
if(inst_39998__$1){
var statearr_40048_42129 = state_40019__$1;
(statearr_40048_42129[(1)] = (15));

} else {
var statearr_40049_42130 = state_40019__$1;
(statearr_40049_42130[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40020 === (16))){
var inst_39998 = (state_40019[(11)]);
var state_40019__$1 = state_40019;
var statearr_40050_42131 = state_40019__$1;
(statearr_40050_42131[(2)] = inst_39998);

(statearr_40050_42131[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40020 === (10))){
var inst_39990 = (state_40019[(2)]);
var state_40019__$1 = state_40019;
var statearr_40051_42132 = state_40019__$1;
(statearr_40051_42132[(2)] = inst_39990);

(statearr_40051_42132[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40020 === (18))){
var inst_40001 = (state_40019[(2)]);
var state_40019__$1 = state_40019;
var statearr_40052_42133 = state_40019__$1;
(statearr_40052_42133[(2)] = inst_40001);

(statearr_40052_42133[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40020 === (8))){
var inst_39987 = cljs.core.async.close_BANG_(to);
var state_40019__$1 = state_40019;
var statearr_40053_42136 = state_40019__$1;
(statearr_40053_42136[(2)] = inst_39987);

(statearr_40053_42136[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__39413__auto__,jobs,results,process,async))
;
return ((function (switch__39111__auto__,c__39413__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__39112__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__39112__auto____0 = (function (){
var statearr_40054 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40054[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__39112__auto__);

(statearr_40054[(1)] = (1));

return statearr_40054;
});
var cljs$core$async$pipeline_STAR__$_state_machine__39112__auto____1 = (function (state_40019){
while(true){
var ret_value__39113__auto__ = (function (){try{while(true){
var result__39114__auto__ = switch__39111__auto__(state_40019);
if(cljs.core.keyword_identical_QMARK_(result__39114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__39114__auto__;
}
break;
}
}catch (e40055){if((e40055 instanceof Object)){
var ex__39115__auto__ = e40055;
var statearr_40056_42139 = state_40019;
(statearr_40056_42139[(5)] = ex__39115__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_40019);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e40055;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__39113__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42140 = state_40019;
state_40019 = G__42140;
continue;
} else {
return ret_value__39113__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__39112__auto__ = function(state_40019){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__39112__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__39112__auto____1.call(this,state_40019);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__39112__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__39112__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__39112__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__39112__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__39112__auto__;
})()
;})(switch__39111__auto__,c__39413__auto__,jobs,results,process,async))
})();
var state__39415__auto__ = (function (){var statearr_40057 = (f__39414__auto__.cljs$core$IFn$_invoke$arity$0 ? f__39414__auto__.cljs$core$IFn$_invoke$arity$0() : f__39414__auto__.call(null));
(statearr_40057[(6)] = c__39413__auto__);

return statearr_40057;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__39415__auto__);
});})(c__39413__auto__,jobs,results,process,async))
);

return c__39413__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__40059 = arguments.length;
switch (G__40059) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__40061 = arguments.length;
switch (G__40061) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__40063 = arguments.length;
switch (G__40063) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__39413__auto___42154 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__39413__auto___42154,tc,fc){
return (function (){
var f__39414__auto__ = (function (){var switch__39111__auto__ = ((function (c__39413__auto___42154,tc,fc){
return (function (state_40089){
var state_val_40090 = (state_40089[(1)]);
if((state_val_40090 === (7))){
var inst_40085 = (state_40089[(2)]);
var state_40089__$1 = state_40089;
var statearr_40091_42156 = state_40089__$1;
(statearr_40091_42156[(2)] = inst_40085);

(statearr_40091_42156[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40090 === (1))){
var state_40089__$1 = state_40089;
var statearr_40092_42157 = state_40089__$1;
(statearr_40092_42157[(2)] = null);

(statearr_40092_42157[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40090 === (4))){
var inst_40066 = (state_40089[(7)]);
var inst_40066__$1 = (state_40089[(2)]);
var inst_40067 = (inst_40066__$1 == null);
var state_40089__$1 = (function (){var statearr_40093 = state_40089;
(statearr_40093[(7)] = inst_40066__$1);

return statearr_40093;
})();
if(cljs.core.truth_(inst_40067)){
var statearr_40094_42160 = state_40089__$1;
(statearr_40094_42160[(1)] = (5));

} else {
var statearr_40095_42163 = state_40089__$1;
(statearr_40095_42163[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40090 === (13))){
var state_40089__$1 = state_40089;
var statearr_40096_42164 = state_40089__$1;
(statearr_40096_42164[(2)] = null);

(statearr_40096_42164[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40090 === (6))){
var inst_40066 = (state_40089[(7)]);
var inst_40072 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_40066) : p.call(null,inst_40066));
var state_40089__$1 = state_40089;
if(cljs.core.truth_(inst_40072)){
var statearr_40097_42165 = state_40089__$1;
(statearr_40097_42165[(1)] = (9));

} else {
var statearr_40098_42167 = state_40089__$1;
(statearr_40098_42167[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40090 === (3))){
var inst_40087 = (state_40089[(2)]);
var state_40089__$1 = state_40089;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40089__$1,inst_40087);
} else {
if((state_val_40090 === (12))){
var state_40089__$1 = state_40089;
var statearr_40099_42168 = state_40089__$1;
(statearr_40099_42168[(2)] = null);

(statearr_40099_42168[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40090 === (2))){
var state_40089__$1 = state_40089;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40089__$1,(4),ch);
} else {
if((state_val_40090 === (11))){
var inst_40066 = (state_40089[(7)]);
var inst_40076 = (state_40089[(2)]);
var state_40089__$1 = state_40089;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_40089__$1,(8),inst_40076,inst_40066);
} else {
if((state_val_40090 === (9))){
var state_40089__$1 = state_40089;
var statearr_40101_42171 = state_40089__$1;
(statearr_40101_42171[(2)] = tc);

(statearr_40101_42171[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40090 === (5))){
var inst_40069 = cljs.core.async.close_BANG_(tc);
var inst_40070 = cljs.core.async.close_BANG_(fc);
var state_40089__$1 = (function (){var statearr_40105 = state_40089;
(statearr_40105[(8)] = inst_40069);

return statearr_40105;
})();
var statearr_40107_42174 = state_40089__$1;
(statearr_40107_42174[(2)] = inst_40070);

(statearr_40107_42174[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40090 === (14))){
var inst_40083 = (state_40089[(2)]);
var state_40089__$1 = state_40089;
var statearr_40108_42175 = state_40089__$1;
(statearr_40108_42175[(2)] = inst_40083);

(statearr_40108_42175[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40090 === (10))){
var state_40089__$1 = state_40089;
var statearr_40109_42177 = state_40089__$1;
(statearr_40109_42177[(2)] = fc);

(statearr_40109_42177[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40090 === (8))){
var inst_40078 = (state_40089[(2)]);
var state_40089__$1 = state_40089;
if(cljs.core.truth_(inst_40078)){
var statearr_40110_42178 = state_40089__$1;
(statearr_40110_42178[(1)] = (12));

} else {
var statearr_40111_42179 = state_40089__$1;
(statearr_40111_42179[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__39413__auto___42154,tc,fc))
;
return ((function (switch__39111__auto__,c__39413__auto___42154,tc,fc){
return (function() {
var cljs$core$async$state_machine__39112__auto__ = null;
var cljs$core$async$state_machine__39112__auto____0 = (function (){
var statearr_40112 = [null,null,null,null,null,null,null,null,null];
(statearr_40112[(0)] = cljs$core$async$state_machine__39112__auto__);

(statearr_40112[(1)] = (1));

return statearr_40112;
});
var cljs$core$async$state_machine__39112__auto____1 = (function (state_40089){
while(true){
var ret_value__39113__auto__ = (function (){try{while(true){
var result__39114__auto__ = switch__39111__auto__(state_40089);
if(cljs.core.keyword_identical_QMARK_(result__39114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__39114__auto__;
}
break;
}
}catch (e40113){if((e40113 instanceof Object)){
var ex__39115__auto__ = e40113;
var statearr_40114_42184 = state_40089;
(statearr_40114_42184[(5)] = ex__39115__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_40089);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e40113;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__39113__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42185 = state_40089;
state_40089 = G__42185;
continue;
} else {
return ret_value__39113__auto__;
}
break;
}
});
cljs$core$async$state_machine__39112__auto__ = function(state_40089){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__39112__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__39112__auto____1.call(this,state_40089);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__39112__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__39112__auto____0;
cljs$core$async$state_machine__39112__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__39112__auto____1;
return cljs$core$async$state_machine__39112__auto__;
})()
;})(switch__39111__auto__,c__39413__auto___42154,tc,fc))
})();
var state__39415__auto__ = (function (){var statearr_40115 = (f__39414__auto__.cljs$core$IFn$_invoke$arity$0 ? f__39414__auto__.cljs$core$IFn$_invoke$arity$0() : f__39414__auto__.call(null));
(statearr_40115[(6)] = c__39413__auto___42154);

return statearr_40115;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__39415__auto__);
});})(c__39413__auto___42154,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__39413__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__39413__auto__){
return (function (){
var f__39414__auto__ = (function (){var switch__39111__auto__ = ((function (c__39413__auto__){
return (function (state_40149){
var state_val_40150 = (state_40149[(1)]);
if((state_val_40150 === (7))){
var inst_40145 = (state_40149[(2)]);
var state_40149__$1 = state_40149;
var statearr_40155_42189 = state_40149__$1;
(statearr_40155_42189[(2)] = inst_40145);

(statearr_40155_42189[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40150 === (1))){
var inst_40126 = init;
var state_40149__$1 = (function (){var statearr_40156 = state_40149;
(statearr_40156[(7)] = inst_40126);

return statearr_40156;
})();
var statearr_40160_42192 = state_40149__$1;
(statearr_40160_42192[(2)] = null);

(statearr_40160_42192[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40150 === (4))){
var inst_40129 = (state_40149[(8)]);
var inst_40129__$1 = (state_40149[(2)]);
var inst_40133 = (inst_40129__$1 == null);
var state_40149__$1 = (function (){var statearr_40162 = state_40149;
(statearr_40162[(8)] = inst_40129__$1);

return statearr_40162;
})();
if(cljs.core.truth_(inst_40133)){
var statearr_40163_42193 = state_40149__$1;
(statearr_40163_42193[(1)] = (5));

} else {
var statearr_40164_42195 = state_40149__$1;
(statearr_40164_42195[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40150 === (6))){
var inst_40129 = (state_40149[(8)]);
var inst_40136 = (state_40149[(9)]);
var inst_40126 = (state_40149[(7)]);
var inst_40136__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_40126,inst_40129) : f.call(null,inst_40126,inst_40129));
var inst_40137 = cljs.core.reduced_QMARK_(inst_40136__$1);
var state_40149__$1 = (function (){var statearr_40166 = state_40149;
(statearr_40166[(9)] = inst_40136__$1);

return statearr_40166;
})();
if(inst_40137){
var statearr_40169_42198 = state_40149__$1;
(statearr_40169_42198[(1)] = (8));

} else {
var statearr_40170_42199 = state_40149__$1;
(statearr_40170_42199[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40150 === (3))){
var inst_40147 = (state_40149[(2)]);
var state_40149__$1 = state_40149;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40149__$1,inst_40147);
} else {
if((state_val_40150 === (2))){
var state_40149__$1 = state_40149;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40149__$1,(4),ch);
} else {
if((state_val_40150 === (9))){
var inst_40136 = (state_40149[(9)]);
var inst_40126 = inst_40136;
var state_40149__$1 = (function (){var statearr_40175 = state_40149;
(statearr_40175[(7)] = inst_40126);

return statearr_40175;
})();
var statearr_40176_42202 = state_40149__$1;
(statearr_40176_42202[(2)] = null);

(statearr_40176_42202[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40150 === (5))){
var inst_40126 = (state_40149[(7)]);
var state_40149__$1 = state_40149;
var statearr_40177_42203 = state_40149__$1;
(statearr_40177_42203[(2)] = inst_40126);

(statearr_40177_42203[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40150 === (10))){
var inst_40143 = (state_40149[(2)]);
var state_40149__$1 = state_40149;
var statearr_40178_42205 = state_40149__$1;
(statearr_40178_42205[(2)] = inst_40143);

(statearr_40178_42205[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40150 === (8))){
var inst_40136 = (state_40149[(9)]);
var inst_40139 = cljs.core.deref(inst_40136);
var state_40149__$1 = state_40149;
var statearr_40179_42206 = state_40149__$1;
(statearr_40179_42206[(2)] = inst_40139);

(statearr_40179_42206[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__39413__auto__))
;
return ((function (switch__39111__auto__,c__39413__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__39112__auto__ = null;
var cljs$core$async$reduce_$_state_machine__39112__auto____0 = (function (){
var statearr_40180 = [null,null,null,null,null,null,null,null,null,null];
(statearr_40180[(0)] = cljs$core$async$reduce_$_state_machine__39112__auto__);

(statearr_40180[(1)] = (1));

return statearr_40180;
});
var cljs$core$async$reduce_$_state_machine__39112__auto____1 = (function (state_40149){
while(true){
var ret_value__39113__auto__ = (function (){try{while(true){
var result__39114__auto__ = switch__39111__auto__(state_40149);
if(cljs.core.keyword_identical_QMARK_(result__39114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__39114__auto__;
}
break;
}
}catch (e40181){if((e40181 instanceof Object)){
var ex__39115__auto__ = e40181;
var statearr_40182_42211 = state_40149;
(statearr_40182_42211[(5)] = ex__39115__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_40149);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e40181;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__39113__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42212 = state_40149;
state_40149 = G__42212;
continue;
} else {
return ret_value__39113__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__39112__auto__ = function(state_40149){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__39112__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__39112__auto____1.call(this,state_40149);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__39112__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__39112__auto____0;
cljs$core$async$reduce_$_state_machine__39112__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__39112__auto____1;
return cljs$core$async$reduce_$_state_machine__39112__auto__;
})()
;})(switch__39111__auto__,c__39413__auto__))
})();
var state__39415__auto__ = (function (){var statearr_40183 = (f__39414__auto__.cljs$core$IFn$_invoke$arity$0 ? f__39414__auto__.cljs$core$IFn$_invoke$arity$0() : f__39414__auto__.call(null));
(statearr_40183[(6)] = c__39413__auto__);

return statearr_40183;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__39415__auto__);
});})(c__39413__auto__))
);

return c__39413__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__39413__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__39413__auto__,f__$1){
return (function (){
var f__39414__auto__ = (function (){var switch__39111__auto__ = ((function (c__39413__auto__,f__$1){
return (function (state_40189){
var state_val_40190 = (state_40189[(1)]);
if((state_val_40190 === (1))){
var inst_40184 = cljs.core.async.reduce(f__$1,init,ch);
var state_40189__$1 = state_40189;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40189__$1,(2),inst_40184);
} else {
if((state_val_40190 === (2))){
var inst_40186 = (state_40189[(2)]);
var inst_40187 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_40186) : f__$1.call(null,inst_40186));
var state_40189__$1 = state_40189;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40189__$1,inst_40187);
} else {
return null;
}
}
});})(c__39413__auto__,f__$1))
;
return ((function (switch__39111__auto__,c__39413__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__39112__auto__ = null;
var cljs$core$async$transduce_$_state_machine__39112__auto____0 = (function (){
var statearr_40194 = [null,null,null,null,null,null,null];
(statearr_40194[(0)] = cljs$core$async$transduce_$_state_machine__39112__auto__);

(statearr_40194[(1)] = (1));

return statearr_40194;
});
var cljs$core$async$transduce_$_state_machine__39112__auto____1 = (function (state_40189){
while(true){
var ret_value__39113__auto__ = (function (){try{while(true){
var result__39114__auto__ = switch__39111__auto__(state_40189);
if(cljs.core.keyword_identical_QMARK_(result__39114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__39114__auto__;
}
break;
}
}catch (e40195){if((e40195 instanceof Object)){
var ex__39115__auto__ = e40195;
var statearr_40196_42219 = state_40189;
(statearr_40196_42219[(5)] = ex__39115__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_40189);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e40195;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__39113__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42222 = state_40189;
state_40189 = G__42222;
continue;
} else {
return ret_value__39113__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__39112__auto__ = function(state_40189){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__39112__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__39112__auto____1.call(this,state_40189);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__39112__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__39112__auto____0;
cljs$core$async$transduce_$_state_machine__39112__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__39112__auto____1;
return cljs$core$async$transduce_$_state_machine__39112__auto__;
})()
;})(switch__39111__auto__,c__39413__auto__,f__$1))
})();
var state__39415__auto__ = (function (){var statearr_40199 = (f__39414__auto__.cljs$core$IFn$_invoke$arity$0 ? f__39414__auto__.cljs$core$IFn$_invoke$arity$0() : f__39414__auto__.call(null));
(statearr_40199[(6)] = c__39413__auto__);

return statearr_40199;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__39415__auto__);
});})(c__39413__auto__,f__$1))
);

return c__39413__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__40201 = arguments.length;
switch (G__40201) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__39413__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__39413__auto__){
return (function (){
var f__39414__auto__ = (function (){var switch__39111__auto__ = ((function (c__39413__auto__){
return (function (state_40231){
var state_val_40232 = (state_40231[(1)]);
if((state_val_40232 === (7))){
var inst_40209 = (state_40231[(2)]);
var state_40231__$1 = state_40231;
var statearr_40234_42229 = state_40231__$1;
(statearr_40234_42229[(2)] = inst_40209);

(statearr_40234_42229[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40232 === (1))){
var inst_40203 = cljs.core.seq(coll);
var inst_40204 = inst_40203;
var state_40231__$1 = (function (){var statearr_40235 = state_40231;
(statearr_40235[(7)] = inst_40204);

return statearr_40235;
})();
var statearr_40236_42232 = state_40231__$1;
(statearr_40236_42232[(2)] = null);

(statearr_40236_42232[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40232 === (4))){
var inst_40204 = (state_40231[(7)]);
var inst_40207 = cljs.core.first(inst_40204);
var state_40231__$1 = state_40231;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_40231__$1,(7),ch,inst_40207);
} else {
if((state_val_40232 === (13))){
var inst_40224 = (state_40231[(2)]);
var state_40231__$1 = state_40231;
var statearr_40241_42233 = state_40231__$1;
(statearr_40241_42233[(2)] = inst_40224);

(statearr_40241_42233[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40232 === (6))){
var inst_40212 = (state_40231[(2)]);
var state_40231__$1 = state_40231;
if(cljs.core.truth_(inst_40212)){
var statearr_40242_42235 = state_40231__$1;
(statearr_40242_42235[(1)] = (8));

} else {
var statearr_40243_42236 = state_40231__$1;
(statearr_40243_42236[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40232 === (3))){
var inst_40229 = (state_40231[(2)]);
var state_40231__$1 = state_40231;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40231__$1,inst_40229);
} else {
if((state_val_40232 === (12))){
var state_40231__$1 = state_40231;
var statearr_40244_42239 = state_40231__$1;
(statearr_40244_42239[(2)] = null);

(statearr_40244_42239[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40232 === (2))){
var inst_40204 = (state_40231[(7)]);
var state_40231__$1 = state_40231;
if(cljs.core.truth_(inst_40204)){
var statearr_40245_42242 = state_40231__$1;
(statearr_40245_42242[(1)] = (4));

} else {
var statearr_40246_42243 = state_40231__$1;
(statearr_40246_42243[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40232 === (11))){
var inst_40221 = cljs.core.async.close_BANG_(ch);
var state_40231__$1 = state_40231;
var statearr_40247_42244 = state_40231__$1;
(statearr_40247_42244[(2)] = inst_40221);

(statearr_40247_42244[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40232 === (9))){
var state_40231__$1 = state_40231;
if(cljs.core.truth_(close_QMARK_)){
var statearr_40248_42246 = state_40231__$1;
(statearr_40248_42246[(1)] = (11));

} else {
var statearr_40249_42247 = state_40231__$1;
(statearr_40249_42247[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40232 === (5))){
var inst_40204 = (state_40231[(7)]);
var state_40231__$1 = state_40231;
var statearr_40250_42249 = state_40231__$1;
(statearr_40250_42249[(2)] = inst_40204);

(statearr_40250_42249[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40232 === (10))){
var inst_40226 = (state_40231[(2)]);
var state_40231__$1 = state_40231;
var statearr_40252_42253 = state_40231__$1;
(statearr_40252_42253[(2)] = inst_40226);

(statearr_40252_42253[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40232 === (8))){
var inst_40204 = (state_40231[(7)]);
var inst_40217 = cljs.core.next(inst_40204);
var inst_40204__$1 = inst_40217;
var state_40231__$1 = (function (){var statearr_40253 = state_40231;
(statearr_40253[(7)] = inst_40204__$1);

return statearr_40253;
})();
var statearr_40254_42254 = state_40231__$1;
(statearr_40254_42254[(2)] = null);

(statearr_40254_42254[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__39413__auto__))
;
return ((function (switch__39111__auto__,c__39413__auto__){
return (function() {
var cljs$core$async$state_machine__39112__auto__ = null;
var cljs$core$async$state_machine__39112__auto____0 = (function (){
var statearr_40255 = [null,null,null,null,null,null,null,null];
(statearr_40255[(0)] = cljs$core$async$state_machine__39112__auto__);

(statearr_40255[(1)] = (1));

return statearr_40255;
});
var cljs$core$async$state_machine__39112__auto____1 = (function (state_40231){
while(true){
var ret_value__39113__auto__ = (function (){try{while(true){
var result__39114__auto__ = switch__39111__auto__(state_40231);
if(cljs.core.keyword_identical_QMARK_(result__39114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__39114__auto__;
}
break;
}
}catch (e40256){if((e40256 instanceof Object)){
var ex__39115__auto__ = e40256;
var statearr_40257_42258 = state_40231;
(statearr_40257_42258[(5)] = ex__39115__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_40231);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e40256;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__39113__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42259 = state_40231;
state_40231 = G__42259;
continue;
} else {
return ret_value__39113__auto__;
}
break;
}
});
cljs$core$async$state_machine__39112__auto__ = function(state_40231){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__39112__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__39112__auto____1.call(this,state_40231);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__39112__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__39112__auto____0;
cljs$core$async$state_machine__39112__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__39112__auto____1;
return cljs$core$async$state_machine__39112__auto__;
})()
;})(switch__39111__auto__,c__39413__auto__))
})();
var state__39415__auto__ = (function (){var statearr_40258 = (f__39414__auto__.cljs$core$IFn$_invoke$arity$0 ? f__39414__auto__.cljs$core$IFn$_invoke$arity$0() : f__39414__auto__.call(null));
(statearr_40258[(6)] = c__39413__auto__);

return statearr_40258;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__39415__auto__);
});})(c__39413__auto__))
);

return c__39413__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__4433__auto__ = (((_ == null))?null:_);
var m__4434__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4434__auto__.call(null,_));
} else {
var m__4431__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4431__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4434__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4431__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4431__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4434__auto__.call(null,m,ch));
} else {
var m__4431__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4431__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4434__auto__.call(null,m));
} else {
var m__4431__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4431__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async40259 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async40259 = (function (ch,cs,meta40260){
this.ch = ch;
this.cs = cs;
this.meta40260 = meta40260;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async40259.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_40261,meta40260__$1){
var self__ = this;
var _40261__$1 = this;
return (new cljs.core.async.t_cljs$core$async40259(self__.ch,self__.cs,meta40260__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async40259.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_40261){
var self__ = this;
var _40261__$1 = this;
return self__.meta40260;
});})(cs))
;

cljs.core.async.t_cljs$core$async40259.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async40259.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async40259.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async40259.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async40259.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async40259.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async40259.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta40260","meta40260",539912319,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async40259.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async40259.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async40259";

cljs.core.async.t_cljs$core$async40259.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core.async/t_cljs$core$async40259");
});})(cs))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async40259.
 */
cljs.core.async.__GT_t_cljs$core$async40259 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async40259(ch__$1,cs__$1,meta40260){
return (new cljs.core.async.t_cljs$core$async40259(ch__$1,cs__$1,meta40260));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async40259(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__39413__auto___42277 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__39413__auto___42277,cs,m,dchan,dctr,done){
return (function (){
var f__39414__auto__ = (function (){var switch__39111__auto__ = ((function (c__39413__auto___42277,cs,m,dchan,dctr,done){
return (function (state_40396){
var state_val_40397 = (state_40396[(1)]);
if((state_val_40397 === (7))){
var inst_40392 = (state_40396[(2)]);
var state_40396__$1 = state_40396;
var statearr_40398_42279 = state_40396__$1;
(statearr_40398_42279[(2)] = inst_40392);

(statearr_40398_42279[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40397 === (20))){
var inst_40295 = (state_40396[(7)]);
var inst_40307 = cljs.core.first(inst_40295);
var inst_40308 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40307,(0),null);
var inst_40309 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40307,(1),null);
var state_40396__$1 = (function (){var statearr_40399 = state_40396;
(statearr_40399[(8)] = inst_40308);

return statearr_40399;
})();
if(cljs.core.truth_(inst_40309)){
var statearr_40400_42284 = state_40396__$1;
(statearr_40400_42284[(1)] = (22));

} else {
var statearr_40401_42285 = state_40396__$1;
(statearr_40401_42285[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40397 === (27))){
var inst_40337 = (state_40396[(9)]);
var inst_40264 = (state_40396[(10)]);
var inst_40344 = (state_40396[(11)]);
var inst_40339 = (state_40396[(12)]);
var inst_40344__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_40337,inst_40339);
var inst_40345 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_40344__$1,inst_40264,done);
var state_40396__$1 = (function (){var statearr_40402 = state_40396;
(statearr_40402[(11)] = inst_40344__$1);

return statearr_40402;
})();
if(cljs.core.truth_(inst_40345)){
var statearr_40403_42287 = state_40396__$1;
(statearr_40403_42287[(1)] = (30));

} else {
var statearr_40404_42288 = state_40396__$1;
(statearr_40404_42288[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40397 === (1))){
var state_40396__$1 = state_40396;
var statearr_40405_42289 = state_40396__$1;
(statearr_40405_42289[(2)] = null);

(statearr_40405_42289[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40397 === (24))){
var inst_40295 = (state_40396[(7)]);
var inst_40314 = (state_40396[(2)]);
var inst_40315 = cljs.core.next(inst_40295);
var inst_40273 = inst_40315;
var inst_40274 = null;
var inst_40275 = (0);
var inst_40276 = (0);
var state_40396__$1 = (function (){var statearr_40406 = state_40396;
(statearr_40406[(13)] = inst_40275);

(statearr_40406[(14)] = inst_40273);

(statearr_40406[(15)] = inst_40274);

(statearr_40406[(16)] = inst_40314);

(statearr_40406[(17)] = inst_40276);

return statearr_40406;
})();
var statearr_40407_42292 = state_40396__$1;
(statearr_40407_42292[(2)] = null);

(statearr_40407_42292[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40397 === (39))){
var state_40396__$1 = state_40396;
var statearr_40412_42295 = state_40396__$1;
(statearr_40412_42295[(2)] = null);

(statearr_40412_42295[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40397 === (4))){
var inst_40264 = (state_40396[(10)]);
var inst_40264__$1 = (state_40396[(2)]);
var inst_40265 = (inst_40264__$1 == null);
var state_40396__$1 = (function (){var statearr_40413 = state_40396;
(statearr_40413[(10)] = inst_40264__$1);

return statearr_40413;
})();
if(cljs.core.truth_(inst_40265)){
var statearr_40414_42296 = state_40396__$1;
(statearr_40414_42296[(1)] = (5));

} else {
var statearr_40415_42297 = state_40396__$1;
(statearr_40415_42297[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40397 === (15))){
var inst_40275 = (state_40396[(13)]);
var inst_40273 = (state_40396[(14)]);
var inst_40274 = (state_40396[(15)]);
var inst_40276 = (state_40396[(17)]);
var inst_40291 = (state_40396[(2)]);
var inst_40292 = (inst_40276 + (1));
var tmp40408 = inst_40275;
var tmp40410 = inst_40273;
var tmp40411 = inst_40274;
var inst_40273__$1 = tmp40410;
var inst_40274__$1 = tmp40411;
var inst_40275__$1 = tmp40408;
var inst_40276__$1 = inst_40292;
var state_40396__$1 = (function (){var statearr_40416 = state_40396;
(statearr_40416[(13)] = inst_40275__$1);

(statearr_40416[(18)] = inst_40291);

(statearr_40416[(14)] = inst_40273__$1);

(statearr_40416[(15)] = inst_40274__$1);

(statearr_40416[(17)] = inst_40276__$1);

return statearr_40416;
})();
var statearr_40417_42299 = state_40396__$1;
(statearr_40417_42299[(2)] = null);

(statearr_40417_42299[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40397 === (21))){
var inst_40318 = (state_40396[(2)]);
var state_40396__$1 = state_40396;
var statearr_40421_42302 = state_40396__$1;
(statearr_40421_42302[(2)] = inst_40318);

(statearr_40421_42302[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40397 === (31))){
var inst_40344 = (state_40396[(11)]);
var inst_40348 = done(null);
var inst_40349 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_40344);
var state_40396__$1 = (function (){var statearr_40425 = state_40396;
(statearr_40425[(19)] = inst_40348);

return statearr_40425;
})();
var statearr_40426_42305 = state_40396__$1;
(statearr_40426_42305[(2)] = inst_40349);

(statearr_40426_42305[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40397 === (32))){
var inst_40338 = (state_40396[(20)]);
var inst_40337 = (state_40396[(9)]);
var inst_40339 = (state_40396[(12)]);
var inst_40336 = (state_40396[(21)]);
var inst_40351 = (state_40396[(2)]);
var inst_40352 = (inst_40339 + (1));
var tmp40418 = inst_40338;
var tmp40419 = inst_40337;
var tmp40420 = inst_40336;
var inst_40336__$1 = tmp40420;
var inst_40337__$1 = tmp40419;
var inst_40338__$1 = tmp40418;
var inst_40339__$1 = inst_40352;
var state_40396__$1 = (function (){var statearr_40427 = state_40396;
(statearr_40427[(20)] = inst_40338__$1);

(statearr_40427[(9)] = inst_40337__$1);

(statearr_40427[(22)] = inst_40351);

(statearr_40427[(12)] = inst_40339__$1);

(statearr_40427[(21)] = inst_40336__$1);

return statearr_40427;
})();
var statearr_40428_42307 = state_40396__$1;
(statearr_40428_42307[(2)] = null);

(statearr_40428_42307[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40397 === (40))){
var inst_40364 = (state_40396[(23)]);
var inst_40368 = done(null);
var inst_40369 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_40364);
var state_40396__$1 = (function (){var statearr_40429 = state_40396;
(statearr_40429[(24)] = inst_40368);

return statearr_40429;
})();
var statearr_40430_42310 = state_40396__$1;
(statearr_40430_42310[(2)] = inst_40369);

(statearr_40430_42310[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40397 === (33))){
var inst_40355 = (state_40396[(25)]);
var inst_40357 = cljs.core.chunked_seq_QMARK_(inst_40355);
var state_40396__$1 = state_40396;
if(inst_40357){
var statearr_40431_42313 = state_40396__$1;
(statearr_40431_42313[(1)] = (36));

} else {
var statearr_40432_42314 = state_40396__$1;
(statearr_40432_42314[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40397 === (13))){
var inst_40285 = (state_40396[(26)]);
var inst_40288 = cljs.core.async.close_BANG_(inst_40285);
var state_40396__$1 = state_40396;
var statearr_40433_42315 = state_40396__$1;
(statearr_40433_42315[(2)] = inst_40288);

(statearr_40433_42315[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40397 === (22))){
var inst_40308 = (state_40396[(8)]);
var inst_40311 = cljs.core.async.close_BANG_(inst_40308);
var state_40396__$1 = state_40396;
var statearr_40434_42317 = state_40396__$1;
(statearr_40434_42317[(2)] = inst_40311);

(statearr_40434_42317[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40397 === (36))){
var inst_40355 = (state_40396[(25)]);
var inst_40359 = cljs.core.chunk_first(inst_40355);
var inst_40360 = cljs.core.chunk_rest(inst_40355);
var inst_40361 = cljs.core.count(inst_40359);
var inst_40336 = inst_40360;
var inst_40337 = inst_40359;
var inst_40338 = inst_40361;
var inst_40339 = (0);
var state_40396__$1 = (function (){var statearr_40435 = state_40396;
(statearr_40435[(20)] = inst_40338);

(statearr_40435[(9)] = inst_40337);

(statearr_40435[(12)] = inst_40339);

(statearr_40435[(21)] = inst_40336);

return statearr_40435;
})();
var statearr_40436_42320 = state_40396__$1;
(statearr_40436_42320[(2)] = null);

(statearr_40436_42320[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40397 === (41))){
var inst_40355 = (state_40396[(25)]);
var inst_40371 = (state_40396[(2)]);
var inst_40372 = cljs.core.next(inst_40355);
var inst_40336 = inst_40372;
var inst_40337 = null;
var inst_40338 = (0);
var inst_40339 = (0);
var state_40396__$1 = (function (){var statearr_40437 = state_40396;
(statearr_40437[(20)] = inst_40338);

(statearr_40437[(9)] = inst_40337);

(statearr_40437[(27)] = inst_40371);

(statearr_40437[(12)] = inst_40339);

(statearr_40437[(21)] = inst_40336);

return statearr_40437;
})();
var statearr_40438_42323 = state_40396__$1;
(statearr_40438_42323[(2)] = null);

(statearr_40438_42323[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40397 === (43))){
var state_40396__$1 = state_40396;
var statearr_40439_42324 = state_40396__$1;
(statearr_40439_42324[(2)] = null);

(statearr_40439_42324[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40397 === (29))){
var inst_40380 = (state_40396[(2)]);
var state_40396__$1 = state_40396;
var statearr_40440_42326 = state_40396__$1;
(statearr_40440_42326[(2)] = inst_40380);

(statearr_40440_42326[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40397 === (44))){
var inst_40389 = (state_40396[(2)]);
var state_40396__$1 = (function (){var statearr_40441 = state_40396;
(statearr_40441[(28)] = inst_40389);

return statearr_40441;
})();
var statearr_40442_42327 = state_40396__$1;
(statearr_40442_42327[(2)] = null);

(statearr_40442_42327[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40397 === (6))){
var inst_40328 = (state_40396[(29)]);
var inst_40327 = cljs.core.deref(cs);
var inst_40328__$1 = cljs.core.keys(inst_40327);
var inst_40329 = cljs.core.count(inst_40328__$1);
var inst_40330 = cljs.core.reset_BANG_(dctr,inst_40329);
var inst_40335 = cljs.core.seq(inst_40328__$1);
var inst_40336 = inst_40335;
var inst_40337 = null;
var inst_40338 = (0);
var inst_40339 = (0);
var state_40396__$1 = (function (){var statearr_40443 = state_40396;
(statearr_40443[(20)] = inst_40338);

(statearr_40443[(9)] = inst_40337);

(statearr_40443[(29)] = inst_40328__$1);

(statearr_40443[(12)] = inst_40339);

(statearr_40443[(21)] = inst_40336);

(statearr_40443[(30)] = inst_40330);

return statearr_40443;
})();
var statearr_40444_42332 = state_40396__$1;
(statearr_40444_42332[(2)] = null);

(statearr_40444_42332[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40397 === (28))){
var inst_40355 = (state_40396[(25)]);
var inst_40336 = (state_40396[(21)]);
var inst_40355__$1 = cljs.core.seq(inst_40336);
var state_40396__$1 = (function (){var statearr_40445 = state_40396;
(statearr_40445[(25)] = inst_40355__$1);

return statearr_40445;
})();
if(inst_40355__$1){
var statearr_40446_42333 = state_40396__$1;
(statearr_40446_42333[(1)] = (33));

} else {
var statearr_40447_42334 = state_40396__$1;
(statearr_40447_42334[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40397 === (25))){
var inst_40338 = (state_40396[(20)]);
var inst_40339 = (state_40396[(12)]);
var inst_40341 = (inst_40339 < inst_40338);
var inst_40342 = inst_40341;
var state_40396__$1 = state_40396;
if(cljs.core.truth_(inst_40342)){
var statearr_40448_42336 = state_40396__$1;
(statearr_40448_42336[(1)] = (27));

} else {
var statearr_40449_42337 = state_40396__$1;
(statearr_40449_42337[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40397 === (34))){
var state_40396__$1 = state_40396;
var statearr_40450_42338 = state_40396__$1;
(statearr_40450_42338[(2)] = null);

(statearr_40450_42338[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40397 === (17))){
var state_40396__$1 = state_40396;
var statearr_40451_42341 = state_40396__$1;
(statearr_40451_42341[(2)] = null);

(statearr_40451_42341[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40397 === (3))){
var inst_40394 = (state_40396[(2)]);
var state_40396__$1 = state_40396;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40396__$1,inst_40394);
} else {
if((state_val_40397 === (12))){
var inst_40323 = (state_40396[(2)]);
var state_40396__$1 = state_40396;
var statearr_40452_42342 = state_40396__$1;
(statearr_40452_42342[(2)] = inst_40323);

(statearr_40452_42342[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40397 === (2))){
var state_40396__$1 = state_40396;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40396__$1,(4),ch);
} else {
if((state_val_40397 === (23))){
var state_40396__$1 = state_40396;
var statearr_40453_42345 = state_40396__$1;
(statearr_40453_42345[(2)] = null);

(statearr_40453_42345[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40397 === (35))){
var inst_40378 = (state_40396[(2)]);
var state_40396__$1 = state_40396;
var statearr_40454_42346 = state_40396__$1;
(statearr_40454_42346[(2)] = inst_40378);

(statearr_40454_42346[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40397 === (19))){
var inst_40295 = (state_40396[(7)]);
var inst_40299 = cljs.core.chunk_first(inst_40295);
var inst_40300 = cljs.core.chunk_rest(inst_40295);
var inst_40301 = cljs.core.count(inst_40299);
var inst_40273 = inst_40300;
var inst_40274 = inst_40299;
var inst_40275 = inst_40301;
var inst_40276 = (0);
var state_40396__$1 = (function (){var statearr_40455 = state_40396;
(statearr_40455[(13)] = inst_40275);

(statearr_40455[(14)] = inst_40273);

(statearr_40455[(15)] = inst_40274);

(statearr_40455[(17)] = inst_40276);

return statearr_40455;
})();
var statearr_40456_42348 = state_40396__$1;
(statearr_40456_42348[(2)] = null);

(statearr_40456_42348[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40397 === (11))){
var inst_40295 = (state_40396[(7)]);
var inst_40273 = (state_40396[(14)]);
var inst_40295__$1 = cljs.core.seq(inst_40273);
var state_40396__$1 = (function (){var statearr_40457 = state_40396;
(statearr_40457[(7)] = inst_40295__$1);

return statearr_40457;
})();
if(inst_40295__$1){
var statearr_40458_42349 = state_40396__$1;
(statearr_40458_42349[(1)] = (16));

} else {
var statearr_40459_42350 = state_40396__$1;
(statearr_40459_42350[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40397 === (9))){
var inst_40325 = (state_40396[(2)]);
var state_40396__$1 = state_40396;
var statearr_40460_42351 = state_40396__$1;
(statearr_40460_42351[(2)] = inst_40325);

(statearr_40460_42351[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40397 === (5))){
var inst_40271 = cljs.core.deref(cs);
var inst_40272 = cljs.core.seq(inst_40271);
var inst_40273 = inst_40272;
var inst_40274 = null;
var inst_40275 = (0);
var inst_40276 = (0);
var state_40396__$1 = (function (){var statearr_40461 = state_40396;
(statearr_40461[(13)] = inst_40275);

(statearr_40461[(14)] = inst_40273);

(statearr_40461[(15)] = inst_40274);

(statearr_40461[(17)] = inst_40276);

return statearr_40461;
})();
var statearr_40462_42356 = state_40396__$1;
(statearr_40462_42356[(2)] = null);

(statearr_40462_42356[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40397 === (14))){
var state_40396__$1 = state_40396;
var statearr_40463_42357 = state_40396__$1;
(statearr_40463_42357[(2)] = null);

(statearr_40463_42357[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40397 === (45))){
var inst_40386 = (state_40396[(2)]);
var state_40396__$1 = state_40396;
var statearr_40464_42358 = state_40396__$1;
(statearr_40464_42358[(2)] = inst_40386);

(statearr_40464_42358[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40397 === (26))){
var inst_40328 = (state_40396[(29)]);
var inst_40382 = (state_40396[(2)]);
var inst_40383 = cljs.core.seq(inst_40328);
var state_40396__$1 = (function (){var statearr_40469 = state_40396;
(statearr_40469[(31)] = inst_40382);

return statearr_40469;
})();
if(inst_40383){
var statearr_40470_42360 = state_40396__$1;
(statearr_40470_42360[(1)] = (42));

} else {
var statearr_40471_42361 = state_40396__$1;
(statearr_40471_42361[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40397 === (16))){
var inst_40295 = (state_40396[(7)]);
var inst_40297 = cljs.core.chunked_seq_QMARK_(inst_40295);
var state_40396__$1 = state_40396;
if(inst_40297){
var statearr_40472_42362 = state_40396__$1;
(statearr_40472_42362[(1)] = (19));

} else {
var statearr_40473_42365 = state_40396__$1;
(statearr_40473_42365[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40397 === (38))){
var inst_40375 = (state_40396[(2)]);
var state_40396__$1 = state_40396;
var statearr_40474_42366 = state_40396__$1;
(statearr_40474_42366[(2)] = inst_40375);

(statearr_40474_42366[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40397 === (30))){
var state_40396__$1 = state_40396;
var statearr_40475_42369 = state_40396__$1;
(statearr_40475_42369[(2)] = null);

(statearr_40475_42369[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40397 === (10))){
var inst_40274 = (state_40396[(15)]);
var inst_40276 = (state_40396[(17)]);
var inst_40284 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_40274,inst_40276);
var inst_40285 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40284,(0),null);
var inst_40286 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40284,(1),null);
var state_40396__$1 = (function (){var statearr_40478 = state_40396;
(statearr_40478[(26)] = inst_40285);

return statearr_40478;
})();
if(cljs.core.truth_(inst_40286)){
var statearr_40479_42371 = state_40396__$1;
(statearr_40479_42371[(1)] = (13));

} else {
var statearr_40480_42372 = state_40396__$1;
(statearr_40480_42372[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40397 === (18))){
var inst_40321 = (state_40396[(2)]);
var state_40396__$1 = state_40396;
var statearr_40481_42373 = state_40396__$1;
(statearr_40481_42373[(2)] = inst_40321);

(statearr_40481_42373[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40397 === (42))){
var state_40396__$1 = state_40396;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40396__$1,(45),dchan);
} else {
if((state_val_40397 === (37))){
var inst_40364 = (state_40396[(23)]);
var inst_40264 = (state_40396[(10)]);
var inst_40355 = (state_40396[(25)]);
var inst_40364__$1 = cljs.core.first(inst_40355);
var inst_40365 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_40364__$1,inst_40264,done);
var state_40396__$1 = (function (){var statearr_40482 = state_40396;
(statearr_40482[(23)] = inst_40364__$1);

return statearr_40482;
})();
if(cljs.core.truth_(inst_40365)){
var statearr_40483_42378 = state_40396__$1;
(statearr_40483_42378[(1)] = (39));

} else {
var statearr_40484_42379 = state_40396__$1;
(statearr_40484_42379[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40397 === (8))){
var inst_40275 = (state_40396[(13)]);
var inst_40276 = (state_40396[(17)]);
var inst_40278 = (inst_40276 < inst_40275);
var inst_40279 = inst_40278;
var state_40396__$1 = state_40396;
if(cljs.core.truth_(inst_40279)){
var statearr_40485_42380 = state_40396__$1;
(statearr_40485_42380[(1)] = (10));

} else {
var statearr_40486_42382 = state_40396__$1;
(statearr_40486_42382[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__39413__auto___42277,cs,m,dchan,dctr,done))
;
return ((function (switch__39111__auto__,c__39413__auto___42277,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__39112__auto__ = null;
var cljs$core$async$mult_$_state_machine__39112__auto____0 = (function (){
var statearr_40487 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40487[(0)] = cljs$core$async$mult_$_state_machine__39112__auto__);

(statearr_40487[(1)] = (1));

return statearr_40487;
});
var cljs$core$async$mult_$_state_machine__39112__auto____1 = (function (state_40396){
while(true){
var ret_value__39113__auto__ = (function (){try{while(true){
var result__39114__auto__ = switch__39111__auto__(state_40396);
if(cljs.core.keyword_identical_QMARK_(result__39114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__39114__auto__;
}
break;
}
}catch (e40488){if((e40488 instanceof Object)){
var ex__39115__auto__ = e40488;
var statearr_40489_42387 = state_40396;
(statearr_40489_42387[(5)] = ex__39115__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_40396);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e40488;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__39113__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42388 = state_40396;
state_40396 = G__42388;
continue;
} else {
return ret_value__39113__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__39112__auto__ = function(state_40396){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__39112__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__39112__auto____1.call(this,state_40396);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__39112__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__39112__auto____0;
cljs$core$async$mult_$_state_machine__39112__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__39112__auto____1;
return cljs$core$async$mult_$_state_machine__39112__auto__;
})()
;})(switch__39111__auto__,c__39413__auto___42277,cs,m,dchan,dctr,done))
})();
var state__39415__auto__ = (function (){var statearr_40490 = (f__39414__auto__.cljs$core$IFn$_invoke$arity$0 ? f__39414__auto__.cljs$core$IFn$_invoke$arity$0() : f__39414__auto__.call(null));
(statearr_40490[(6)] = c__39413__auto___42277);

return statearr_40490;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__39415__auto__);
});})(c__39413__auto___42277,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__40492 = arguments.length;
switch (G__40492) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4434__auto__.call(null,m,ch));
} else {
var m__4431__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4431__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4434__auto__.call(null,m,ch));
} else {
var m__4431__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4431__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4434__auto__.call(null,m));
} else {
var m__4431__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4431__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4434__auto__.call(null,m,state_map));
} else {
var m__4431__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4431__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4434__auto__.call(null,m,mode));
} else {
var m__4431__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4431__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___42406 = arguments.length;
var i__4731__auto___42407 = (0);
while(true){
if((i__4731__auto___42407 < len__4730__auto___42406)){
args__4736__auto__.push((arguments[i__4731__auto___42407]));

var G__42408 = (i__4731__auto___42407 + (1));
i__4731__auto___42407 = G__42408;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__40518){
var map__40521 = p__40518;
var map__40521__$1 = (((((!((map__40521 == null))))?(((((map__40521.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40521.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40521):map__40521);
var opts = map__40521__$1;
var statearr_40523_42413 = state;
(statearr_40523_42413[(1)] = cont_block);


var temp__5735__auto__ = cljs.core.async.do_alts(((function (map__40521,map__40521__$1,opts){
return (function (val){
var statearr_40524_42414 = state;
(statearr_40524_42414[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
});})(map__40521,map__40521__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__5735__auto__)){
var cb = temp__5735__auto__;
var statearr_40526_42416 = state;
(statearr_40526_42416[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq40506){
var G__40508 = cljs.core.first(seq40506);
var seq40506__$1 = cljs.core.next(seq40506);
var G__40509 = cljs.core.first(seq40506__$1);
var seq40506__$2 = cljs.core.next(seq40506__$1);
var G__40510 = cljs.core.first(seq40506__$2);
var seq40506__$3 = cljs.core.next(seq40506__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__40508,G__40509,G__40510,seq40506__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv(((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async40530 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async40530 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta40531){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta40531 = meta40531;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async40530.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_40532,meta40531__$1){
var self__ = this;
var _40532__$1 = this;
return (new cljs.core.async.t_cljs$core$async40530(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta40531__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async40530.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_40532){
var self__ = this;
var _40532__$1 = this;
return self__.meta40531;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async40530.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async40530.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async40530.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async40530.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async40530.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async40530.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async40530.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async40530.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async40530.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta40531","meta40531",1390956777,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async40530.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async40530.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async40530";

cljs.core.async.t_cljs$core$async40530.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core.async/t_cljs$core$async40530");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async40530.
 */
cljs.core.async.__GT_t_cljs$core$async40530 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async40530(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta40531){
return (new cljs.core.async.t_cljs$core$async40530(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta40531));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async40530(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__39413__auto___42440 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__39413__auto___42440,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__39414__auto__ = (function (){var switch__39111__auto__ = ((function (c__39413__auto___42440,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_40667){
var state_val_40668 = (state_40667[(1)]);
if((state_val_40668 === (7))){
var inst_40574 = (state_40667[(2)]);
var state_40667__$1 = state_40667;
var statearr_40670_42442 = state_40667__$1;
(statearr_40670_42442[(2)] = inst_40574);

(statearr_40670_42442[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40668 === (20))){
var inst_40587 = (state_40667[(7)]);
var state_40667__$1 = state_40667;
var statearr_40671_42444 = state_40667__$1;
(statearr_40671_42444[(2)] = inst_40587);

(statearr_40671_42444[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40668 === (27))){
var state_40667__$1 = state_40667;
var statearr_40672_42445 = state_40667__$1;
(statearr_40672_42445[(2)] = null);

(statearr_40672_42445[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40668 === (1))){
var inst_40561 = (state_40667[(8)]);
var inst_40561__$1 = calc_state();
var inst_40563 = (inst_40561__$1 == null);
var inst_40564 = cljs.core.not(inst_40563);
var state_40667__$1 = (function (){var statearr_40676 = state_40667;
(statearr_40676[(8)] = inst_40561__$1);

return statearr_40676;
})();
if(inst_40564){
var statearr_40677_42447 = state_40667__$1;
(statearr_40677_42447[(1)] = (2));

} else {
var statearr_40678_42449 = state_40667__$1;
(statearr_40678_42449[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40668 === (24))){
var inst_40624 = (state_40667[(9)]);
var inst_40638 = (state_40667[(10)]);
var inst_40613 = (state_40667[(11)]);
var inst_40638__$1 = (inst_40613.cljs$core$IFn$_invoke$arity$1 ? inst_40613.cljs$core$IFn$_invoke$arity$1(inst_40624) : inst_40613.call(null,inst_40624));
var state_40667__$1 = (function (){var statearr_40679 = state_40667;
(statearr_40679[(10)] = inst_40638__$1);

return statearr_40679;
})();
if(cljs.core.truth_(inst_40638__$1)){
var statearr_40680_42450 = state_40667__$1;
(statearr_40680_42450[(1)] = (29));

} else {
var statearr_40681_42453 = state_40667__$1;
(statearr_40681_42453[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40668 === (4))){
var inst_40577 = (state_40667[(2)]);
var state_40667__$1 = state_40667;
if(cljs.core.truth_(inst_40577)){
var statearr_40682_42454 = state_40667__$1;
(statearr_40682_42454[(1)] = (8));

} else {
var statearr_40683_42455 = state_40667__$1;
(statearr_40683_42455[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40668 === (15))){
var inst_40607 = (state_40667[(2)]);
var state_40667__$1 = state_40667;
if(cljs.core.truth_(inst_40607)){
var statearr_40684_42456 = state_40667__$1;
(statearr_40684_42456[(1)] = (19));

} else {
var statearr_40685_42457 = state_40667__$1;
(statearr_40685_42457[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40668 === (21))){
var inst_40612 = (state_40667[(12)]);
var inst_40612__$1 = (state_40667[(2)]);
var inst_40613 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40612__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_40614 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40612__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_40615 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40612__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_40667__$1 = (function (){var statearr_40686 = state_40667;
(statearr_40686[(11)] = inst_40613);

(statearr_40686[(13)] = inst_40614);

(statearr_40686[(12)] = inst_40612__$1);

return statearr_40686;
})();
return cljs.core.async.ioc_alts_BANG_(state_40667__$1,(22),inst_40615);
} else {
if((state_val_40668 === (31))){
var inst_40649 = (state_40667[(2)]);
var state_40667__$1 = state_40667;
if(cljs.core.truth_(inst_40649)){
var statearr_40688_42459 = state_40667__$1;
(statearr_40688_42459[(1)] = (32));

} else {
var statearr_40690_42460 = state_40667__$1;
(statearr_40690_42460[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40668 === (32))){
var inst_40623 = (state_40667[(14)]);
var state_40667__$1 = state_40667;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_40667__$1,(35),out,inst_40623);
} else {
if((state_val_40668 === (33))){
var inst_40612 = (state_40667[(12)]);
var inst_40587 = inst_40612;
var state_40667__$1 = (function (){var statearr_40692 = state_40667;
(statearr_40692[(7)] = inst_40587);

return statearr_40692;
})();
var statearr_40693_42463 = state_40667__$1;
(statearr_40693_42463[(2)] = null);

(statearr_40693_42463[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40668 === (13))){
var inst_40587 = (state_40667[(7)]);
var inst_40596 = inst_40587.cljs$lang$protocol_mask$partition0$;
var inst_40597 = (inst_40596 & (64));
var inst_40598 = inst_40587.cljs$core$ISeq$;
var inst_40599 = (cljs.core.PROTOCOL_SENTINEL === inst_40598);
var inst_40600 = ((inst_40597) || (inst_40599));
var state_40667__$1 = state_40667;
if(cljs.core.truth_(inst_40600)){
var statearr_40694_42464 = state_40667__$1;
(statearr_40694_42464[(1)] = (16));

} else {
var statearr_40695_42467 = state_40667__$1;
(statearr_40695_42467[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40668 === (22))){
var inst_40624 = (state_40667[(9)]);
var inst_40623 = (state_40667[(14)]);
var inst_40622 = (state_40667[(2)]);
var inst_40623__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40622,(0),null);
var inst_40624__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40622,(1),null);
var inst_40625 = (inst_40623__$1 == null);
var inst_40626 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_40624__$1,change);
var inst_40627 = ((inst_40625) || (inst_40626));
var state_40667__$1 = (function (){var statearr_40696 = state_40667;
(statearr_40696[(9)] = inst_40624__$1);

(statearr_40696[(14)] = inst_40623__$1);

return statearr_40696;
})();
if(cljs.core.truth_(inst_40627)){
var statearr_40697_42468 = state_40667__$1;
(statearr_40697_42468[(1)] = (23));

} else {
var statearr_40698_42470 = state_40667__$1;
(statearr_40698_42470[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40668 === (36))){
var inst_40612 = (state_40667[(12)]);
var inst_40587 = inst_40612;
var state_40667__$1 = (function (){var statearr_40700 = state_40667;
(statearr_40700[(7)] = inst_40587);

return statearr_40700;
})();
var statearr_40701_42471 = state_40667__$1;
(statearr_40701_42471[(2)] = null);

(statearr_40701_42471[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40668 === (29))){
var inst_40638 = (state_40667[(10)]);
var state_40667__$1 = state_40667;
var statearr_40702_42472 = state_40667__$1;
(statearr_40702_42472[(2)] = inst_40638);

(statearr_40702_42472[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40668 === (6))){
var state_40667__$1 = state_40667;
var statearr_40703_42475 = state_40667__$1;
(statearr_40703_42475[(2)] = false);

(statearr_40703_42475[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40668 === (28))){
var inst_40634 = (state_40667[(2)]);
var inst_40635 = calc_state();
var inst_40587 = inst_40635;
var state_40667__$1 = (function (){var statearr_40704 = state_40667;
(statearr_40704[(7)] = inst_40587);

(statearr_40704[(15)] = inst_40634);

return statearr_40704;
})();
var statearr_40705_42478 = state_40667__$1;
(statearr_40705_42478[(2)] = null);

(statearr_40705_42478[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40668 === (25))){
var inst_40663 = (state_40667[(2)]);
var state_40667__$1 = state_40667;
var statearr_40707_42479 = state_40667__$1;
(statearr_40707_42479[(2)] = inst_40663);

(statearr_40707_42479[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40668 === (34))){
var inst_40661 = (state_40667[(2)]);
var state_40667__$1 = state_40667;
var statearr_40709_42481 = state_40667__$1;
(statearr_40709_42481[(2)] = inst_40661);

(statearr_40709_42481[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40668 === (17))){
var state_40667__$1 = state_40667;
var statearr_40711_42482 = state_40667__$1;
(statearr_40711_42482[(2)] = false);

(statearr_40711_42482[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40668 === (3))){
var state_40667__$1 = state_40667;
var statearr_40712_42484 = state_40667__$1;
(statearr_40712_42484[(2)] = false);

(statearr_40712_42484[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40668 === (12))){
var inst_40665 = (state_40667[(2)]);
var state_40667__$1 = state_40667;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40667__$1,inst_40665);
} else {
if((state_val_40668 === (2))){
var inst_40561 = (state_40667[(8)]);
var inst_40566 = inst_40561.cljs$lang$protocol_mask$partition0$;
var inst_40567 = (inst_40566 & (64));
var inst_40568 = inst_40561.cljs$core$ISeq$;
var inst_40569 = (cljs.core.PROTOCOL_SENTINEL === inst_40568);
var inst_40570 = ((inst_40567) || (inst_40569));
var state_40667__$1 = state_40667;
if(cljs.core.truth_(inst_40570)){
var statearr_40714_42488 = state_40667__$1;
(statearr_40714_42488[(1)] = (5));

} else {
var statearr_40715_42489 = state_40667__$1;
(statearr_40715_42489[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40668 === (23))){
var inst_40623 = (state_40667[(14)]);
var inst_40629 = (inst_40623 == null);
var state_40667__$1 = state_40667;
if(cljs.core.truth_(inst_40629)){
var statearr_40716_42490 = state_40667__$1;
(statearr_40716_42490[(1)] = (26));

} else {
var statearr_40717_42492 = state_40667__$1;
(statearr_40717_42492[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40668 === (35))){
var inst_40652 = (state_40667[(2)]);
var state_40667__$1 = state_40667;
if(cljs.core.truth_(inst_40652)){
var statearr_40718_42493 = state_40667__$1;
(statearr_40718_42493[(1)] = (36));

} else {
var statearr_40719_42494 = state_40667__$1;
(statearr_40719_42494[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40668 === (19))){
var inst_40587 = (state_40667[(7)]);
var inst_40609 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_40587);
var state_40667__$1 = state_40667;
var statearr_40720_42497 = state_40667__$1;
(statearr_40720_42497[(2)] = inst_40609);

(statearr_40720_42497[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40668 === (11))){
var inst_40587 = (state_40667[(7)]);
var inst_40591 = (inst_40587 == null);
var inst_40592 = cljs.core.not(inst_40591);
var state_40667__$1 = state_40667;
if(inst_40592){
var statearr_40721_42500 = state_40667__$1;
(statearr_40721_42500[(1)] = (13));

} else {
var statearr_40722_42501 = state_40667__$1;
(statearr_40722_42501[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40668 === (9))){
var inst_40561 = (state_40667[(8)]);
var state_40667__$1 = state_40667;
var statearr_40723_42502 = state_40667__$1;
(statearr_40723_42502[(2)] = inst_40561);

(statearr_40723_42502[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40668 === (5))){
var state_40667__$1 = state_40667;
var statearr_40724_42504 = state_40667__$1;
(statearr_40724_42504[(2)] = true);

(statearr_40724_42504[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40668 === (14))){
var state_40667__$1 = state_40667;
var statearr_40726_42505 = state_40667__$1;
(statearr_40726_42505[(2)] = false);

(statearr_40726_42505[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40668 === (26))){
var inst_40624 = (state_40667[(9)]);
var inst_40631 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_40624);
var state_40667__$1 = state_40667;
var statearr_40727_42508 = state_40667__$1;
(statearr_40727_42508[(2)] = inst_40631);

(statearr_40727_42508[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40668 === (16))){
var state_40667__$1 = state_40667;
var statearr_40729_42509 = state_40667__$1;
(statearr_40729_42509[(2)] = true);

(statearr_40729_42509[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40668 === (38))){
var inst_40657 = (state_40667[(2)]);
var state_40667__$1 = state_40667;
var statearr_40731_42512 = state_40667__$1;
(statearr_40731_42512[(2)] = inst_40657);

(statearr_40731_42512[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40668 === (30))){
var inst_40624 = (state_40667[(9)]);
var inst_40613 = (state_40667[(11)]);
var inst_40614 = (state_40667[(13)]);
var inst_40642 = cljs.core.empty_QMARK_(inst_40613);
var inst_40643 = (inst_40614.cljs$core$IFn$_invoke$arity$1 ? inst_40614.cljs$core$IFn$_invoke$arity$1(inst_40624) : inst_40614.call(null,inst_40624));
var inst_40644 = cljs.core.not(inst_40643);
var inst_40646 = ((inst_40642) && (inst_40644));
var state_40667__$1 = state_40667;
var statearr_40734_42514 = state_40667__$1;
(statearr_40734_42514[(2)] = inst_40646);

(statearr_40734_42514[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40668 === (10))){
var inst_40561 = (state_40667[(8)]);
var inst_40582 = (state_40667[(2)]);
var inst_40583 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40582,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_40585 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40582,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_40586 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40582,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_40587 = inst_40561;
var state_40667__$1 = (function (){var statearr_40736 = state_40667;
(statearr_40736[(7)] = inst_40587);

(statearr_40736[(16)] = inst_40583);

(statearr_40736[(17)] = inst_40586);

(statearr_40736[(18)] = inst_40585);

return statearr_40736;
})();
var statearr_40737_42519 = state_40667__$1;
(statearr_40737_42519[(2)] = null);

(statearr_40737_42519[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40668 === (18))){
var inst_40604 = (state_40667[(2)]);
var state_40667__$1 = state_40667;
var statearr_40738_42520 = state_40667__$1;
(statearr_40738_42520[(2)] = inst_40604);

(statearr_40738_42520[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40668 === (37))){
var state_40667__$1 = state_40667;
var statearr_40739_42521 = state_40667__$1;
(statearr_40739_42521[(2)] = null);

(statearr_40739_42521[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40668 === (8))){
var inst_40561 = (state_40667[(8)]);
var inst_40579 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_40561);
var state_40667__$1 = state_40667;
var statearr_40740_42523 = state_40667__$1;
(statearr_40740_42523[(2)] = inst_40579);

(statearr_40740_42523[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__39413__auto___42440,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__39111__auto__,c__39413__auto___42440,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__39112__auto__ = null;
var cljs$core$async$mix_$_state_machine__39112__auto____0 = (function (){
var statearr_40744 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40744[(0)] = cljs$core$async$mix_$_state_machine__39112__auto__);

(statearr_40744[(1)] = (1));

return statearr_40744;
});
var cljs$core$async$mix_$_state_machine__39112__auto____1 = (function (state_40667){
while(true){
var ret_value__39113__auto__ = (function (){try{while(true){
var result__39114__auto__ = switch__39111__auto__(state_40667);
if(cljs.core.keyword_identical_QMARK_(result__39114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__39114__auto__;
}
break;
}
}catch (e40745){if((e40745 instanceof Object)){
var ex__39115__auto__ = e40745;
var statearr_40747_42528 = state_40667;
(statearr_40747_42528[(5)] = ex__39115__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_40667);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e40745;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__39113__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42529 = state_40667;
state_40667 = G__42529;
continue;
} else {
return ret_value__39113__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__39112__auto__ = function(state_40667){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__39112__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__39112__auto____1.call(this,state_40667);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__39112__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__39112__auto____0;
cljs$core$async$mix_$_state_machine__39112__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__39112__auto____1;
return cljs$core$async$mix_$_state_machine__39112__auto__;
})()
;})(switch__39111__auto__,c__39413__auto___42440,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__39415__auto__ = (function (){var statearr_40748 = (f__39414__auto__.cljs$core$IFn$_invoke$arity$0 ? f__39414__auto__.cljs$core$IFn$_invoke$arity$0() : f__39414__auto__.call(null));
(statearr_40748[(6)] = c__39413__auto___42440);

return statearr_40748;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__39415__auto__);
});})(c__39413__auto___42440,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4434__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4431__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4431__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4434__auto__.call(null,p,v,ch));
} else {
var m__4431__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4431__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__40766 = arguments.length;
switch (G__40766) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4434__auto__.call(null,p));
} else {
var m__4431__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4431__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4434__auto__.call(null,p,v));
} else {
var m__4431__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4431__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__40777 = arguments.length;
switch (G__40777) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__4131__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,((function (or__4131__auto__,mults){
return (function (p1__40775_SHARP_){
if(cljs.core.truth_((p1__40775_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__40775_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__40775_SHARP_.call(null,topic)))){
return p1__40775_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__40775_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
});})(or__4131__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async40787 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async40787 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta40788){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta40788 = meta40788;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async40787.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_40789,meta40788__$1){
var self__ = this;
var _40789__$1 = this;
return (new cljs.core.async.t_cljs$core$async40787(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta40788__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async40787.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_40789){
var self__ = this;
var _40789__$1 = this;
return self__.meta40788;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async40787.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async40787.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async40787.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async40787.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async40787.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5735__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5735__auto__)){
var m = temp__5735__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async40787.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async40787.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async40787.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta40788","meta40788",-489456144,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async40787.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async40787.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async40787";

cljs.core.async.t_cljs$core$async40787.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core.async/t_cljs$core$async40787");
});})(mults,ensure_mult))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async40787.
 */
cljs.core.async.__GT_t_cljs$core$async40787 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async40787(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta40788){
return (new cljs.core.async.t_cljs$core$async40787(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta40788));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async40787(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__39413__auto___42558 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__39413__auto___42558,mults,ensure_mult,p){
return (function (){
var f__39414__auto__ = (function (){var switch__39111__auto__ = ((function (c__39413__auto___42558,mults,ensure_mult,p){
return (function (state_40886){
var state_val_40887 = (state_40886[(1)]);
if((state_val_40887 === (7))){
var inst_40881 = (state_40886[(2)]);
var state_40886__$1 = state_40886;
var statearr_40889_42563 = state_40886__$1;
(statearr_40889_42563[(2)] = inst_40881);

(statearr_40889_42563[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40887 === (20))){
var state_40886__$1 = state_40886;
var statearr_40892_42564 = state_40886__$1;
(statearr_40892_42564[(2)] = null);

(statearr_40892_42564[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40887 === (1))){
var state_40886__$1 = state_40886;
var statearr_40893_42565 = state_40886__$1;
(statearr_40893_42565[(2)] = null);

(statearr_40893_42565[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40887 === (24))){
var inst_40863 = (state_40886[(7)]);
var inst_40873 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_40863);
var state_40886__$1 = state_40886;
var statearr_40894_42567 = state_40886__$1;
(statearr_40894_42567[(2)] = inst_40873);

(statearr_40894_42567[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40887 === (4))){
var inst_40812 = (state_40886[(8)]);
var inst_40812__$1 = (state_40886[(2)]);
var inst_40813 = (inst_40812__$1 == null);
var state_40886__$1 = (function (){var statearr_40896 = state_40886;
(statearr_40896[(8)] = inst_40812__$1);

return statearr_40896;
})();
if(cljs.core.truth_(inst_40813)){
var statearr_40902_42570 = state_40886__$1;
(statearr_40902_42570[(1)] = (5));

} else {
var statearr_40909_42571 = state_40886__$1;
(statearr_40909_42571[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40887 === (15))){
var inst_40857 = (state_40886[(2)]);
var state_40886__$1 = state_40886;
var statearr_40911_42573 = state_40886__$1;
(statearr_40911_42573[(2)] = inst_40857);

(statearr_40911_42573[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40887 === (21))){
var inst_40878 = (state_40886[(2)]);
var state_40886__$1 = (function (){var statearr_40912 = state_40886;
(statearr_40912[(9)] = inst_40878);

return statearr_40912;
})();
var statearr_40916_42575 = state_40886__$1;
(statearr_40916_42575[(2)] = null);

(statearr_40916_42575[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40887 === (13))){
var inst_40837 = (state_40886[(10)]);
var inst_40841 = cljs.core.chunked_seq_QMARK_(inst_40837);
var state_40886__$1 = state_40886;
if(inst_40841){
var statearr_40921_42576 = state_40886__$1;
(statearr_40921_42576[(1)] = (16));

} else {
var statearr_40925_42578 = state_40886__$1;
(statearr_40925_42578[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40887 === (22))){
var inst_40870 = (state_40886[(2)]);
var state_40886__$1 = state_40886;
if(cljs.core.truth_(inst_40870)){
var statearr_40932_42579 = state_40886__$1;
(statearr_40932_42579[(1)] = (23));

} else {
var statearr_40933_42580 = state_40886__$1;
(statearr_40933_42580[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40887 === (6))){
var inst_40865 = (state_40886[(11)]);
var inst_40812 = (state_40886[(8)]);
var inst_40863 = (state_40886[(7)]);
var inst_40863__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_40812) : topic_fn.call(null,inst_40812));
var inst_40864 = cljs.core.deref(mults);
var inst_40865__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40864,inst_40863__$1);
var state_40886__$1 = (function (){var statearr_40944 = state_40886;
(statearr_40944[(11)] = inst_40865__$1);

(statearr_40944[(7)] = inst_40863__$1);

return statearr_40944;
})();
if(cljs.core.truth_(inst_40865__$1)){
var statearr_40945_42583 = state_40886__$1;
(statearr_40945_42583[(1)] = (19));

} else {
var statearr_40946_42584 = state_40886__$1;
(statearr_40946_42584[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40887 === (25))){
var inst_40875 = (state_40886[(2)]);
var state_40886__$1 = state_40886;
var statearr_40952_42585 = state_40886__$1;
(statearr_40952_42585[(2)] = inst_40875);

(statearr_40952_42585[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40887 === (17))){
var inst_40837 = (state_40886[(10)]);
var inst_40848 = cljs.core.first(inst_40837);
var inst_40849 = cljs.core.async.muxch_STAR_(inst_40848);
var inst_40850 = cljs.core.async.close_BANG_(inst_40849);
var inst_40851 = cljs.core.next(inst_40837);
var inst_40823 = inst_40851;
var inst_40824 = null;
var inst_40825 = (0);
var inst_40826 = (0);
var state_40886__$1 = (function (){var statearr_40958 = state_40886;
(statearr_40958[(12)] = inst_40826);

(statearr_40958[(13)] = inst_40824);

(statearr_40958[(14)] = inst_40823);

(statearr_40958[(15)] = inst_40850);

(statearr_40958[(16)] = inst_40825);

return statearr_40958;
})();
var statearr_40962_42588 = state_40886__$1;
(statearr_40962_42588[(2)] = null);

(statearr_40962_42588[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40887 === (3))){
var inst_40883 = (state_40886[(2)]);
var state_40886__$1 = state_40886;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40886__$1,inst_40883);
} else {
if((state_val_40887 === (12))){
var inst_40859 = (state_40886[(2)]);
var state_40886__$1 = state_40886;
var statearr_40967_42590 = state_40886__$1;
(statearr_40967_42590[(2)] = inst_40859);

(statearr_40967_42590[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40887 === (2))){
var state_40886__$1 = state_40886;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40886__$1,(4),ch);
} else {
if((state_val_40887 === (23))){
var state_40886__$1 = state_40886;
var statearr_40971_42592 = state_40886__$1;
(statearr_40971_42592[(2)] = null);

(statearr_40971_42592[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40887 === (19))){
var inst_40865 = (state_40886[(11)]);
var inst_40812 = (state_40886[(8)]);
var inst_40868 = cljs.core.async.muxch_STAR_(inst_40865);
var state_40886__$1 = state_40886;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_40886__$1,(22),inst_40868,inst_40812);
} else {
if((state_val_40887 === (11))){
var inst_40837 = (state_40886[(10)]);
var inst_40823 = (state_40886[(14)]);
var inst_40837__$1 = cljs.core.seq(inst_40823);
var state_40886__$1 = (function (){var statearr_40973 = state_40886;
(statearr_40973[(10)] = inst_40837__$1);

return statearr_40973;
})();
if(inst_40837__$1){
var statearr_40974_42596 = state_40886__$1;
(statearr_40974_42596[(1)] = (13));

} else {
var statearr_40975_42597 = state_40886__$1;
(statearr_40975_42597[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40887 === (9))){
var inst_40861 = (state_40886[(2)]);
var state_40886__$1 = state_40886;
var statearr_40976_42598 = state_40886__$1;
(statearr_40976_42598[(2)] = inst_40861);

(statearr_40976_42598[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40887 === (5))){
var inst_40820 = cljs.core.deref(mults);
var inst_40821 = cljs.core.vals(inst_40820);
var inst_40822 = cljs.core.seq(inst_40821);
var inst_40823 = inst_40822;
var inst_40824 = null;
var inst_40825 = (0);
var inst_40826 = (0);
var state_40886__$1 = (function (){var statearr_40977 = state_40886;
(statearr_40977[(12)] = inst_40826);

(statearr_40977[(13)] = inst_40824);

(statearr_40977[(14)] = inst_40823);

(statearr_40977[(16)] = inst_40825);

return statearr_40977;
})();
var statearr_40979_42600 = state_40886__$1;
(statearr_40979_42600[(2)] = null);

(statearr_40979_42600[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40887 === (14))){
var state_40886__$1 = state_40886;
var statearr_40983_42601 = state_40886__$1;
(statearr_40983_42601[(2)] = null);

(statearr_40983_42601[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40887 === (16))){
var inst_40837 = (state_40886[(10)]);
var inst_40843 = cljs.core.chunk_first(inst_40837);
var inst_40844 = cljs.core.chunk_rest(inst_40837);
var inst_40845 = cljs.core.count(inst_40843);
var inst_40823 = inst_40844;
var inst_40824 = inst_40843;
var inst_40825 = inst_40845;
var inst_40826 = (0);
var state_40886__$1 = (function (){var statearr_40984 = state_40886;
(statearr_40984[(12)] = inst_40826);

(statearr_40984[(13)] = inst_40824);

(statearr_40984[(14)] = inst_40823);

(statearr_40984[(16)] = inst_40825);

return statearr_40984;
})();
var statearr_40985_42606 = state_40886__$1;
(statearr_40985_42606[(2)] = null);

(statearr_40985_42606[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40887 === (10))){
var inst_40826 = (state_40886[(12)]);
var inst_40824 = (state_40886[(13)]);
var inst_40823 = (state_40886[(14)]);
var inst_40825 = (state_40886[(16)]);
var inst_40831 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_40824,inst_40826);
var inst_40832 = cljs.core.async.muxch_STAR_(inst_40831);
var inst_40833 = cljs.core.async.close_BANG_(inst_40832);
var inst_40834 = (inst_40826 + (1));
var tmp40980 = inst_40824;
var tmp40981 = inst_40823;
var tmp40982 = inst_40825;
var inst_40823__$1 = tmp40981;
var inst_40824__$1 = tmp40980;
var inst_40825__$1 = tmp40982;
var inst_40826__$1 = inst_40834;
var state_40886__$1 = (function (){var statearr_40986 = state_40886;
(statearr_40986[(17)] = inst_40833);

(statearr_40986[(12)] = inst_40826__$1);

(statearr_40986[(13)] = inst_40824__$1);

(statearr_40986[(14)] = inst_40823__$1);

(statearr_40986[(16)] = inst_40825__$1);

return statearr_40986;
})();
var statearr_40987_42608 = state_40886__$1;
(statearr_40987_42608[(2)] = null);

(statearr_40987_42608[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40887 === (18))){
var inst_40854 = (state_40886[(2)]);
var state_40886__$1 = state_40886;
var statearr_40989_42609 = state_40886__$1;
(statearr_40989_42609[(2)] = inst_40854);

(statearr_40989_42609[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40887 === (8))){
var inst_40826 = (state_40886[(12)]);
var inst_40825 = (state_40886[(16)]);
var inst_40828 = (inst_40826 < inst_40825);
var inst_40829 = inst_40828;
var state_40886__$1 = state_40886;
if(cljs.core.truth_(inst_40829)){
var statearr_40992_42610 = state_40886__$1;
(statearr_40992_42610[(1)] = (10));

} else {
var statearr_40993_42612 = state_40886__$1;
(statearr_40993_42612[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__39413__auto___42558,mults,ensure_mult,p))
;
return ((function (switch__39111__auto__,c__39413__auto___42558,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__39112__auto__ = null;
var cljs$core$async$state_machine__39112__auto____0 = (function (){
var statearr_40995 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40995[(0)] = cljs$core$async$state_machine__39112__auto__);

(statearr_40995[(1)] = (1));

return statearr_40995;
});
var cljs$core$async$state_machine__39112__auto____1 = (function (state_40886){
while(true){
var ret_value__39113__auto__ = (function (){try{while(true){
var result__39114__auto__ = switch__39111__auto__(state_40886);
if(cljs.core.keyword_identical_QMARK_(result__39114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__39114__auto__;
}
break;
}
}catch (e40996){if((e40996 instanceof Object)){
var ex__39115__auto__ = e40996;
var statearr_40997_42616 = state_40886;
(statearr_40997_42616[(5)] = ex__39115__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_40886);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e40996;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__39113__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42617 = state_40886;
state_40886 = G__42617;
continue;
} else {
return ret_value__39113__auto__;
}
break;
}
});
cljs$core$async$state_machine__39112__auto__ = function(state_40886){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__39112__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__39112__auto____1.call(this,state_40886);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__39112__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__39112__auto____0;
cljs$core$async$state_machine__39112__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__39112__auto____1;
return cljs$core$async$state_machine__39112__auto__;
})()
;})(switch__39111__auto__,c__39413__auto___42558,mults,ensure_mult,p))
})();
var state__39415__auto__ = (function (){var statearr_40998 = (f__39414__auto__.cljs$core$IFn$_invoke$arity$0 ? f__39414__auto__.cljs$core$IFn$_invoke$arity$0() : f__39414__auto__.call(null));
(statearr_40998[(6)] = c__39413__auto___42558);

return statearr_40998;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__39415__auto__);
});})(c__39413__auto___42558,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__41006 = arguments.length;
switch (G__41006) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__41012 = arguments.length;
switch (G__41012) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__41019 = arguments.length;
switch (G__41019) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__39413__auto___42632 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__39413__auto___42632,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__39414__auto__ = (function (){var switch__39111__auto__ = ((function (c__39413__auto___42632,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_41070){
var state_val_41071 = (state_41070[(1)]);
if((state_val_41071 === (7))){
var state_41070__$1 = state_41070;
var statearr_41077_42635 = state_41070__$1;
(statearr_41077_42635[(2)] = null);

(statearr_41077_42635[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41071 === (1))){
var state_41070__$1 = state_41070;
var statearr_41078_42638 = state_41070__$1;
(statearr_41078_42638[(2)] = null);

(statearr_41078_42638[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41071 === (4))){
var inst_41025 = (state_41070[(7)]);
var inst_41027 = (inst_41025 < cnt);
var state_41070__$1 = state_41070;
if(cljs.core.truth_(inst_41027)){
var statearr_41079_42639 = state_41070__$1;
(statearr_41079_42639[(1)] = (6));

} else {
var statearr_41080_42640 = state_41070__$1;
(statearr_41080_42640[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41071 === (15))){
var inst_41064 = (state_41070[(2)]);
var state_41070__$1 = state_41070;
var statearr_41081_42642 = state_41070__$1;
(statearr_41081_42642[(2)] = inst_41064);

(statearr_41081_42642[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41071 === (13))){
var inst_41057 = cljs.core.async.close_BANG_(out);
var state_41070__$1 = state_41070;
var statearr_41086_42643 = state_41070__$1;
(statearr_41086_42643[(2)] = inst_41057);

(statearr_41086_42643[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41071 === (6))){
var state_41070__$1 = state_41070;
var statearr_41087_42646 = state_41070__$1;
(statearr_41087_42646[(2)] = null);

(statearr_41087_42646[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41071 === (3))){
var inst_41066 = (state_41070[(2)]);
var state_41070__$1 = state_41070;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41070__$1,inst_41066);
} else {
if((state_val_41071 === (12))){
var inst_41054 = (state_41070[(8)]);
var inst_41054__$1 = (state_41070[(2)]);
var inst_41055 = cljs.core.some(cljs.core.nil_QMARK_,inst_41054__$1);
var state_41070__$1 = (function (){var statearr_41092 = state_41070;
(statearr_41092[(8)] = inst_41054__$1);

return statearr_41092;
})();
if(cljs.core.truth_(inst_41055)){
var statearr_41093_42649 = state_41070__$1;
(statearr_41093_42649[(1)] = (13));

} else {
var statearr_41094_42650 = state_41070__$1;
(statearr_41094_42650[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41071 === (2))){
var inst_41024 = cljs.core.reset_BANG_(dctr,cnt);
var inst_41025 = (0);
var state_41070__$1 = (function (){var statearr_41095 = state_41070;
(statearr_41095[(7)] = inst_41025);

(statearr_41095[(9)] = inst_41024);

return statearr_41095;
})();
var statearr_41096_42652 = state_41070__$1;
(statearr_41096_42652[(2)] = null);

(statearr_41096_42652[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41071 === (11))){
var inst_41025 = (state_41070[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_41070,(10),Object,null,(9));
var inst_41040 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_41025) : chs__$1.call(null,inst_41025));
var inst_41041 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_41025) : done.call(null,inst_41025));
var inst_41042 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_41040,inst_41041);
var state_41070__$1 = state_41070;
var statearr_41097_42657 = state_41070__$1;
(statearr_41097_42657[(2)] = inst_41042);


cljs.core.async.impl.ioc_helpers.process_exception(state_41070__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41071 === (9))){
var inst_41025 = (state_41070[(7)]);
var inst_41044 = (state_41070[(2)]);
var inst_41045 = (inst_41025 + (1));
var inst_41025__$1 = inst_41045;
var state_41070__$1 = (function (){var statearr_41098 = state_41070;
(statearr_41098[(7)] = inst_41025__$1);

(statearr_41098[(10)] = inst_41044);

return statearr_41098;
})();
var statearr_41099_42659 = state_41070__$1;
(statearr_41099_42659[(2)] = null);

(statearr_41099_42659[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41071 === (5))){
var inst_41052 = (state_41070[(2)]);
var state_41070__$1 = (function (){var statearr_41102 = state_41070;
(statearr_41102[(11)] = inst_41052);

return statearr_41102;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41070__$1,(12),dchan);
} else {
if((state_val_41071 === (14))){
var inst_41054 = (state_41070[(8)]);
var inst_41059 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_41054);
var state_41070__$1 = state_41070;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_41070__$1,(16),out,inst_41059);
} else {
if((state_val_41071 === (16))){
var inst_41061 = (state_41070[(2)]);
var state_41070__$1 = (function (){var statearr_41105 = state_41070;
(statearr_41105[(12)] = inst_41061);

return statearr_41105;
})();
var statearr_41106_42664 = state_41070__$1;
(statearr_41106_42664[(2)] = null);

(statearr_41106_42664[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41071 === (10))){
var inst_41033 = (state_41070[(2)]);
var inst_41034 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_41070__$1 = (function (){var statearr_41107 = state_41070;
(statearr_41107[(13)] = inst_41033);

return statearr_41107;
})();
var statearr_41109_42665 = state_41070__$1;
(statearr_41109_42665[(2)] = inst_41034);


cljs.core.async.impl.ioc_helpers.process_exception(state_41070__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41071 === (8))){
var inst_41050 = (state_41070[(2)]);
var state_41070__$1 = state_41070;
var statearr_41110_42667 = state_41070__$1;
(statearr_41110_42667[(2)] = inst_41050);

(statearr_41110_42667[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__39413__auto___42632,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__39111__auto__,c__39413__auto___42632,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__39112__auto__ = null;
var cljs$core$async$state_machine__39112__auto____0 = (function (){
var statearr_41111 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_41111[(0)] = cljs$core$async$state_machine__39112__auto__);

(statearr_41111[(1)] = (1));

return statearr_41111;
});
var cljs$core$async$state_machine__39112__auto____1 = (function (state_41070){
while(true){
var ret_value__39113__auto__ = (function (){try{while(true){
var result__39114__auto__ = switch__39111__auto__(state_41070);
if(cljs.core.keyword_identical_QMARK_(result__39114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__39114__auto__;
}
break;
}
}catch (e41115){if((e41115 instanceof Object)){
var ex__39115__auto__ = e41115;
var statearr_41116_42672 = state_41070;
(statearr_41116_42672[(5)] = ex__39115__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_41070);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e41115;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__39113__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42673 = state_41070;
state_41070 = G__42673;
continue;
} else {
return ret_value__39113__auto__;
}
break;
}
});
cljs$core$async$state_machine__39112__auto__ = function(state_41070){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__39112__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__39112__auto____1.call(this,state_41070);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__39112__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__39112__auto____0;
cljs$core$async$state_machine__39112__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__39112__auto____1;
return cljs$core$async$state_machine__39112__auto__;
})()
;})(switch__39111__auto__,c__39413__auto___42632,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__39415__auto__ = (function (){var statearr_41117 = (f__39414__auto__.cljs$core$IFn$_invoke$arity$0 ? f__39414__auto__.cljs$core$IFn$_invoke$arity$0() : f__39414__auto__.call(null));
(statearr_41117[(6)] = c__39413__auto___42632);

return statearr_41117;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__39415__auto__);
});})(c__39413__auto___42632,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__41125 = arguments.length;
switch (G__41125) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__39413__auto___42680 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__39413__auto___42680,out){
return (function (){
var f__39414__auto__ = (function (){var switch__39111__auto__ = ((function (c__39413__auto___42680,out){
return (function (state_41164){
var state_val_41165 = (state_41164[(1)]);
if((state_val_41165 === (7))){
var inst_41142 = (state_41164[(7)]);
var inst_41141 = (state_41164[(8)]);
var inst_41141__$1 = (state_41164[(2)]);
var inst_41142__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41141__$1,(0),null);
var inst_41143 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41141__$1,(1),null);
var inst_41144 = (inst_41142__$1 == null);
var state_41164__$1 = (function (){var statearr_41173 = state_41164;
(statearr_41173[(9)] = inst_41143);

(statearr_41173[(7)] = inst_41142__$1);

(statearr_41173[(8)] = inst_41141__$1);

return statearr_41173;
})();
if(cljs.core.truth_(inst_41144)){
var statearr_41174_42683 = state_41164__$1;
(statearr_41174_42683[(1)] = (8));

} else {
var statearr_41175_42685 = state_41164__$1;
(statearr_41175_42685[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41165 === (1))){
var inst_41127 = cljs.core.vec(chs);
var inst_41128 = inst_41127;
var state_41164__$1 = (function (){var statearr_41176 = state_41164;
(statearr_41176[(10)] = inst_41128);

return statearr_41176;
})();
var statearr_41177_42688 = state_41164__$1;
(statearr_41177_42688[(2)] = null);

(statearr_41177_42688[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41165 === (4))){
var inst_41128 = (state_41164[(10)]);
var state_41164__$1 = state_41164;
return cljs.core.async.ioc_alts_BANG_(state_41164__$1,(7),inst_41128);
} else {
if((state_val_41165 === (6))){
var inst_41160 = (state_41164[(2)]);
var state_41164__$1 = state_41164;
var statearr_41180_42689 = state_41164__$1;
(statearr_41180_42689[(2)] = inst_41160);

(statearr_41180_42689[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41165 === (3))){
var inst_41162 = (state_41164[(2)]);
var state_41164__$1 = state_41164;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41164__$1,inst_41162);
} else {
if((state_val_41165 === (2))){
var inst_41128 = (state_41164[(10)]);
var inst_41133 = cljs.core.count(inst_41128);
var inst_41134 = (inst_41133 > (0));
var state_41164__$1 = state_41164;
if(cljs.core.truth_(inst_41134)){
var statearr_41184_42691 = state_41164__$1;
(statearr_41184_42691[(1)] = (4));

} else {
var statearr_41185_42693 = state_41164__$1;
(statearr_41185_42693[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41165 === (11))){
var inst_41128 = (state_41164[(10)]);
var inst_41153 = (state_41164[(2)]);
var tmp41183 = inst_41128;
var inst_41128__$1 = tmp41183;
var state_41164__$1 = (function (){var statearr_41186 = state_41164;
(statearr_41186[(11)] = inst_41153);

(statearr_41186[(10)] = inst_41128__$1);

return statearr_41186;
})();
var statearr_41187_42697 = state_41164__$1;
(statearr_41187_42697[(2)] = null);

(statearr_41187_42697[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41165 === (9))){
var inst_41142 = (state_41164[(7)]);
var state_41164__$1 = state_41164;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_41164__$1,(11),out,inst_41142);
} else {
if((state_val_41165 === (5))){
var inst_41158 = cljs.core.async.close_BANG_(out);
var state_41164__$1 = state_41164;
var statearr_41188_42698 = state_41164__$1;
(statearr_41188_42698[(2)] = inst_41158);

(statearr_41188_42698[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41165 === (10))){
var inst_41156 = (state_41164[(2)]);
var state_41164__$1 = state_41164;
var statearr_41189_42700 = state_41164__$1;
(statearr_41189_42700[(2)] = inst_41156);

(statearr_41189_42700[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41165 === (8))){
var inst_41143 = (state_41164[(9)]);
var inst_41142 = (state_41164[(7)]);
var inst_41128 = (state_41164[(10)]);
var inst_41141 = (state_41164[(8)]);
var inst_41148 = (function (){var cs = inst_41128;
var vec__41136 = inst_41141;
var v = inst_41142;
var c = inst_41143;
return ((function (cs,vec__41136,v,c,inst_41143,inst_41142,inst_41128,inst_41141,state_val_41165,c__39413__auto___42680,out){
return (function (p1__41118_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__41118_SHARP_);
});
;})(cs,vec__41136,v,c,inst_41143,inst_41142,inst_41128,inst_41141,state_val_41165,c__39413__auto___42680,out))
})();
var inst_41149 = cljs.core.filterv(inst_41148,inst_41128);
var inst_41128__$1 = inst_41149;
var state_41164__$1 = (function (){var statearr_41192 = state_41164;
(statearr_41192[(10)] = inst_41128__$1);

return statearr_41192;
})();
var statearr_41193_42705 = state_41164__$1;
(statearr_41193_42705[(2)] = null);

(statearr_41193_42705[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__39413__auto___42680,out))
;
return ((function (switch__39111__auto__,c__39413__auto___42680,out){
return (function() {
var cljs$core$async$state_machine__39112__auto__ = null;
var cljs$core$async$state_machine__39112__auto____0 = (function (){
var statearr_41196 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_41196[(0)] = cljs$core$async$state_machine__39112__auto__);

(statearr_41196[(1)] = (1));

return statearr_41196;
});
var cljs$core$async$state_machine__39112__auto____1 = (function (state_41164){
while(true){
var ret_value__39113__auto__ = (function (){try{while(true){
var result__39114__auto__ = switch__39111__auto__(state_41164);
if(cljs.core.keyword_identical_QMARK_(result__39114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__39114__auto__;
}
break;
}
}catch (e41199){if((e41199 instanceof Object)){
var ex__39115__auto__ = e41199;
var statearr_41200_42707 = state_41164;
(statearr_41200_42707[(5)] = ex__39115__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_41164);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e41199;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__39113__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42710 = state_41164;
state_41164 = G__42710;
continue;
} else {
return ret_value__39113__auto__;
}
break;
}
});
cljs$core$async$state_machine__39112__auto__ = function(state_41164){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__39112__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__39112__auto____1.call(this,state_41164);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__39112__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__39112__auto____0;
cljs$core$async$state_machine__39112__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__39112__auto____1;
return cljs$core$async$state_machine__39112__auto__;
})()
;})(switch__39111__auto__,c__39413__auto___42680,out))
})();
var state__39415__auto__ = (function (){var statearr_41203 = (f__39414__auto__.cljs$core$IFn$_invoke$arity$0 ? f__39414__auto__.cljs$core$IFn$_invoke$arity$0() : f__39414__auto__.call(null));
(statearr_41203[(6)] = c__39413__auto___42680);

return statearr_41203;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__39415__auto__);
});})(c__39413__auto___42680,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__41205 = arguments.length;
switch (G__41205) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__39413__auto___42715 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__39413__auto___42715,out){
return (function (){
var f__39414__auto__ = (function (){var switch__39111__auto__ = ((function (c__39413__auto___42715,out){
return (function (state_41234){
var state_val_41235 = (state_41234[(1)]);
if((state_val_41235 === (7))){
var inst_41215 = (state_41234[(7)]);
var inst_41215__$1 = (state_41234[(2)]);
var inst_41216 = (inst_41215__$1 == null);
var inst_41217 = cljs.core.not(inst_41216);
var state_41234__$1 = (function (){var statearr_41238 = state_41234;
(statearr_41238[(7)] = inst_41215__$1);

return statearr_41238;
})();
if(inst_41217){
var statearr_41240_42716 = state_41234__$1;
(statearr_41240_42716[(1)] = (8));

} else {
var statearr_41241_42717 = state_41234__$1;
(statearr_41241_42717[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41235 === (1))){
var inst_41210 = (0);
var state_41234__$1 = (function (){var statearr_41242 = state_41234;
(statearr_41242[(8)] = inst_41210);

return statearr_41242;
})();
var statearr_41243_42720 = state_41234__$1;
(statearr_41243_42720[(2)] = null);

(statearr_41243_42720[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41235 === (4))){
var state_41234__$1 = state_41234;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41234__$1,(7),ch);
} else {
if((state_val_41235 === (6))){
var inst_41229 = (state_41234[(2)]);
var state_41234__$1 = state_41234;
var statearr_41244_42723 = state_41234__$1;
(statearr_41244_42723[(2)] = inst_41229);

(statearr_41244_42723[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41235 === (3))){
var inst_41231 = (state_41234[(2)]);
var inst_41232 = cljs.core.async.close_BANG_(out);
var state_41234__$1 = (function (){var statearr_41247 = state_41234;
(statearr_41247[(9)] = inst_41231);

return statearr_41247;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_41234__$1,inst_41232);
} else {
if((state_val_41235 === (2))){
var inst_41210 = (state_41234[(8)]);
var inst_41212 = (inst_41210 < n);
var state_41234__$1 = state_41234;
if(cljs.core.truth_(inst_41212)){
var statearr_41248_42724 = state_41234__$1;
(statearr_41248_42724[(1)] = (4));

} else {
var statearr_41249_42725 = state_41234__$1;
(statearr_41249_42725[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41235 === (11))){
var inst_41210 = (state_41234[(8)]);
var inst_41220 = (state_41234[(2)]);
var inst_41222 = (inst_41210 + (1));
var inst_41210__$1 = inst_41222;
var state_41234__$1 = (function (){var statearr_41250 = state_41234;
(statearr_41250[(10)] = inst_41220);

(statearr_41250[(8)] = inst_41210__$1);

return statearr_41250;
})();
var statearr_41251_42728 = state_41234__$1;
(statearr_41251_42728[(2)] = null);

(statearr_41251_42728[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41235 === (9))){
var state_41234__$1 = state_41234;
var statearr_41252_42729 = state_41234__$1;
(statearr_41252_42729[(2)] = null);

(statearr_41252_42729[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41235 === (5))){
var state_41234__$1 = state_41234;
var statearr_41256_42730 = state_41234__$1;
(statearr_41256_42730[(2)] = null);

(statearr_41256_42730[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41235 === (10))){
var inst_41226 = (state_41234[(2)]);
var state_41234__$1 = state_41234;
var statearr_41257_42733 = state_41234__$1;
(statearr_41257_42733[(2)] = inst_41226);

(statearr_41257_42733[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41235 === (8))){
var inst_41215 = (state_41234[(7)]);
var state_41234__$1 = state_41234;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_41234__$1,(11),out,inst_41215);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__39413__auto___42715,out))
;
return ((function (switch__39111__auto__,c__39413__auto___42715,out){
return (function() {
var cljs$core$async$state_machine__39112__auto__ = null;
var cljs$core$async$state_machine__39112__auto____0 = (function (){
var statearr_41260 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_41260[(0)] = cljs$core$async$state_machine__39112__auto__);

(statearr_41260[(1)] = (1));

return statearr_41260;
});
var cljs$core$async$state_machine__39112__auto____1 = (function (state_41234){
while(true){
var ret_value__39113__auto__ = (function (){try{while(true){
var result__39114__auto__ = switch__39111__auto__(state_41234);
if(cljs.core.keyword_identical_QMARK_(result__39114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__39114__auto__;
}
break;
}
}catch (e41261){if((e41261 instanceof Object)){
var ex__39115__auto__ = e41261;
var statearr_41263_42737 = state_41234;
(statearr_41263_42737[(5)] = ex__39115__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_41234);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e41261;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__39113__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42738 = state_41234;
state_41234 = G__42738;
continue;
} else {
return ret_value__39113__auto__;
}
break;
}
});
cljs$core$async$state_machine__39112__auto__ = function(state_41234){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__39112__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__39112__auto____1.call(this,state_41234);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__39112__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__39112__auto____0;
cljs$core$async$state_machine__39112__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__39112__auto____1;
return cljs$core$async$state_machine__39112__auto__;
})()
;})(switch__39111__auto__,c__39413__auto___42715,out))
})();
var state__39415__auto__ = (function (){var statearr_41266 = (f__39414__auto__.cljs$core$IFn$_invoke$arity$0 ? f__39414__auto__.cljs$core$IFn$_invoke$arity$0() : f__39414__auto__.call(null));
(statearr_41266[(6)] = c__39413__auto___42715);

return statearr_41266;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__39415__auto__);
});})(c__39413__auto___42715,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async41270 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async41270 = (function (f,ch,meta41271){
this.f = f;
this.ch = ch;
this.meta41271 = meta41271;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async41270.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_41272,meta41271__$1){
var self__ = this;
var _41272__$1 = this;
return (new cljs.core.async.t_cljs$core$async41270(self__.f,self__.ch,meta41271__$1));
});

cljs.core.async.t_cljs$core$async41270.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_41272){
var self__ = this;
var _41272__$1 = this;
return self__.meta41271;
});

cljs.core.async.t_cljs$core$async41270.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async41270.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async41270.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async41270.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async41270.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async41281 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async41281 = (function (f,ch,meta41271,_,fn1,meta41282){
this.f = f;
this.ch = ch;
this.meta41271 = meta41271;
this._ = _;
this.fn1 = fn1;
this.meta41282 = meta41282;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async41281.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_41283,meta41282__$1){
var self__ = this;
var _41283__$1 = this;
return (new cljs.core.async.t_cljs$core$async41281(self__.f,self__.ch,self__.meta41271,self__._,self__.fn1,meta41282__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async41281.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_41283){
var self__ = this;
var _41283__$1 = this;
return self__.meta41282;
});})(___$1))
;

cljs.core.async.t_cljs$core$async41281.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async41281.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async41281.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async41281.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__41269_SHARP_){
var G__41288 = (((p1__41269_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__41269_SHARP_) : self__.f.call(null,p1__41269_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__41288) : f1.call(null,G__41288));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async41281.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta41271","meta41271",-2045191063,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async41270","cljs.core.async/t_cljs$core$async41270",-1478321360,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta41282","meta41282",1329152791,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async41281.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async41281.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async41281";

cljs.core.async.t_cljs$core$async41281.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core.async/t_cljs$core$async41281");
});})(___$1))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async41281.
 */
cljs.core.async.__GT_t_cljs$core$async41281 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async41281(f__$1,ch__$1,meta41271__$1,___$2,fn1__$1,meta41282){
return (new cljs.core.async.t_cljs$core$async41281(f__$1,ch__$1,meta41271__$1,___$2,fn1__$1,meta41282));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async41281(self__.f,self__.ch,self__.meta41271,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4120__auto__ = ret;
if(cljs.core.truth_(and__4120__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4120__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__41296 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__41296) : self__.f.call(null,G__41296));
})());
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async41270.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async41270.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async41270.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta41271","meta41271",-2045191063,null)], null);
});

cljs.core.async.t_cljs$core$async41270.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async41270.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async41270";

cljs.core.async.t_cljs$core$async41270.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core.async/t_cljs$core$async41270");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async41270.
 */
cljs.core.async.__GT_t_cljs$core$async41270 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async41270(f__$1,ch__$1,meta41271){
return (new cljs.core.async.t_cljs$core$async41270(f__$1,ch__$1,meta41271));
});

}

return (new cljs.core.async.t_cljs$core$async41270(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async41306 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async41306 = (function (f,ch,meta41307){
this.f = f;
this.ch = ch;
this.meta41307 = meta41307;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async41306.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_41308,meta41307__$1){
var self__ = this;
var _41308__$1 = this;
return (new cljs.core.async.t_cljs$core$async41306(self__.f,self__.ch,meta41307__$1));
});

cljs.core.async.t_cljs$core$async41306.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_41308){
var self__ = this;
var _41308__$1 = this;
return self__.meta41307;
});

cljs.core.async.t_cljs$core$async41306.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async41306.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async41306.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async41306.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async41306.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async41306.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
});

cljs.core.async.t_cljs$core$async41306.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta41307","meta41307",-1516138213,null)], null);
});

cljs.core.async.t_cljs$core$async41306.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async41306.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async41306";

cljs.core.async.t_cljs$core$async41306.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core.async/t_cljs$core$async41306");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async41306.
 */
cljs.core.async.__GT_t_cljs$core$async41306 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async41306(f__$1,ch__$1,meta41307){
return (new cljs.core.async.t_cljs$core$async41306(f__$1,ch__$1,meta41307));
});

}

return (new cljs.core.async.t_cljs$core$async41306(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async41325 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async41325 = (function (p,ch,meta41326){
this.p = p;
this.ch = ch;
this.meta41326 = meta41326;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async41325.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_41327,meta41326__$1){
var self__ = this;
var _41327__$1 = this;
return (new cljs.core.async.t_cljs$core$async41325(self__.p,self__.ch,meta41326__$1));
});

cljs.core.async.t_cljs$core$async41325.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_41327){
var self__ = this;
var _41327__$1 = this;
return self__.meta41326;
});

cljs.core.async.t_cljs$core$async41325.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async41325.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async41325.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async41325.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async41325.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async41325.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async41325.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
});

cljs.core.async.t_cljs$core$async41325.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta41326","meta41326",196469257,null)], null);
});

cljs.core.async.t_cljs$core$async41325.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async41325.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async41325";

cljs.core.async.t_cljs$core$async41325.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core.async/t_cljs$core$async41325");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async41325.
 */
cljs.core.async.__GT_t_cljs$core$async41325 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async41325(p__$1,ch__$1,meta41326){
return (new cljs.core.async.t_cljs$core$async41325(p__$1,ch__$1,meta41326));
});

}

return (new cljs.core.async.t_cljs$core$async41325(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__41357 = arguments.length;
switch (G__41357) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__39413__auto___42764 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__39413__auto___42764,out){
return (function (){
var f__39414__auto__ = (function (){var switch__39111__auto__ = ((function (c__39413__auto___42764,out){
return (function (state_41391){
var state_val_41392 = (state_41391[(1)]);
if((state_val_41392 === (7))){
var inst_41387 = (state_41391[(2)]);
var state_41391__$1 = state_41391;
var statearr_41398_42771 = state_41391__$1;
(statearr_41398_42771[(2)] = inst_41387);

(statearr_41398_42771[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41392 === (1))){
var state_41391__$1 = state_41391;
var statearr_41400_42772 = state_41391__$1;
(statearr_41400_42772[(2)] = null);

(statearr_41400_42772[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41392 === (4))){
var inst_41372 = (state_41391[(7)]);
var inst_41372__$1 = (state_41391[(2)]);
var inst_41373 = (inst_41372__$1 == null);
var state_41391__$1 = (function (){var statearr_41403 = state_41391;
(statearr_41403[(7)] = inst_41372__$1);

return statearr_41403;
})();
if(cljs.core.truth_(inst_41373)){
var statearr_41404_42775 = state_41391__$1;
(statearr_41404_42775[(1)] = (5));

} else {
var statearr_41405_42776 = state_41391__$1;
(statearr_41405_42776[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41392 === (6))){
var inst_41372 = (state_41391[(7)]);
var inst_41377 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_41372) : p.call(null,inst_41372));
var state_41391__$1 = state_41391;
if(cljs.core.truth_(inst_41377)){
var statearr_41408_42777 = state_41391__$1;
(statearr_41408_42777[(1)] = (8));

} else {
var statearr_41409_42779 = state_41391__$1;
(statearr_41409_42779[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41392 === (3))){
var inst_41389 = (state_41391[(2)]);
var state_41391__$1 = state_41391;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41391__$1,inst_41389);
} else {
if((state_val_41392 === (2))){
var state_41391__$1 = state_41391;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41391__$1,(4),ch);
} else {
if((state_val_41392 === (11))){
var inst_41380 = (state_41391[(2)]);
var state_41391__$1 = state_41391;
var statearr_41413_42787 = state_41391__$1;
(statearr_41413_42787[(2)] = inst_41380);

(statearr_41413_42787[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41392 === (9))){
var state_41391__$1 = state_41391;
var statearr_41414_42789 = state_41391__$1;
(statearr_41414_42789[(2)] = null);

(statearr_41414_42789[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41392 === (5))){
var inst_41375 = cljs.core.async.close_BANG_(out);
var state_41391__$1 = state_41391;
var statearr_41415_42790 = state_41391__$1;
(statearr_41415_42790[(2)] = inst_41375);

(statearr_41415_42790[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41392 === (10))){
var inst_41383 = (state_41391[(2)]);
var state_41391__$1 = (function (){var statearr_41418 = state_41391;
(statearr_41418[(8)] = inst_41383);

return statearr_41418;
})();
var statearr_41420_42793 = state_41391__$1;
(statearr_41420_42793[(2)] = null);

(statearr_41420_42793[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41392 === (8))){
var inst_41372 = (state_41391[(7)]);
var state_41391__$1 = state_41391;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_41391__$1,(11),out,inst_41372);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__39413__auto___42764,out))
;
return ((function (switch__39111__auto__,c__39413__auto___42764,out){
return (function() {
var cljs$core$async$state_machine__39112__auto__ = null;
var cljs$core$async$state_machine__39112__auto____0 = (function (){
var statearr_41424 = [null,null,null,null,null,null,null,null,null];
(statearr_41424[(0)] = cljs$core$async$state_machine__39112__auto__);

(statearr_41424[(1)] = (1));

return statearr_41424;
});
var cljs$core$async$state_machine__39112__auto____1 = (function (state_41391){
while(true){
var ret_value__39113__auto__ = (function (){try{while(true){
var result__39114__auto__ = switch__39111__auto__(state_41391);
if(cljs.core.keyword_identical_QMARK_(result__39114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__39114__auto__;
}
break;
}
}catch (e41425){if((e41425 instanceof Object)){
var ex__39115__auto__ = e41425;
var statearr_41430_42798 = state_41391;
(statearr_41430_42798[(5)] = ex__39115__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_41391);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e41425;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__39113__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42799 = state_41391;
state_41391 = G__42799;
continue;
} else {
return ret_value__39113__auto__;
}
break;
}
});
cljs$core$async$state_machine__39112__auto__ = function(state_41391){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__39112__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__39112__auto____1.call(this,state_41391);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__39112__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__39112__auto____0;
cljs$core$async$state_machine__39112__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__39112__auto____1;
return cljs$core$async$state_machine__39112__auto__;
})()
;})(switch__39111__auto__,c__39413__auto___42764,out))
})();
var state__39415__auto__ = (function (){var statearr_41431 = (f__39414__auto__.cljs$core$IFn$_invoke$arity$0 ? f__39414__auto__.cljs$core$IFn$_invoke$arity$0() : f__39414__auto__.call(null));
(statearr_41431[(6)] = c__39413__auto___42764);

return statearr_41431;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__39415__auto__);
});})(c__39413__auto___42764,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__41436 = arguments.length;
switch (G__41436) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__39413__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__39413__auto__){
return (function (){
var f__39414__auto__ = (function (){var switch__39111__auto__ = ((function (c__39413__auto__){
return (function (state_41512){
var state_val_41513 = (state_41512[(1)]);
if((state_val_41513 === (7))){
var inst_41508 = (state_41512[(2)]);
var state_41512__$1 = state_41512;
var statearr_41528_42804 = state_41512__$1;
(statearr_41528_42804[(2)] = inst_41508);

(statearr_41528_42804[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41513 === (20))){
var inst_41476 = (state_41512[(7)]);
var inst_41489 = (state_41512[(2)]);
var inst_41490 = cljs.core.next(inst_41476);
var inst_41461 = inst_41490;
var inst_41462 = null;
var inst_41463 = (0);
var inst_41464 = (0);
var state_41512__$1 = (function (){var statearr_41534 = state_41512;
(statearr_41534[(8)] = inst_41463);

(statearr_41534[(9)] = inst_41464);

(statearr_41534[(10)] = inst_41489);

(statearr_41534[(11)] = inst_41461);

(statearr_41534[(12)] = inst_41462);

return statearr_41534;
})();
var statearr_41537_42808 = state_41512__$1;
(statearr_41537_42808[(2)] = null);

(statearr_41537_42808[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41513 === (1))){
var state_41512__$1 = state_41512;
var statearr_41538_42809 = state_41512__$1;
(statearr_41538_42809[(2)] = null);

(statearr_41538_42809[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41513 === (4))){
var inst_41447 = (state_41512[(13)]);
var inst_41447__$1 = (state_41512[(2)]);
var inst_41448 = (inst_41447__$1 == null);
var state_41512__$1 = (function (){var statearr_41541 = state_41512;
(statearr_41541[(13)] = inst_41447__$1);

return statearr_41541;
})();
if(cljs.core.truth_(inst_41448)){
var statearr_41546_42815 = state_41512__$1;
(statearr_41546_42815[(1)] = (5));

} else {
var statearr_41547_42816 = state_41512__$1;
(statearr_41547_42816[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41513 === (15))){
var state_41512__$1 = state_41512;
var statearr_41553_42817 = state_41512__$1;
(statearr_41553_42817[(2)] = null);

(statearr_41553_42817[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41513 === (21))){
var state_41512__$1 = state_41512;
var statearr_41556_42819 = state_41512__$1;
(statearr_41556_42819[(2)] = null);

(statearr_41556_42819[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41513 === (13))){
var inst_41463 = (state_41512[(8)]);
var inst_41464 = (state_41512[(9)]);
var inst_41461 = (state_41512[(11)]);
var inst_41462 = (state_41512[(12)]);
var inst_41472 = (state_41512[(2)]);
var inst_41473 = (inst_41464 + (1));
var tmp41548 = inst_41463;
var tmp41549 = inst_41461;
var tmp41550 = inst_41462;
var inst_41461__$1 = tmp41549;
var inst_41462__$1 = tmp41550;
var inst_41463__$1 = tmp41548;
var inst_41464__$1 = inst_41473;
var state_41512__$1 = (function (){var statearr_41558 = state_41512;
(statearr_41558[(8)] = inst_41463__$1);

(statearr_41558[(9)] = inst_41464__$1);

(statearr_41558[(11)] = inst_41461__$1);

(statearr_41558[(12)] = inst_41462__$1);

(statearr_41558[(14)] = inst_41472);

return statearr_41558;
})();
var statearr_41563_42824 = state_41512__$1;
(statearr_41563_42824[(2)] = null);

(statearr_41563_42824[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41513 === (22))){
var state_41512__$1 = state_41512;
var statearr_41564_42830 = state_41512__$1;
(statearr_41564_42830[(2)] = null);

(statearr_41564_42830[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41513 === (6))){
var inst_41447 = (state_41512[(13)]);
var inst_41458 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_41447) : f.call(null,inst_41447));
var inst_41459 = cljs.core.seq(inst_41458);
var inst_41461 = inst_41459;
var inst_41462 = null;
var inst_41463 = (0);
var inst_41464 = (0);
var state_41512__$1 = (function (){var statearr_41568 = state_41512;
(statearr_41568[(8)] = inst_41463);

(statearr_41568[(9)] = inst_41464);

(statearr_41568[(11)] = inst_41461);

(statearr_41568[(12)] = inst_41462);

return statearr_41568;
})();
var statearr_41572_42834 = state_41512__$1;
(statearr_41572_42834[(2)] = null);

(statearr_41572_42834[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41513 === (17))){
var inst_41476 = (state_41512[(7)]);
var inst_41482 = cljs.core.chunk_first(inst_41476);
var inst_41483 = cljs.core.chunk_rest(inst_41476);
var inst_41484 = cljs.core.count(inst_41482);
var inst_41461 = inst_41483;
var inst_41462 = inst_41482;
var inst_41463 = inst_41484;
var inst_41464 = (0);
var state_41512__$1 = (function (){var statearr_41574 = state_41512;
(statearr_41574[(8)] = inst_41463);

(statearr_41574[(9)] = inst_41464);

(statearr_41574[(11)] = inst_41461);

(statearr_41574[(12)] = inst_41462);

return statearr_41574;
})();
var statearr_41577_42840 = state_41512__$1;
(statearr_41577_42840[(2)] = null);

(statearr_41577_42840[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41513 === (3))){
var inst_41510 = (state_41512[(2)]);
var state_41512__$1 = state_41512;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41512__$1,inst_41510);
} else {
if((state_val_41513 === (12))){
var inst_41498 = (state_41512[(2)]);
var state_41512__$1 = state_41512;
var statearr_41580_42842 = state_41512__$1;
(statearr_41580_42842[(2)] = inst_41498);

(statearr_41580_42842[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41513 === (2))){
var state_41512__$1 = state_41512;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41512__$1,(4),in$);
} else {
if((state_val_41513 === (23))){
var inst_41506 = (state_41512[(2)]);
var state_41512__$1 = state_41512;
var statearr_41581_42843 = state_41512__$1;
(statearr_41581_42843[(2)] = inst_41506);

(statearr_41581_42843[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41513 === (19))){
var inst_41493 = (state_41512[(2)]);
var state_41512__$1 = state_41512;
var statearr_41583_42844 = state_41512__$1;
(statearr_41583_42844[(2)] = inst_41493);

(statearr_41583_42844[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41513 === (11))){
var inst_41476 = (state_41512[(7)]);
var inst_41461 = (state_41512[(11)]);
var inst_41476__$1 = cljs.core.seq(inst_41461);
var state_41512__$1 = (function (){var statearr_41584 = state_41512;
(statearr_41584[(7)] = inst_41476__$1);

return statearr_41584;
})();
if(inst_41476__$1){
var statearr_41586_42846 = state_41512__$1;
(statearr_41586_42846[(1)] = (14));

} else {
var statearr_41589_42847 = state_41512__$1;
(statearr_41589_42847[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41513 === (9))){
var inst_41500 = (state_41512[(2)]);
var inst_41501 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_41512__$1 = (function (){var statearr_41591 = state_41512;
(statearr_41591[(15)] = inst_41500);

return statearr_41591;
})();
if(cljs.core.truth_(inst_41501)){
var statearr_41594_42851 = state_41512__$1;
(statearr_41594_42851[(1)] = (21));

} else {
var statearr_41595_42852 = state_41512__$1;
(statearr_41595_42852[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41513 === (5))){
var inst_41450 = cljs.core.async.close_BANG_(out);
var state_41512__$1 = state_41512;
var statearr_41596_42853 = state_41512__$1;
(statearr_41596_42853[(2)] = inst_41450);

(statearr_41596_42853[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41513 === (14))){
var inst_41476 = (state_41512[(7)]);
var inst_41480 = cljs.core.chunked_seq_QMARK_(inst_41476);
var state_41512__$1 = state_41512;
if(inst_41480){
var statearr_41597_42854 = state_41512__$1;
(statearr_41597_42854[(1)] = (17));

} else {
var statearr_41600_42855 = state_41512__$1;
(statearr_41600_42855[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41513 === (16))){
var inst_41496 = (state_41512[(2)]);
var state_41512__$1 = state_41512;
var statearr_41601_42856 = state_41512__$1;
(statearr_41601_42856[(2)] = inst_41496);

(statearr_41601_42856[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41513 === (10))){
var inst_41464 = (state_41512[(9)]);
var inst_41462 = (state_41512[(12)]);
var inst_41470 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_41462,inst_41464);
var state_41512__$1 = state_41512;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_41512__$1,(13),out,inst_41470);
} else {
if((state_val_41513 === (18))){
var inst_41476 = (state_41512[(7)]);
var inst_41487 = cljs.core.first(inst_41476);
var state_41512__$1 = state_41512;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_41512__$1,(20),out,inst_41487);
} else {
if((state_val_41513 === (8))){
var inst_41463 = (state_41512[(8)]);
var inst_41464 = (state_41512[(9)]);
var inst_41466 = (inst_41464 < inst_41463);
var inst_41467 = inst_41466;
var state_41512__$1 = state_41512;
if(cljs.core.truth_(inst_41467)){
var statearr_41607_42869 = state_41512__$1;
(statearr_41607_42869[(1)] = (10));

} else {
var statearr_41608_42872 = state_41512__$1;
(statearr_41608_42872[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__39413__auto__))
;
return ((function (switch__39111__auto__,c__39413__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__39112__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__39112__auto____0 = (function (){
var statearr_41612 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_41612[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__39112__auto__);

(statearr_41612[(1)] = (1));

return statearr_41612;
});
var cljs$core$async$mapcat_STAR__$_state_machine__39112__auto____1 = (function (state_41512){
while(true){
var ret_value__39113__auto__ = (function (){try{while(true){
var result__39114__auto__ = switch__39111__auto__(state_41512);
if(cljs.core.keyword_identical_QMARK_(result__39114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__39114__auto__;
}
break;
}
}catch (e41616){if((e41616 instanceof Object)){
var ex__39115__auto__ = e41616;
var statearr_41617_42875 = state_41512;
(statearr_41617_42875[(5)] = ex__39115__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_41512);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e41616;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__39113__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42878 = state_41512;
state_41512 = G__42878;
continue;
} else {
return ret_value__39113__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__39112__auto__ = function(state_41512){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__39112__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__39112__auto____1.call(this,state_41512);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__39112__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__39112__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__39112__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__39112__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__39112__auto__;
})()
;})(switch__39111__auto__,c__39413__auto__))
})();
var state__39415__auto__ = (function (){var statearr_41619 = (f__39414__auto__.cljs$core$IFn$_invoke$arity$0 ? f__39414__auto__.cljs$core$IFn$_invoke$arity$0() : f__39414__auto__.call(null));
(statearr_41619[(6)] = c__39413__auto__);

return statearr_41619;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__39415__auto__);
});})(c__39413__auto__))
);

return c__39413__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__41626 = arguments.length;
switch (G__41626) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__41633 = arguments.length;
switch (G__41633) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__41640 = arguments.length;
switch (G__41640) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__39413__auto___42897 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__39413__auto___42897,out){
return (function (){
var f__39414__auto__ = (function (){var switch__39111__auto__ = ((function (c__39413__auto___42897,out){
return (function (state_41669){
var state_val_41670 = (state_41669[(1)]);
if((state_val_41670 === (7))){
var inst_41664 = (state_41669[(2)]);
var state_41669__$1 = state_41669;
var statearr_41674_42902 = state_41669__$1;
(statearr_41674_42902[(2)] = inst_41664);

(statearr_41674_42902[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41670 === (1))){
var inst_41644 = null;
var state_41669__$1 = (function (){var statearr_41677 = state_41669;
(statearr_41677[(7)] = inst_41644);

return statearr_41677;
})();
var statearr_41678_42903 = state_41669__$1;
(statearr_41678_42903[(2)] = null);

(statearr_41678_42903[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41670 === (4))){
var inst_41647 = (state_41669[(8)]);
var inst_41647__$1 = (state_41669[(2)]);
var inst_41650 = (inst_41647__$1 == null);
var inst_41651 = cljs.core.not(inst_41650);
var state_41669__$1 = (function (){var statearr_41680 = state_41669;
(statearr_41680[(8)] = inst_41647__$1);

return statearr_41680;
})();
if(inst_41651){
var statearr_41681_42905 = state_41669__$1;
(statearr_41681_42905[(1)] = (5));

} else {
var statearr_41682_42906 = state_41669__$1;
(statearr_41682_42906[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41670 === (6))){
var state_41669__$1 = state_41669;
var statearr_41683_42907 = state_41669__$1;
(statearr_41683_42907[(2)] = null);

(statearr_41683_42907[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41670 === (3))){
var inst_41666 = (state_41669[(2)]);
var inst_41667 = cljs.core.async.close_BANG_(out);
var state_41669__$1 = (function (){var statearr_41686 = state_41669;
(statearr_41686[(9)] = inst_41666);

return statearr_41686;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_41669__$1,inst_41667);
} else {
if((state_val_41670 === (2))){
var state_41669__$1 = state_41669;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41669__$1,(4),ch);
} else {
if((state_val_41670 === (11))){
var inst_41647 = (state_41669[(8)]);
var inst_41658 = (state_41669[(2)]);
var inst_41644 = inst_41647;
var state_41669__$1 = (function (){var statearr_41689 = state_41669;
(statearr_41689[(7)] = inst_41644);

(statearr_41689[(10)] = inst_41658);

return statearr_41689;
})();
var statearr_41690_42914 = state_41669__$1;
(statearr_41690_42914[(2)] = null);

(statearr_41690_42914[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41670 === (9))){
var inst_41647 = (state_41669[(8)]);
var state_41669__$1 = state_41669;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_41669__$1,(11),out,inst_41647);
} else {
if((state_val_41670 === (5))){
var inst_41644 = (state_41669[(7)]);
var inst_41647 = (state_41669[(8)]);
var inst_41653 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_41647,inst_41644);
var state_41669__$1 = state_41669;
if(inst_41653){
var statearr_41693_42918 = state_41669__$1;
(statearr_41693_42918[(1)] = (8));

} else {
var statearr_41694_42919 = state_41669__$1;
(statearr_41694_42919[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41670 === (10))){
var inst_41661 = (state_41669[(2)]);
var state_41669__$1 = state_41669;
var statearr_41695_42920 = state_41669__$1;
(statearr_41695_42920[(2)] = inst_41661);

(statearr_41695_42920[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41670 === (8))){
var inst_41644 = (state_41669[(7)]);
var tmp41692 = inst_41644;
var inst_41644__$1 = tmp41692;
var state_41669__$1 = (function (){var statearr_41698 = state_41669;
(statearr_41698[(7)] = inst_41644__$1);

return statearr_41698;
})();
var statearr_41699_42923 = state_41669__$1;
(statearr_41699_42923[(2)] = null);

(statearr_41699_42923[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__39413__auto___42897,out))
;
return ((function (switch__39111__auto__,c__39413__auto___42897,out){
return (function() {
var cljs$core$async$state_machine__39112__auto__ = null;
var cljs$core$async$state_machine__39112__auto____0 = (function (){
var statearr_41702 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_41702[(0)] = cljs$core$async$state_machine__39112__auto__);

(statearr_41702[(1)] = (1));

return statearr_41702;
});
var cljs$core$async$state_machine__39112__auto____1 = (function (state_41669){
while(true){
var ret_value__39113__auto__ = (function (){try{while(true){
var result__39114__auto__ = switch__39111__auto__(state_41669);
if(cljs.core.keyword_identical_QMARK_(result__39114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__39114__auto__;
}
break;
}
}catch (e41703){if((e41703 instanceof Object)){
var ex__39115__auto__ = e41703;
var statearr_41704_42928 = state_41669;
(statearr_41704_42928[(5)] = ex__39115__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_41669);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e41703;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__39113__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42933 = state_41669;
state_41669 = G__42933;
continue;
} else {
return ret_value__39113__auto__;
}
break;
}
});
cljs$core$async$state_machine__39112__auto__ = function(state_41669){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__39112__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__39112__auto____1.call(this,state_41669);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__39112__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__39112__auto____0;
cljs$core$async$state_machine__39112__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__39112__auto____1;
return cljs$core$async$state_machine__39112__auto__;
})()
;})(switch__39111__auto__,c__39413__auto___42897,out))
})();
var state__39415__auto__ = (function (){var statearr_41706 = (f__39414__auto__.cljs$core$IFn$_invoke$arity$0 ? f__39414__auto__.cljs$core$IFn$_invoke$arity$0() : f__39414__auto__.call(null));
(statearr_41706[(6)] = c__39413__auto___42897);

return statearr_41706;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__39415__auto__);
});})(c__39413__auto___42897,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__41712 = arguments.length;
switch (G__41712) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__39413__auto___42944 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__39413__auto___42944,out){
return (function (){
var f__39414__auto__ = (function (){var switch__39111__auto__ = ((function (c__39413__auto___42944,out){
return (function (state_41755){
var state_val_41756 = (state_41755[(1)]);
if((state_val_41756 === (7))){
var inst_41751 = (state_41755[(2)]);
var state_41755__$1 = state_41755;
var statearr_41760_42948 = state_41755__$1;
(statearr_41760_42948[(2)] = inst_41751);

(statearr_41760_42948[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41756 === (1))){
var inst_41716 = (new Array(n));
var inst_41717 = inst_41716;
var inst_41718 = (0);
var state_41755__$1 = (function (){var statearr_41763 = state_41755;
(statearr_41763[(7)] = inst_41718);

(statearr_41763[(8)] = inst_41717);

return statearr_41763;
})();
var statearr_41764_42954 = state_41755__$1;
(statearr_41764_42954[(2)] = null);

(statearr_41764_42954[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41756 === (4))){
var inst_41721 = (state_41755[(9)]);
var inst_41721__$1 = (state_41755[(2)]);
var inst_41722 = (inst_41721__$1 == null);
var inst_41723 = cljs.core.not(inst_41722);
var state_41755__$1 = (function (){var statearr_41766 = state_41755;
(statearr_41766[(9)] = inst_41721__$1);

return statearr_41766;
})();
if(inst_41723){
var statearr_41767_42955 = state_41755__$1;
(statearr_41767_42955[(1)] = (5));

} else {
var statearr_41768_42956 = state_41755__$1;
(statearr_41768_42956[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41756 === (15))){
var inst_41745 = (state_41755[(2)]);
var state_41755__$1 = state_41755;
var statearr_41771_42960 = state_41755__$1;
(statearr_41771_42960[(2)] = inst_41745);

(statearr_41771_42960[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41756 === (13))){
var state_41755__$1 = state_41755;
var statearr_41774_42961 = state_41755__$1;
(statearr_41774_42961[(2)] = null);

(statearr_41774_42961[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41756 === (6))){
var inst_41718 = (state_41755[(7)]);
var inst_41741 = (inst_41718 > (0));
var state_41755__$1 = state_41755;
if(cljs.core.truth_(inst_41741)){
var statearr_41775_42962 = state_41755__$1;
(statearr_41775_42962[(1)] = (12));

} else {
var statearr_41776_42966 = state_41755__$1;
(statearr_41776_42966[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41756 === (3))){
var inst_41753 = (state_41755[(2)]);
var state_41755__$1 = state_41755;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41755__$1,inst_41753);
} else {
if((state_val_41756 === (12))){
var inst_41717 = (state_41755[(8)]);
var inst_41743 = cljs.core.vec(inst_41717);
var state_41755__$1 = state_41755;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_41755__$1,(15),out,inst_41743);
} else {
if((state_val_41756 === (2))){
var state_41755__$1 = state_41755;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41755__$1,(4),ch);
} else {
if((state_val_41756 === (11))){
var inst_41735 = (state_41755[(2)]);
var inst_41736 = (new Array(n));
var inst_41717 = inst_41736;
var inst_41718 = (0);
var state_41755__$1 = (function (){var statearr_41778 = state_41755;
(statearr_41778[(7)] = inst_41718);

(statearr_41778[(8)] = inst_41717);

(statearr_41778[(10)] = inst_41735);

return statearr_41778;
})();
var statearr_41781_42970 = state_41755__$1;
(statearr_41781_42970[(2)] = null);

(statearr_41781_42970[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41756 === (9))){
var inst_41717 = (state_41755[(8)]);
var inst_41733 = cljs.core.vec(inst_41717);
var state_41755__$1 = state_41755;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_41755__$1,(11),out,inst_41733);
} else {
if((state_val_41756 === (5))){
var inst_41718 = (state_41755[(7)]);
var inst_41717 = (state_41755[(8)]);
var inst_41721 = (state_41755[(9)]);
var inst_41728 = (state_41755[(11)]);
var inst_41726 = (inst_41717[inst_41718] = inst_41721);
var inst_41728__$1 = (inst_41718 + (1));
var inst_41729 = (inst_41728__$1 < n);
var state_41755__$1 = (function (){var statearr_41784 = state_41755;
(statearr_41784[(12)] = inst_41726);

(statearr_41784[(11)] = inst_41728__$1);

return statearr_41784;
})();
if(cljs.core.truth_(inst_41729)){
var statearr_41785_42981 = state_41755__$1;
(statearr_41785_42981[(1)] = (8));

} else {
var statearr_41787_42982 = state_41755__$1;
(statearr_41787_42982[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41756 === (14))){
var inst_41748 = (state_41755[(2)]);
var inst_41749 = cljs.core.async.close_BANG_(out);
var state_41755__$1 = (function (){var statearr_41789 = state_41755;
(statearr_41789[(13)] = inst_41748);

return statearr_41789;
})();
var statearr_41790_42983 = state_41755__$1;
(statearr_41790_42983[(2)] = inst_41749);

(statearr_41790_42983[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41756 === (10))){
var inst_41739 = (state_41755[(2)]);
var state_41755__$1 = state_41755;
var statearr_41793_42984 = state_41755__$1;
(statearr_41793_42984[(2)] = inst_41739);

(statearr_41793_42984[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41756 === (8))){
var inst_41717 = (state_41755[(8)]);
var inst_41728 = (state_41755[(11)]);
var tmp41788 = inst_41717;
var inst_41717__$1 = tmp41788;
var inst_41718 = inst_41728;
var state_41755__$1 = (function (){var statearr_41796 = state_41755;
(statearr_41796[(7)] = inst_41718);

(statearr_41796[(8)] = inst_41717__$1);

return statearr_41796;
})();
var statearr_41798_42988 = state_41755__$1;
(statearr_41798_42988[(2)] = null);

(statearr_41798_42988[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__39413__auto___42944,out))
;
return ((function (switch__39111__auto__,c__39413__auto___42944,out){
return (function() {
var cljs$core$async$state_machine__39112__auto__ = null;
var cljs$core$async$state_machine__39112__auto____0 = (function (){
var statearr_41801 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_41801[(0)] = cljs$core$async$state_machine__39112__auto__);

(statearr_41801[(1)] = (1));

return statearr_41801;
});
var cljs$core$async$state_machine__39112__auto____1 = (function (state_41755){
while(true){
var ret_value__39113__auto__ = (function (){try{while(true){
var result__39114__auto__ = switch__39111__auto__(state_41755);
if(cljs.core.keyword_identical_QMARK_(result__39114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__39114__auto__;
}
break;
}
}catch (e41804){if((e41804 instanceof Object)){
var ex__39115__auto__ = e41804;
var statearr_41805_42992 = state_41755;
(statearr_41805_42992[(5)] = ex__39115__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_41755);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e41804;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__39113__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__42993 = state_41755;
state_41755 = G__42993;
continue;
} else {
return ret_value__39113__auto__;
}
break;
}
});
cljs$core$async$state_machine__39112__auto__ = function(state_41755){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__39112__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__39112__auto____1.call(this,state_41755);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__39112__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__39112__auto____0;
cljs$core$async$state_machine__39112__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__39112__auto____1;
return cljs$core$async$state_machine__39112__auto__;
})()
;})(switch__39111__auto__,c__39413__auto___42944,out))
})();
var state__39415__auto__ = (function (){var statearr_41807 = (f__39414__auto__.cljs$core$IFn$_invoke$arity$0 ? f__39414__auto__.cljs$core$IFn$_invoke$arity$0() : f__39414__auto__.call(null));
(statearr_41807[(6)] = c__39413__auto___42944);

return statearr_41807;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__39415__auto__);
});})(c__39413__auto___42944,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__41813 = arguments.length;
switch (G__41813) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__39413__auto___43002 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__39413__auto___43002,out){
return (function (){
var f__39414__auto__ = (function (){var switch__39111__auto__ = ((function (c__39413__auto___43002,out){
return (function (state_41863){
var state_val_41864 = (state_41863[(1)]);
if((state_val_41864 === (7))){
var inst_41858 = (state_41863[(2)]);
var state_41863__$1 = state_41863;
var statearr_41867_43007 = state_41863__$1;
(statearr_41867_43007[(2)] = inst_41858);

(statearr_41867_43007[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41864 === (1))){
var inst_41819 = [];
var inst_41820 = inst_41819;
var inst_41821 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_41863__$1 = (function (){var statearr_41869 = state_41863;
(statearr_41869[(7)] = inst_41820);

(statearr_41869[(8)] = inst_41821);

return statearr_41869;
})();
var statearr_41870_43017 = state_41863__$1;
(statearr_41870_43017[(2)] = null);

(statearr_41870_43017[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41864 === (4))){
var inst_41824 = (state_41863[(9)]);
var inst_41824__$1 = (state_41863[(2)]);
var inst_41825 = (inst_41824__$1 == null);
var inst_41826 = cljs.core.not(inst_41825);
var state_41863__$1 = (function (){var statearr_41872 = state_41863;
(statearr_41872[(9)] = inst_41824__$1);

return statearr_41872;
})();
if(inst_41826){
var statearr_41874_43025 = state_41863__$1;
(statearr_41874_43025[(1)] = (5));

} else {
var statearr_41875_43026 = state_41863__$1;
(statearr_41875_43026[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41864 === (15))){
var inst_41851 = (state_41863[(2)]);
var state_41863__$1 = state_41863;
var statearr_41878_43033 = state_41863__$1;
(statearr_41878_43033[(2)] = inst_41851);

(statearr_41878_43033[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41864 === (13))){
var state_41863__$1 = state_41863;
var statearr_41879_43037 = state_41863__$1;
(statearr_41879_43037[(2)] = null);

(statearr_41879_43037[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41864 === (6))){
var inst_41820 = (state_41863[(7)]);
var inst_41846 = inst_41820.length;
var inst_41847 = (inst_41846 > (0));
var state_41863__$1 = state_41863;
if(cljs.core.truth_(inst_41847)){
var statearr_41881_43038 = state_41863__$1;
(statearr_41881_43038[(1)] = (12));

} else {
var statearr_41882_43039 = state_41863__$1;
(statearr_41882_43039[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41864 === (3))){
var inst_41861 = (state_41863[(2)]);
var state_41863__$1 = state_41863;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41863__$1,inst_41861);
} else {
if((state_val_41864 === (12))){
var inst_41820 = (state_41863[(7)]);
var inst_41849 = cljs.core.vec(inst_41820);
var state_41863__$1 = state_41863;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_41863__$1,(15),out,inst_41849);
} else {
if((state_val_41864 === (2))){
var state_41863__$1 = state_41863;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41863__$1,(4),ch);
} else {
if((state_val_41864 === (11))){
var inst_41828 = (state_41863[(10)]);
var inst_41824 = (state_41863[(9)]);
var inst_41839 = (state_41863[(2)]);
var inst_41840 = [];
var inst_41841 = inst_41840.push(inst_41824);
var inst_41820 = inst_41840;
var inst_41821 = inst_41828;
var state_41863__$1 = (function (){var statearr_41890 = state_41863;
(statearr_41890[(11)] = inst_41841);

(statearr_41890[(7)] = inst_41820);

(statearr_41890[(12)] = inst_41839);

(statearr_41890[(8)] = inst_41821);

return statearr_41890;
})();
var statearr_41893_43046 = state_41863__$1;
(statearr_41893_43046[(2)] = null);

(statearr_41893_43046[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41864 === (9))){
var inst_41820 = (state_41863[(7)]);
var inst_41837 = cljs.core.vec(inst_41820);
var state_41863__$1 = state_41863;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_41863__$1,(11),out,inst_41837);
} else {
if((state_val_41864 === (5))){
var inst_41828 = (state_41863[(10)]);
var inst_41821 = (state_41863[(8)]);
var inst_41824 = (state_41863[(9)]);
var inst_41828__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_41824) : f.call(null,inst_41824));
var inst_41830 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_41828__$1,inst_41821);
var inst_41831 = cljs.core.keyword_identical_QMARK_(inst_41821,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_41832 = ((inst_41830) || (inst_41831));
var state_41863__$1 = (function (){var statearr_41897 = state_41863;
(statearr_41897[(10)] = inst_41828__$1);

return statearr_41897;
})();
if(cljs.core.truth_(inst_41832)){
var statearr_41900_43054 = state_41863__$1;
(statearr_41900_43054[(1)] = (8));

} else {
var statearr_41901_43055 = state_41863__$1;
(statearr_41901_43055[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41864 === (14))){
var inst_41854 = (state_41863[(2)]);
var inst_41856 = cljs.core.async.close_BANG_(out);
var state_41863__$1 = (function (){var statearr_41904 = state_41863;
(statearr_41904[(13)] = inst_41854);

return statearr_41904;
})();
var statearr_41905_43056 = state_41863__$1;
(statearr_41905_43056[(2)] = inst_41856);

(statearr_41905_43056[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41864 === (10))){
var inst_41844 = (state_41863[(2)]);
var state_41863__$1 = state_41863;
var statearr_41907_43058 = state_41863__$1;
(statearr_41907_43058[(2)] = inst_41844);

(statearr_41907_43058[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_41864 === (8))){
var inst_41828 = (state_41863[(10)]);
var inst_41820 = (state_41863[(7)]);
var inst_41824 = (state_41863[(9)]);
var inst_41834 = inst_41820.push(inst_41824);
var tmp41902 = inst_41820;
var inst_41820__$1 = tmp41902;
var inst_41821 = inst_41828;
var state_41863__$1 = (function (){var statearr_41911 = state_41863;
(statearr_41911[(14)] = inst_41834);

(statearr_41911[(7)] = inst_41820__$1);

(statearr_41911[(8)] = inst_41821);

return statearr_41911;
})();
var statearr_41912_43060 = state_41863__$1;
(statearr_41912_43060[(2)] = null);

(statearr_41912_43060[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__39413__auto___43002,out))
;
return ((function (switch__39111__auto__,c__39413__auto___43002,out){
return (function() {
var cljs$core$async$state_machine__39112__auto__ = null;
var cljs$core$async$state_machine__39112__auto____0 = (function (){
var statearr_41914 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_41914[(0)] = cljs$core$async$state_machine__39112__auto__);

(statearr_41914[(1)] = (1));

return statearr_41914;
});
var cljs$core$async$state_machine__39112__auto____1 = (function (state_41863){
while(true){
var ret_value__39113__auto__ = (function (){try{while(true){
var result__39114__auto__ = switch__39111__auto__(state_41863);
if(cljs.core.keyword_identical_QMARK_(result__39114__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__39114__auto__;
}
break;
}
}catch (e41915){if((e41915 instanceof Object)){
var ex__39115__auto__ = e41915;
var statearr_41916_43061 = state_41863;
(statearr_41916_43061[(5)] = ex__39115__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_41863);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e41915;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__39113__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43062 = state_41863;
state_41863 = G__43062;
continue;
} else {
return ret_value__39113__auto__;
}
break;
}
});
cljs$core$async$state_machine__39112__auto__ = function(state_41863){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__39112__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__39112__auto____1.call(this,state_41863);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__39112__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__39112__auto____0;
cljs$core$async$state_machine__39112__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__39112__auto____1;
return cljs$core$async$state_machine__39112__auto__;
})()
;})(switch__39111__auto__,c__39413__auto___43002,out))
})();
var state__39415__auto__ = (function (){var statearr_41921 = (f__39414__auto__.cljs$core$IFn$_invoke$arity$0 ? f__39414__auto__.cljs$core$IFn$_invoke$arity$0() : f__39414__auto__.call(null));
(statearr_41921[(6)] = c__39413__auto___43002);

return statearr_41921;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__39415__auto__);
});})(c__39413__auto___43002,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=cljs.core.async.js.map
