/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.emp.connector;

import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.client.ClientSession;

public class ReplayExtension
extends ClientSession.Extension.Adapter {
    private static final String EXTENSION_NAME = "replay";
    private final ConcurrentMap<String, Long> dataMap;
    private final AtomicBoolean supported = new AtomicBoolean();

    public ReplayExtension(ConcurrentMap<String, Long> dataMap) {
        this.dataMap = dataMap;
    }

    public boolean rcv(ClientSession session, Message.Mutable message) {
        Object data = message.get((Object)EXTENSION_NAME);
        if (this.supported.get() && data != null) {
            try {
                this.dataMap.put(message.getChannel(), (Long)data);
            }
            catch (ClassCastException e) {
                return false;
            }
        }
        return true;
    }

    public boolean rcvMeta(ClientSession session, Message.Mutable message) {
        switch (message.getChannel()) {
            case "/meta/handshake": {
                Map ext = message.getExt(false);
                this.supported.set(ext != null && Boolean.TRUE.equals(ext.get(EXTENSION_NAME)));
            }
        }
        return true;
    }

    public boolean sendMeta(ClientSession session, Message.Mutable message) {
        switch (message.getChannel()) {
            case "/meta/handshake": {
                message.getExt(true).put(EXTENSION_NAME, Boolean.TRUE);
                break;
            }
            case "/meta/subscribe": {
                if (!this.supported.get()) break;
                message.getExt(true).put(EXTENSION_NAME, this.dataMap);
            }
        }
        return true;
    }
}

