/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.emp.connector;

import com.salesforce.emp.connector.BayeuxParameters;
import com.salesforce.emp.connector.DelegatingBayeuxParameters;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.URL;
import java.nio.ByteBuffer;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.util.ByteBufferContentProvider;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class LoginHelper {
    public static final String COMETD_REPLAY = "/cometd/";
    public static final String COMETD_REPLAY_OLD = "/cometd/replay/";
    static final String LOGIN_ENDPOINT = "https://login.salesforce.com";
    private static final String ENV_END = "</soapenv:Body></soapenv:Envelope>";
    private static final String ENV_START = "<soapenv:Envelope xmlns:soapenv='http://schemas.xmlsoap.org/soap/envelope/' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xmlns:urn='urn:partner.soap.sforce.com'><soapenv:Body>";
    private static final String SERVICES_SOAP_PARTNER_ENDPOINT = "/services/Soap/u/22.0/";

    public static BayeuxParameters login(String username, String password) throws Exception {
        return LoginHelper.login(new URL(LOGIN_ENDPOINT), username, password);
    }

    public static BayeuxParameters login(String username, String password, BayeuxParameters params) throws Exception {
        return LoginHelper.login(new URL(LOGIN_ENDPOINT), username, password, params);
    }

    public static BayeuxParameters login(URL loginEndpoint, String username, String password) throws Exception {
        return LoginHelper.login(loginEndpoint, username, password, new BayeuxParameters(){

            @Override
            public String bearerToken() {
                throw new IllegalStateException("Have not authenticated");
            }

            @Override
            public URL endpoint() {
                throw new IllegalStateException("Have not established replay endpoint");
            }
        });
    }

    public static BayeuxParameters login(URL loginEndpoint, String username, String password, BayeuxParameters parameters) throws Exception {
        HttpClient client = new HttpClient(parameters.sslContextFactory());
        client.getProxyConfiguration().getProxies().addAll(parameters.proxies());
        client.start();
        URL endpoint = new URL(loginEndpoint, LoginHelper.getSoapUri());
        Request post = client.POST(endpoint.toURI());
        post.content((ContentProvider)new ByteBufferContentProvider("text/xml", new ByteBuffer[]{ByteBuffer.wrap(LoginHelper.soapXmlForLogin(username, password))}));
        post.header("SOAPAction", "''");
        post.header("PrettyPrint", "Yes");
        ContentResponse response = post.send();
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setFeature("http://xml.org/sax/features/external-general-entities", false);
        spf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        spf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        spf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        spf.setNamespaceAware(true);
        SAXParser saxParser = spf.newSAXParser();
        LoginResponseParser parser = new LoginResponseParser();
        saxParser.parse((InputStream)new ByteArrayInputStream(response.getContent()), (DefaultHandler)parser);
        final String sessionId = parser.sessionId;
        if (sessionId == null || parser.serverUrl == null) {
            throw new ConnectException(String.format("Unable to login: %s", parser.faultstring));
        }
        URL soapEndpoint = new URL(parser.serverUrl);
        String cometdEndpoint = Float.parseFloat(parameters.version()) < 37.0f ? COMETD_REPLAY_OLD : COMETD_REPLAY;
        final URL replayEndpoint = new URL(soapEndpoint.getProtocol(), soapEndpoint.getHost(), soapEndpoint.getPort(), cometdEndpoint + parameters.version());
        return new DelegatingBayeuxParameters(parameters){

            @Override
            public String bearerToken() {
                return sessionId;
            }

            @Override
            public URL endpoint() {
                return replayEndpoint;
            }
        };
    }

    private static String getSoapUri() {
        return SERVICES_SOAP_PARTNER_ENDPOINT;
    }

    private static byte[] soapXmlForLogin(String username, String password) throws UnsupportedEncodingException {
        return ("<soapenv:Envelope xmlns:soapenv='http://schemas.xmlsoap.org/soap/envelope/' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xmlns:urn='urn:partner.soap.sforce.com'><soapenv:Body>  <urn:login>    <urn:username>" + username + "</urn:username>" + "    <urn:password>" + password + "</urn:password>" + "  </urn:login>" + ENV_END).getBytes("UTF-8");
    }

    private static class LoginResponseParser
    extends DefaultHandler {
        private String buffer;
        private String faultstring;
        private boolean reading = false;
        private String serverUrl;
        private String sessionId;

        private LoginResponseParser() {
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this.reading) {
                this.buffer = new String(ch, start, length);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            this.reading = false;
            switch (localName) {
                case "sessionId": {
                    this.sessionId = this.buffer;
                    break;
                }
                case "serverUrl": {
                    this.serverUrl = this.buffer;
                    break;
                }
                case "faultstring": {
                    this.faultstring = this.buffer;
                }
            }
            this.buffer = null;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            switch (localName) {
                case "sessionId": {
                    this.reading = true;
                    break;
                }
                case "serverUrl": {
                    this.reading = true;
                    break;
                }
                case "faultstring": {
                    this.reading = true;
                }
            }
        }
    }
}

