/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.athena.api;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.simba.athena.amazonaws.ClientConfiguration;
import com.simba.athena.amazonaws.SdkClientException;
import com.simba.athena.amazonaws.client.builder.AwsClientBuilder;
import com.simba.athena.amazonaws.client.builder.AwsSyncClientBuilder;
import com.simba.athena.amazonaws.retry.PredefinedRetryPolicies;
import com.simba.athena.amazonaws.retry.RetryPolicy;
import com.simba.athena.amazonaws.services.athena.AmazonAthena;
import com.simba.athena.amazonaws.services.athena.AmazonAthenaClientBuilder;
import com.simba.athena.amazonaws.services.athena.model.AmazonAthenaException;
import com.simba.athena.amazonaws.services.athena.model.Datum;
import com.simba.athena.amazonaws.services.athena.model.EncryptionConfiguration;
import com.simba.athena.amazonaws.services.athena.model.GetQueryExecutionRequest;
import com.simba.athena.amazonaws.services.athena.model.GetQueryExecutionResult;
import com.simba.athena.amazonaws.services.athena.model.GetQueryResultsRequest;
import com.simba.athena.amazonaws.services.athena.model.GetQueryResultsResult;
import com.simba.athena.amazonaws.services.athena.model.QueryExecutionContext;
import com.simba.athena.amazonaws.services.athena.model.QueryExecutionState;
import com.simba.athena.amazonaws.services.athena.model.ResultConfiguration;
import com.simba.athena.amazonaws.services.athena.model.Row;
import com.simba.athena.amazonaws.services.athena.model.StartQueryExecutionRequest;
import com.simba.athena.amazonaws.services.athena.model.StartQueryExecutionResult;
import com.simba.athena.amazonaws.services.athena.model.StopQueryExecutionRequest;
import com.simba.athena.amazonaws.services.athena.model.StopQueryExecutionResult;
import com.simba.athena.amazonaws.services.athenastreamingservice.AthenaStreamingService;
import com.simba.athena.amazonaws.services.athenastreamingservice.AthenaStreamingServiceClient;
import com.simba.athena.amazonaws.services.athenastreamingservice.AthenaStreamingServiceClientBuilder;
import com.simba.athena.amazonaws.services.athenastreamingservice.model.GetQueryResultsStreamRequest;
import com.simba.athena.amazonaws.services.athenastreamingservice.model.GetQueryResultsStreamResult;
import com.simba.athena.amazonaws.services.glue.AWSGlue;
import com.simba.athena.amazonaws.services.glue.AWSGlueClientBuilder;
import com.simba.athena.amazonaws.services.glue.model.AWSGlueException;
import com.simba.athena.amazonaws.services.glue.model.Column;
import com.simba.athena.amazonaws.services.glue.model.Database;
import com.simba.athena.amazonaws.services.glue.model.GetCatalogImportStatusRequest;
import com.simba.athena.amazonaws.services.glue.model.GetCatalogImportStatusResult;
import com.simba.athena.amazonaws.services.glue.model.GetDatabasesRequest;
import com.simba.athena.amazonaws.services.glue.model.GetDatabasesResult;
import com.simba.athena.amazonaws.services.glue.model.GetTablesRequest;
import com.simba.athena.amazonaws.services.glue.model.GetTablesResult;
import com.simba.athena.amazonaws.services.glue.model.Table;
import com.simba.athena.athena.AJMetadataRetrievalMethod;
import com.simba.athena.athena.api.AJExecutionContext;
import com.simba.athena.athena.core.AJDriver;
import com.simba.athena.athena.core.AJSettings;
import com.simba.athena.athena.dataengine.AJResultSetBuffer;
import com.simba.athena.athena.dataengine.metadata.AJColumnMetadata;
import com.simba.athena.athena.dataengine.metadata.AJTableMetadata;
import com.simba.athena.athena.exceptions.AJMessageKey;
import com.simba.athena.athena.utilities.AJAWSLogAppender;
import com.simba.athena.athena.utilities.AJTypeUtilities;
import com.simba.athena.athena.utilities.AJUtilities;
import com.simba.athena.dsi.core.utilities.Variant;
import com.simba.athena.dsi.exceptions.OperationCanceledException;
import com.simba.athena.jdbc.core.DSDriver;
import com.simba.athena.jdbc.exceptions.CommonJDBCMessageKey;
import com.simba.athena.jdbc.utils.StringWrapperFilter;
import com.simba.athena.shaded.apache.http.conn.ConnectTimeoutException;
import com.simba.athena.shaded.apache.log4j.Appender;
import com.simba.athena.shaded.apache.log4j.Logger;
import com.simba.athena.support.ILogger;
import com.simba.athena.support.LogUtilities;
import com.simba.athena.support.Pair;
import com.simba.athena.support.exceptions.DiagState;
import com.simba.athena.support.exceptions.ErrorException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.TimeUnit;

public class AJClient {
    private static final int AJ_NO_QUERY_TIMEOUT = 0;
    private static final RetryPolicy AJ_GLUE_DETECTION_RETRY_POLICY = new RetryPolicy(PredefinedRetryPolicies.DEFAULT_RETRY_CONDITION, RetryPolicy.BackoffStrategy.NO_DELAY, 5, true);
    private ILogger m_logger;
    private AmazonAthena m_athenaClient;
    private AWSGlue m_glueClient;
    private AthenaStreamingService m_streamClient;
    private final AJSettings m_settings;
    private final Object m_lockCancel = new Object();

    public AJClient(ILogger iLogger, AJSettings aJSettings) throws ErrorException {
        Object object;
        LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        this.m_logger = iLogger;
        this.m_settings = aJSettings;
        if (this.m_settings.m_useAwsLogger) {
            object = new AJAWSLogAppender(this.m_logger, this.m_logger.getLogLevel());
            Logger.getRootLogger().addAppender((Appender)object);
        }
        object = AJUtilities.createAwsCredentialsProvider(this.m_logger, this.m_settings.m_uid, this.m_settings.m_pwd, this.m_settings.m_awsCredentialsProviderClass, this.m_settings.m_awsCredentialProviderArgs);
        try {
            AmazonAthenaClientBuilder amazonAthenaClientBuilder = AmazonAthenaClientBuilder.standard();
            ((AmazonAthenaClientBuilder)((AmazonAthenaClientBuilder)amazonAthenaClientBuilder.withRegion(this.m_settings.m_awsRegion)).withClientConfiguration(this.m_settings.m_clientConfig)).withCredentials((AWSCredentialsProvider)object);
            this.m_athenaClient = (AmazonAthena)amazonAthenaClientBuilder.build();
            AWSGlueClientBuilder aWSGlueClientBuilder = AWSGlueClientBuilder.standard();
            ((AWSGlueClientBuilder)((AWSGlueClientBuilder)aWSGlueClientBuilder.withRegion(this.m_settings.m_awsRegion)).withClientConfiguration(this.m_settings.m_clientConfig)).withCredentials((AWSCredentialsProvider)object);
            this.m_glueClient = (AWSGlue)aWSGlueClientBuilder.build();
            if (this.m_settings.m_useStreamClient) {
                String string = "https://athena." + this.m_settings.m_awsRegion + ".amazonaws.com:" + this.m_settings.m_athenaStreamClientPort;
                AthenaStreamingServiceClientBuilder athenaStreamingServiceClientBuilder = AthenaStreamingServiceClient.builder();
                ((AthenaStreamingServiceClientBuilder)((AthenaStreamingServiceClientBuilder)athenaStreamingServiceClientBuilder.withClientConfiguration(this.m_settings.m_clientConfig)).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(string, this.m_settings.m_awsRegion))).withCredentials((AWSCredentialsProvider)object);
                this.m_streamClient = (AthenaStreamingService)athenaStreamingServiceClientBuilder.build();
            }
        }
        catch (Exception exception) {
            this.checkAndThrowException(exception);
        }
        if (AJMetadataRetrievalMethod.AUTO_DETECT_GLUE == this.m_settings.m_metadataRetrievalMethod) {
            this.checkGlueSupport((AWSCredentialsProvider)object);
        }
        if (this.m_settings.m_performConnectionTest) {
            this.checkAthenaConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelQuery(AJExecutionContext aJExecutionContext) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, aJExecutionContext);
        Object object = this.m_lockCancel;
        synchronized (object) {
            aJExecutionContext.m_hasBeenCanceled = true;
            if (null == aJExecutionContext.m_queryExecId) {
                LogUtilities.logDebug("No query ID available for query: " + aJExecutionContext.getQuery() + ". Cancel request is not sent to server.", this.m_logger);
                return;
            }
            StopQueryExecutionRequest stopQueryExecutionRequest = new StopQueryExecutionRequest().withQueryExecutionId(aJExecutionContext.m_queryExecId);
            StopQueryExecutionResult stopQueryExecutionResult = this.m_athenaClient.stopQueryExecution(stopQueryExecutionRequest);
            if (200 != stopQueryExecutionResult.getSdkHttpMetadata().getHttpStatusCode()) {
                LogUtilities.logDebug("Error occurred while trying to cancel query: " + aJExecutionContext.getQuery() + ". HTTP Status Code: " + stopQueryExecutionResult.getSdkHttpMetadata().getHttpStatusCode(), this.m_logger);
                throw AJDriver.s_AJMessages.createCustomException(DiagState.DIAG_SERVER_DECLINED_CANCEL.name(), AJMessageKey.ATHENA_CLIENT_ERROR.name(), "Error occurred while trying to cancel query: " + aJExecutionContext.getQuery() + ". HTTP Status Code: " + stopQueryExecutionResult.getSdkHttpMetadata().getHttpStatusCode());
            }
            LogUtilities.logDebug("Successfully canceled query: " + aJExecutionContext.getQuery(), this.m_logger);
        }
    }

    public void checkAndThrowException(Exception exception) throws ErrorException {
        if (exception instanceof AmazonAthenaException) {
            throw AJDriver.s_AJMessages.createGeneralException(AJMessageKey.ATHENA_CLIENT_ERROR.name(), new String[]{null == ((AmazonAthenaException)exception).getErrorMessage() ? " Unknown" : ((AmazonAthenaException)exception).getErrorMessage()}, (Throwable)exception);
        }
        if (exception instanceof AWSGlueException) {
            throw AJDriver.s_AJMessages.createGeneralException(AJMessageKey.GLUE_CLIENT_ERROR.name(), new String[]{null == ((AWSGlueException)exception).getErrorMessage() ? " Unknown" : ((AWSGlueException)exception).getErrorMessage()}, (Throwable)exception);
        }
        if (exception instanceof SdkClientException) {
            throw AJDriver.s_AJMessages.createGeneralException(AJMessageKey.AWS_CLIENT_ERR.name(), new String[]{null == exception.getMessage() ? "Unknown" : exception.getMessage()}, (Throwable)exception);
        }
        if (exception instanceof ErrorException) {
            throw (ErrorException)exception;
        }
        throw AJDriver.s_AJMessages.createGeneralException(AJMessageKey.GENERAL_ERROR.name(), (Throwable)exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkCancelFlag(AJExecutionContext aJExecutionContext) throws OperationCanceledException {
        LogUtilities.logFunctionEntrance(this.m_logger, aJExecutionContext);
        Object object = this.m_lockCancel;
        synchronized (object) {
            if (aJExecutionContext.m_hasBeenCanceled) {
                throw new OperationCanceledException(101, AJMessageKey.QUERY_CANCELED_ERR.name(), new String[]{aJExecutionContext.getQuery()});
            }
            return aJExecutionContext.m_hasBeenCanceled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCancel(AJExecutionContext aJExecutionContext) {
        LogUtilities.logFunctionEntrance(this.m_logger, aJExecutionContext);
        Object object = this.m_lockCancel;
        synchronized (object) {
            aJExecutionContext.m_hasBeenCanceled = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeQuery(AJExecutionContext aJExecutionContext) throws ErrorException {
        boolean bl;
        Cloneable cloneable;
        LogUtilities.logFunctionEntrance(this.m_logger, aJExecutionContext);
        QueryExecutionContext queryExecutionContext = new QueryExecutionContext().withDatabase(this.m_settings.m_schema);
        ResultConfiguration resultConfiguration = new ResultConfiguration().withOutputLocation(this.m_settings.m_s3OutputLocation);
        if (null != this.m_settings.m_s3OutputEncryptionOption) {
            cloneable = new EncryptionConfiguration().withEncryptionOption(this.m_settings.m_s3OutputEncryptionOption);
            if (this.m_settings.m_s3OutputEncryptionOption.equals("SSE_KMS") || this.m_settings.m_s3OutputEncryptionOption.equals("CSE_KMS")) {
                ((EncryptionConfiguration)cloneable).setKmsKey(this.m_settings.m_s3OutputEncryptionKmsKey);
            }
            resultConfiguration.setEncryptionConfiguration((EncryptionConfiguration)cloneable);
        }
        cloneable = new StartQueryExecutionRequest().withQueryExecutionContext(queryExecutionContext).withQueryString(aJExecutionContext.getQuery()).withResultConfiguration(resultConfiguration);
        StartQueryExecutionResult startQueryExecutionResult = null;
        this.readQueryTimeoutValue(aJExecutionContext);
        long l = 0L;
        boolean bl2 = bl = 0 < aJExecutionContext.m_queryTimeout;
        if (bl) {
            l = System.nanoTime();
        }
        Object object = this.m_lockCancel;
        synchronized (object) {
            try {
                startQueryExecutionResult = this.m_athenaClient.startQueryExecution((StartQueryExecutionRequest)cloneable);
            }
            catch (Exception exception) {
                this.checkAndThrowException(exception);
            }
            aJExecutionContext.m_queryExecId = startQueryExecutionResult.getQueryExecutionId();
        }
        object = new GetQueryExecutionRequest().withQueryExecutionId(aJExecutionContext.m_queryExecId);
        GetQueryExecutionResult getQueryExecutionResult = null;
        boolean bl3 = true;
        while (bl3) {
            String string;
            long l2;
            long l3;
            if (bl && (l3 = TimeUnit.NANOSECONDS.toSeconds((l2 = System.nanoTime()) - l)) >= (long)aJExecutionContext.m_queryTimeout) {
                this.cancelQuery(aJExecutionContext);
            }
            if ((string = (getQueryExecutionResult = this.m_athenaClient.getQueryExecution((GetQueryExecutionRequest)object)).getQueryExecution().getStatus().getState()).equals(QueryExecutionState.FAILED.toString())) {
                throw AJDriver.s_AJMessages.createGeneralException(AJMessageKey.ATHENA_CLIENT_ERROR.name(), getQueryExecutionResult.getQueryExecution().getStatus().getStateChangeReason());
            }
            if (string.equals(QueryExecutionState.CANCELLED.toString())) {
                throw new OperationCanceledException(101, AJMessageKey.QUERY_CANCELED_ERR.name(), new String[]{aJExecutionContext.getQuery()});
            }
            if (string.equals(QueryExecutionState.SUCCEEDED.toString())) {
                bl3 = false;
                return;
            }
            try {
                Thread.sleep(this.m_settings.m_queryExecPollingInterval);
            }
            catch (InterruptedException interruptedException) {
                throw AJDriver.s_AJMessages.createGeneralException(AJMessageKey.THREAD_INTERRUPTED_ERR.name(), interruptedException.getMessage());
            }
        }
    }

    public void fetchRows(AJExecutionContext aJExecutionContext, AJResultSetBuffer aJResultSetBuffer) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, aJExecutionContext);
        this.readFetchSizeValue(aJExecutionContext);
        GetQueryResultsRequest getQueryResultsRequest = new GetQueryResultsRequest().withQueryExecutionId(aJExecutionContext.m_queryExecId).withMaxResults(aJExecutionContext.m_fetchSize);
        if (null != aJExecutionContext.m_nextToken) {
            getQueryResultsRequest.withNextToken(aJExecutionContext.m_nextToken);
        }
        try {
            GetQueryResultsResult getQueryResultsResult = this.m_athenaClient.getQueryResults(getQueryResultsRequest);
            if (!aJExecutionContext.m_hasResultSetMetadata) {
                aJResultSetBuffer.setResultSetMetadata(getQueryResultsResult.getResultSet().getResultSetMetadata());
                aJExecutionContext.m_hasResultSetMetadata = true;
            }
            aJResultSetBuffer.setResultRows(getQueryResultsResult.getResultSet().getRows());
            aJExecutionContext.m_nextToken = getQueryResultsResult.getNextToken();
            aJExecutionContext.m_hasMoreRows = null != aJExecutionContext.m_nextToken;
        }
        catch (Exception exception) {
            this.checkAndThrowException(exception);
        }
    }

    public GetQueryResultsStreamResult fetchStreamResults(AJExecutionContext aJExecutionContext) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, aJExecutionContext);
        this.readFetchSizeValue(aJExecutionContext);
        GetQueryResultsStreamRequest getQueryResultsStreamRequest = new GetQueryResultsStreamRequest().withMaxResults(aJExecutionContext.m_fetchSize).withQueryExecutionId(aJExecutionContext.m_queryExecId);
        if (null != aJExecutionContext.m_nextToken) {
            getQueryResultsStreamRequest.withNextToken(aJExecutionContext.m_nextToken);
        }
        GetQueryResultsStreamResult getQueryResultsStreamResult = null;
        try {
            getQueryResultsStreamResult = this.m_streamClient.getQueryResultsStream(getQueryResultsStreamRequest);
        }
        catch (Exception exception) {
            this.checkAndThrowException(exception);
        }
        return getQueryResultsStreamResult;
    }

    public void getColumnsMetadata(String string, StringWrapperFilter stringWrapperFilter, StringWrapperFilter stringWrapperFilter2, List<AJColumnMetadata> list) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, stringWrapperFilter, stringWrapperFilter2, list);
        assert (AJMetadataRetrievalMethod.AUTO_DETECT_GLUE != this.m_settings.m_metadataRetrievalMethod);
        if (AJMetadataRetrievalMethod.GET_METADATA_FROM_GLUE == this.m_settings.m_metadataRetrievalMethod) {
            this.fetchColumnsMetadataWithGlue(string, stringWrapperFilter, stringWrapperFilter2, list);
        } else {
            this.fetchColumnsMetadataWithQuery(string, stringWrapperFilter, stringWrapperFilter2, list);
        }
    }

    public void getSchemas(List<String> list) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, list);
        assert (AJMetadataRetrievalMethod.AUTO_DETECT_GLUE != this.m_settings.m_metadataRetrievalMethod);
        if (AJMetadataRetrievalMethod.GET_METADATA_FROM_GLUE == this.m_settings.m_metadataRetrievalMethod) {
            this.fetchSchemasWithGlue(list);
        } else {
            this.fetchSchemasWithQuery(list);
        }
    }

    public void getTablesMetadata(String string, List<AJTableMetadata> list) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, list);
        assert (AJMetadataRetrievalMethod.AUTO_DETECT_GLUE != this.m_settings.m_metadataRetrievalMethod);
        if (AJMetadataRetrievalMethod.GET_METADATA_FROM_GLUE == this.m_settings.m_metadataRetrievalMethod) {
            ArrayList<Table> arrayList = new ArrayList<Table>();
            this.fetchTablesWithGlue(string, arrayList);
            for (Table table : arrayList) {
                String string2 = table.getTableType();
                if (this.m_settings.m_forceTableTypeTable) {
                    string2 = "TABLE";
                } else if (null == string2 || string2.isEmpty()) {
                    string2 = "EXTERNAL_TABLE";
                }
                list.add(new AJTableMetadata("AwsDataCatalog", string, table.getName(), string2));
            }
        } else {
            ArrayList<String> arrayList = new ArrayList<String>();
            this.fetchTablesWithQuery(string, arrayList);
            for (String string3 : arrayList) {
                list.add(new AJTableMetadata("AwsDataCatalog", string, string3, "TABLE"));
            }
        }
    }

    private void addColumnMetadata(String string, String string2, String string3, String string4, int n, String string5, List<AJColumnMetadata> list) throws ErrorException {
        int n2 = AJTypeUtilities.mapAthenaTypeNameToSqlType(string5, this.m_settings);
        String string6 = AJTypeUtilities.canonicalizeTypeName(string5);
        Pair<Integer, Integer> pair = AJTypeUtilities.extractDecimalPrecisionAndScale(string5);
        int n3 = AJTypeUtilities.extractCharacterTypeColMaxLen(string5);
        if (string6.equalsIgnoreCase("string")) {
            n3 = this.m_settings.m_stringColumnLength;
        } else if (AJTypeUtilities.isComplexType(string6)) {
            n3 = this.m_settings.m_complexTypeColumnLength;
        }
        int n4 = this.m_settings.m_binaryColumnLength;
        string6 = string6.equalsIgnoreCase("varchar") ? AJTypeUtilities.rectifyTypeName(string6, n3) : AJTypeUtilities.rectifyTypeName(string6);
        list.add(new AJColumnMetadata("AwsDataCatalog", string, string2, string3, n2, string6, string4, n, pair.key(), pair.value(), n3, n4));
    }

    private void checkAthenaConnection() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            if (AJMetadataRetrievalMethod.GET_METADATA_FROM_GLUE == this.m_settings.m_metadataRetrievalMethod) {
                LogUtilities.logDebug("Testing connection with getDatabases().", this.m_logger);
                GetDatabasesRequest getDatabasesRequest = new GetDatabasesRequest().withMaxResults(1);
                GetDatabasesResult getDatabasesResult = this.m_glueClient.getDatabases(getDatabasesRequest);
                getDatabasesResult.getDatabaseList();
            } else {
                LogUtilities.logDebug("Testing connection with query.", this.m_logger);
                AJExecutionContext aJExecutionContext = new AJExecutionContext();
                aJExecutionContext.setQuery("SELECT 1");
                this.executeQuery(aJExecutionContext);
            }
        }
        catch (Exception exception) {
            if (null != exception && exception instanceof SdkClientException && null != exception.getCause() && exception.getCause() instanceof ConnectTimeoutException) {
                throw new ErrorException(DiagState.DIAG_CONN_TIMEOUT_EXPIRED, 105, CommonJDBCMessageKey.CONN_LOGINTIMEOUT_ERR.name(), new String[]{null == exception.getCause().getMessage() ? "None" : exception.getCause().getMessage()});
            }
            if (null != exception && null != exception.getCause() && exception.getCause() instanceof SdkClientException && null != exception.getCause().getCause() && exception.getCause().getCause() instanceof ConnectTimeoutException) {
                throw new ErrorException(DiagState.DIAG_CONN_TIMEOUT_EXPIRED, 105, CommonJDBCMessageKey.CONN_LOGINTIMEOUT_ERR.name(), new String[]{null == exception.getCause().getMessage() ? "None" : exception.getCause().getMessage()});
            }
            if (null != exception && exception instanceof ErrorException) {
                throw (ErrorException)exception;
            }
            throw DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_UNEXP_SESSION_ERR.name(), null == exception.getMessage() ? "Unknown" : exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkGlueSupport(AWSCredentialsProvider aWSCredentialsProvider) throws ErrorException {
        ArrayList<String> arrayList;
        Object object;
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            LogUtilities.logDebug("Performing AWS Glue availability detection.", this.m_logger);
            LogUtilities.logDebug("Aws::Glue - GlueClient - getCatalogImportStatus +++++ enter +++++", this.m_logger);
            object = new ClientConfiguration(this.m_settings.m_clientConfig);
            ((ClientConfiguration)object).withRetryPolicy(AJ_GLUE_DETECTION_RETRY_POLICY).withMaxErrorRetry(this.m_settings.m_glueDetectionMaxRetry);
            arrayList = AWSGlueClientBuilder.standard();
            ((AWSGlueClientBuilder)((AWSGlueClientBuilder)((AwsClientBuilder)((Object)arrayList)).withRegion(this.m_settings.m_awsRegion)).withClientConfiguration((ClientConfiguration)object)).withCredentials(aWSCredentialsProvider);
            AWSGlue aWSGlue = (AWSGlue)((AwsSyncClientBuilder)((Object)arrayList)).build();
            GetCatalogImportStatusRequest getCatalogImportStatusRequest = new GetCatalogImportStatusRequest();
            GetCatalogImportStatusResult getCatalogImportStatusResult = aWSGlue.getCatalogImportStatus(getCatalogImportStatusRequest);
            if (null != getCatalogImportStatusResult) {
                this.m_settings.m_metadataRetrievalMethod = getCatalogImportStatusResult.getImportStatus().isImportCompleted() != false ? AJMetadataRetrievalMethod.GET_METADATA_FROM_GLUE : AJMetadataRetrievalMethod.GET_METADATA_WITH_QUERY;
                LogUtilities.logDebug("GetCatalogImportStatusResult is valid. Setting metadata retrieval method as: " + this.m_settings.m_metadataRetrievalMethod.toString(), this.m_logger);
                this.m_settings.m_performConnectionTest = false;
                return;
            }
            LogUtilities.logDebug("GetCatalogImportStatusResult is invalid. GetCatalogImportStatusResult is null.", this.m_logger);
        }
        catch (Exception exception) {
            arrayList = "An exception was caught during AWS Glue availability detection operation. Detail: " + exception;
            LogUtilities.logDebug((String)((Object)arrayList), this.m_logger);
            if (exception instanceof SdkClientException && null != exception.getCause() && exception.getCause() instanceof UnknownHostException) {
                this.m_settings.m_metadataRetrievalMethod = AJMetadataRetrievalMethod.GET_METADATA_WITH_QUERY;
                return;
            }
        }
        finally {
            LogUtilities.logDebug("Aws::Glue - GlueClient - getCatalogImportStatus ----- exit -----", this.m_logger);
        }
        LogUtilities.logDebug("Trying to detect AWS Glue availability by comparing the schema list returned by GetDatabases Glue API and SHOW SCHEMAS query.", this.m_logger);
        object = new ArrayList();
        arrayList = new ArrayList<String>();
        this.m_settings.m_metadataRetrievalMethod = AJMetadataRetrievalMethod.GET_METADATA_FROM_GLUE;
        try {
            this.fetchSchemasWithGlue((List<String>)object);
        }
        catch (ErrorException errorException) {
            LogUtilities.logError(errorException, this.m_logger);
            this.m_settings.m_metadataRetrievalMethod = AJMetadataRetrievalMethod.GET_METADATA_WITH_QUERY;
            return;
        }
        this.fetchSchemasWithQuery(arrayList);
        if (!object.equals(arrayList)) {
            this.m_settings.m_metadataRetrievalMethod = AJMetadataRetrievalMethod.GET_METADATA_WITH_QUERY;
        }
    }

    private void fetchColumnsMetadataWithGlue(String string, StringWrapperFilter stringWrapperFilter, StringWrapperFilter stringWrapperFilter2, List<AJColumnMetadata> list) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        ArrayList<Table> arrayList = new ArrayList<Table>();
        this.fetchTablesWithGlue(string, arrayList);
        for (Table table : arrayList) {
            if (!stringWrapperFilter.filter(table.getName())) continue;
            List<Column> list2 = table.getStorageDescriptor().getColumns();
            list2.addAll(table.getPartitionKeys());
            int n = 0;
            for (Column column : list2) {
                String string2 = column.getName();
                if (!stringWrapperFilter2.filter(string2)) continue;
                String string3 = column.getType();
                String string4 = column.getComment();
                this.addColumnMetadata(string, table.getName(), string2, string4, ++n, string3, list);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void fetchColumnsMetadataWithQuery(String string, StringWrapperFilter stringWrapperFilter, StringWrapperFilter stringWrapperFilter2, List<AJColumnMetadata> list) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        ArrayList<String> arrayList = new ArrayList<String>();
        this.fetchTablesWithQuery(string, arrayList);
        for (String string2 : arrayList) {
            if (!stringWrapperFilter.filter(string2)) continue;
            String string3 = "DESCRIBE `" + string + "`.`" + string2 + "`";
            AJExecutionContext aJExecutionContext = new AJExecutionContext();
            aJExecutionContext.setQuery(string3);
            this.executeQuery(aJExecutionContext);
            AJResultSetBuffer aJResultSetBuffer = new AJResultSetBuffer();
            int n = 0;
            block1: do {
                String string4;
                String string5;
                Object object;
                this.fetchRows(aJExecutionContext, aJResultSetBuffer);
                List<Row> list2 = aJResultSetBuffer.getResultRows();
                int n2 = aJResultSetBuffer.getResultSetMetadata().getColumnInfo().size();
                int n3 = aJResultSetBuffer.getResultRows().get(0).getData().size();
                if (n2 != n3) {
                    if (1 != n3) throw AJDriver.s_AJMessages.createGeneralException(AJMessageKey.UNEXPECTED_NUM_RESULT_COLUMNS, new String[]{String.valueOf(n3), String.valueOf(n2)});
                    for (Row row : list2) {
                        object = new ArrayList();
                        AJUtilities.parseCellAsTabDelimited(this.m_logger, row.getData().get(0).getVarCharValue(), n2, (List<String>)object);
                        String string6 = string5 = this.m_settings.m_rightTrimNonGlueColumnName ? AJUtilities.rtrim((String)object.get(0)) : (String)object.get(0);
                        if (null == string5 || string5.trim().isEmpty()) continue block1;
                        if (!stringWrapperFilter2.filter(string5)) continue;
                        string4 = (String)object.get(1);
                        String string7 = (String)object.get(2);
                        this.addColumnMetadata(string, string2, string5, string7, ++n, string4.trim(), list);
                    }
                } else {
                    for (Row row : list2) {
                        object = row.getData().get(0).getVarCharValue();
                        if (!stringWrapperFilter2.filter((String)object)) continue;
                        string5 = row.getData().get(1).getVarCharValue();
                        string4 = row.getData().get(2).getVarCharValue();
                        this.addColumnMetadata(string, string2, (String)object, string4, ++n, string5.trim(), list);
                    }
                }
            } while (aJExecutionContext.m_hasMoreRows);
        }
    }

    private void fetchSchemasWithGlue(List<String> list) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        String string = null;
        do {
            GetDatabasesRequest getDatabasesRequest = new GetDatabasesRequest().withMaxResults(this.nonStreamFetchSizeCorrection(this.m_settings.m_rowsToFetchPerBlock));
            if (null != string) {
                getDatabasesRequest.withNextToken(string);
            }
            LogUtilities.logDebug("Aws::Glue - GlueClient - GetDatabases +++++ enter +++++", this.m_logger);
            GetDatabasesResult getDatabasesResult = null;
            try {
                getDatabasesResult = this.m_glueClient.getDatabases(getDatabasesRequest);
            }
            catch (Exception exception) {
                this.checkAndThrowException(exception);
            }
            LogUtilities.logDebug("Aws::Glue - GlueClient - GetDatabases ----- exit -----", this.m_logger);
            List<Database> list2 = getDatabasesResult.getDatabaseList();
            for (Database database : list2) {
                if (null == database.getName() || database.getName().isEmpty()) {
                    LogUtilities.logInfo("A schema with empty name was encountered and ignored when fetching list of schemas.", this.m_logger);
                    continue;
                }
                list.add(database.getName());
            }
            string = getDatabasesResult.getNextToken();
            this.m_settings.m_performConnectionTest = false;
        } while (null != string);
    }

    private void fetchSchemasWithQuery(List<String> list) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        String string = "SHOW SCHEMAS";
        this.getMetadataStringResults(string, list);
        this.m_settings.m_performConnectionTest = false;
    }

    private void fetchTablesWithGlue(String string, List<Table> list) throws ErrorException {
        GetTablesResult getTablesResult;
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        String string2 = null;
        do {
            GetTablesRequest getTablesRequest = new GetTablesRequest().withDatabaseName(string).withMaxResults(this.nonStreamFetchSizeCorrection(this.m_settings.m_rowsToFetchPerBlock));
            if (null != string2) {
                getTablesRequest.withNextToken(string2);
            }
            LogUtilities.logDebug("Aws::Glue - GlueClient - GetTables +++++ enter +++++", this.m_logger);
            getTablesResult = null;
            try {
                getTablesResult = this.m_glueClient.getTables(getTablesRequest);
            }
            catch (Exception exception) {
                this.checkAndThrowException(exception);
            }
            LogUtilities.logDebug("Aws::Glue - GlueClient - GetTables ----- exit -----", this.m_logger);
            List<Table> list2 = getTablesResult.getTableList();
            list.addAll(list2);
        } while (null != (string2 = getTablesResult.getNextToken()));
    }

    private void fetchTablesWithQuery(String string, List<String> list) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        String string2 = "SHOW TABLES IN `" + string + "`";
        this.getMetadataStringResults(string2, list);
    }

    private void getMetadataStringResults(String string, List<String> list) throws ErrorException {
        AJExecutionContext aJExecutionContext = new AJExecutionContext();
        aJExecutionContext.setQuery(string);
        this.executeQuery(aJExecutionContext);
        AJResultSetBuffer aJResultSetBuffer = new AJResultSetBuffer();
        do {
            this.fetchRows(aJExecutionContext, aJResultSetBuffer);
            ListIterator<Row> listIterator = aJResultSetBuffer.getResultRows().listIterator(0);
            while (listIterator.hasNext()) {
                Datum datum = listIterator.next().getData().get(0);
                list.add(datum.getVarCharValue());
            }
        } while (aJExecutionContext.m_hasMoreRows);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFetchSizeValue(AJExecutionContext aJExecutionContext) {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            Variant variant = aJExecutionContext.m_statement.getProperty(6);
            int n = variant.getInt();
            aJExecutionContext.m_fetchSize = 0 < n ? (n < this.m_settings.m_rowsToFetchPerBlock ? n : this.m_settings.m_rowsToFetchPerBlock) : this.m_settings.m_rowsToFetchPerBlock;
        }
        catch (Exception exception) {
            aJExecutionContext.m_fetchSize = this.m_settings.m_rowsToFetchPerBlock;
        }
        finally {
            if (!aJExecutionContext.m_fetchWithStream) {
                aJExecutionContext.m_fetchSize = this.nonStreamFetchSizeCorrection(aJExecutionContext.m_fetchSize);
            }
        }
    }

    private void readQueryTimeoutValue(AJExecutionContext aJExecutionContext) {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            Variant variant = aJExecutionContext.m_statement.getProperty(3);
            if (-1 < variant.getInt()) {
                aJExecutionContext.m_queryTimeout = variant.getInt();
            }
        }
        catch (Exception exception) {
            aJExecutionContext.m_queryTimeout = 0;
        }
    }

    private int nonStreamFetchSizeCorrection(int n) {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (n > this.m_settings.m_maxNumRowsToFetchPerBlock) {
            return this.m_settings.m_maxNumRowsToFetchPerBlock;
        }
        return n;
    }
}

