/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.services.glue.model.transform;

import com.simba.athena.amazonaws.services.glue.model.Column;
import com.simba.athena.amazonaws.services.glue.model.Table;
import com.simba.athena.amazonaws.services.glue.model.transform.ColumnJsonUnmarshaller;
import com.simba.athena.amazonaws.services.glue.model.transform.StorageDescriptorJsonUnmarshaller;
import com.simba.athena.amazonaws.transform.JsonUnmarshallerContext;
import com.simba.athena.amazonaws.transform.ListUnmarshaller;
import com.simba.athena.amazonaws.transform.MapUnmarshaller;
import com.simba.athena.amazonaws.transform.Unmarshaller;
import com.simba.athena.shaded.fasterxml.jackson.core.JsonToken;
import java.util.Date;

public class TableJsonUnmarshaller
implements Unmarshaller<Table, JsonUnmarshallerContext> {
    private static TableJsonUnmarshaller instance;

    @Override
    public Table unmarshall(JsonUnmarshallerContext context) throws Exception {
        Table table = new Table();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    table.setName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("DatabaseName", targetDepth)) {
                    context.nextToken();
                    table.setDatabaseName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Description", targetDepth)) {
                    context.nextToken();
                    table.setDescription(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Owner", targetDepth)) {
                    context.nextToken();
                    table.setOwner(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("CreateTime", targetDepth)) {
                    context.nextToken();
                    table.setCreateTime(context.getUnmarshaller(Date.class).unmarshall(context));
                }
                if (context.testExpression("UpdateTime", targetDepth)) {
                    context.nextToken();
                    table.setUpdateTime(context.getUnmarshaller(Date.class).unmarshall(context));
                }
                if (context.testExpression("LastAccessTime", targetDepth)) {
                    context.nextToken();
                    table.setLastAccessTime(context.getUnmarshaller(Date.class).unmarshall(context));
                }
                if (context.testExpression("LastAnalyzedTime", targetDepth)) {
                    context.nextToken();
                    table.setLastAnalyzedTime(context.getUnmarshaller(Date.class).unmarshall(context));
                }
                if (context.testExpression("Retention", targetDepth)) {
                    context.nextToken();
                    table.setRetention(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("StorageDescriptor", targetDepth)) {
                    context.nextToken();
                    table.setStorageDescriptor(StorageDescriptorJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("PartitionKeys", targetDepth)) {
                    context.nextToken();
                    table.setPartitionKeys(new ListUnmarshaller<Column>(ColumnJsonUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("ViewOriginalText", targetDepth)) {
                    context.nextToken();
                    table.setViewOriginalText(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ViewExpandedText", targetDepth)) {
                    context.nextToken();
                    table.setViewExpandedText(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("TableType", targetDepth)) {
                    context.nextToken();
                    table.setTableType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Parameters", targetDepth)) {
                    context.nextToken();
                    table.setParameters(new MapUnmarshaller<String, String>(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("CreatedBy", targetDepth)) {
                    context.nextToken();
                    table.setCreatedBy(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return table;
    }

    public static TableJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new TableJsonUnmarshaller();
        }
        return instance;
    }
}

