/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.jdbc.jdbc41;

import com.simba.athena.dsi.core.interfaces.IConnection;
import com.simba.athena.dsi.core.utilities.PropertyUtilities;
import com.simba.athena.dsi.core.utilities.Variant;
import com.simba.athena.dsi.dataengine.interfaces.IArray;
import com.simba.athena.exceptions.ExceptionConverter;
import com.simba.athena.exceptions.JDBCMessageKey;
import com.simba.athena.jdbc.common.SConnection;
import com.simba.athena.jdbc.jdbc41.S41Array;
import com.simba.athena.support.LogUtilities;
import com.simba.athena.support.exceptions.ExceptionType;
import com.simba.athena.utilities.FunctionID;
import java.sql.Array;
import java.sql.SQLException;
import java.sql.SQLPermission;
import java.util.concurrent.Executor;

public class S41Connection
extends SConnection {
    private static final SQLPermission ABORT_PERM = new SQLPermission("callAbort");

    public S41Connection(IConnection iConnection, String string) throws SQLException {
        super(iConnection, string);
    }

    @Override
    public void setSchema(String string) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string);
            this.checkIfOpen();
            if (!PropertyUtilities.hasSchemaSupport(this.m_connection)) {
                return;
            }
            Variant variant = null;
            variant = null == string ? new Variant(0, "") : new Variant(0, string);
            this.m_warningListener.clearAndSetFunction(FunctionID.CONNECTION_SET_PROPERTY);
            this.m_connection.setProperty(1008, variant);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getSchema() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (!PropertyUtilities.hasSchemaSupport(this.m_connection)) {
                return null;
            }
            Variant variant = this.m_connection.getProperty(1008);
            return variant.getString();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void abort(Executor executor) throws SQLException, SecurityException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            SecurityManager securityManager = System.getSecurityManager();
            if (null != securityManager) {
                securityManager.checkPermission(ABORT_PERM);
            }
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    block2: {
                        try {
                            S41Connection.this.abortInternal();
                        }
                        catch (SQLException sQLException) {
                            if (null == S41Connection.this.m_logger) break block2;
                            LogUtilities.logError(sQLException, S41Connection.this.m_logger);
                        }
                    }
                }
            });
            this.markConnectionClosed();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void setNetworkTimeout(Executor executor, int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n);
        this.checkIfOpen();
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.m_logger);
        throw sQLException;
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.checkIfOpen();
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.m_logger);
        throw sQLException;
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, objectArray);
            IConnection iConnection = this.getDSIConnection();
            IArray iArray = iConnection.createArrayOf(string, objectArray);
            return new S41Array(iArray, iConnection, this.m_logger, this.m_warningListener);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }
}

