/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.athena.dataengine;

import com.simba.athena.athena.core.AJDriver;
import com.simba.athena.athena.exceptions.AJMessageKey;
import com.simba.athena.athena.utilities.AJTypeUtilities;
import com.simba.athena.support.EscapeTypes;
import com.simba.athena.support.IReplacerChecked;
import com.simba.athena.support.Pair;
import com.simba.athena.support.exceptions.ErrorException;
import java.util.ArrayList;

public class AJReplacer
implements IReplacerChecked<ErrorException> {
    @Override
    public StringBuilder replace(EscapeTypes escapeTypes, ArrayList<StringBuilder> arrayList) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder();
        switch (escapeTypes) {
            case PARAM: {
                return stringBuilder.append("?");
            }
            case ESCAPE: {
                return stringBuilder.append("ESCAPE ").append((CharSequence)arrayList.get(0));
            }
            case LIMIT_OFFSET: {
                if (arrayList.size() == 1) {
                    return stringBuilder.append("LIMIT ").append((CharSequence)arrayList.get(0));
                }
                if (arrayList.size() == 2) {
                    return stringBuilder.append("LIMIT ").append((CharSequence)arrayList.get(0)).append(" OFFSET ").append((CharSequence)arrayList.get(1));
                }
            }
            case DATE: 
            case TIME: 
            case TIMESTAMP: {
                return stringBuilder.append(escapeTypes.name()).append(" ").append((CharSequence)arrayList.get(0));
            }
            case OUTERJOIN: {
                int n = arrayList.size();
                stringBuilder.append("(");
                for (int i = 0; i < n; ++i) {
                    stringBuilder.append((CharSequence)arrayList.get(i));
                    if (i == n - 1) continue;
                    stringBuilder.append(" ");
                }
                return stringBuilder.append(")");
            }
            case FN: {
                String string = arrayList.get(0).toString().toUpperCase();
                if (string.equals(JDBCScalarFunctions.COT.name())) {
                    this.replacerCheck(arrayList, 2);
                    return stringBuilder.append("1/Tan(").append((CharSequence)arrayList.get(1)).append(")");
                }
                if (string.equals(JDBCScalarFunctions.LOG.name())) {
                    this.replacerCheck(arrayList, 2);
                    return stringBuilder.append("LN(").append((CharSequence)arrayList.get(1)).append(")");
                }
                if (string.equals(JDBCScalarFunctions.RAND.name())) {
                    if (1 == arrayList.size()) {
                        return stringBuilder.append("RANDOM()");
                    }
                    if (2 == arrayList.size()) {
                        return stringBuilder.append("RANDOM(").append((CharSequence)arrayList.get(1)).append(")");
                    }
                    this.replacerCheck(arrayList, 2);
                } else {
                    if (string.equals(JDBCScalarFunctions.TRUNCATE.name())) {
                        this.replacerCheck(arrayList, 3);
                        return stringBuilder.append("ROUND(").append((CharSequence)arrayList.get(1)).append(", ").append((CharSequence)arrayList.get(2)).append(")");
                    }
                    if (string.equals(JDBCScalarFunctions.CHAR.name())) {
                        this.replacerCheck(arrayList, 2);
                        return stringBuilder.append("CHR(").append((CharSequence)arrayList.get(1)).append(")");
                    }
                    if (string.equals(JDBCScalarFunctions.CHAR_LENGTH.name()) || string.equals(JDBCScalarFunctions.CHARACTER_LENGTH.name())) {
                        this.replacerCheck(arrayList, 2);
                        return stringBuilder.append("LENGTH(").append((CharSequence)arrayList.get(1)).append(")");
                    }
                    if (string.equals(JDBCScalarFunctions.INSERT.name())) {
                        this.replacerCheck(arrayList, 5);
                        return stringBuilder.append("CONCAT(SUBSTR(").append((CharSequence)arrayList.get(1)).append(", 1, ").append((CharSequence)arrayList.get(2)).append("-1), ").append((CharSequence)arrayList.get(4)).append(", SUBSTR(").append((CharSequence)arrayList.get(1)).append(", ").append((CharSequence)arrayList.get(2)).append("+").append((CharSequence)arrayList.get(3)).append("))");
                    }
                    if (string.equals(JDBCScalarFunctions.LCASE.name())) {
                        this.replacerCheck(arrayList, 2);
                        return stringBuilder.append("LOWER(").append((CharSequence)arrayList.get(1)).append(")");
                    }
                    if (string.equals(JDBCScalarFunctions.LEFT.name())) {
                        this.replacerCheck(arrayList, 3);
                        return stringBuilder.append("SUBSTR(").append((CharSequence)arrayList.get(1)).append(", 1, ").append((CharSequence)arrayList.get(2)).append(")");
                    }
                    if (string.equals(JDBCScalarFunctions.LOCATE.name())) {
                        this.replacerCheck(arrayList, 3, 4);
                        if (3 == arrayList.size()) {
                            return stringBuilder.append("STRPOS(").append((CharSequence)arrayList.get(2)).append(", ").append((CharSequence)arrayList.get(1)).append(")");
                        }
                        return stringBuilder.append("STRPOS(SUBSTR(").append((CharSequence)arrayList.get(2)).append(", ").append((CharSequence)arrayList.get(3)).append("), ").append((CharSequence)arrayList.get(1)).append(")");
                    }
                    if (string.equals(JDBCScalarFunctions.REPEAT.name())) {
                        this.replacerCheck(arrayList, 3);
                        try {
                            int n = Integer.valueOf(arrayList.get(2).toString());
                            if (0 >= n) {
                                return stringBuilder.append("''");
                            }
                            if (1 == n) {
                                return arrayList.get(1);
                            }
                            stringBuilder.append("CONCAT(");
                            for (int i = 0; i < n; ++i) {
                                stringBuilder.append((CharSequence)arrayList.get(1));
                                if (n - 1 <= i) continue;
                                stringBuilder.append(", ");
                            }
                            return stringBuilder.append(")");
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw AJDriver.s_AJMessages.createGeneralException(AJMessageKey.GENERAL_ERROR, (Throwable)numberFormatException);
                        }
                    }
                    if (string.equals(JDBCScalarFunctions.RIGHT.name())) {
                        this.replacerCheck(arrayList, 3);
                        return stringBuilder.append("SUBSTR(").append((CharSequence)arrayList.get(1)).append(", -(").append((CharSequence)arrayList.get(2)).append("))");
                    }
                    if (string.equals(JDBCScalarFunctions.SPACE.name())) {
                        this.replacerCheck(arrayList, 2);
                        try {
                            int n = Integer.valueOf(arrayList.get(1).toString());
                            if (0 >= n) {
                                return stringBuilder.append("''");
                            }
                            if (1 == n) {
                                return stringBuilder.append("' '");
                            }
                            stringBuilder.append("CONCAT(");
                            for (int i = 0; i < n; ++i) {
                                stringBuilder.append("' '");
                                if (n - 1 <= i) continue;
                                stringBuilder.append(", ");
                            }
                            return stringBuilder.append(")");
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw AJDriver.s_AJMessages.createGeneralException(AJMessageKey.GENERAL_ERROR, numberFormatException.getMessage());
                        }
                    }
                    if (string.equals(JDBCScalarFunctions.SUBSTRING.name())) {
                        this.replacerCheck(arrayList, 4);
                        return stringBuilder.append("SUBSTR(").append((CharSequence)arrayList.get(1)).append(", ").append((CharSequence)arrayList.get(2)).append(", ").append((CharSequence)arrayList.get(3)).append(")");
                    }
                    if (string.equals(JDBCScalarFunctions.UCASE.name())) {
                        this.replacerCheck(arrayList, 2);
                        return stringBuilder.append("UPPER(").append((CharSequence)arrayList.get(1)).append(")");
                    }
                    if (string.equals(JDBCScalarFunctions.CURRENT_DATE.name()) || string.equals(JDBCScalarFunctions.CURDATE.name())) {
                        this.replacerCheck(arrayList, 2);
                        return stringBuilder.append("CURRENT_DATE");
                    }
                    if (string.equals(JDBCScalarFunctions.CURRENT_TIME.name()) || string.equals(JDBCScalarFunctions.CURTIME.name())) {
                        this.replacerCheck(arrayList, 2);
                        return stringBuilder.append("CURRENT_TIME");
                    }
                    if (string.equals(JDBCScalarFunctions.CURRENT_TIMESTAMP.name())) {
                        this.replacerCheck(arrayList, 2);
                        return stringBuilder.append("CURRENT_TIMESTAMP");
                    }
                    if (string.equals(JDBCScalarFunctions.DAYNAME.name())) {
                        this.replacerCheck(arrayList, 2);
                        return stringBuilder.append("DATE_FORMAT(").append("CAST(").append((CharSequence)arrayList.get(1)).append(" AS DATE)").append(", '%a')");
                    }
                    if (string.equals(JDBCScalarFunctions.DAYOFMONTH.name())) {
                        this.replacerCheck(arrayList, 2);
                        return stringBuilder.append("DAY_OF_MONTH(").append("CAST(").append((CharSequence)arrayList.get(1)).append(" AS DATE)").append(")");
                    }
                    if (string.equals(JDBCScalarFunctions.DAYOFWEEK.name())) {
                        this.replacerCheck(arrayList, 2);
                        StringBuilder stringBuilder2 = new StringBuilder();
                        stringBuilder2.append("DAY_OF_WEEK(").append("CAST(").append((CharSequence)arrayList.get(1)).append(" AS DATE)").append(")");
                        return stringBuilder.append("CASE ").append((CharSequence)stringBuilder2).append(" WHEN 7 THEN 1 ELSE ").append((CharSequence)stringBuilder2).append(" + 1 END");
                    }
                    if (string.equals(JDBCScalarFunctions.DAYOFYEAR.name())) {
                        this.replacerCheck(arrayList, 2);
                        return stringBuilder.append("DAY_OF_YEAR(").append("CAST(").append((CharSequence)arrayList.get(1)).append(" AS DATE)").append(")");
                    }
                    if (string.equals(JDBCScalarFunctions.MONTHNAME.name())) {
                        this.replacerCheck(arrayList, 2);
                        return stringBuilder.append("DATE_FORMAT(").append("CAST(").append((CharSequence)arrayList.get(1)).append(" AS DATE)").append(", '%M')");
                    }
                    if (string.equals(JDBCScalarFunctions.TIMESTAMPADD.name())) {
                        this.replacerCheck(arrayList, 4);
                        return stringBuilder.append("DATE_ADD('").append(this.getIntervalType(arrayList.get(1).toString())).append("', ").append((CharSequence)arrayList.get(2)).append(", ").append((CharSequence)arrayList.get(3)).append(")");
                    }
                    if (string.equals(JDBCScalarFunctions.TIMESTAMPDIFF.name())) {
                        this.replacerCheck(arrayList, 4);
                        return stringBuilder.append("DATE_DIFF('").append(this.getIntervalType(arrayList.get(1).toString())).append("', ").append((CharSequence)arrayList.get(2)).append(", ").append((CharSequence)arrayList.get(3)).append(")");
                    }
                    if (string.equals(JDBCScalarFunctions.IFNULL.name())) {
                        this.replacerCheck(arrayList, 3);
                        return stringBuilder.append("IF(").append((CharSequence)arrayList.get(1)).append(" IS NULL, ").append((CharSequence)arrayList.get(2)).append(", ").append((CharSequence)arrayList.get(1)).append(")");
                    }
                    if (string.equals(JDBCScalarFunctions.CONVERT.name())) {
                        this.replacerCheck(arrayList, 3);
                        return this.getCastClause(arrayList);
                    }
                }
                return this.createFuncOrProc(arrayList);
            }
        }
        throw AJDriver.s_AJMessages.createGeneralException(AJMessageKey.UNSUPPORTED_ESCAPE_SEQ_ERR.name());
    }

    private StringBuilder createFuncOrProc(ArrayList<StringBuilder> arrayList) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((CharSequence)arrayList.get(0)).append("(");
        int n = arrayList.size();
        for (int i = 1; i < n; ++i) {
            stringBuilder.append((CharSequence)arrayList.get(i));
            if (n - 1 == i) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.append(")");
    }

    private StringBuilder getCastClause(ArrayList<StringBuilder> arrayList) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder();
        String string = AJTypeUtilities.mapSQLTypeNameToAthenaTypeName(arrayList.get(2).toString());
        if (AJTypeUtilities.isCharacterType(string)) {
            int n = AJTypeUtilities.extractCharacterTypeColMaxLen(arrayList.get(2).toString());
            string = string + "(" + String.valueOf(n) + ")";
        } else if (string.equalsIgnoreCase("decimal")) {
            Pair<Integer, Integer> pair = AJTypeUtilities.extractDecimalPrecisionAndScale(arrayList.get(2).toString());
            string = string + "(" + String.valueOf(pair.key()) + ", " + String.valueOf(pair.value()) + ")";
        }
        return stringBuilder.append("CAST(").append((CharSequence)arrayList.get(1)).append(" AS ").append(string).append(")");
    }

    private String getIntervalType(String string) {
        if (string.equalsIgnoreCase(SQLIntervalTypes.SQL_TSI_FRAC_SECOND.name())) {
            return "millisecond";
        }
        if (string.equalsIgnoreCase(SQLIntervalTypes.SQL_TSI_SECOND.name())) {
            return "second";
        }
        if (string.equalsIgnoreCase(SQLIntervalTypes.SQL_TSI_MINUTE.name())) {
            return "minute";
        }
        if (string.equalsIgnoreCase(SQLIntervalTypes.SQL_TSI_HOUR.name())) {
            return "hour";
        }
        if (string.equalsIgnoreCase(SQLIntervalTypes.SQL_TSI_DAY.name())) {
            return "day";
        }
        if (string.equalsIgnoreCase(SQLIntervalTypes.SQL_TSI_WEEK.name())) {
            return "week";
        }
        if (string.equalsIgnoreCase(SQLIntervalTypes.SQL_TSI_MONTH.name())) {
            return "month";
        }
        if (string.equalsIgnoreCase(SQLIntervalTypes.SQL_TSI_QUARTER.name())) {
            return "quarter";
        }
        if (string.equalsIgnoreCase(SQLIntervalTypes.SQL_TSI_YEAR.name())) {
            return "year";
        }
        return string;
    }

    private void replacerCheck(ArrayList<StringBuilder> arrayList, int n) throws ErrorException {
        if (n != arrayList.size()) {
            throw AJDriver.s_AJMessages.createGeneralException(AJMessageKey.WRONG_SCALAR_FUNC_PARAM_NUM.name(), this.createFuncOrProc(arrayList).toString());
        }
    }

    private void replacerCheck(ArrayList<StringBuilder> arrayList, int n, int n2) throws ErrorException {
        if (n > arrayList.size() || n2 < arrayList.size()) {
            throw AJDriver.s_AJMessages.createGeneralException(AJMessageKey.WRONG_SCALAR_FUNC_PARAM_NUM.name(), this.createFuncOrProc(arrayList).toString());
        }
    }

    public static enum SQLIntervalTypes {
        SQL_TSI_FRAC_SECOND,
        SQL_TSI_SECOND,
        SQL_TSI_MINUTE,
        SQL_TSI_HOUR,
        SQL_TSI_DAY,
        SQL_TSI_WEEK,
        SQL_TSI_MONTH,
        SQL_TSI_QUARTER,
        SQL_TSI_YEAR;

    }

    public static enum JDBCScalarFunctions {
        ABS,
        ACOS,
        ASIN,
        ATAN,
        ATAN2,
        CEILING,
        COS,
        COT,
        DEGREES,
        EXP,
        FLOOR,
        LOG,
        LOG10,
        MOD,
        PI,
        POWER,
        RADIANS,
        RAND,
        ROUND,
        SIGN,
        SIN,
        SQRT,
        TAN,
        TRUNCATE,
        ASCII,
        CHAR,
        CHAR_LENGTH,
        CHARACTER_LENGTH,
        CONCAT,
        DIFFERENCE,
        INSERT,
        LCASE,
        LEFT,
        LENGTH,
        LOCATE,
        LTRIM,
        OCTET_LENGTH,
        POSITION,
        REPEAT,
        REPLACE,
        RIGHT,
        RTRIM,
        SOUNDEX,
        SPACE,
        SUBSTRING,
        UCASE,
        CURRENT_DATE,
        CURRENT_TIME,
        CURRENT_TIMESTAMP,
        CURDATE,
        CURTIME,
        DAYNAME,
        DAYOFMONTH,
        DAYOFWEEK,
        DAYOFYEAR,
        EXTRACT,
        HOUR,
        MINUTE,
        MONTH,
        MONTHNAME,
        NOW,
        QUARTER,
        SECOND,
        TIMESTAMPADD,
        TIMESTAMPDIFF,
        WEEK,
        YEAR,
        DATABASE,
        IFNULL,
        USER,
        CONVERT;

    }
}

