/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.regions;

import com.simba.athena.amazonaws.AmazonClientException;
import com.simba.athena.amazonaws.SdkClientException;
import com.simba.athena.amazonaws.regions.AwsRegionProvider;
import com.simba.athena.amazonaws.util.EC2MetadataUtils;
import com.simba.athena.shaded.apache.commons.logging.LogFactory;

public class InstanceMetadataRegionProvider
extends AwsRegionProvider {
    private volatile String region;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getRegion() throws SdkClientException {
        if (this.region == null) {
            InstanceMetadataRegionProvider instanceMetadataRegionProvider = this;
            synchronized (instanceMetadataRegionProvider) {
                if (this.region == null) {
                    this.region = this.tryDetectRegion();
                }
            }
        }
        return this.region;
    }

    private String tryDetectRegion() {
        try {
            return EC2MetadataUtils.getEC2InstanceRegion();
        }
        catch (AmazonClientException sce) {
            LogFactory.getLog(InstanceMetadataRegionProvider.class).debug("Ignoring failure to retrieve the region: " + sce.getMessage());
            return null;
        }
    }
}

