(ns subversion
  (:use
    fastbeans.utils
    simplelog.use
    subversion.internals
    hiccup.core
    hiccup.util)
  (:require
    [subversion-clj.core :as core]
    [subversion-clj.local :as local]
    [diff :as diff]
    [clojure.core.memoize :as memo])
  (:import
    [subversion.clj StructuredDiffGenerator]))

(def cached-repo (memo/memo-lru core/repo-for 100))

(callfn youngest
  []
  (core/youngest repo))

(declare pretty-diff)

(defn zip-diffs-with-changes
  [diffs file-changes pretty?]
  (for [[path diff] diffs]
    [path (file-changes path) (if pretty?
                                (pretty-diff diff)
                                diff)]))

(defn diff
  [repo-path revision pretty?]
  (let [repo (cached-repo repo-path)
        generator (structured-diff-for repo revision)
        diff (.grabDiff generator)
        file-changes (.grabFileChanges generator)]
    (assoc diff :files (zip-diffs-with-changes (:files diff) file-changes pretty?))))

(callfn commit
  [revision]
  (cheap-revision-for repo (as-int revision)))

(callfn commit-range
  [rev-a rev-b]
  (cheap-revisions-for repo (as-int rev-a) (as-int rev-b)))

(def line-class
  {:add "gi"
   :delete "gd"
   :context ""})

(defn pretty-diff
  [diff]
  (let [chunks (diff/parse-diff diff)]
     (html
      (for [[left right lines] chunks]
        [:div {:class (if (> (count chunks) 1) "code-viewer chunk" "code-viewer")}
         [:div.code-lines
          [:pre (map #(str (or % "&nbsp;") "\n") left)]]
         [:div.code-lines
          [:pre (map #(str (or % "&nbsp;") "\n") right)]]
         [:div.code-list
          [:pre
           (for [line lines]
             (str (html
                   [:div [:span {:class (line-class (diff/line-type line))}
                          (escape-html line)]])
                  "\n"))]]]))))
