(ns git.wc
  (:use
    fastbeans.utils
    simplelog.use
    git.internals)
  (:require 
    [clj-jgit.porcelain :as core]
    [clj-jgit.querying :as query]
    [clj-jgit.internal :as internal]
    [clojure.java.io :as io]))

(callfn current-revision
  [wc-path]
  (when (file-exists? wc-path)
    (let [wc (core/load-repo wc-path)
          commit (first (log-with-limit wc 1))] 
      (when commit
        (.getName commit)))))

(callfn initialize
  [wc-path branch-name commit]
  (let [wc (if (file-exists? wc-path)
             (core/load-repo wc-path)
             (core/git-clone cache-path wc-path "origin" branch-name))]
    (when commit
      (core/git-reset wc commit))))

(callfn update-submodules
  [wc-path]
  (let [wc (core/load-repo wc-path)]
    (doto wc
      (core/git-submodule-init)
      (core/git-submodule-sync)
      (core/git-submodule-update))
    true))

(callfn update
  [wc-path branch-name commit]
  (let [wc (core/load-repo wc-path)]
    (core/git-fetch wc)
    (core/git-reset wc commit :hard)
    true))