(ns fastbeans.netty
  (:require
    [fastbeans.handlers :as handler])
  (:import
     [java.net InetSocketAddress]
     [java.util.concurrent Executors]
     [org.jboss.netty.bootstrap ServerBootstrap]
     [org.jboss.netty.channel ChannelPipelineFactory SimpleChannelHandler
                              AdaptiveReceiveBufferSizePredictorFactory]
     [org.jboss.netty.channel.socket.nio NioServerSocketChannelFactory]))

(defn start
  "Start a Netty server. Returns the pipeline."
  [port]
  (let [channel-factory (NioServerSocketChannelFactory.
                          (Executors/newCachedThreadPool)
                          (Executors/newCachedThreadPool))
        bootstrap (ServerBootstrap. channel-factory)
        pipeline (.getPipeline bootstrap)
        handler (fastbeans.handlers.NettyHandler.)
        buffer-size-predictor (AdaptiveReceiveBufferSizePredictorFactory. 1024 4096 8192)]
    (.addLast pipeline "handler" handler)
    (.setOption bootstrap "child.tcpNoDelay", true)
    (.setOption bootstrap "child.keepAlive", true)
    (.setOption bootstrap "child.receiveBufferSizePredictorFactory" buffer-size-predictor)
    (.bind bootstrap (InetSocketAddress. port))
    pipeline))
