# lark/tree

> “Leaves turned to soil beneath my feet. Thus it is, trees eat themselves.”
>
> -- _David Mitchell, Cloud Atlas_

Parse Clojure code into an AST suitable for structural editing environments.

## What can it do?

1. Parse raw Clojure source into an AST (`lark.tree.core/ast`) and corresponding zipper (`lark.tree.core/ast-zip`).
2. Traverse and edit as desired.
3. Emit Clojure (`lark.tree.core/string` or `lark.tree.core/sexp`) with existing whitespace intact.

An example of real-world usage can be found in [Maria](https://github.com/mhuebert/maria), a beginner-friendly ClojureScript REPL.

## Testing

`lein doo phantom test`

## Future

In addition to being 'whitespace-aware', a lark/tree AST should also be 'cursor-aware' and 'selection-aware', and thus encapsulate nearly the full state of an editor. This will simplify the implementation of new editing commands, make testing easier, and allow for more freedoms in the visual representation and manipulation of code. (CodeMirror will be just one of many possible 'views' on an AST, one which happens to use a string representation.)
