(ns test
  (:require [tools.compiler.grammar :as g])
  (:require [tools.compiler.lexer-gen :as l])
  (:require [tools.fl.fa.da :as da])
  )


(def t1 (slurp "testing/t1.txt"))
(def t2 (slurp "testing/t2.txt"))
(def t4 (slurp "testing/t4.txt"))
(def t5 (slurp "testing/t5.txt"))

(def tkns-desc1 '[
                   [space "[\t \n]+"]
                   [id "\\p{Alpha}+"]
                   [hexnum "\\p{Digit}+x0"]
                   [num "\\p{Digit}+"]
                   [plus "\\+"]
                   [minus "-"]
                   ])


(def tkns-desc '[
                  [space "[\t \n]+"]
                  [Int "int"]
                  [Float "float"]
                  [Write "write"]
                  [Id "[a-zA-Z][a-zA-Z0-9]*"]
                  [FloatLiteral "[1-9][0-9]*\\.[0-9]+"]
                  [IntLiteral "[1-9][0-9]*"]
                  [SemiColon ";"]
                  [LeftParen "\\("]
                  [RigthParen "\\)"]
                  [Sum "\\+"]
                  [Multiplication "\\*"]
                  [Assignment "="]
                  ])

(defn print-all-tokens-in-str []
  (l/setTokens-desc tkns-desc)
  (let [r (l/all-tokens-in-str t4)]
    (prn r)
    )
  )

(defn test-dfa []
  (da/set-dfa {
                :transitions '{
                                [q0 a] q1
                                [q0 b] q0

                                [q1 a] q2
                                [q1 b] q0

                                [q2 a] q2
                                [q2 b] q2
                                }

                :initial-state 'q0

                :final-states #{'q2}})

  (da/recognize '(a, b, a, b, a, b, b, b, a, b, a, b, a, a, a, b, b))
  )


(def g1 '{
           P {
               E [[T Ep]]
               Ep [[+ T Ep] [- T Ep] []]
               T [[F Tp]]
               Tp [[* F Tp] [/ F Tp] []]
               F [[pa E pc] [id] [num]]

               ;               A [[Ep ??] [Tp ?]]
               }
           sigma #{* / id pa pc num + -}
           ;           N #{E T Ep F Tp A}
           N #{E T Ep F Tp}
           S E
           })

(def gmemo '{
              P {
                  Is [[I Is] []]
                  I [[WI SemiColon] [DI SemiColon] [AI SemiColon]]
                  AI [[Id Assignment E SemiColon]]
                  DI [[Type Id SemiColon]]
                  Type [[Int] [Float]]
                  WI [[Write E SemiColon]]
                  E [[T Mt]]
                  Mt [[Sum T Mt] []]
                  T [[F Mf]]
                  Mf [[Multiplication F Mf] []]
                  F [[LeftParen E RigthParen] [Id] [IntLiteral] [FloatLiteral]]
                  }

              sigma #{Int Float Write Id FloatLiteral IntLiteral SemiColon LeftParen RigthParen Sum Multiplication Assignment Error EOT}

              S Is
              config {
                       :tTypeName "exp_lang.compiler.MemoTypes"
                       :kTypeName "exp_lang.compiler.TokenKind"
                       :langName "exp_lang"
                       }
              }
  )

(defn gtest []
  (g/setGrammar gmemo)

  ;  (g/LL1-parser-firsts-as-strings-and-vectors)
  (g/get-LL1-parser-java)
  )

(defn current-action []
  ;  (print-all-tokens-in-str)

  (println (gtest))
  )