(ns <<project-ns>>.system.control
  (:require [clojure.tools.logging :as log :refer [spy spyf]]
            [mount.core :as mount]
            [mount.tools.graph :as mount-graph]
            [booma.utils :as utils]))

;;;; Control services from backend.
;;;; pretty bare atm

;; AR - maybe there is not need to stop the whole service, only avoid
;; sending the faqs back? This kind of logic maybe should not be here.
;; Also, do we assume that if at least on business client (browser) is
;; connected, then the whole faq stops? what if the human cannot keep
;; up with the work? should be have an "emergency button" for answering
;; with faq to everybody except the users I am working on?

;; (@search-enabled?)

(defn started?
  "Return true if the input state is started."
  ([var-sym-or-str]
   (started? (mount-graph/states-with-deps) var-sym-or-str))
  ([mount-graph var-sym-or-str]
   (let [pattern (re-pattern (str (utils/var-symbol var-sym-or-str)))]
     (contains? (->> mount-graph
                     (filter #(re-find pattern (:name %)))
                     first
                     :status)
                :started))))

(defn stopped?
  "Return true if the input state is started."
  ([var-sym-or-str]
   (stopped? (mount-graph/states-with-deps) var-sym-or-str))
  ([mount-graph var-sym-or-str]
   (let [pattern (re-pattern (str (utils/var-symbol var-sym-or-str)))]
     (contains? (->> mount-graph
                     (filter #(re-find pattern (:name %)))
                     first
                     :status)
                :stopped))))

(defn toggle!
  "Toggle the runtime status of a state (started->stopped and
  viceversa)."
  [var-sym-or-str]
  (let [v (resolve (utils/var-symbol var-sym-or-str))]
    (cond
      (started? var-sym-or-str) (mount/stop v)
      (stopped? var-sym-or-str) (mount/start v))))
