(ns <<project-ns>>.core
  "The main application namespace"
  (:require [mount.core :as mount]
            [clojure.tools.logging :as log]
            [clojure.tools.cli :as cli]
            [robert.hooke :as hooke]
            [<<project-ns>>.system :as system]
            [<<project-ns>>.logging :as logging])
  (:gen-class))

(defn main-stop
  "Hook for -main side-effects on stop.

  For instance this function should call shutdown-agents, which is not
  desirable when stopping the app at the repl."
  [f & args]
  (apply f args)
  (shutdown-agents))

(defn main-start
  "Hook for -main side-effects on start.

  For instance this function should set .addShutdownHook and perform
  all the side effects that need to be avoided when working at the
  repl."
  [f & args]
  (.addShutdownHook (Runtime/getRuntime) (Thread. #(system/stop)))
  (apply f args))

(def cli-options
  "Customize at will"
  [#_["-p" "--port PORT" "Port number"
      :parse-fn #(Integer/parseInt %)]])

(defn -main
  [& args]
  (hooke/add-hook #'<<project-ns>>.system/stop #'<<project-ns>>.core/main-stop)
  (hooke/add-hook #'<<project-ns>>.system/start #'<<project-ns>>.core/main-start)
  (system/start (cli/parse-opts cli-options)))
