(ns <<project-ns>>.core
  "Implements the Apache Commons Daemon interface.

  Documentation at:
  https://commons.apache.org/proper/commons-daemon/apidocs/index.html"
  (:require [clojure.tools.logging :as log]
            ;; require your stateful namespaces here
            [<<project-ns>>.system :as system])
  (:gen-class :implements [org.apache.commons.daemon.Daemon]))

(defn -init
  "Initializes this Daemon instance.

  This method gets called once the JVM process is created and the Daemon
  instance is created thru its empty public constructor.

  Under certain operating systems (typically Unix based operating systems)
  and if the native invocation framework is configured to do so, this
  method might be called with super-user privileges.

  For example, it might be wise to create ServerSocket instances within
  the scope of this method, and perform all operations requiring
  super-user privileges in the underlying operating system.

  Apart from set up and allocation of native resources, this method must
  not start the actual operation of the Daemon (such as starting threads
  calling the ServerSocket.accept() method) as this would impose some
  serious security hazards. The start of operation must be performed in
  the start() method."
  [this daemon-context])

(defn -start
  "Starts the operation of this Daemon instance. This method is to be
  invoked by the environment after the init() method has been
  successfully invoked and possibly the security level of the JVM has
  been dropped. Implementors of this method are free to start any number
  of threads, but need to return control after having done that to
  enable invocation of the stop()-method."
  [this]
  (system/start nil)) ;; start can receive arguments

(defn -stop
  "Stops the operation of this Daemon instance. Note that the proper
  place to free any allocated resources such as sockets or file
  descriptors is in the destroy method, as the container may restart the
  Daemon by calling start() after stop()."
  [this]
  (system/stop)
  (shutdown-agents))

(defn -destroy
  "Frees any resources allocated by this daemon such as file descriptors
  or sockets. This method gets called by the container after stop() has
  been called, before the JVM exits. The Daemon can not be restarted
  after this method has been called without a new call to the init()
  method."
  [this])
