/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.tests.math;

import org.jbox2d.common.MathUtils;

public class SinCosTable {
    public static final double TWOPI = Math.PI * 2;
    public static boolean LERP_LOOKUP = true;
    public final double precision;
    public final int tableLength;
    public final double[] sinLUT;

    public SinCosTable(double argPrecision) {
        this.precision = argPrecision;
        this.tableLength = (int)Math.ceil(Math.PI * 2 / this.precision);
        this.sinLUT = new double[this.tableLength];
        for (int i = 0; i < this.tableLength; ++i) {
            this.sinLUT[i] = Math.sin((double)i * this.precision);
        }
    }

    public final double sin(double x) {
        x %= Math.PI * 2;
        if (LERP_LOOKUP) {
            int index = (int)(x /= this.precision);
            if (index != 0) {
                x %= (double)index;
            }
            if (index == this.tableLength - 1) {
                return (1.0 - x) * this.sinLUT[index] + x * this.sinLUT[0];
            }
            return (1.0 - x) * this.sinLUT[index] + x * this.sinLUT[index + 1];
        }
        return this.sinLUT[MathUtils.round((double)(x / this.precision)) % this.tableLength];
    }
}

