/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.EdgeShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.joints.DistanceJointDef;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.JointDef;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class Web
extends TestbedTest {
    Body[] m_bodies = new Body[4];
    Joint[] m_joints = new Joint[8];

    @Override
    public void initTest(boolean argDeserialized) {
        Body ground = null;
        BodyDef bd = new BodyDef();
        ground = this.getWorld().createBody(bd);
        EdgeShape shape = new EdgeShape();
        shape.set(new Vec2(-40.0, 0.0), new Vec2(40.0, 0.0));
        ground.createFixture((Shape)shape, 0.0);
        PolygonShape shape2 = new PolygonShape();
        shape2.setAsBox(0.5, 0.5);
        BodyDef bd2 = new BodyDef();
        bd2.type = BodyType.DYNAMIC;
        bd2.position.set(-5.0, 5.0);
        this.m_bodies[0] = this.getWorld().createBody(bd2);
        this.m_bodies[0].createFixture((Shape)shape2, 5.0);
        bd2.position.set(5.0, 5.0);
        this.m_bodies[1] = this.getWorld().createBody(bd2);
        this.m_bodies[1].createFixture((Shape)shape2, 5.0);
        bd2.position.set(5.0, 15.0);
        this.m_bodies[2] = this.getWorld().createBody(bd2);
        this.m_bodies[2].createFixture((Shape)shape2, 5.0);
        bd2.position.set(-5.0, 15.0);
        this.m_bodies[3] = this.getWorld().createBody(bd2);
        this.m_bodies[3].createFixture((Shape)shape2, 5.0);
        DistanceJointDef jd = new DistanceJointDef();
        Vec2 p1 = new Vec2();
        Vec2 p2 = new Vec2();
        Vec2 d = new Vec2();
        jd.frequencyHz = 4.0;
        jd.dampingRatio = 0.5;
        jd.bodyA = ground;
        jd.bodyB = this.m_bodies[0];
        jd.localAnchorA.set(-10.0, 0.0);
        jd.localAnchorB.set(-0.5, -0.5);
        p1 = jd.bodyA.getWorldPoint(jd.localAnchorA);
        p2 = jd.bodyB.getWorldPoint(jd.localAnchorB);
        d = p2.sub(p1);
        jd.length = d.length();
        this.m_joints[0] = this.getWorld().createJoint((JointDef)jd);
        jd.bodyA = ground;
        jd.bodyB = this.m_bodies[1];
        jd.localAnchorA.set(10.0, 0.0);
        jd.localAnchorB.set(0.5, -0.5);
        p1 = jd.bodyA.getWorldPoint(jd.localAnchorA);
        p2 = jd.bodyB.getWorldPoint(jd.localAnchorB);
        d = p2.sub(p1);
        jd.length = d.length();
        this.m_joints[1] = this.getWorld().createJoint((JointDef)jd);
        jd.bodyA = ground;
        jd.bodyB = this.m_bodies[2];
        jd.localAnchorA.set(10.0, 20.0);
        jd.localAnchorB.set(0.5, 0.5);
        p1 = jd.bodyA.getWorldPoint(jd.localAnchorA);
        p2 = jd.bodyB.getWorldPoint(jd.localAnchorB);
        d = p2.sub(p1);
        jd.length = d.length();
        this.m_joints[2] = this.getWorld().createJoint((JointDef)jd);
        jd.bodyA = ground;
        jd.bodyB = this.m_bodies[3];
        jd.localAnchorA.set(-10.0, 20.0);
        jd.localAnchorB.set(-0.5, 0.5);
        p1 = jd.bodyA.getWorldPoint(jd.localAnchorA);
        p2 = jd.bodyB.getWorldPoint(jd.localAnchorB);
        d = p2.sub(p1);
        jd.length = d.length();
        this.m_joints[3] = this.getWorld().createJoint((JointDef)jd);
        jd.bodyA = this.m_bodies[0];
        jd.bodyB = this.m_bodies[1];
        jd.localAnchorA.set(0.5, 0.0);
        jd.localAnchorB.set(-0.5, 0.0);
        p1 = jd.bodyA.getWorldPoint(jd.localAnchorA);
        p2 = jd.bodyB.getWorldPoint(jd.localAnchorB);
        d = p2.sub(p1);
        jd.length = d.length();
        this.m_joints[4] = this.getWorld().createJoint((JointDef)jd);
        jd.bodyA = this.m_bodies[1];
        jd.bodyB = this.m_bodies[2];
        jd.localAnchorA.set(0.0, 0.5);
        jd.localAnchorB.set(0.0, -0.5);
        p1 = jd.bodyA.getWorldPoint(jd.localAnchorA);
        p2 = jd.bodyB.getWorldPoint(jd.localAnchorB);
        d = p2.sub(p1);
        jd.length = d.length();
        this.m_joints[5] = this.getWorld().createJoint((JointDef)jd);
        jd.bodyA = this.m_bodies[2];
        jd.bodyB = this.m_bodies[3];
        jd.localAnchorA.set(-0.5, 0.0);
        jd.localAnchorB.set(0.5, 0.0);
        p1 = jd.bodyA.getWorldPoint(jd.localAnchorA);
        p2 = jd.bodyB.getWorldPoint(jd.localAnchorB);
        d = p2.sub(p1);
        jd.length = d.length();
        this.m_joints[6] = this.getWorld().createJoint((JointDef)jd);
        jd.bodyA = this.m_bodies[3];
        jd.bodyB = this.m_bodies[0];
        jd.localAnchorA.set(0.0, -0.5);
        jd.localAnchorB.set(0.0, 0.5);
        p1 = jd.bodyA.getWorldPoint(jd.localAnchorA);
        p2 = jd.bodyB.getWorldPoint(jd.localAnchorB);
        d = p2.sub(p1);
        jd.length = d.length();
        this.m_joints[7] = this.getWorld().createJoint((JointDef)jd);
    }

    @Override
    public void keyPressed(char key, int argKeyCode) {
        block0 : switch (key) {
            case 'b': {
                for (int i = 0; i < 4; ++i) {
                    if (this.m_bodies[i] == null) continue;
                    this.getWorld().destroyBody(this.m_bodies[i]);
                    this.m_bodies[i] = null;
                    break block0;
                }
                break;
            }
            case 'j': {
                for (int i = 0; i < 8; ++i) {
                    if (this.m_joints[i] == null) continue;
                    this.getWorld().destroyJoint(this.m_joints[i]);
                    this.m_joints[i] = null;
                    break block0;
                }
                break;
            }
        }
    }

    @Override
    public void step(TestbedSettings settings) {
        super.step(settings);
        this.addTextLine("This demonstrates a soft distance joint.");
        this.addTextLine("Press: (b) to delete a body, (j) to delete a joint");
    }

    @Override
    public void jointDestroyed(Joint joint) {
        for (int i = 0; i < 8; ++i) {
            if (this.m_joints[i] != joint) continue;
            this.m_joints[i] = null;
            break;
        }
    }

    @Override
    public String getTestName() {
        return "Web";
    }
}

