/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.joints.JointDef;
import org.jbox2d.dynamics.joints.RevoluteJoint;
import org.jbox2d.dynamics.joints.RevoluteJointDef;
import org.jbox2d.particle.ParticleGroupDef;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class WaveMachine
extends TestbedTest {
    RevoluteJoint m_joint;
    double m_time;

    @Override
    public void step(TestbedSettings settings) {
        super.step(settings);
        double hz = settings.getSetting((String)"Hz").value;
        if (hz > 0.0) {
            this.m_time += 1.0 / hz;
        }
        this.m_joint.setMotorSpeed((double)0.05f * MathUtils.cos((double)this.m_time) * Math.PI);
    }

    @Override
    public void initTest(boolean deserialized) {
        BodyDef bd = new BodyDef();
        bd.type = BodyType.DYNAMIC;
        bd.allowSleep = false;
        bd.position.set(0.0, 10.0);
        Body body = this.m_world.createBody(bd);
        PolygonShape shape = new PolygonShape();
        shape.setAsBox(0.5, 10.0, new Vec2(20.0, 0.0), 0.0);
        body.createFixture((Shape)shape, 5.0);
        shape.setAsBox(0.5, 10.0, new Vec2(-20.0, 0.0), 0.0);
        body.createFixture((Shape)shape, 5.0);
        shape.setAsBox(20.0, 0.5, new Vec2(0.0, 10.0), 0.0);
        body.createFixture((Shape)shape, 5.0);
        shape.setAsBox(20.0, 0.5, new Vec2(0.0, -10.0), 0.0);
        body.createFixture((Shape)shape, 5.0);
        RevoluteJointDef jd = new RevoluteJointDef();
        jd.bodyA = this.getGroundBody();
        jd.bodyB = body;
        jd.localAnchorA.set(0.0, 10.0);
        jd.localAnchorB.set(0.0, 0.0);
        jd.referenceAngle = 0.0;
        jd.motorSpeed = 0.1570796350201586;
        jd.maxMotorTorque = 1.0E7;
        jd.enableMotor = true;
        this.m_joint = (RevoluteJoint)this.m_world.createJoint((JointDef)jd);
        this.m_world.setParticleRadius((double)0.15f);
        this.m_world.setParticleDamping((double)0.2f);
        ParticleGroupDef pd = new ParticleGroupDef();
        pd.flags = 0;
        PolygonShape shape2 = new PolygonShape();
        shape2.setAsBox(9.0, 9.0, new Vec2(0.0, 10.0), 0.0);
        pd.shape = shape2;
        this.m_world.createParticleGroup(pd);
        this.m_time = 0.0;
    }

    @Override
    public String getTestName() {
        return "Wave Machine";
    }
}

