/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.EdgeShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.FixtureDef;
import org.jbox2d.testbed.framework.TestbedTest;

public class VaryingRestitution
extends TestbedTest {
    @Override
    public boolean isSaveLoadEnabled() {
        return true;
    }

    @Override
    public void initTest(boolean deserialized) {
        if (deserialized) {
            return;
        }
        BodyDef bd = new BodyDef();
        Body ground = this.getWorld().createBody(bd);
        EdgeShape shape = new EdgeShape();
        shape.set(new Vec2(-40.0, 0.0), new Vec2(40.0, 0.0));
        ground.createFixture((Shape)shape, 0.0);
        CircleShape shape2 = new CircleShape();
        shape2.m_radius = 1.0;
        FixtureDef fd = new FixtureDef();
        fd.shape = shape2;
        fd.density = 1.0;
        double[] restitution = new double[]{0.0, 0.1f, 0.3f, 0.5, 0.75, 0.9f, 1.0};
        for (int i = 0; i < 7; ++i) {
            BodyDef bd2 = new BodyDef();
            bd2.type = BodyType.DYNAMIC;
            bd2.position.set((double)(-10.0f + 3.0f * (float)i), 20.0);
            Body body = this.getWorld().createBody(bd2);
            fd.restitution = restitution[i];
            body.createFixture(fd);
        }
    }

    @Override
    public String getTestName() {
        return "Varying Restitution";
    }
}

