/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.joints.JointDef;
import org.jbox2d.dynamics.joints.RevoluteJoint;
import org.jbox2d.dynamics.joints.RevoluteJointDef;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class Tumbler
extends TestbedTest {
    private static final int MAX_NUM = 800;
    RevoluteJoint m_joint;
    int m_count;

    @Override
    public void initTest(boolean deserialized) {
        BodyDef bd = new BodyDef();
        bd.type = BodyType.DYNAMIC;
        bd.allowSleep = false;
        bd.position.set(0.0, 10.0);
        Body body = this.m_world.createBody(bd);
        PolygonShape shape = new PolygonShape();
        shape.setAsBox(0.5, 10.0, new Vec2(10.0, 0.0), 0.0);
        body.createFixture((Shape)shape, 5.0);
        shape.setAsBox(0.5, 10.0, new Vec2(-10.0, 0.0), 0.0);
        body.createFixture((Shape)shape, 5.0);
        shape.setAsBox(10.0, 0.5, new Vec2(0.0, 10.0), 0.0);
        body.createFixture((Shape)shape, 5.0);
        shape.setAsBox(10.0, 0.5, new Vec2(0.0, -10.0), 0.0);
        body.createFixture((Shape)shape, 5.0);
        RevoluteJointDef jd = new RevoluteJointDef();
        jd.bodyA = this.getGroundBody();
        jd.bodyB = body;
        jd.localAnchorA.set(0.0, 10.0);
        jd.localAnchorB.set(0.0, 0.0);
        jd.referenceAngle = 0.0;
        jd.motorSpeed = 0.1570796350201586;
        jd.maxMotorTorque = 1.0E8;
        jd.enableMotor = true;
        this.m_joint = (RevoluteJoint)this.m_world.createJoint((JointDef)jd);
        this.m_count = 0;
    }

    @Override
    public synchronized void step(TestbedSettings settings) {
        super.step(settings);
        if (this.m_count < 800) {
            BodyDef bd = new BodyDef();
            bd.type = BodyType.DYNAMIC;
            bd.position.set(0.0, 10.0);
            Body body = this.m_world.createBody(bd);
            PolygonShape shape = new PolygonShape();
            shape.setAsBox(0.125, 0.125);
            body.createFixture((Shape)shape, 1.0);
            ++this.m_count;
        }
    }

    @Override
    public String getTestName() {
        return "Tumbler";
    }
}

