/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import java.util.Formatter;
import org.jbox2d.collision.shapes.EdgeShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.joints.JointDef;
import org.jbox2d.dynamics.joints.PrismaticJoint;
import org.jbox2d.dynamics.joints.PrismaticJointDef;
import org.jbox2d.dynamics.joints.RevoluteJoint;
import org.jbox2d.dynamics.joints.RevoluteJointDef;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class SliderCrankTest
extends TestbedTest {
    private RevoluteJoint m_joint1;
    private PrismaticJoint m_joint2;

    @Override
    public void initTest(boolean argDeserialized) {
        Body ground = null;
        BodyDef bd = new BodyDef();
        ground = this.getWorld().createBody(bd);
        EdgeShape shape = new EdgeShape();
        shape.set(new Vec2(-40.0, 0.0), new Vec2(40.0, 0.0));
        ground.createFixture((Shape)shape, 0.0);
        Body prevBody = ground;
        shape = new PolygonShape();
        shape.setAsBox(0.5, 2.0);
        BodyDef bd2 = new BodyDef();
        bd2.type = BodyType.DYNAMIC;
        bd2.position.set(0.0, 7.0);
        Body body = this.getWorld().createBody(bd2);
        body.createFixture((Shape)shape, 2.0);
        RevoluteJointDef rjd = new RevoluteJointDef();
        rjd.initialize(prevBody, body, new Vec2(0.0, 5.0));
        rjd.motorSpeed = Math.PI;
        rjd.maxMotorTorque = 10000.0;
        rjd.enableMotor = true;
        this.m_joint1 = (RevoluteJoint)this.getWorld().createJoint((JointDef)rjd);
        prevBody = body;
        shape = new PolygonShape();
        shape.setAsBox(0.5, 4.0);
        bd2 = new BodyDef();
        bd2.type = BodyType.DYNAMIC;
        bd2.position.set(0.0, 13.0);
        body = this.getWorld().createBody(bd2);
        body.createFixture((Shape)shape, 2.0);
        rjd = new RevoluteJointDef();
        rjd.initialize(prevBody, body, new Vec2(0.0, 9.0));
        rjd.enableMotor = false;
        this.getWorld().createJoint((JointDef)rjd);
        prevBody = body;
        shape = new PolygonShape();
        shape.setAsBox(1.5, 1.5);
        bd2 = new BodyDef();
        bd2.type = BodyType.DYNAMIC;
        bd2.fixedRotation = true;
        bd2.position.set(0.0, 17.0);
        body = this.getWorld().createBody(bd2);
        body.createFixture((Shape)shape, 2.0);
        rjd = new RevoluteJointDef();
        rjd.initialize(prevBody, body, new Vec2(0.0, 17.0));
        this.getWorld().createJoint((JointDef)rjd);
        PrismaticJointDef pjd = new PrismaticJointDef();
        pjd.initialize(ground, body, new Vec2(0.0, 17.0), new Vec2(0.0, 1.0));
        pjd.maxMotorForce = 1000.0;
        pjd.enableMotor = false;
        this.m_joint2 = (PrismaticJoint)this.getWorld().createJoint((JointDef)pjd);
        shape = new PolygonShape();
        shape.setAsBox(1.5, 1.5);
        bd2 = new BodyDef();
        bd2.type = BodyType.DYNAMIC;
        bd2.position.set(0.0, 23.0);
        body = this.getWorld().createBody(bd2);
        body.createFixture((Shape)shape, 2.0);
    }

    @Override
    public void step(TestbedSettings settings) {
        super.step(settings);
        this.addTextLine("Keys: (f) toggle friction, (m) toggle motor");
        double torque = this.m_joint1.getMotorTorque(1.0);
        Formatter f = new Formatter();
        this.addTextLine(f.format("Friction: %b, Motor Force = %5.0f, ", this.m_joint2.isMotorEnabled(), torque).toString());
        f.close();
    }

    @Override
    public void keyPressed(char argKeyChar, int argKeyCode) {
        switch (argKeyChar) {
            case 'f': {
                this.m_joint2.enableMotor(!this.m_joint2.isMotorEnabled());
                this.getModel().getKeys()[102] = false;
                break;
            }
            case 'm': {
                this.m_joint1.enableMotor(!this.m_joint1.isMotorEnabled());
                this.getModel().getKeys()[109] = false;
            }
        }
    }

    @Override
    public String getTestName() {
        return "Slider Crank";
    }
}

