/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.EdgeShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.FixtureDef;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.JointDef;
import org.jbox2d.dynamics.joints.RevoluteJointDef;
import org.jbox2d.dynamics.joints.RopeJointDef;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class RopeTest
extends TestbedTest {
    RopeJointDef m_ropeDef;
    Joint m_rope;

    @Override
    public void initTest(boolean deserialized) {
        if (deserialized) {
            return;
        }
        Body ground = null;
        BodyDef bd = new BodyDef();
        ground = this.getWorld().createBody(bd);
        EdgeShape shape = new EdgeShape();
        shape.set(new Vec2(-40.0, 0.0), new Vec2(40.0, 0.0));
        ground.createFixture((Shape)shape, 0.0);
        PolygonShape shape2 = new PolygonShape();
        shape2.setAsBox(0.5, 0.125);
        FixtureDef fd = new FixtureDef();
        fd.shape = shape2;
        fd.density = 20.0;
        fd.friction = 0.2f;
        fd.filter.categoryBits = 1;
        fd.filter.maskBits = 65533;
        RevoluteJointDef jd = new RevoluteJointDef();
        jd.collideConnected = false;
        int N = 10;
        double y = 15.0;
        this.m_ropeDef = new RopeJointDef();
        this.m_ropeDef.localAnchorA.set(0.0, 15.0);
        Body prevBody = ground;
        for (int i = 0; i < 10; ++i) {
            BodyDef bd2 = new BodyDef();
            bd2.type = BodyType.DYNAMIC;
            bd2.position.set((double)(0.5f + 1.0f * (float)i), 15.0);
            if (i == 9) {
                shape2.setAsBox(1.5, 1.5);
                fd.density = 100.0;
                fd.filter.categoryBits = 2;
                bd2.position.set((double)(1.0f * (float)i), 15.0);
                bd2.angularDamping = 0.4f;
            }
            Body body = this.getWorld().createBody(bd2);
            body.createFixture(fd);
            Vec2 anchor = new Vec2((double)i, 15.0);
            jd.initialize(prevBody, body, anchor);
            this.getWorld().createJoint((JointDef)jd);
            prevBody = body;
        }
        this.m_ropeDef.localAnchorB.setZero();
        double extraLength = 0.01f;
        this.m_ropeDef.maxLength = 9.0 + extraLength;
        this.m_ropeDef.bodyB = prevBody;
        this.m_ropeDef.bodyA = ground;
        this.m_rope = this.getWorld().createJoint((JointDef)this.m_ropeDef);
    }

    @Override
    public void keyPressed(char keyChar, int keyCode) {
        switch (keyChar) {
            case 'j': {
                if (this.m_rope != null) {
                    this.getWorld().destroyJoint(this.m_rope);
                    this.m_rope = null;
                    break;
                }
                this.m_rope = this.getWorld().createJoint((JointDef)this.m_ropeDef);
            }
        }
    }

    @Override
    public synchronized void step(TestbedSettings settings) {
        super.step(settings);
        this.addTextLine("Press (j) to toggle the rope joint.");
        this.m_textLine += 15;
        if (this.m_rope != null) {
            this.addTextLine("Rope ON");
        } else {
            this.addTextLine("Rope OFF");
        }
    }

    @Override
    public String getTestName() {
        return "Rope Joint";
    }
}

