/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.EdgeShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.FixtureDef;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.JointDef;
import org.jbox2d.dynamics.joints.RevoluteJoint;
import org.jbox2d.dynamics.joints.RevoluteJointDef;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class RevoluteTest
extends TestbedTest {
    private static final long JOINT_TAG = 1L;
    private RevoluteJoint m_joint;
    private boolean isLeft = false;

    @Override
    public Long getTag(Joint joint) {
        if (joint == this.m_joint) {
            return 1L;
        }
        return super.getTag(joint);
    }

    @Override
    public void processJoint(Joint joint, Long tag) {
        if (tag == 1L) {
            this.m_joint = (RevoluteJoint)joint;
            this.isLeft = this.m_joint.getMotorSpeed() > 0.0;
        } else {
            super.processJoint(joint, tag);
        }
    }

    @Override
    public boolean isSaveLoadEnabled() {
        return true;
    }

    @Override
    public void initTest(boolean deserialized) {
        if (deserialized) {
            return;
        }
        Body ground = null;
        BodyDef bd = new BodyDef();
        ground = this.getWorld().createBody(bd);
        EdgeShape shape = new EdgeShape();
        shape.set(new Vec2(-40.0, 0.0), new Vec2(40.0, 0.0));
        ground.createFixture((Shape)shape, 0.0);
        CircleShape shape2 = new CircleShape();
        shape2.m_radius = 0.5;
        BodyDef bd2 = new BodyDef();
        bd2.type = BodyType.DYNAMIC;
        RevoluteJointDef rjd = new RevoluteJointDef();
        bd2.position.set(-10.0, 20.0);
        Body body = this.getWorld().createBody(bd2);
        body.createFixture((Shape)shape2, 5.0);
        double w = 100.0;
        body.setAngularVelocity(w);
        body.setLinearVelocity(new Vec2(-8.0 * w, 0.0));
        rjd.initialize(ground, body, new Vec2(-10.0, 12.0));
        rjd.motorSpeed = -Math.PI;
        rjd.maxMotorTorque = 10000.0;
        rjd.enableMotor = false;
        rjd.lowerAngle = -0.7853981633974483;
        rjd.upperAngle = 1.5707963267948966;
        rjd.enableLimit = true;
        rjd.collideConnected = true;
        this.m_joint = (RevoluteJoint)this.getWorld().createJoint((JointDef)rjd);
        CircleShape circle_shape = new CircleShape();
        circle_shape.m_radius = 3.0;
        BodyDef circle_bd = new BodyDef();
        circle_bd.type = BodyType.DYNAMIC;
        circle_bd.position.set(5.0, 30.0);
        FixtureDef fd = new FixtureDef();
        fd.density = 5.0;
        fd.filter.maskBits = 1;
        fd.shape = circle_shape;
        Body ball = this.m_world.createBody(circle_bd);
        ball.createFixture(fd);
        PolygonShape polygon_shape = new PolygonShape();
        polygon_shape.setAsBox(10.0, (double)0.2f, new Vec2(-10.0, 0.0), 0.0);
        BodyDef polygon_bd = new BodyDef();
        polygon_bd.position.set(20.0, 10.0);
        polygon_bd.type = BodyType.DYNAMIC;
        polygon_bd.bullet = true;
        Body polygon_body = this.m_world.createBody(polygon_bd);
        polygon_body.createFixture((Shape)polygon_shape, 2.0);
        RevoluteJointDef rjd2 = new RevoluteJointDef();
        rjd2.initialize(ground, polygon_body, new Vec2(20.0, 10.0));
        rjd2.lowerAngle = -0.7853981633974483;
        rjd2.upperAngle = 0.0;
        rjd2.enableLimit = true;
        this.m_world.createJoint((JointDef)rjd2);
        BodyDef bodyDef = new BodyDef();
        bodyDef.type = BodyType.DYNAMIC;
        Body body2 = this.m_world.createBody(bodyDef);
        PolygonShape polyShape = new PolygonShape();
        Vec2[] verts = new Vec2[]{new Vec2((double)17.63f, (double)36.31f), new Vec2((double)17.52f, (double)36.69f), new Vec2((double)17.19f, (double)36.36f)};
        polyShape.set(verts, 3);
        FixtureDef polyFixtureDef = new FixtureDef();
        polyFixtureDef.shape = polyShape;
        polyFixtureDef.density = 1.0;
        body2.createFixture(polyFixtureDef);
    }

    @Override
    public void step(TestbedSettings settings) {
        super.step(settings);
        this.addTextLine("Limits " + (this.m_joint.isLimitEnabled() ? "on" : "off") + ", Motor " + (this.m_joint.isMotorEnabled() ? "on " : "off ") + (this.isLeft ? "left" : "right"));
        this.addTextLine("Keys: (l) limits, (m) motor, (a) left, (d) right");
    }

    @Override
    public void keyPressed(char argKeyChar, int argKeyCode) {
        switch (argKeyChar) {
            case 'l': {
                this.m_joint.enableLimit(!this.m_joint.isLimitEnabled());
                break;
            }
            case 'm': {
                this.m_joint.enableMotor(!this.m_joint.isMotorEnabled());
                break;
            }
            case 'a': {
                this.m_joint.setMotorSpeed(Math.PI);
                this.isLeft = true;
                break;
            }
            case 'd': {
                this.m_joint.setMotorSpeed(-Math.PI);
                this.isLeft = false;
            }
        }
    }

    @Override
    public String getTestName() {
        return "Revolute";
    }
}

