/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.EdgeShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.testbed.framework.TestbedTest;

public class PyramidTest
extends TestbedTest {
    @Override
    public boolean isSaveLoadEnabled() {
        return true;
    }

    @Override
    public void initTest(boolean deserialized) {
        if (deserialized) {
            return;
        }
        int count = 20;
        BodyDef bd = new BodyDef();
        Body ground = this.getWorld().createBody(bd);
        EdgeShape shape = new EdgeShape();
        shape.set(new Vec2(-40.0, 0.0), new Vec2(40.0, 0.0));
        ground.createFixture((Shape)shape, 0.0);
        double a = 0.5;
        shape = new PolygonShape();
        shape.setAsBox(a, a);
        Vec2 x = new Vec2(-7.0, 0.75);
        Vec2 y = new Vec2();
        Vec2 deltaX = new Vec2(0.5625, 1.25);
        Vec2 deltaY = new Vec2(1.125, 0.0);
        for (int i = 0; i < count; ++i) {
            y.set(x);
            for (int j = i; j < count; ++j) {
                BodyDef bd2 = new BodyDef();
                bd2.type = BodyType.DYNAMIC;
                bd2.position.set(y);
                Body body = this.getWorld().createBody(bd2);
                body.createFixture((Shape)shape, 5.0);
                y.addLocal(deltaY);
            }
            x.addLocal(deltaX);
        }
    }

    @Override
    public String getTestName() {
        return "Pyramid";
    }
}

